/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.tree;

import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.datamgr.archive.ProjectArchive;
import ghidra.app.plugin.core.datamgr.tree.DomainFileArchiveNode;
import ghidra.framework.model.DomainFile;

public class ProjectArchiveNode
extends DomainFileArchiveNode {
    public ProjectArchiveNode(ProjectArchive archive) {
        super(archive);
    }

    @Override
    protected void dataTypeManagerChanged() {
        this.removeAll();
        this.installDataTypeManagerListener();
        this.nodeChanged();
        this.fireNodeStructureChanged((GTreeNode)this);
    }

    @Override
    public String getToolTip() {
        DomainFile file = ((ProjectArchive)this.archive).getDomainFile();
        if (file != null) {
            return file.getPathname();
        }
        return "[Unsaved New Project Archive]";
    }

    public boolean hasWriteLock() {
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        if (super.equals(o)) {
            DomainFile myFile = ((ProjectArchive)this.archive).getDomainFile();
            DomainFile otherFile = ((ProjectArchive)((ProjectArchiveNode)o).archive).getDomainFile();
            return myFile.equals(otherFile);
        }
        return false;
    }
}

