/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypesActionContext;
import ghidra.app.plugin.core.datamgr.archive.Archive;
import ghidra.app.plugin.core.datamgr.archive.ArchiveUtils;
import ghidra.app.plugin.core.datamgr.archive.FileArchive;
import ghidra.app.plugin.core.datamgr.archive.ProjectArchive;
import ghidra.app.plugin.core.datamgr.tree.ArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.FileArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.ProjectArchiveNode;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateFileException;
import java.awt.Component;
import java.io.IOException;
import javax.swing.tree.TreePath;

public class SaveAsAction
extends DockingAction {
    private DataTypeManagerPlugin plugin;

    public SaveAsAction(DataTypeManagerPlugin plugin) {
        super("Save As", plugin.getName());
        this.plugin = plugin;
        this.setPopupMenuData(new MenuData(new String[]{"Save Archive As..."}, "File"));
        this.setEnabled(true);
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context instanceof DataTypesActionContext)) {
            return false;
        }
        Object contextObject = context.getContextObject();
        GTree gtree = (GTree)contextObject;
        TreePath[] selectionPaths = gtree.getSelectionPaths();
        if (selectionPaths == null || selectionPaths.length != 1) {
            return false;
        }
        GTreeNode node = (GTreeNode)selectionPaths[0].getLastPathComponent();
        return node instanceof FileArchiveNode || node instanceof ProjectArchiveNode;
    }

    public void actionPerformed(ActionContext context) {
        GTree gtree = (GTree)context.getContextObject();
        TreePath[] selectionPaths = gtree.getSelectionPaths();
        ArchiveNode node = (ArchiveNode)selectionPaths[0].getLastPathComponent();
        Archive archive = node.getArchive();
        try {
            if (node instanceof FileArchiveNode) {
                FileArchive fa = (FileArchive)archive;
                ArchiveUtils.saveAs((Component)gtree, fa);
                this.plugin.addRecentlyOpenedArchiveFile(fa.getFile());
            } else if (node instanceof ProjectArchiveNode) {
                ProjectArchive pa = (ProjectArchive)archive;
                pa.saveAs((Component)gtree);
                this.plugin.addRecentlyOpenedProjectArchive(pa);
            }
        }
        catch (DuplicateFileException de) {
            Msg.showError((Object)((Object)this), (Component)gtree, (String)"Unable to Save File", (Object)("Archive already exists: " + archive));
        }
        catch (IOException ioe) {
            Msg.showError((Object)((Object)this), (Component)gtree, (String)"Unable to Save File", (Object)("Unexpected exception attempting to save archive: " + archive), (Throwable)ioe);
        }
    }
}

