/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.GTreeState;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypesActionContext;
import ghidra.app.plugin.core.datamgr.archive.ArchiveUtils;
import ghidra.app.plugin.core.datamgr.archive.FileArchive;
import ghidra.app.plugin.core.datamgr.tree.FileArchiveNode;
import javax.swing.tree.TreePath;

public class LockArchiveAction
extends DockingAction {
    public static final String ACTION_NAME = "Lock Archive";

    public LockArchiveAction(DataTypeManagerPlugin plugin) {
        super(ACTION_NAME, plugin.getName());
        this.setPopupMenuData(new MenuData(new String[]{"Open For Editing"}, null, "FileEdit"));
        this.setEnabled(true);
    }

    public boolean isAddToPopup(ActionContext context) {
        if (!(context instanceof DataTypesActionContext)) {
            return false;
        }
        TreePath[] selectionPaths = this.getSelectionPaths(context);
        return this.isOnlyFileArchivesSelected(selectionPaths);
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context instanceof DataTypesActionContext)) {
            return false;
        }
        TreePath[] selectionPaths = this.getSelectionPaths(context);
        return this.isOnlyFileArchivesSelected(selectionPaths) && this.isOneOrMoreSelectedFileArchivesLockable(selectionPaths);
    }

    private boolean isOnlyFileArchivesSelected(TreePath[] selectionPaths) {
        if (selectionPaths.length == 0) {
            return false;
        }
        for (TreePath path : selectionPaths) {
            GTreeNode node = (GTreeNode)path.getLastPathComponent();
            if (node instanceof FileArchiveNode) continue;
            return false;
        }
        return true;
    }

    private boolean isOneOrMoreSelectedFileArchivesLockable(TreePath[] selectionPaths) {
        for (TreePath path : selectionPaths) {
            GTreeNode node = (GTreeNode)path.getLastPathComponent();
            if (!this.canLock(node)) continue;
            return true;
        }
        return false;
    }

    private TreePath[] getSelectionPaths(ActionContext context) {
        Object contextObject = context.getContextObject();
        GTree gtree = (GTree)contextObject;
        TreePath[] selectionPaths = gtree.getSelectionPaths();
        return selectionPaths;
    }

    private boolean canLock(GTreeNode node) {
        FileArchiveNode fileNode = (FileArchiveNode)node;
        FileArchive archive = (FileArchive)fileNode.getArchive();
        String fname = archive.getFile().getName();
        if (!fname.endsWith(".gdt")) {
            return false;
        }
        return !archive.hasWriteLock();
    }

    public void actionPerformed(ActionContext context) {
        GTree gTree = (GTree)context.getContextObject();
        TreePath[] selectionPaths = gTree.getSelectionPaths();
        GTreeState treeState = gTree.getTreeState();
        for (TreePath path : selectionPaths) {
            FileArchiveNode node = (FileArchiveNode)path.getLastPathComponent();
            FileArchive archive = (FileArchive)node.getArchive();
            if (archive.hasWriteLock()) continue;
            ArchiveUtils.lockArchive(archive);
        }
        gTree.restoreTreeState(treeState);
    }
}

