/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr;

import docking.DialogComponentProvider;
import ghidra.app.plugin.core.datamgr.DataOrganizationPanel;
import ghidra.app.plugin.core.datamgr.SizeAlignmentPanel;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataOrganizationImpl;
import ghidra.program.model.data.DataTypeManager;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DataOrganizationDialog
extends DialogComponentProvider {
    private static String TITLE = "Data Type Alignment";
    private DataTypeManager dataTypeManager;
    private DataOrganization dataOrganization;
    private JPanel mainPanel;
    private DataOrganizationPanel alignPanel;
    private SizeAlignmentPanel sizePanel;
    private boolean actionComplete;

    public DataOrganizationDialog(DataTypeManager dataTypeManager, DataOrganizationImpl dataOrganization) {
        super(TITLE, true);
        this.dataTypeManager = dataTypeManager;
        this.dataOrganization = dataOrganization;
        JPanel headerPanel = new JPanel();
        headerPanel.add(new JLabel("<HTML>Alignment Information for <b>" + dataTypeManager.getName() + "</b>.</HTML>"));
        this.alignPanel = new DataOrganizationPanel();
        this.alignPanel.setOrganization(dataOrganization);
        this.sizePanel = new SizeAlignmentPanel();
        this.sizePanel.setOrganization(dataOrganization);
        JPanel infoPanel = new JPanel(new BorderLayout());
        infoPanel.add((Component)this.alignPanel, "North");
        infoPanel.add((Component)this.sizePanel, "Center");
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.add((Component)headerPanel, "North");
        this.mainPanel.add((Component)infoPanel, "Center");
        this.addWorkPanel(this.mainPanel);
        this.initialize();
    }

    private void initialize() {
        this.actionComplete = false;
        this.addOKButton();
        this.setOkButtonText("Set");
        this.addCancelButton();
    }

    public boolean userCanceled() {
        return !this.actionComplete && !this.isVisible();
    }

    protected void okCallback() {
        this.actionComplete = true;
        this.close();
    }

    protected void cancelCallback() {
        super.cancelCallback();
        this.actionComplete = false;
    }

    public DataOrganization getDataOrganization() {
        return this.dataOrganization;
    }
}

