/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.cparser;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.widgets.OptionDialog;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.cparser.CParserTask;
import ghidra.app.plugin.core.cparser.ParseDialog;
import ghidra.app.services.DataTypeManagerService;
import ghidra.app.util.cparser.C.CParser;
import ghidra.app.util.cparser.CPP.ParseException;
import ghidra.app.util.cparser.CPP.PreProcessor;
import ghidra.app.util.xml.DataTypesXmlMgr;
import ghidra.framework.Application;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.database.data.ProgramDataTypeManager;
import ghidra.program.model.data.BuiltInDataTypeManager;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.FileDataTypeManager;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Analysis", shortDescription="C Code Parser", description="Parse C and C Header files, extracting data definitions and function signatures.")
public class CParserPlugin
extends ProgramPlugin {
    static final String PARSE_ACTION_NAME = "Import C DataTypes";
    static final String USER_PROFILES_DIR = Application.getUserSettingsDirectory().getAbsolutePath() + File.separatorChar + "parserprofiles";
    private ParseDialog parseDialog;
    private File userProfileDir;
    static final String DESCRIPTION = "Parse C and C Header files, extracting data definitions and function signatures.";

    public CParserPlugin(PluginTool plugintool) {
        super(plugintool, false, false);
        this.createActions();
        this.setUserProfileDir(USER_PROFILES_DIR);
    }

    void setUserProfileDir(String path) {
        this.userProfileDir = new File(path);
        this.userProfileDir.mkdir();
    }

    File getUserProfileDir() {
        return this.userProfileDir;
    }

    public boolean isSingleton() {
        return true;
    }

    public Program getProgram() {
        return this.currentProgram;
    }

    public void dispose() {
        if (this.parseDialog != null) {
            this.parseDialog.close();
            this.parseDialog = null;
        }
    }

    public void readDataState(SaveState saveState) {
        this.parseDialog = new ParseDialog(this);
        this.parseDialog.readState(saveState);
    }

    public void writeDataState(SaveState saveState) {
        if (this.parseDialog != null) {
            this.parseDialog.writeState(saveState);
        }
    }

    protected boolean canClose() {
        if (this.parseDialog != null) {
            this.parseDialog.closeProfile();
        }
        return true;
    }

    private void createActions() {
        DockingAction parseAction = new DockingAction(PARSE_ACTION_NAME, this.getName()){

            public void actionPerformed(ActionContext context) {
                CParserPlugin.this.showParseDialog();
            }
        };
        String[] menuPath = new String[]{"&File", "Parse C Source..."};
        MenuData menuData = new MenuData(menuPath, "Import/Export");
        menuData.setMenuSubGroup("d");
        parseAction.setMenuBarData(menuData);
        parseAction.setDescription(DESCRIPTION);
        parseAction.setHelpLocation(new HelpLocation(this.getName(), "Parse_C_Source"));
        parseAction.setEnabled(true);
        this.tool.addAction((DockingActionIf)parseAction);
    }

    protected void showParseDialog() {
        if (this.parseDialog == null) {
            this.parseDialog = new ParseDialog(this);
        } else {
            this.parseDialog.toFront();
        }
        this.tool.showDialog((DialogComponentProvider)this.parseDialog);
    }

    public void doCParser() {
        try {
            String filename1 = "c:/Program Files/Microsoft Visual Studio/VC98/Include/windows.h";
            String[] args = new String[]{"-Ic:/Program Files/Microsoft Visual Studio/VC98/Include/", "-D_M_IX86=500", "-D_MSC_VER=9090", "-D_WIN32_WINNT=0x0400", "-D_WIN32_WINDOWS=0x400", "-D_INTEGRAL_MAX_BITS=32", "-D_X86_", "-D_WIN32"};
            PreProcessor cpp = new PreProcessor();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            cpp.setArgs(args);
            FileOutputStream os = null;
            try {
                os = new FileOutputStream("c:/tmpwindows.h.out");
            }
            catch (FileNotFoundException e) {
                Msg.error((Object)((Object)this), (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
            }
            PrintStream ps = new PrintStream(os);
            System.setErr(ps);
            System.setOut(ps);
            cpp.setOutputStream(bos);
            try {
                cpp.parse(filename1);
            }
            catch (RuntimeException e) {
                Msg.error((Object)((Object)this), (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
            }
            System.out.println(bos);
            FileDataTypeManager dtMgr = FileDataTypeManager.createFileArchive((File)new File("c:/parse.gdt"));
            CParser cParser = new CParser((DataTypeManager)dtMgr, true, null);
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            cParser.parse(bis);
            try {
                DataTypesXmlMgr.writeAsXMLForDebug((DataTypeManager)dtMgr, "c:/parse.xml");
                dtMgr.save();
                dtMgr.close();
            }
            catch (IOException e3) {
                Msg.error((Object)((Object)this), (Object)("Unexpected Exception: " + e3.getMessage()), (Throwable)e3);
            }
        }
        catch (Exception e) {
            Msg.error((Object)((Object)this), (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
        }
    }

    protected void parse(String[] filenames, String options, String dataFilename) {
        CParserTask parseTask = new CParserTask(this, filenames, options, dataFilename);
        this.getTool().execute((Task)parseTask, 500);
    }

    protected void parse(String[] filenames, String options, DataTypeManager dtMgr, TaskMonitor monitor) throws ghidra.app.util.cparser.C.ParseException, ParseException {
        String[] args = this.parseOptions(options);
        DataTypeManager[] openDTmanagers = null;
        DataTypeManagerService dtService = (DataTypeManagerService)this.tool.getService(DataTypeManagerService.class);
        if (dtService != null) {
            openDTmanagers = dtService.getDataTypeManagers();
            ArrayList<DataTypeManager> list = new ArrayList<DataTypeManager>();
            Object htmlNamesList = "";
            for (int i = 0; i < openDTmanagers.length; ++i) {
                if (openDTmanagers[i] instanceof ProgramDataTypeManager) continue;
                list.add(openDTmanagers[i]);
                if (openDTmanagers[i] instanceof BuiltInDataTypeManager) continue;
                htmlNamesList = (String)htmlNamesList + "<li><b>" + openDTmanagers[i].getName() + "</b></li>";
            }
            openDTmanagers = list.toArray(new DataTypeManager[0]);
            if (openDTmanagers.length > 1 && OptionDialog.showOptionDialog((Component)this.parseDialog.getComponent(), (String)"Use Open Archives?", (String)("<html>The following archives are currently open: <ul>" + (String)htmlNamesList + "</ul><p><b>The new archive will become dependent on these archives<br>for any datatypes already defined in them </b>(only unique <br>data types will be added to the new archive)."), (String)"Continue?", (int)3) != 1) {
                return;
            }
        }
        PreProcessor cpp = new PreProcessor();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        cpp.setArgs(args);
        PrintStream os = System.out;
        try {
            String homeDir = System.getProperty("user.home");
            String fName = homeDir + File.separator + "CParserPlugin.out";
            os = new PrintStream(new FileOutputStream(fName));
        }
        catch (FileNotFoundException e2) {
            Msg.error((Object)((Object)this), (Object)("Unexpected Exception: " + e2.getMessage()), (Throwable)e2);
        }
        PrintStream old = System.out;
        System.setOut(os);
        cpp.setOutputStream(bos);
        try {
            for (String filename : filenames) {
                if (monitor.isCancelled()) break;
                File file = new File(filename);
                if (file.isDirectory()) {
                    String[] children = file.list();
                    if (children == null) continue;
                    for (String element : children) {
                        File child = new File(file.getAbsolutePath() + "/" + element);
                        if (!child.getName().endsWith(".h")) continue;
                        this.parseFile(child.getAbsolutePath(), monitor, cpp);
                    }
                    continue;
                }
                this.parseFile(filename, monitor, cpp);
            }
        }
        catch (RuntimeException re) {
            Msg.error((Object)((Object)this), (Object)re.getMessage());
            os.close();
            return;
        }
        cpp.getDefinitions().populateDefineEquates(dtMgr);
        System.out.println(bos);
        System.setOut(old);
        os.close();
        if (!monitor.isCancelled()) {
            monitor.setMessage("Parsing C");
            CParser cParser = new CParser(dtMgr, true, openDTmanagers);
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            cParser.parse(bis);
            boolean isProgramDtMgr = dtMgr instanceof ProgramDataTypeManager;
            SwingUtilities.invokeLater(() -> {
                if (isProgramDtMgr) {
                    Msg.showInfo(((Object)((Object)this)).getClass(), (Component)this.parseDialog.getComponent(), (String)"Parse Header Files Completed", (Object)"Successfully parsed header file(s).\nCheck the Manage Data Types window for added data types.");
                } else {
                    this.parseDialog.setDialogText("Successfully parsed header file(s).");
                }
            });
        }
    }

    private void parseFile(String filename, TaskMonitor monitor, PreProcessor cpp) {
        monitor.setMessage("PreProcessing " + filename);
        try {
            Msg.info((Object)((Object)this), (Object)("parse " + filename));
            cpp.parse(filename);
        }
        catch (Throwable e) {
            Msg.error((Object)((Object)this), (Object)("Parsing file :" + filename));
            Msg.error((Object)((Object)this), (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
        }
    }

    protected void parse(String[] filenames, String options) {
        if (this.currentProgram == null) {
            Msg.showInfo(((Object)((Object)this)).getClass(), (Component)this.parseDialog.getComponent(), (String)"No Open Program", (Object)"A program must be open to \"Parse to Program\"");
            return;
        }
        int result = OptionDialog.showOptionDialog((Component)this.parseDialog.getComponent(), (String)"Confirm", (String)("Parse C source to \"" + this.currentProgram.getDomainFile().getName() + "\"?"), (String)"Continue");
        if (result == 0) {
            return;
        }
        CParserTask parseTask = new CParserTask(this, filenames, options, this.currentProgram.getDataTypeManager());
        this.tool.execute((Task)parseTask);
    }

    ParseDialog getDialog() {
        return this.parseDialog;
    }

    private String[] parseOptions(String options) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer toker = new StringTokenizer(options, "\r\n");
        while (toker.hasMoreTokens()) {
            String val = toker.nextToken();
            val = val.trim();
            StringBuffer arg = new StringBuffer();
            boolean parseQuote = false;
            int index = 0;
            block5: while (index < val.length()) {
                char ch = val.charAt(index++);
                switch (ch) {
                    case '\"': {
                        parseQuote = !parseQuote;
                        continue block5;
                    }
                    case '-': {
                        String sarg;
                        if (parseQuote || (sarg = arg.toString().trim()).length() <= 0) break;
                        list.add(sarg);
                    }
                }
                arg.append(ch);
            }
            String sarg = arg.toString().trim();
            if (sarg.length() <= 0) continue;
            list.add(sarg);
        }
        return list.toArray(new String[list.size()]);
    }
}

