/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;

public class DndTableCellRenderer
implements TableCellRenderer {
    private int rowForFeedback = -1;
    private int rangeMin = -1;
    private int rangeMax = -1;
    private boolean inserting = false;
    private TableCellRenderer orig;
    private DndBorder border;
    private JTable table;

    public DndTableCellRenderer(TableCellRenderer orig, JTable table) {
        this.orig = orig;
        this.table = table;
        this.border = new DndBorder(0, 2, table.getSelectionBackground(), null);
    }

    @Override
    public Component getTableCellRendererComponent(JTable myTable, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JComponent c = (JComponent)this.orig.getTableCellRendererComponent(myTable, value, isSelected, hasFocus, row, column);
        Border origBorder = c.getBorder();
        if (origBorder instanceof DndBorder) {
            origBorder = ((DndBorder)origBorder).getUnderBorder();
        }
        this.border.setUnderBorder(origBorder);
        this.border.clrBorders();
        if (isSelected) {
            if (this.inSameSelectionBlock(row)) {
                if (column == 0 && !this.inserting) {
                    this.border.addBorders(8);
                }
                if (column == myTable.getColumnCount() - 1 && !this.inserting) {
                    this.border.addBorders(2);
                }
                if (row == this.rangeMin) {
                    this.border.addBorders(1);
                }
                if (row == this.rangeMax && !this.inserting) {
                    this.border.addBorders(4);
                }
                c.setBorder(this.border);
            } else {
                c.setBorder(origBorder);
            }
        } else if (row == this.rowForFeedback) {
            this.border.addBorders(1);
            if (!this.inserting) {
                this.border.addBorders(4);
            }
            if (column == 0 && !this.inserting) {
                this.border.addBorders(8);
            }
            if (column == myTable.getColumnCount() - 1 & !this.inserting) {
                this.border.addBorders(2);
            }
            c.setBorder(this.border);
        } else {
            c.setBorder(origBorder);
        }
        return c;
    }

    private boolean inSameSelectionBlock(int row) {
        if (this.rowForFeedback == -1) {
            return false;
        }
        return row >= this.rangeMin && row <= this.rangeMax;
    }

    public Color getBorderColor() {
        return this.border.getColor();
    }

    public void setBorderColor(Color color) {
        this.border.setColor(color);
    }

    public void selectRange(boolean inserting) {
        this.inserting = inserting;
        int tmpRow = this.rowForFeedback;
        this.rowForFeedback = -1;
        this.rangeMin = -1;
        this.rangeMax = -1;
        this.setRowForFeedback(tmpRow);
    }

    public boolean setRowForFeedback(int row) {
        int i;
        if (this.rowForFeedback == row) {
            return false;
        }
        this.rowForFeedback = row;
        this.rangeMin = -1;
        this.rangeMax = -1;
        if (row == -1) {
            return true;
        }
        ListSelectionModel model = this.table.getSelectionModel();
        if (!model.isSelectedIndex(row)) {
            return true;
        }
        this.rangeMin = row;
        this.rangeMax = row;
        if (this.inserting) {
            return true;
        }
        int[] rows = this.table.getSelectedRows();
        int index = -1;
        for (i = 0; i < rows.length; ++i) {
            if (row != rows[i]) continue;
            index = i;
        }
        if (index != -1) {
            for (i = index - 1; i >= 0; --i) {
                if (rows[i] + 1 != rows[i + 1]) {
                    this.rangeMin = rows[i + 1];
                    break;
                }
                this.rangeMin = rows[i];
            }
            for (i = index + 1; i < rows.length; ++i) {
                if (rows[i - 1] != rows[i] - 1) {
                    this.rangeMax = rows[i - 1];
                    break;
                }
                this.rangeMax = rows[i];
            }
        }
        return true;
    }

    public static class DndBorder
    extends AbstractBorder {
        private static final long serialVersionUID = 1L;
        private int borders;
        private int thickness;
        private Color color;
        private Border under;
        public static final int TOP = 1;
        public static final int RIGHT = 2;
        public static final int BOTTOM = 4;
        public static final int LEFT = 8;
        public static final int ALL = 15;

        public DndBorder(int borders, int thickness, Color color, Border under) {
            this.borders = borders;
            this.thickness = thickness;
            this.color = color;
            this.under = under;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (this.under != null) {
                this.under.paintBorder(c, g, x, y, width, height);
            }
            Graphics g2 = g.create();
            g2.setColor(this.color);
            if ((this.borders & 1) == 1) {
                g2.fillRect(x, y, width, this.thickness);
            }
            if ((this.borders & 2) == 2) {
                g2.fillRect(x + width - this.thickness, y, this.thickness, height);
            }
            if ((this.borders & 4) == 4) {
                g2.fillRect(x, y + height - this.thickness, width, this.thickness);
            }
            if ((this.borders & 8) == 8) {
                g2.fillRect(x, y, this.thickness, height);
            }
            g2.dispose();
        }

        @Override
        public Insets getBorderInsets(Component c) {
            if (this.under != null) {
                Insets result = this.under.getBorderInsets(c);
                return result;
            }
            throw new IllegalStateException("Must set under border");
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            if (this.under == null) {
                throw new IllegalStateException("Must set under border");
            }
            if (this.under instanceof AbstractBorder) {
                return ((AbstractBorder)this.under).getBorderInsets(c, insets);
            }
            Insets temp = this.under.getBorderInsets(c);
            insets.top = temp.top;
            insets.left = temp.left;
            insets.bottom = temp.bottom;
            insets.right = temp.right;
            return insets;
        }

        public void addBorders(int border) {
            this.borders |= border;
        }

        public void delBorders(int border) {
            this.borders &= ~border;
        }

        public void clrBorders() {
            this.borders = 0;
        }

        public void setUnderBorder(Border under) {
            this.under = under;
        }

        public Border getUnderBorder() {
            return this.under;
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
        }
    }
}

