/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.clear;

import docking.DialogComponentProvider;
import ghidra.app.context.ListingActionContext;
import ghidra.app.plugin.core.clear.ClearOptions;
import ghidra.app.plugin.core.clear.ClearPlugin;
import ghidra.util.HelpLocation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class ClearDialog
extends DialogComponentProvider {
    private ClearPlugin plugin;
    private JPanel panel;
    private JCheckBox symbolsCb;
    private JCheckBox commentsCb;
    private JCheckBox propertiesCb;
    private JCheckBox codeCb;
    private JCheckBox functionsCb;
    private JCheckBox registersCb;
    private JCheckBox equatesCb;
    private JCheckBox userReferencesCb;
    private JCheckBox analysisReferencesCb;
    private JCheckBox importReferencesCb;
    private JCheckBox systemReferencesCb;
    private JCheckBox bookmarksCb;
    private ListingActionContext context;

    ClearDialog(ClearPlugin plugin) {
        super("Clear");
        this.plugin = plugin;
        this.create();
        this.addWorkPanel(this.panel);
        this.addOKButton();
        this.addCancelButton();
        this.setHelpLocation(new HelpLocation(plugin.getName(), "Clear_With_Options"));
    }

    public void okCallback() {
        this.close();
        ClearOptions opts = new ClearOptions();
        opts.setClearCode(this.codeCb.isSelected());
        opts.setClearSymbols(this.symbolsCb.isSelected());
        opts.setClearComments(this.commentsCb.isSelected());
        opts.setClearProperties(this.propertiesCb.isSelected());
        opts.setClearFunctions(this.functionsCb.isSelected());
        opts.setClearRegisters(this.registersCb.isSelected());
        opts.setClearEquates(this.equatesCb.isSelected());
        opts.setClearUserReferences(this.userReferencesCb.isSelected());
        opts.setClearAnalysisReferences(this.analysisReferencesCb.isSelected());
        opts.setClearImportReferences(this.importReferencesCb.isSelected());
        opts.setClearDefaultReferences(this.systemReferencesCb.isSelected());
        opts.setClearBookmarks(this.bookmarksCb.isSelected());
        this.plugin.clear(opts, this.context);
    }

    protected void cancelCallback() {
        this.close();
    }

    private void create() {
        KeyAdapter listener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    e.consume();
                    ClearDialog.this.okCallback();
                }
            }
        };
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout(10, 10));
        JLabel label = new JLabel("Clear Options:");
        this.panel.add((Component)label, "North");
        JPanel cbPanel = new JPanel();
        BoxLayout bl = new BoxLayout(cbPanel, 1);
        cbPanel.setLayout(bl);
        this.symbolsCb = new JCheckBox("Symbols");
        this.commentsCb = new JCheckBox("<HTML>Comments <FONT SIZE=\"2\">(does not affect automatic comments)</FONT>");
        this.commentsCb.setVerticalTextPosition(1);
        this.propertiesCb = new JCheckBox("Properties");
        this.codeCb = new JCheckBox("Code");
        this.functionsCb = new JCheckBox("Functions");
        this.registersCb = new JCheckBox("Registers");
        this.equatesCb = new JCheckBox("Equates");
        this.userReferencesCb = new JCheckBox("User-defined References");
        this.analysisReferencesCb = new JCheckBox("Analysis References");
        this.importReferencesCb = new JCheckBox("Import References");
        this.systemReferencesCb = new JCheckBox("Default References");
        this.bookmarksCb = new JCheckBox("Bookmarks");
        this.symbolsCb.setSelected(true);
        this.symbolsCb.addKeyListener(listener);
        this.commentsCb.setSelected(true);
        this.commentsCb.addKeyListener(listener);
        this.propertiesCb.setSelected(true);
        this.propertiesCb.addKeyListener(listener);
        this.codeCb.setSelected(true);
        this.codeCb.addKeyListener(listener);
        this.functionsCb.setSelected(true);
        this.functionsCb.addKeyListener(listener);
        this.registersCb.setSelected(true);
        this.registersCb.addKeyListener(listener);
        this.equatesCb.setSelected(true);
        this.equatesCb.addKeyListener(listener);
        this.userReferencesCb.setSelected(true);
        this.userReferencesCb.addKeyListener(listener);
        this.analysisReferencesCb.setSelected(true);
        this.analysisReferencesCb.addKeyListener(listener);
        this.importReferencesCb.setSelected(true);
        this.importReferencesCb.addKeyListener(listener);
        this.systemReferencesCb.setSelected(true);
        this.systemReferencesCb.addKeyListener(listener);
        this.bookmarksCb.setSelected(true);
        this.bookmarksCb.addKeyListener(listener);
        cbPanel.add(this.symbolsCb);
        cbPanel.add(this.commentsCb);
        cbPanel.add(this.propertiesCb);
        cbPanel.add(this.codeCb);
        cbPanel.add(this.userReferencesCb);
        cbPanel.add(this.analysisReferencesCb);
        cbPanel.add(this.importReferencesCb);
        cbPanel.add(this.systemReferencesCb);
        cbPanel.add(this.functionsCb);
        cbPanel.add(this.registersCb);
        cbPanel.add(this.equatesCb);
        cbPanel.add(this.bookmarksCb);
        this.codeCb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (ClearDialog.this.codeCb.isSelected()) {
                    ClearDialog.this.userReferencesCb.setSelected(true);
                    ClearDialog.this.userReferencesCb.setEnabled(false);
                    ClearDialog.this.analysisReferencesCb.setSelected(true);
                    ClearDialog.this.analysisReferencesCb.setEnabled(false);
                    ClearDialog.this.importReferencesCb.setSelected(true);
                    ClearDialog.this.importReferencesCb.setEnabled(false);
                    ClearDialog.this.systemReferencesCb.setSelected(true);
                    ClearDialog.this.systemReferencesCb.setEnabled(false);
                } else {
                    ClearDialog.this.userReferencesCb.setEnabled(true);
                    ClearDialog.this.analysisReferencesCb.setEnabled(true);
                    ClearDialog.this.importReferencesCb.setEnabled(true);
                    ClearDialog.this.systemReferencesCb.setEnabled(true);
                }
            }
        });
        this.userReferencesCb.setEnabled(false);
        this.analysisReferencesCb.setEnabled(false);
        this.importReferencesCb.setEnabled(false);
        this.systemReferencesCb.setEnabled(false);
        final ArrayList<JCheckBox> checkBoxList = new ArrayList<JCheckBox>(10);
        checkBoxList.add(this.symbolsCb);
        checkBoxList.add(this.commentsCb);
        checkBoxList.add(this.propertiesCb);
        checkBoxList.add(this.codeCb);
        checkBoxList.add(this.userReferencesCb);
        checkBoxList.add(this.analysisReferencesCb);
        checkBoxList.add(this.importReferencesCb);
        checkBoxList.add(this.systemReferencesCb);
        checkBoxList.add(this.functionsCb);
        checkBoxList.add(this.registersCb);
        checkBoxList.add(this.equatesCb);
        checkBoxList.add(this.bookmarksCb);
        JPanel buttonPanel = new JPanel();
        JButton selectAllButton = new JButton("Select All");
        selectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClearDialog.this.setAllCheckBoxesSelected(true, checkBoxList);
            }
        });
        JButton deselectAllbutton = new JButton("Deselect All");
        deselectAllbutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClearDialog.this.setAllCheckBoxesSelected(false, checkBoxList);
            }
        });
        buttonPanel.add(selectAllButton);
        buttonPanel.add(Box.createHorizontalStrut(10));
        buttonPanel.add(deselectAllbutton);
        JPanel lowerPanel = new JPanel();
        lowerPanel.setLayout(new BoxLayout(lowerPanel, 1));
        JSeparator separator = new JSeparator();
        lowerPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 5, 10));
        lowerPanel.add(separator);
        lowerPanel.add(buttonPanel);
        JPanel p = new JPanel(new FlowLayout(1));
        p.add(cbPanel);
        this.panel.add((Component)p, "Center");
        this.panel.add((Component)lowerPanel, "South");
    }

    private void setAllCheckBoxesSelected(boolean selected, List<JCheckBox> list) {
        for (JCheckBox checkBox : list) {
            checkBox.setSelected(selected);
        }
    }

    public void setProgramActionContext(ListingActionContext context) {
        this.context = context;
    }
}

