/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.checksums;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.ToggleDockingAction;
import docking.action.ToolBarData;
import ghidra.app.context.ProgramContextAction;
import ghidra.app.plugin.core.checksums.ChecksumAlgorithm;
import ghidra.app.plugin.core.checksums.ChecksumTableModel;
import ghidra.app.plugin.core.checksums.ComputeChecksumTask;
import ghidra.app.plugin.core.checksums.ComputeChecksumsPlugin;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.util.HelpLocation;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.table.GhidraTable;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;
import resources.Icons;
import resources.ResourceManager;

public class ComputeChecksumsProvider
extends ComponentProviderAdapter {
    private ComputeChecksumsPlugin plugin;
    private DockingAction computeAction;
    private ToggleDockingAction selectionAction;
    private ToggleDockingAction showHexAction;
    private ToggleDockingAction xorAction;
    private ToggleDockingAction carryAction;
    private ToggleDockingAction onesCompAction;
    private ToggleDockingAction twosCompAction;
    private GhidraTable table;
    private ChecksumTableModel model;
    private List<ChecksumAlgorithm> checksums = new ArrayList<ChecksumAlgorithm>();
    private boolean hasResults;
    private JPanel mainPanel;
    private JLabel errorStatus;

    public ComputeChecksumsProvider(ComputeChecksumsPlugin plugin) {
        super(plugin.getTool(), "Checksum Generator", plugin.getName(), ProgramContextAction.class);
        this.setHelpLocation(new HelpLocation("ComputeChecksumsPlugin", "Generate_Checksum_Help"));
        ClassSearcher.getInstances(ChecksumAlgorithm.class).forEach(alg -> this.addChecksumAlgorithm((ChecksumAlgorithm)alg));
        this.plugin = plugin;
        this.mainPanel = this.createWorkPanel();
        this.setSelection(false);
        this.addToTool();
        this.createActions();
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    private JPanel createWorkPanel() {
        this.initializeTable();
        JPanel main = new JPanel();
        main.setLayout(new BorderLayout());
        JPanel resultsMainPanel = new JPanel(new BorderLayout());
        resultsMainPanel.setBorder(BorderFactory.createTitledBorder("Checksum Results"));
        JPanel tablePanel = new JPanel(new BorderLayout());
        JScrollPane scroll = new JScrollPane((Component)((Object)this.table));
        tablePanel.add(scroll);
        resultsMainPanel.add(tablePanel);
        main.add((Component)resultsMainPanel, "Center");
        this.errorStatus = new JLabel(" ");
        this.errorStatus.setName("message");
        this.errorStatus.setHorizontalAlignment(0);
        this.errorStatus.setForeground(Color.RED);
        this.errorStatus.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        main.add((Component)this.errorStatus, "South");
        return main;
    }

    private void generate() {
        if (this.plugin.getProgram() == null || !this.isVisible()) {
            return;
        }
        ComputeChecksumTask task = new ComputeChecksumTask(this, this.plugin.getProgram().getMemory(), this.doOnSelection() ? this.plugin.getSelection() : null);
        new TaskLauncher((Task)task, (Component)this.mainPanel);
        if (task.hasError()) {
            this.setErrorMessage(task.getErrorMessage());
        }
    }

    void generateChecksumCompleted() {
        this.hasResults = true;
        this.updateFields();
    }

    void setSelection(boolean state) {
        this.setErrorMessage("");
        if (this.selectionAction == null) {
            return;
        }
        this.selectionAction.setSelected(state);
        this.selectionAction.setEnabled(state);
        if (state) {
            this.generate();
        } else {
            this.clearFields();
        }
    }

    private boolean doOnSelection() {
        return this.selectionAction.isEnabled() && this.plugin.hasSelection() && this.selectionAction.isSelected();
    }

    public boolean isOnes() {
        return this.onesCompAction.isSelected();
    }

    public boolean isTwos() {
        return this.twosCompAction.isSelected();
    }

    public boolean isXor() {
        return this.xorAction.isSelected();
    }

    public boolean isCarry() {
        return this.carryAction.isSelected();
    }

    public ChecksumTableModel getModel() {
        return this.model;
    }

    public GhidraTable getTable() {
        return this.table;
    }

    public List<ChecksumAlgorithm> getChecksums() {
        return this.checksums;
    }

    public void addChecksumAlgorithm(ChecksumAlgorithm checksumAlgorithm) {
        this.checksums.add(checksumAlgorithm);
        if (this.model != null) {
            this.model.fireTableDataChanged();
        }
    }

    private void initializeTable() {
        this.model = new ChecksumTableModel((ServiceProvider)this.tool, this.checksums);
        this.table = new GhidraTable((TableModel)((Object)this.model));
        this.table.setSelectionMode(0);
    }

    void updateFields() {
        if (!this.hasResults) {
            return;
        }
        this.model.formatOptions(this.showHexAction.isSelected());
        this.model.fireTableDataChanged();
    }

    private void clearFields() {
        if (this.checksums != null) {
            this.checksums.stream().forEach(checkResult -> checkResult.reset());
        }
        this.model.fireTableDataChanged();
    }

    private void createActions() {
        this.computeAction = new DockingAction("Compute Checksum", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                ComputeChecksumsProvider.this.generate();
            }

            public boolean isEnabledForContext(ActionContext context) {
                return ComputeChecksumsProvider.this.isVisible();
            }
        };
        this.computeAction.setHelpLocation(new HelpLocation("ComputeChecksumsPlugin", "compute"));
        this.computeAction.setEnabled(true);
        this.computeAction.setToolBarData(new ToolBarData((Icon)Icons.REFRESH_ICON, null));
        this.computeAction.setDescription("Refreshes checksums");
        this.selectionAction = new ToggleDockingAction("On Selection", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                ComputeChecksumsProvider.this.updateFields();
                ComputeChecksumsProvider.this.generate();
            }

            public boolean isEnabledForContext(ActionContext context) {
                return ComputeChecksumsProvider.this.isVisible();
            }
        };
        this.selectionAction.setHelpLocation(new HelpLocation("ComputeChecksumsPlugin", "On_Selection"));
        this.selectionAction.setEnabled(this.plugin.hasSelection());
        this.selectionAction.setToolBarData(new ToolBarData((Icon)ResourceManager.loadImage((String)"images/NextSelectionBlock16.gif"), null));
        this.selectionAction.setDescription("When toggled, generates checksums on selection. Otherwise checksums are generated over the entire program");
        this.showHexAction = new ToggleDockingAction("Show Hex Values", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                ComputeChecksumsProvider.this.updateFields();
            }

            public boolean isEnabledForContext(ActionContext context) {
                return ComputeChecksumsProvider.this.isVisible();
            }
        };
        this.showHexAction.setHelpLocation(new HelpLocation("ComputeChecksumsPlugin", "As_Hex"));
        this.showHexAction.setEnabled(true);
        this.showHexAction.setToolBarData(new ToolBarData((Icon)ResourceManager.loadImage((String)"images/hexData.png"), null));
        this.showHexAction.setDescription("Toggle to show the hex values instead of decimal values.");
        this.xorAction = new ToggleDockingAction("XOR Checksum Values", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                if (ComputeChecksumsProvider.this.xorAction.isSelected() && ComputeChecksumsProvider.this.carryAction.isSelected()) {
                    ComputeChecksumsProvider.this.carryAction.setSelected(false);
                }
                ComputeChecksumsProvider.this.generate();
            }

            public boolean isEnabledForContext(ActionContext context) {
                return ComputeChecksumsProvider.this.isVisible();
            }
        };
        this.xorAction.setHelpLocation(new HelpLocation("ComputeChecksumsPlugin", "xor"));
        this.xorAction.setEnabled(true);
        this.xorAction.setToolBarData(new ToolBarData((Icon)ResourceManager.loadImage((String)"images/xor.png"), null));
        this.xorAction.setDescription("Toggle to recompute values with a xor operation.");
        this.carryAction = new ToggleDockingAction("Carry Checksum Values", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                if (ComputeChecksumsProvider.this.carryAction.isSelected() && ComputeChecksumsProvider.this.xorAction.isSelected()) {
                    ComputeChecksumsProvider.this.xorAction.setSelected(false);
                }
                ComputeChecksumsProvider.this.generate();
            }

            public boolean isEnabledForContext(ActionContext context) {
                return ComputeChecksumsProvider.this.isVisible();
            }
        };
        this.carryAction.setHelpLocation(new HelpLocation("ComputeChecksumsPlugin", "carry"));
        this.carryAction.setEnabled(true);
        this.carryAction.setToolBarData(new ToolBarData((Icon)ResourceManager.loadImage((String)"images/carry.png"), null));
        this.carryAction.setDescription("Toggle to recompute values with a carry operation.");
        this.onesCompAction = new ToggleDockingAction("Ones Complement", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                if (ComputeChecksumsProvider.this.onesCompAction.isSelected() && ComputeChecksumsProvider.this.twosCompAction.isSelected()) {
                    ComputeChecksumsProvider.this.twosCompAction.setSelected(false);
                }
                ComputeChecksumsProvider.this.generate();
            }

            public boolean isEnabledForContext(ActionContext context) {
                return ComputeChecksumsProvider.this.isVisible();
            }
        };
        this.onesCompAction.setHelpLocation(new HelpLocation("ComputeChecksumsPlugin", "ones_comp"));
        this.onesCompAction.setEnabled(true);
        this.onesCompAction.setToolBarData(new ToolBarData((Icon)ResourceManager.loadImage((String)"images/onesComplement.png"), null));
        this.onesCompAction.setDescription("Toggle to recompute values with a one's complement.");
        this.twosCompAction = new ToggleDockingAction("Twos Complement", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                if (ComputeChecksumsProvider.this.onesCompAction.isSelected() && ComputeChecksumsProvider.this.twosCompAction.isSelected()) {
                    ComputeChecksumsProvider.this.onesCompAction.setSelected(false);
                }
                ComputeChecksumsProvider.this.generate();
            }

            public boolean isEnabledForContext(ActionContext context) {
                return ComputeChecksumsProvider.this.isVisible();
            }
        };
        this.twosCompAction.setHelpLocation(new HelpLocation("ComputeChecksumsPlugin", "twos_comp"));
        this.twosCompAction.setEnabled(true);
        this.twosCompAction.setToolBarData(new ToolBarData((Icon)ResourceManager.loadImage((String)"images/twosComplement.png"), null));
        this.twosCompAction.setDescription("Toggle to recompute values with a two's complement.");
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.onesCompAction);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.twosCompAction);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.xorAction);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.carryAction);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.selectionAction);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.showHexAction);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.computeAction);
    }

    void dispose() {
        this.table.dispose();
    }

    String getErrorStatus() {
        return this.errorStatus.getText();
    }

    private void setErrorMessage(String text) {
        this.errorStatus.setText(text);
    }
}

