/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.archive;

import generic.io.JarReader;
import ghidra.app.plugin.core.archive.ArchivePlugin;
import ghidra.framework.main.FrontEndTool;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.model.ProjectManager;
import ghidra.util.Msg;
import ghidra.util.NotOwnerException;
import ghidra.util.exception.DuplicateFileException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.jar.JarInputStream;
import javax.swing.SwingUtilities;
import utilities.util.FileUtilities;

class RestoreTask
extends Task {
    private File jarFile;
    private ProjectLocator projectLocator;
    private ArchivePlugin plugin;
    private String message;

    RestoreTask(ProjectLocator projectLocator, File inJarFile, ArchivePlugin plugin) {
        super("Restoring Project: " + projectLocator.getName(), true, false, true);
        this.projectLocator = projectLocator;
        this.jarFile = inJarFile;
        this.plugin = plugin;
    }

    public void run(TaskMonitor monitor) {
        boolean ok = false;
        try {
            this.unjarArchive(monitor);
            ok = true;
        }
        catch (Exception e) {
            Msg.showError((Object)((Object)this), null, null, null, (Throwable)e);
            this.message = this.message + " failed.";
        }
        this.message = "\"" + this.projectLocator.toString() + "\" from \"" + this.jarFile.getAbsolutePath() + "\"";
        if (monitor.isCancelled()) {
            this.message = this.message + " was cancelled by user.";
            this.plugin.cleanupRestoredProject(this.projectLocator);
        } else {
            this.message = this.message + (ok ? " succeeded." : " failed.");
            boolean success = ok;
            Runnable r = () -> this.restoreCompleted(success);
            try {
                SwingUtilities.invokeAndWait(r);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        Msg.info((Object)((Object)this), (Object)("Restore Archive: " + this.message));
    }

    private void unjarArchive(TaskMonitor monitor) throws IOException {
        JarInputStream jarIn = new JarInputStream(new FileInputStream(this.jarFile));
        JarReader reader = new JarReader(jarIn);
        jarIn.getNextJarEntry();
        jarIn.getNextJarEntry();
        File projectFile = this.projectLocator.getMarkerFile();
        File projectDir = this.projectLocator.getProjectDir();
        if (projectFile.exists()) {
            throw new DuplicateFileException("Project already exists: " + projectFile);
        }
        if (projectDir.exists()) {
            throw new DuplicateFileException("Project already exists: " + projectDir);
        }
        reader.createRecursively(projectDir.getAbsolutePath() + File.separator, monitor);
        jarIn.close();
        if (monitor.isCancelled()) {
            return;
        }
        File file = new File(projectDir, "project.prp");
        file.delete();
        file = new File(projectDir, "projectState");
        file.delete();
        file = new File(projectDir, "save");
        FileUtilities.deleteDir((File)file);
        file = new File(projectDir, "groups");
        FileUtilities.deleteDir((File)file);
        RestoreTask.removeOldFolderProperties(projectDir);
        if (!projectFile.createNewFile()) {
            throw new IOException("Couldn't create file " + projectFile.getAbsolutePath());
        }
    }

    private static void removeOldFolderProperties(File dir) {
        File[] files;
        File f = new File(dir, ".properties");
        f.delete();
        for (File file : files = dir.listFiles()) {
            if (!file.isDirectory()) continue;
            RestoreTask.removeOldFolderProperties(file);
        }
    }

    private void restoreCompleted(boolean ok) {
        if (ok) {
            ProjectManager pm = this.plugin.getTool().getProjectManager();
            try {
                Project project = pm.openProject(this.projectLocator, true, true);
                pm.rememberProject(this.projectLocator);
                FrontEndTool tool = (FrontEndTool)this.plugin.getTool();
                tool.setActiveProject(project);
            }
            catch (NotOwnerException project) {
            }
            catch (Exception e) {
                this.message = "Error opening project: " + this.projectLocator.getName();
                Msg.showError((Object)((Object)this), null, null, null, (Throwable)e);
            }
        } else {
            this.plugin.cleanupRestoredProject(this.projectLocator);
        }
    }
}

