/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge.datatypes;

import ghidra.app.merge.MergeResolver;
import ghidra.app.merge.datatypes.CategoryMergePanel;
import ghidra.app.merge.datatypes.DataTypeMergePanel;
import ghidra.app.merge.datatypes.SourceArchiveMergePanel;
import ghidra.app.plugin.core.datamgr.archive.SourceArchive;
import ghidra.framework.data.DomainObjectMergeManager;
import ghidra.program.database.data.DataTypeManagerDB;
import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.BadDataType;
import ghidra.program.model.data.BuiltIn;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeDependencyException;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypeManagerDomainObject;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.TypedefDataType;
import ghidra.program.model.data.Union;
import ghidra.program.model.listing.DataTypeChangeSet;
import ghidra.util.HelpLocation;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.UniversalID;
import ghidra.util.datastruct.LongObjectHashtable;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.TaskMonitorAdapter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;

public class DataTypeMergeManager
implements MergeResolver {
    private static String[] DATA_TYPES_PHASE = new String[]{"Data Types"};
    private static final int RESULT = 0;
    private static final int ORIGINAL = 3;
    private static final int LATEST = 1;
    private static final int MY = 2;
    static final int CANCELED = -2;
    static final int ASK_USER = -1;
    static final int OPTION_LATEST = 0;
    static final int OPTION_MY = 1;
    static final int OPTION_ORIGINAL = 2;
    private DomainObjectMergeManager mergeManager;
    private DataTypeManagerDomainObject[] domainObjects = new DataTypeManagerDomainObject[4];
    private DataTypeManager[] dtms = new DataTypeManager[4];
    private TaskMonitor currentMonitor;
    private int originalConflictOption;
    private int conflictOption;
    private HashMap<UniversalID, Boolean> dirtyMap;
    private ArrayList<Long> myArchiveAddedList;
    private ArrayList<Long> myArchiveChangeList;
    private ArrayList<Long> archiveConflictList;
    private SourceArchiveMergePanel archiveMergePanel;
    private ArrayList<Long> myCatAddedList;
    private ArrayList<Long> myCatChangeList;
    private ArrayList<Long> catConflictList;
    private CategoryMergePanel catMergePanel;
    private ArrayList<Long> myDtAddedList;
    private ArrayList<Long> myDtChangeList;
    private ArrayList<Long> dtConflictList;
    private ArrayList<Long> dtSourceConflictList;
    private ArrayList<Long> origDtConflictList;
    private DataTypeMergePanel dtMergePanel;
    private int totalConflictCount;
    private int currentConflictIndex;
    private LongObjectHashtable<DataType> myResolvedDts;
    private LongObjectHashtable<DataType> latestResolvedDts;
    private LongObjectHashtable<DataType> origResolvedDts;
    private List<FixUpInfo> fixUpList;
    private LongObjectHashtable<CleanUpInfo> cleanupPlaceHolderList;
    private int progressIndex;
    private int categoryChoice = -1;
    private int dataTypeChoice = -1;
    private int sourceArchiveChoice = -1;

    public DataTypeMergeManager(DomainObjectMergeManager mergeManager, DataTypeManagerDomainObject resultDomainObject, DataTypeManagerDomainObject myDomainObject, DataTypeManagerDomainObject originalDomainObject, DataTypeManagerDomainObject latestDomainObject, DataTypeChangeSet latestChanges, DataTypeChangeSet myChanges) {
        this.mergeManager = mergeManager;
        this.domainObjects[0] = resultDomainObject;
        this.domainObjects[3] = originalDomainObject;
        this.domainObjects[1] = latestDomainObject;
        this.domainObjects[2] = myDomainObject;
        this.dtms[0] = resultDomainObject.getDataTypeManager();
        this.dtms[3] = originalDomainObject.getDataTypeManager();
        this.dtms[1] = latestDomainObject.getDataTypeManager();
        this.dtms[2] = myDomainObject.getDataTypeManager();
        this.totalConflictCount = 0;
        this.setupSourceArchiveChanges(latestChanges, myChanges);
        this.setupDataTypeChanges(latestChanges, myChanges);
        this.setupCategoryChanges(latestChanges, myChanges);
        this.originalConflictOption = -1;
        this.conflictOption = -1;
    }

    @Override
    public void apply() {
        if (this.catMergePanel != null && this.catMergePanel.isVisible()) {
            this.conflictOption = this.catMergePanel.getSelectedOption();
            if (this.catMergePanel.getUseForAll()) {
                this.categoryChoice = this.conflictOption;
            }
        } else if (this.dtMergePanel != null && this.dtMergePanel.isVisible()) {
            this.conflictOption = this.dtMergePanel.getSelectedOption();
            if (this.dtMergePanel.getUseForAll()) {
                this.dataTypeChoice = this.conflictOption;
            }
        } else {
            this.conflictOption = this.archiveMergePanel.getSelectedOption();
            if (this.archiveMergePanel.getUseForAll()) {
                this.sourceArchiveChoice = this.conflictOption;
            }
        }
    }

    @Override
    public void cancel() {
        this.conflictOption = -2;
    }

    @Override
    public String getDescription() {
        return "Merge Data Types and Categories";
    }

    @Override
    public String getName() {
        return "Data Type Merger";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void merge(TaskMonitor monitor) {
        this.mergeManager.setInProgress(DATA_TYPES_PHASE);
        this.currentMonitor = monitor;
        monitor.initialize((long)(this.totalConflictCount + this.myCatAddedList.size() + this.myCatChangeList.size() + this.myDtAddedList.size() + this.myDtChangeList.size()));
        int transactionID = this.domainObjects[0].startTransaction("Merge Categories/Data Types");
        boolean commit = false;
        try {
            this.mergeManager.updateProgress(0, "Data Type Merge is processing changed source archives...");
            this.processSourceArchiveChanges();
            this.mergeManager.updateProgress(2, "Data Type Merge is processing added source archives...");
            this.processSourceArchiveAdditions();
            this.mergeManager.updateProgress(4, "Data Type Merge is processing source archive conflicts...");
            this.processSourceArchiveConflicts();
            this.mergeManager.updateProgress(6, "Data Type Merge is processing category changes...");
            this.processCategoryChanges();
            this.mergeManager.updateProgress(12, "Data Type Merge is processing deleted data types...");
            this.processDataTypesDeleted();
            this.mergeManager.updateProgress(25, "Data Type Merge is processing added data types...");
            this.processDataTypesAdded();
            this.mergeManager.updateProgress(37, "Data Type Merge is processing changed data types...");
            this.processDataTypeChanges();
            this.mergeManager.updateProgress(50, "Data Type Merge is processing data type conflicts...");
            this.processDataTypeConflicts();
            this.mergeManager.updateProgress(62, "Data Type Merge is processing deleted categories...");
            this.processCategoriesDeleted();
            this.mergeManager.updateProgress(75, "Data Type Merge is processing added categories...");
            this.processCategoriesAdded();
            this.mergeManager.updateProgress(87, "Data Type Merge is processing category conflicts...");
            this.processCategoryConflicts();
            this.fixupDirtyFlags();
            this.mergeManager.updateProgress(100, this.getDescription());
            if (this.mergeManager != null) {
                this.mergeManager.setResolveInformation("ResolvedLatestDataTypes", this.latestResolvedDts);
                this.mergeManager.setResolveInformation("ResolvedMyDataTypes", this.myResolvedDts);
                this.mergeManager.setResolveInformation("ResolvedOriginalDataTypes", this.origResolvedDts);
            }
            commit = true;
        }
        catch (CancelledException cancelledException) {
        }
        finally {
            this.domainObjects[0].endTransaction(transactionID, commit);
        }
        this.mergeManager.setCompleted(DATA_TYPES_PHASE);
    }

    void setConflictResolution(int option) {
        this.conflictOption = option;
        this.originalConflictOption = option;
    }

    private void processSourceArchiveChanges() throws CancelledException {
        this.conflictOption = 1;
        for (int i = 0; i < this.myArchiveChangeList.size(); ++i) {
            if (this.currentMonitor.isCancelled()) {
                throw new CancelledException();
            }
            this.currentMonitor.setProgress((long)(++this.progressIndex));
            long id = this.myArchiveChangeList.get(i);
            this.updateSourceArchive(id);
        }
        this.resetOption();
    }

    private void updateSourceArchive(long id) {
        UniversalID universalID = new UniversalID(id);
        SourceArchive resultSourceArchive = this.dtms[0].getSourceArchive(universalID);
        SourceArchive sourceArchive = null;
        int optionToUse = this.sourceArchiveChoice == -1 ? this.conflictOption : this.sourceArchiveChoice;
        switch (optionToUse) {
            case 0: {
                return;
            }
            case 1: {
                sourceArchive = this.dtms[2].getSourceArchive(universalID);
                break;
            }
            case 2: {
                sourceArchive = this.dtms[3].getSourceArchive(universalID);
                break;
            }
            default: {
                return;
            }
        }
        if (resultSourceArchive == null) {
            if (sourceArchive != null) {
                this.addSourceArchive(sourceArchive);
            }
            return;
        }
        if (sourceArchive == null) {
            this.removeSourceArchive(universalID);
            return;
        }
        this.updateSourceName(resultSourceArchive, sourceArchive.getName());
        this.adjustTime(resultSourceArchive, this.dtms[2].getSourceArchive(universalID));
    }

    private void updateSourceName(SourceArchive resultSourceArchive, String name) {
        if (!resultSourceArchive.getName().equals(name)) {
            resultSourceArchive.setName(name);
        }
    }

    private void processSourceArchiveAdditions() throws CancelledException {
        for (int i = 0; i < this.myArchiveAddedList.size(); ++i) {
            if (this.currentMonitor.isCancelled()) {
                throw new CancelledException();
            }
            this.currentMonitor.setProgress((long)(++this.progressIndex));
            long id = this.myArchiveAddedList.get(i);
            UniversalID universalID = new UniversalID(id);
            SourceArchive mySourceArchive = this.dtms[2].getSourceArchive(universalID);
            this.addSourceArchive(mySourceArchive);
        }
    }

    private void addSourceArchive(SourceArchive mySourceArchive) {
        SourceArchive resultSourceArchive = this.dtms[0].getSourceArchive(mySourceArchive.getSourceArchiveID());
        if (resultSourceArchive != null) {
            this.adjustTime(resultSourceArchive, mySourceArchive);
            return;
        }
        ((DataTypeManagerDB)this.dtms[0]).resolveSourceArchive(mySourceArchive);
    }

    private void removeSourceArchive(UniversalID universalID) {
        SourceArchive resultSourceArchive = this.dtms[0].getSourceArchive(universalID);
        if (resultSourceArchive == null) {
            return;
        }
        ((DataTypeManagerDB)this.dtms[0]).removeSourceArchive(resultSourceArchive);
    }

    private void adjustTime(SourceArchive resultSourceArchive, SourceArchive mySourceArchive) {
        UniversalID sourceID;
        Boolean dirtyFlagObject;
        long resultTime = resultSourceArchive.getLastSyncTime();
        long myTime = mySourceArchive.getLastSyncTime();
        if (myTime > resultTime) {
            resultSourceArchive.setLastSyncTime(myTime);
        }
        if ((dirtyFlagObject = this.dirtyMap.get(sourceID = mySourceArchive.getSourceArchiveID())) != null) {
            boolean finalDirtyFlag = dirtyFlagObject;
            if (resultSourceArchive.isDirty() != finalDirtyFlag) {
                resultSourceArchive.setDirtyFlag(finalDirtyFlag);
            }
        }
    }

    private void fixupDirtyFlags() {
        for (UniversalID sourceID : this.dirtyMap.keySet()) {
            boolean isDirty = this.dirtyMap.get(sourceID);
            SourceArchive sourceArchive = this.dtms[0].getSourceArchive(sourceID);
            if (sourceArchive.isDirty() == isDirty) continue;
            sourceArchive.setDirtyFlag(isDirty);
        }
    }

    private void processSourceArchiveConflicts() throws CancelledException {
        for (int i = 0; i < this.archiveConflictList.size(); ++i) {
            if (this.currentMonitor.isCancelled()) {
                throw new CancelledException();
            }
            this.currentMonitor.setProgress((long)(++this.progressIndex));
            long sourceArchiveID = this.archiveConflictList.get(i);
            ++this.currentConflictIndex;
            this.handleSourceArchiveConflict(sourceArchiveID, this.currentConflictIndex);
        }
        this.archiveConflictList.clear();
    }

    private void handleSourceArchiveConflict(long sourceID, int conflictIndex) throws CancelledException {
        if (this.sourceArchiveChoice == -1 && this.conflictOption == -1 && this.mergeManager != null) {
            this.showArchiveMergePanel(sourceID, conflictIndex);
            if (this.conflictOption == -2) {
                throw new CancelledException();
            }
        }
        this.updateSourceArchive(sourceID);
        this.resetOption();
    }

    private void processCategoriesAdded() throws CancelledException {
        for (int i = 0; i < this.myCatAddedList.size(); ++i) {
            if (this.currentMonitor.isCancelled()) {
                throw new CancelledException();
            }
            this.currentMonitor.setProgress((long)(++this.progressIndex));
            long id = this.myCatAddedList.get(i);
            Category myCat = this.dtms[2].getCategory(id);
            CategoryPath myPath = myCat.getCategoryPath();
            if (this.dtms[0].containsCategory(myPath)) continue;
            this.dtms[0].createCategory(myPath);
        }
    }

    private void processCategoryConflicts() throws CancelledException {
        for (int i = 0; i < this.catConflictList.size(); ++i) {
            if (this.currentMonitor.isCancelled()) {
                throw new CancelledException();
            }
            this.currentMonitor.setProgress((long)(++this.progressIndex));
            long id = this.catConflictList.get(i);
            ++this.currentConflictIndex;
            this.handleCategoryConflict(id, this.currentConflictIndex);
        }
        this.catConflictList.clear();
    }

    private void handleCategoryConflict(long id, int conflictIndex) throws CancelledException {
        if (this.categoryChoice == -1 && this.conflictOption == -1 && this.mergeManager != null) {
            this.showCategoryMergePanel(id, conflictIndex);
        }
        if (this.categoryWasRenamed(id, this.dtms[2]) || this.categoryWasMoved(id, this.dtms[2])) {
            this.categoryRenamedOrMoved(id);
        }
        if (this.dtms[2].getCategory(id) == null || this.dtms[1].getCategory(id) == null) {
            this.categoryDeleted(id);
        }
        this.resetOption();
    }

    private void processCategoryChanges() throws CancelledException {
        for (int i = 0; i < this.myCatChangeList.size(); ++i) {
            if (this.currentMonitor.isCancelled()) {
                throw new CancelledException();
            }
            this.currentMonitor.setProgress((long)(++this.progressIndex));
            long id = this.myCatChangeList.get(i);
            this.processCategoryRenamed(id);
            this.processCategoryMoved(id);
        }
    }

    private void processCategoriesDeleted() throws CancelledException {
        for (int i = 0; i < this.myCatChangeList.size(); ++i) {
            if (this.currentMonitor.isCancelled()) {
                throw new CancelledException();
            }
            long id = this.myCatChangeList.get(i);
            this.processCategoryDeleted(id);
        }
    }

    private void processDataTypeConflicts() throws CancelledException {
        while (this.dtConflictList.size() > 0) {
            if (this.currentMonitor.isCancelled()) {
                throw new CancelledException();
            }
            this.currentMonitor.setProgress((long)(++this.progressIndex));
            long id = this.dtConflictList.get(0);
            ++this.currentConflictIndex;
            this.handleDataTypeConflict(id, this.currentConflictIndex);
            this.dtConflictList.remove(new Long(id));
        }
        this.fixUpDataTypes();
        this.cleanUpDataTypes();
        if (this.fixUpList.size() > 0) {
            StringBuffer sb = new StringBuffer();
            sb.append("The following data types are unresolved:\n");
            for (int i = 0; i < this.fixUpList.size(); ++i) {
                FixUpInfo info = this.fixUpList.get(i);
                DataTypeManager dtm = info.getDataTypeManager();
                DataType dt = dtm.getDataType(info.id);
                DataType compDt = dtm.getDataType(info.compID);
                sb.append("  Data type name " + dt.getName() + ", component " + compDt.getDisplayName() + "\n");
            }
            this.showMessage("Unresolved Data Types", sb.toString());
        }
    }

    private void handleDataTypeConflict(long id, int conflictIndex) throws CancelledException {
        DataType myDt = this.dtms[2].getDataType(id);
        if (this.dataTypeChoice == -1 && this.conflictOption == -1 && this.mergeManager != null) {
            DataType latestDt = this.dtms[1].getDataType(id);
            DataType origDt = this.dtms[3].getDataType(id);
            this.showDataTypeMergePanel(conflictIndex, latestDt, myDt, origDt);
            if (this.conflictOption == -2) {
                throw new CancelledException();
            }
        }
        this.applyDataTypeConflict(id);
        this.resetOption();
    }

    private void applyDataTypeConflict(long id) {
        boolean dtAdded = false;
        if (this.dataTypeWasRenamed(id, this.dtms[2]) || this.dataTypeWasMoved(id, this.dtms[2])) {
            dtAdded = this.dataTypeRenamedOrMoved(id);
        }
        if (!dtAdded) {
            DataType resultDt;
            boolean latestSourceChanged;
            boolean wasDeleted;
            boolean myChanged = this.dataTypeWasChanged(id, this.dtms[2]);
            boolean latestChanged = this.dataTypeWasChanged(id, this.dtms[1]);
            boolean bl = wasDeleted = this.dataTypeWasDeleted(id, this.dtms[2]) || this.dataTypeWasDeleted(id, this.dtms[1]);
            if (myChanged || latestChanged || wasDeleted) {
                this.dataTypeChanged(id);
            }
            boolean sameSource = !this.dataTypeSourceWasChanged(id, this.dtms[1], this.dtms[2]);
            boolean mySourceChanged = sameSource ? false : this.dataTypeSourceWasChanged(id, this.dtms[2]);
            boolean bl2 = latestSourceChanged = sameSource ? false : this.dataTypeSourceWasChanged(id, this.dtms[1]);
            if (mySourceChanged || latestSourceChanged) {
                this.changeSourceArchive(id);
            }
            if ((resultDt = this.dtms[0].getDataType(id)) != null) {
                long timeNow = System.currentTimeMillis();
                resultDt.setLastChangeTime(timeNow);
            }
        }
        if (this.dtSourceConflictList.contains(id)) {
            this.setSourceDataType(id);
        }
    }

    private void setSourceDataType(long myID) {
        DataType myDt = this.dtms[2].getDataType(myID);
        SourceArchive sourceArchive = myDt.getSourceArchive();
        UniversalID dataTypeID = myDt.getUniversalID();
        int optionToUse = this.dataTypeChoice == -1 ? this.conflictOption : this.dataTypeChoice;
        switch (optionToUse) {
            case 0: {
                break;
            }
            case 1: {
                DataType latestDt = this.dtms[0].getDataType(sourceArchive, dataTypeID);
                long resultID = this.dtms[0].getID(latestDt);
                try {
                    DataType resultDt = this.dtms[0].replaceDataType(latestDt, myDt, false);
                    CategoryPath myCategoryPath = myDt.getCategoryPath();
                    if (!resultDt.getCategoryPath().equals((Object)myCategoryPath)) {
                        resultDt.setCategoryPath(myCategoryPath);
                    }
                    this.myResolvedDts.put(myID, (Object)resultDt);
                    this.latestResolvedDts.put(resultID, (Object)resultDt);
                }
                catch (DataTypeDependencyException e) {
                    String msg = "Cannot replace data type named " + latestDt.getName() + ".\nProblem: " + e.getMessage();
                    Msg.showError((Object)this, null, (String)"Error Replacing Data Type", (Object)msg);
                }
                catch (DuplicateNameException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 2: {
                DataType latestDt3 = this.dtms[0].getDataType(sourceArchive, dataTypeID);
                long resultId3 = this.dtms[0].getID(latestDt3);
                if (!this.dtms[0].remove(latestDt3, this.currentMonitor)) break;
                this.latestResolvedDts.put(resultId3, null);
            }
        }
    }

    private void changeSourceArchive(long dtID) {
        int optionToUse = this.dataTypeChoice == -1 ? this.conflictOption : this.dataTypeChoice;
        switch (optionToUse) {
            case 0: {
                break;
            }
            case 1: {
                this.updateDataTypeSource(dtID, this.dtms[2], this.myResolvedDts);
                break;
            }
            case 2: {
                this.updateDataTypeSource(dtID, this.dtms[3], this.origResolvedDts);
            }
        }
    }

    private void dataTypeChanged(long id) {
        int optionToUse = this.dataTypeChoice == -1 ? this.conflictOption : this.dataTypeChoice;
        switch (optionToUse) {
            case 0: {
                DataType latestDt = this.dtms[0].getDataType(id);
                if (latestDt == null) {
                    this.dataTypeDeleted(id);
                    break;
                }
                this.updateHashTables(id, latestDt, this.latestResolvedDts);
                break;
            }
            case 1: {
                DataType myDt = this.dtms[2].getDataType(id);
                if (myDt == null) {
                    this.dataTypeDeleted(id);
                    break;
                }
                this.updateDataType(id, this.dtms[2], this.myResolvedDts, true);
                break;
            }
            case 2: {
                this.dtms[3].getDataType(id);
                this.updateDataType(id, this.dtms[3], this.origResolvedDts, true);
            }
        }
    }

    private boolean dataTypeRenamedOrMoved(long id) {
        DataType newDt = null;
        switch (this.conflictOption) {
            case 0: {
                break;
            }
            case 1: {
                DataType myDt = this.dtms[2].getDataType(id);
                newDt = this.updateDataTypeName(id, myDt, this.myResolvedDts);
                break;
            }
            case 2: {
                DataType origDt = this.dtms[3].getDataType(id);
                newDt = this.updateDataTypeName(id, origDt, this.origResolvedDts);
            }
        }
        return newDt != null;
    }

    private DataType updateDataTypeName(long id, DataType dt, LongObjectHashtable<DataType> resolvedDataTypes) {
        DataType resultDt = this.dtms[0].getDataType(id);
        DataType newDt = null;
        if (resultDt != null) {
            this.setDataTypeName(resultDt, dt.getName());
            this.setCategoryPath(resultDt, dt.getCategoryPath());
        } else {
            newDt = this.addDataType(id, dt, resolvedDataTypes);
        }
        return newDt;
    }

    private void dataTypeDeleted(long id) {
        DataType latestDt = this.dtms[0].getDataType(id);
        DataType myDt = this.dtms[2].getDataType(id);
        switch (this.conflictOption) {
            case 0: {
                DataType dt;
                if (latestDt != null || this.myDtAddedList.contains(new Long(id)) || (dt = (DataType)this.myResolvedDts.get(id)) == null) break;
                this.dtms[0].remove(dt, this.currentMonitor);
                this.origResolvedDts.remove(id);
                this.myResolvedDts.remove(id);
                break;
            }
            case 1: {
                if (myDt == null) {
                    if (latestDt == null) break;
                    this.dtms[0].remove(latestDt, this.currentMonitor);
                    break;
                }
                this.addDataType(id, myDt, this.myResolvedDts);
                break;
            }
            case 2: {
                DataType origDt = this.dtms[3].getDataType(id);
                this.addDataType(id, origDt, this.origResolvedDts);
            }
        }
    }

    private void setCategoryPath(DataType dt, CategoryPath newPath) {
        if (dt.getCategoryPath().equals((Object)newPath)) {
            return;
        }
        try {
            dt.setCategoryPath(newPath);
        }
        catch (DuplicateNameException duplicateNameException) {
            // empty catch block
        }
    }

    private DataType updateDataType(long id, DataTypeManager dtm, LongObjectHashtable<DataType> resolvedDataTypes, boolean updatePath) {
        DataType resultDt = this.dtms[0].getDataType(id);
        DataType myDt = dtm.getDataType(id);
        if (resultDt == null) {
            resultDt = (DataType)resolvedDataTypes.get(id);
        }
        if (resultDt == null) {
            resultDt = this.addDataType(id, myDt, resolvedDataTypes);
        } else if (resultDt instanceof Composite) {
            this.updateComposite(id, (Composite)myDt, (Composite)resultDt, resolvedDataTypes);
        } else if (resultDt instanceof FunctionDefinition) {
            this.updateFunctionDef(id, (FunctionDefinition)myDt, (FunctionDefinition)resultDt, resolvedDataTypes);
        } else if (resultDt instanceof Enum) {
            ((Enum)resultDt).replaceWith(myDt);
        } else {
            try {
                resultDt = this.dtms[0].replaceDataType(resultDt, myDt, true);
            }
            catch (DataTypeDependencyException e) {
                String msg = "Cannot replace data type named " + resultDt.getName() + ".\nProblem: " + e.getMessage();
                Msg.showError((Object)this, null, (String)"Error Replacing Data Type", (Object)msg);
                return null;
            }
        }
        this.updateHashTables(id, resultDt, resolvedDataTypes);
        if (updatePath && !resultDt.getCategoryPath().equals((Object)myDt.getCategoryPath())) {
            try {
                resultDt.setCategoryPath(myDt.getCategoryPath());
            }
            catch (DuplicateNameException duplicateNameException) {
                // empty catch block
            }
        }
        return resultDt;
    }

    private DataType updateDataTypeSource(long id, DataTypeManager dtm, LongObjectHashtable<DataType> resolvedDataTypes) {
        DataType resultDt = this.dtms[0].getDataType(id);
        DataType myDt = dtm.getDataType(id);
        SourceArchive mySourceArchive = myDt.getSourceArchive();
        if (resultDt == null) {
            resultDt = (DataType)resolvedDataTypes.get(id);
        }
        if (resultDt == null) {
            resultDt = this.addDataType(id, myDt, resolvedDataTypes);
        } else {
            SourceArchive resultSourceArchive = resultDt.getSourceArchive();
            if (!resultSourceArchive.getSourceArchiveID().equals((Object)mySourceArchive.getSourceArchiveID())) {
                resultDt.setSourceArchive(mySourceArchive);
            }
        }
        this.updateHashTables(id, resultDt, resolvedDataTypes);
        return resultDt;
    }

    private DataType addDataType(long dataTypeID, DataType dataType, LongObjectHashtable<DataType> resolvedDataTypes) {
        DataType existingDt = (DataType)resolvedDataTypes.get(dataTypeID);
        if (existingDt != null) {
            return existingDt;
        }
        if (!this.myDtAddedList.contains(new Long(dataTypeID)) && (existingDt = this.dtms[0].getDataType(dataTypeID)) != null) {
            Msg.warn((Object)this, (Object)(" ** WARNING ** : Unexpectedly found data type \"" + existingDt.getPathName() + "\" when trying to add it."));
            return existingDt;
        }
        DataType newDt = dataType;
        if (dataType instanceof Composite) {
            return this.addComposite(dataTypeID, (Composite)dataType, resolvedDataTypes);
        }
        if (dataType instanceof Pointer) {
            newDt = this.createPointer(dataTypeID, (Pointer)dataType, resolvedDataTypes);
        } else if (dataType instanceof Array) {
            newDt = this.createArray(dataTypeID, (Array)dataType, resolvedDataTypes);
        } else if (dataType instanceof TypeDef) {
            newDt = this.createTypeDef(dataTypeID, (TypeDef)dataType, resolvedDataTypes);
        } else if (dataType instanceof FunctionDefinition) {
            newDt = this.addFunctionDef(dataTypeID, (FunctionDefinition)dataType, resolvedDataTypes);
        }
        if (newDt != null) {
            newDt = this.dtms[0].addDataType(newDt, DataTypeConflictHandler.DEFAULT_HANDLER);
            this.updateHashTables(dataTypeID, newDt, resolvedDataTypes);
        }
        return newDt;
    }

    private DataType getResolvedBaseType(long id, DataType dt, LongObjectHashtable<DataType> resolvedDataTypes) {
        DataTypeManager dtm = dt.getDataTypeManager();
        DataType baseDt = this.getBaseDataType(dt);
        if (baseDt == DataType.DEFAULT) {
            return baseDt;
        }
        long baseID = dtm.getID(baseDt);
        DataType resolvedDt = (DataType)resolvedDataTypes.get(baseID);
        if (resolvedDt == null) {
            if (!this.myDtAddedList.contains(new Long(baseID))) {
                resolvedDt = this.dtms[0].getDataType(baseID);
                if (resolvedDt == null) {
                    if (this.origDtConflictList.contains(new Long(baseID))) {
                        resolvedDt = this.addDataType(baseID, baseDt, resolvedDataTypes);
                    } else {
                        this.fixUpList.add(new FixUpInfo(id, baseID, -1, resolvedDataTypes));
                    }
                }
            } else {
                this.fixUpList.add(new FixUpInfo(id, baseID, -1, resolvedDataTypes));
            }
        }
        return resolvedDt;
    }

    private DataType createPointer(long id, Pointer pointerDt, LongObjectHashtable<DataType> resolvedDataTypes) {
        DataType innerDt = pointerDt.getDataType();
        if (innerDt == DataType.DEFAULT) {
            return pointerDt;
        }
        DataType resolvedDt = this.getResolvedBaseType(id, (DataType)pointerDt, resolvedDataTypes);
        if (resolvedDt != null) {
            if (innerDt instanceof Pointer || innerDt instanceof Array || innerDt instanceof TypeDef) {
                resolvedDt = this.addDataType(innerDt.getDataTypeManager().getID(innerDt), innerDt, resolvedDataTypes);
            }
            if (resolvedDt != null) {
                return PointerDataType.getPointer((DataType)resolvedDt, (int)(pointerDt.isDynamicallySized() ? -1 : pointerDt.getLength()));
            }
        }
        return null;
    }

    private DataType createTypeDef(long id, TypeDef originalTypeDef, LongObjectHashtable<DataType> resolvedDataTypes) {
        DataType innerDataType = originalTypeDef.getDataType();
        if (innerDataType == DataType.DEFAULT) {
            return originalTypeDef;
        }
        SourceArchive originalSourceArchive = originalTypeDef.getSourceArchive();
        SourceArchive resultSourceArchive = this.getDataTypeManager(resolvedDataTypes).resolveSourceArchive(originalSourceArchive);
        DataType resolvedBaseDt = this.getResolvedBaseType(id, (DataType)originalTypeDef, resolvedDataTypes);
        if (resolvedBaseDt != null) {
            if (innerDataType instanceof Array || innerDataType instanceof Pointer || innerDataType instanceof TypeDef) {
                resolvedBaseDt = this.addDataType(innerDataType.getDataTypeManager().getID(innerDataType), innerDataType, resolvedDataTypes);
            }
            if (resolvedBaseDt != null) {
                TypedefDataType typedefDataType = new TypedefDataType(originalTypeDef.getCategoryPath(), originalTypeDef.getName(), resolvedBaseDt, originalTypeDef.getUniversalID(), resultSourceArchive, originalTypeDef.getLastChangeTime(), originalTypeDef.getLastChangeTimeInSourceArchive(), this.dtms[0]);
                return typedefDataType;
            }
        }
        return null;
    }

    private DataType createArray(long id, Array array, LongObjectHashtable<DataType> resolvedDataTypes) {
        DataType dt = array.getDataType();
        if (dt == DataType.DEFAULT) {
            return array;
        }
        DataType resolvedDt = this.getResolvedBaseType(id, (DataType)array, resolvedDataTypes);
        if (resolvedDt != null) {
            if (dt instanceof Array || dt instanceof Pointer || dt instanceof TypeDef) {
                resolvedDt = this.addDataType(dt.getDataTypeManager().getID(dt), dt, resolvedDataTypes);
            }
            if (resolvedDt != null) {
                int elementLen = resolvedDt instanceof Dynamic ? array.getElementLength() : resolvedDt.getLength();
                return new ArrayDataType(resolvedDt, array.getNumElements(), elementLen);
            }
        }
        return null;
    }

    private DataType addComposite(long id, Composite myDt, LongObjectHashtable<DataType> resolvedDataTypes) {
        long oldLastChangeTime = myDt.getLastChangeTime();
        long oldLastChangeTimeInSourceArchive = myDt.getLastChangeTimeInSourceArchive();
        DataType newDt = myDt.clone(this.dtms[0]);
        this.updateComposite(id, myDt, (Composite)newDt, resolvedDataTypes);
        SourceArchive originalSourceArchive = myDt.getSourceArchive();
        SourceArchive resultSourceArchive = this.getDataTypeManager(resolvedDataTypes).resolveSourceArchive(originalSourceArchive);
        newDt.setSourceArchive(resultSourceArchive);
        newDt = this.dtms[0].addDataType(newDt, DataTypeConflictHandler.DEFAULT_HANDLER);
        newDt.setLastChangeTime(oldLastChangeTime);
        newDt.setLastChangeTimeInSourceArchive(oldLastChangeTimeInSourceArchive);
        this.updateHashTables(id, newDt, resolvedDataTypes);
        return newDt;
    }

    private DataType addFunctionDef(long id, FunctionDefinition myDt, LongObjectHashtable<DataType> resolvedDataTypes) {
        FunctionDefinition newDt = (FunctionDefinition)myDt.clone(this.dtms[0]);
        try {
            newDt.setCategoryPath(myDt.getCategoryPath());
        }
        catch (DuplicateNameException duplicateNameException) {
            // empty catch block
        }
        this.updateFunctionDef(id, myDt, newDt, resolvedDataTypes);
        return newDt;
    }

    private void updateHashTables(long id, DataType newDt, LongObjectHashtable<DataType> resolvedDataTypes) {
        resolvedDataTypes.put(id, (Object)newDt);
        if (!this.myDtAddedList.contains(new Long(id))) {
            if (resolvedDataTypes == this.myResolvedDts) {
                this.origResolvedDts.put(id, (Object)newDt);
                this.latestResolvedDts.put(id, (Object)newDt);
            } else if (resolvedDataTypes == this.origResolvedDts) {
                this.myResolvedDts.put(id, (Object)newDt);
                this.latestResolvedDts.put(id, (Object)newDt);
            } else {
                this.origResolvedDts.put(id, (Object)newDt);
                this.myResolvedDts.put(id, (Object)newDt);
            }
        }
    }

    private DataType getResolvedComponent(long compID, LongObjectHashtable<DataType> resolvedDataTypes) {
        DataType resolvedDt = (DataType)resolvedDataTypes.get(compID);
        if (resolvedDt != null && (resolvedDt instanceof Pointer || resolvedDt instanceof Array || resolvedDt instanceof TypeDef)) {
            DataTypeManager dtm;
            long baseID;
            DataType baseDt = this.getBaseDataType(resolvedDt);
            if (baseDt == null) {
                return null;
            }
            if (baseDt != DataType.DEFAULT && !this.myDtAddedList.contains(new Long(baseID = (dtm = baseDt.getDataTypeManager()).getID(baseDt)))) {
                if (this.dtms[0].getDataType(baseID) != null) {
                    return resolvedDt;
                }
                return null;
            }
        }
        return resolvedDt;
    }

    private void updateStructure(long sourceDtID, Structure sourceDt, Structure destStruct, LongObjectHashtable<DataType> resolvedDataTypes) {
        DataTypeComponent[] comps;
        destStruct.deleteAll();
        try {
            this.updateAlignment((Composite)sourceDt, (Composite)destStruct);
        }
        catch (InvalidInputException e) {
            String msg = "Some of your changes to " + destStruct.getName() + " cannot be merged.\nProblem: " + e.getMessage();
            Msg.showError((Object)this, null, (String)"Structure Update Failed", (Object)msg);
            return;
        }
        DataTypeManager sourceDTM = sourceDt.getDataTypeManager();
        boolean aligned = sourceDt.isInternallyAligned();
        if (!aligned) {
            destStruct.growStructure(sourceDt.getLength());
        }
        for (DataTypeComponent comp : comps = sourceDt.getDefinedComponents()) {
            DataType dt = comp.getDataType();
            Object comment = comp.getComment();
            DataType resultCompDt = null;
            long sourceComponentID = sourceDTM.getID(dt);
            boolean deletedInLatest = false;
            resultCompDt = this.getResolvedComponent(sourceComponentID, resolvedDataTypes);
            if (resultCompDt == null) {
                if (!this.myDtAddedList.contains(new Long(sourceComponentID))) {
                    DataType rDt = this.dtms[0].getDataType(sourceComponentID);
                    if (rDt != null) {
                        resultCompDt = rDt;
                    } else {
                        deletedInLatest = true;
                        FixUpInfo info = new FixUpInfo(sourceDtID, sourceComponentID, sourceDt.isInternallyAligned() ? comp.getOrdinal() : comp.getOffset(), resolvedDataTypes);
                        this.fixUpList.add(info);
                    }
                } else {
                    this.fixUpList.add(new FixUpInfo(sourceDtID, sourceComponentID, sourceDt.isInternallyAligned() ? comp.getOrdinal() : comp.getOffset(), resolvedDataTypes));
                }
            }
            try {
                if (resultCompDt != null) {
                    BadDataType badDt;
                    if (aligned) {
                        try {
                            destStruct.add(resultCompDt, comp.getLength(), comp.getFieldName(), (String)comment);
                        }
                        catch (IllegalArgumentException e) {
                            this.displayError((Composite)destStruct, e);
                            badDt = BadDataType.dataType;
                            comment = "Couldn't add " + resultCompDt.getDisplayName() + " here. " + e.getMessage() + " " + (String)(comment != null ? " " + (String)comment : "");
                            destStruct.add((DataType)badDt, comp.getLength(), comp.getFieldName(), (String)comment);
                        }
                        continue;
                    }
                    try {
                        destStruct.replaceAtOffset(comp.getOffset(), resultCompDt, comp.getLength(), comp.getFieldName(), (String)comment);
                    }
                    catch (IllegalArgumentException e) {
                        this.displayError((Composite)destStruct, e);
                        badDt = BadDataType.dataType;
                        comment = "Couldn't add " + resultCompDt.getDisplayName() + " here. " + e.getMessage() + " " + (String)(comment != null ? " " + (String)comment : "");
                        destStruct.replaceAtOffset(comp.getOffset(), (DataType)badDt, comp.getLength(), comp.getFieldName(), (String)comment);
                    }
                    continue;
                }
                if (aligned) {
                    destStruct.add((DataType)BadDataType.dataType, comp.getLength(), comp.getFieldName(), (String)comment);
                    continue;
                }
                if (deletedInLatest) continue;
                destStruct.replaceAtOffset(comp.getOffset(), (DataType)BadDataType.dataType, comp.getLength(), comp.getFieldName(), (String)comment);
            }
            catch (IllegalArgumentException e) {
                this.displayError((Composite)destStruct, e);
            }
        }
    }

    private void displayError(Composite destComposite, IllegalArgumentException e) {
        String msg = "Some of your changes to " + destComposite.getName() + " cannot be merged.\nProblem: " + e.getMessage();
        String typeName = destComposite instanceof Union ? "Union" : "Structure";
        Msg.showError((Object)this, null, (String)(typeName + " Update Failed"), (Object)msg);
    }

    private void updateUnion(long sourceDtID, Union sourceDt, Union destUnion, LongObjectHashtable<DataType> resolvedDataTypes) {
        while (destUnion.getNumComponents() > 0) {
            destUnion.delete(0);
        }
        try {
            this.updateAlignment((Composite)sourceDt, (Composite)destUnion);
        }
        catch (InvalidInputException e) {
            String msg = "Some of your changes to " + destUnion.getName() + " cannot be merged.\nProblem: " + e.getMessage();
            Msg.showError((Object)this, null, (String)"Union Update Failed", (Object)msg);
            return;
        }
        DataTypeManager sourceDTM = sourceDt.getDataTypeManager();
        for (int i = 0; i < sourceDt.getNumComponents(); ++i) {
            DataTypeComponent sourceComp = sourceDt.getComponent(i);
            Object comment = sourceComp.getComment();
            DataType sourceCompDt = sourceComp.getDataType();
            long sourceCompID = sourceDTM.getID(sourceCompDt);
            DataType resultCompDt = this.getResolvedComponent(sourceCompID, resolvedDataTypes);
            if (resultCompDt == null) {
                if (!this.myDtAddedList.contains(new Long(sourceCompID))) {
                    DataType resultsDt = this.dtms[0].getDataType(sourceCompID);
                    if (resultsDt != null) {
                        resultCompDt = resultsDt;
                    } else {
                        FixUpInfo info = new FixUpInfo(sourceDtID, sourceCompID, i, resolvedDataTypes);
                        this.fixUpList.add(info);
                    }
                } else {
                    this.fixUpList.add(new FixUpInfo(sourceDtID, sourceCompID, i, resolvedDataTypes));
                }
            }
            if (resultCompDt != null) {
                try {
                    DataTypeComponent resultComp;
                    try {
                        int resultCompDtLength = resultCompDt.getLength();
                        resultComp = resultCompDtLength > 0 ? destUnion.add(resultCompDt) : destUnion.add(resultCompDt, sourceComp.getLength());
                    }
                    catch (IllegalArgumentException e1) {
                        this.displayError((Composite)destUnion, e1);
                        BadDataType badDt = BadDataType.dataType;
                        comment = "Couldn't add " + resultCompDt.getDisplayName() + " here. " + e1.getMessage() + (String)(comment != null ? " " + (String)comment : "");
                        resultComp = destUnion.add((DataType)badDt, sourceComp.getLength());
                    }
                    try {
                        resultComp.setFieldName(sourceComp.getFieldName());
                    }
                    catch (DuplicateNameException e1) {
                        // empty catch block
                    }
                    resultComp.setComment((String)comment);
                }
                catch (IllegalArgumentException e1) {
                    this.displayError((Composite)destUnion, e1);
                }
                continue;
            }
            destUnion.add((DataType)BadDataType.dataType, sourceComp.getLength(), sourceComp.getFieldName(), (String)comment);
        }
    }

    private void updateAlignment(Composite sourceDt, Composite destinationDt) throws InvalidInputException {
        if (sourceDt.isDefaultAligned()) {
            destinationDt.setToDefaultAlignment();
        } else if (sourceDt.isMachineAligned()) {
            destinationDt.setToMachineAlignment();
        } else {
            destinationDt.setMinimumAlignment(sourceDt.getMinimumAlignment());
        }
        destinationDt.setPackingValue(sourceDt.getPackingValue());
        boolean aligned = sourceDt.isInternallyAligned();
        destinationDt.setInternallyAligned(aligned);
    }

    private void updateComposite(long sourceDtID, Composite sourceDt, Composite destDt, LongObjectHashtable<DataType> resolvedDataTypes) {
        if (sourceDt instanceof Structure) {
            this.updateStructure(sourceDtID, (Structure)sourceDt, (Structure)destDt, resolvedDataTypes);
        } else {
            this.updateUnion(sourceDtID, (Union)sourceDt, (Union)destDt, resolvedDataTypes);
        }
    }

    private void updateFunctionDef(long sourceFunctionDefDtID, FunctionDefinition sourceFunctionDefDt, FunctionDefinition destDt, LongObjectHashtable<DataType> resolvedDataTypes) {
        long oldLastChangeTime = sourceFunctionDefDt.getLastChangeTime();
        long oldLastChangeTimeInSourceArchive = sourceFunctionDefDt.getLastChangeTimeInSourceArchive();
        DataTypeManager sourceDTM = sourceFunctionDefDt.getDataTypeManager();
        DataType sourceReturnType = sourceFunctionDefDt.getReturnType();
        ParameterDefinition[] sourceVars = sourceFunctionDefDt.getArguments();
        ParameterDefinition[] destVars = destDt.getArguments();
        boolean sourceHasVarArgs = sourceFunctionDefDt.hasVarArgs();
        if (sourceReturnType != null) {
            long returnTypeID = sourceDTM.getID(sourceReturnType);
            DataType resolvedRDT = this.getResolvedParam(sourceFunctionDefDtID, returnTypeID, -1, resolvedDataTypes);
            destDt.setReturnType(resolvedRDT);
        }
        for (int i = 0; i < sourceVars.length; ++i) {
            DataType varDt = sourceVars[i].getDataType();
            long varID = sourceDTM.getID(varDt);
            DataType resolvedDt = this.getResolvedParam(sourceFunctionDefDtID, varID, i, resolvedDataTypes);
            destVars[i].setComment(sourceVars[i].getComment());
            try {
                destVars[i].setDataType(resolvedDt);
                continue;
            }
            catch (InvalidInputException invalidInputException) {
                // empty catch block
            }
        }
        if (sourceHasVarArgs != destDt.hasVarArgs()) {
            destDt.setVarArgs(sourceHasVarArgs);
        }
        destDt.setLastChangeTime(oldLastChangeTime);
        destDt.setLastChangeTimeInSourceArchive(oldLastChangeTimeInSourceArchive);
    }

    private DataType getResolvedParam(long id, long paramID, int index, LongObjectHashtable<DataType> resolvedDataTypes) {
        DataType resolvedDt = this.getResolvedComponent(paramID, resolvedDataTypes);
        if (resolvedDt == null) {
            if (!this.myDtAddedList.contains(new Long(paramID))) {
                DataType resultsDt = this.dtms[0].getDataType(paramID);
                if (resultsDt != null) {
                    resolvedDt = resultsDt;
                } else {
                    resolvedDt = DataType.DEFAULT;
                    FixUpInfo info = new FixUpInfo(id, paramID, index, resolvedDataTypes);
                    this.fixUpList.add(info);
                }
            } else {
                resolvedDt = DataType.DEFAULT;
                this.fixUpList.add(new FixUpInfo(id, paramID, index, resolvedDataTypes));
            }
        }
        return resolvedDt;
    }

    private void processDataTypeChanges() throws CancelledException {
        for (int i = 0; i < this.myDtChangeList.size(); ++i) {
            if (this.currentMonitor.isCancelled()) {
                throw new CancelledException();
            }
            this.currentMonitor.setProgress((long)(++this.progressIndex));
            long id = this.myDtChangeList.get(i);
            DataType dt = this.dtms[2].getDataType(id);
            if (dt instanceof Pointer || dt instanceof Array || dt instanceof BuiltIn) continue;
            this.processDataTypeRenamed(id);
            this.processDataTypeMoved(id);
            this.processDataTypeEdited(id);
            this.processDataTypeSourceChanged(id);
        }
    }

    private void processCategoryRenamed(long id) {
        Category resultCat;
        if (this.categoryWasRenamed(id, this.dtms[2]) && (resultCat = this.dtms[0].getCategory(id)) != null) {
            Category myCat = this.dtms[2].getCategory(id);
            String myCatName = myCat.getName();
            if (!resultCat.getName().equals(myCatName)) {
                this.setCategoryName(resultCat, myCatName);
            }
        }
    }

    private void processCategoryMoved(long id) {
        Category resultCat;
        Category myCat = this.dtms[2].getCategory(id);
        if (myCat == null) {
            return;
        }
        if (this.categoryWasMoved(id, this.dtms[2]) && (resultCat = this.dtms[0].getCategory(id)) != null) {
            Category myParent = myCat.getParent();
            Category resultNewParent = this.dtms[0].getCategory(myParent.getCategoryPath());
            if (resultNewParent == null) {
                resultNewParent = this.dtms[0].createCategory(myParent.getCategoryPath());
            }
            this.moveCategory(resultNewParent, resultCat);
        }
    }

    private void processCategoryDeleted(long id) {
        Category resultCat;
        Category myCat = this.dtms[2].getCategory(id);
        if (myCat == null && (resultCat = this.dtms[0].getCategory(id)) != null && !this.isParent(resultCat.getCategoryPath())) {
            resultCat.getParent().removeCategory(resultCat.getName(), this.currentMonitor);
        }
    }

    private boolean isParent(CategoryPath catPath) {
        for (int i = 0; i < this.myDtAddedList.size(); ++i) {
            Long id = this.myDtAddedList.get(i);
            DataType dt = this.dtms[2].getDataType(id.longValue());
            if (!catPath.equals((Object)dt.getCategoryPath())) continue;
            return true;
        }
        return false;
    }

    private void moveCategory(Category newParent, Category category) {
        Category[] cats;
        for (Category cat : cats = newParent.getCategories()) {
            if (category != cat) continue;
            return;
        }
        String name = category.getName();
        Object newName = name;
        int oneUpNumber = 0;
        try {
            while (true) {
                if (newParent.getCategory((String)newName) == null) {
                    newParent.moveCategory(category, this.currentMonitor);
                    return;
                }
                newName = name + ".conflict" + ++oneUpNumber;
            }
        }
        catch (DuplicateNameException e) {
            throw new AssertException("Got DuplicateNameException");
        }
        catch (IllegalArgumentException e) {
            return;
        }
    }

    /*
     * Loose catch block
     */
    private void setCategoryName(Category category, String newName) {
        if (category.getName().equals(newName)) {
            return;
        }
        Object name = newName;
        int oneUpNumber = 0;
        while (true) {
            try {
                category.setName((String)name);
                return;
            }
            catch (DuplicateNameException e) {
                name = newName + ".conflict" + ++oneUpNumber;
                continue;
            }
            break;
        }
        catch (InvalidNameException e) {
            throw new AssertException("Got InvalidNameException: " + e);
        }
    }

    /*
     * Loose catch block
     */
    private void setDataTypeName(DataType dt, String newName) {
        if (dt.getName().equals(newName)) {
            return;
        }
        Object name = newName;
        int oneUpNumber = 0;
        while (true) {
            try {
                dt.setName((String)name);
                return;
            }
            catch (DuplicateNameException e) {
                name = newName + ".conflict" + ++oneUpNumber;
                continue;
            }
            break;
        }
        catch (InvalidNameException e) {
            throw new AssertException("Got InvalidNameException: " + e);
        }
    }

    private boolean categoryWasMoved(long id, DataTypeManager dtm1, DataTypeManager dtm2) {
        Category cat1 = dtm1.getCategory(id);
        Category cat2 = dtm2.getCategory(id);
        if (cat1 != null && cat2 != null) {
            Category parent1 = cat1.getParent();
            Category parent2 = cat2.getParent();
            if (parent1 != null && parent2 != null) {
                return !parent1.getCategoryPath().equals((Object)parent2.getCategoryPath());
            }
            return parent1 != null || parent2 != null;
        }
        return false;
    }

    private boolean categoryWasMoved(long id, DataTypeManager dtm) {
        return this.categoryWasMoved(id, this.dtms[3], dtm);
    }

    private boolean categoryWasRenamed(long id, DataTypeManager dtm1, DataTypeManager dtm2) {
        Category cat1 = dtm1.getCategory(id);
        Category cat2 = dtm2.getCategory(id);
        if (cat1 != null && cat2 != null) {
            return !cat1.getName().equals(cat2.getName());
        }
        return false;
    }

    private boolean categoryWasRenamed(long id, DataTypeManager dtm) {
        return this.categoryWasRenamed(id, this.dtms[3], dtm);
    }

    private boolean dataTypeWasMoved(long id, DataTypeManager dtm) {
        return this.dataTypeWasMoved(id, this.dtms[3], dtm);
    }

    private boolean dataTypeWasMoved(long id, DataTypeManager dtm1, DataTypeManager dtm2) {
        DataType dt1 = dtm1.getDataType(id);
        DataType dt2 = dtm2.getDataType(id);
        if (dt1 != null && dt2 != null) {
            CategoryPath p2;
            CategoryPath p1 = dt1.getCategoryPath();
            return !p1.equals((Object)(p2 = dt2.getCategoryPath()));
        }
        return false;
    }

    private boolean dataTypeWasRenamed(long id, DataTypeManager dtm) {
        return this.dataTypeWasRenamed(id, this.dtms[3], dtm);
    }

    private boolean dataTypeWasRenamed(long id, DataTypeManager dtm1, DataTypeManager dtm2) {
        DataType dt1 = dtm1.getDataType(id);
        DataType dt2 = dtm2.getDataType(id);
        if (dt1 != null && dt2 != null) {
            String name2;
            String name1 = dt1.getName();
            return !name1.equals(name2 = dt2.getName());
        }
        return false;
    }

    private boolean dataTypeWasChanged(long id, DataTypeManager dtm) {
        return this.dataTypeWasChanged(id, this.dtms[3], dtm);
    }

    private boolean dataTypeWasChanged(long id, DataTypeManager dtm1, DataTypeManager dtm2) {
        DataType dt1 = dtm1.getDataType(id);
        DataType dt2 = dtm2.getDataType(id);
        if (dt1 != null && dt2 != null && dt1.getClass() == dt2.getClass()) {
            if (dt1 instanceof Composite) {
                Composite c1 = (Composite)dt1;
                Composite c2 = (Composite)dt2;
                return this.compositeDataTypeWasChanged(c1, c2);
            }
            if (dt1 instanceof TypeDef) {
                return false;
            }
            return !dt1.isEquivalent(dt2);
        }
        return false;
    }

    private boolean compositeDataTypeWasChanged(Composite c1, Composite c2) {
        DataTypeManager dtm1 = c1.getDataTypeManager();
        DataTypeManager dtm2 = c2.getDataTypeManager();
        if (c1.isInternallyAligned() != c2.isInternallyAligned() || c1.isDefaultAligned() != c2.isDefaultAligned() || c1.isMachineAligned() != c2.isMachineAligned() || c1.getMinimumAlignment() != c2.getMinimumAlignment() || c1.getPackingValue() != c2.getPackingValue() || !c1.isInternallyAligned() && c1.getLength() != c2.getLength()) {
            return true;
        }
        if (c1.getNumComponents() != c2.getNumComponents()) {
            return true;
        }
        int nComponents = c1.getNumComponents();
        for (int i = 0; i < nComponents; ++i) {
            DataTypeComponent dtc1 = c1.getComponent(i);
            DataTypeComponent dtc2 = c2.getComponent(i);
            if (dtm1.getID(dtc1.getDataType()) != dtm2.getID(dtc2.getDataType())) {
                return true;
            }
            String fname1 = dtc1.getFieldName();
            String fname2 = dtc2.getFieldName();
            String comment1 = dtc1.getComment();
            String comment2 = dtc2.getComment();
            if (!(fname1 != null && !fname1.equals(fname2) || fname2 != null && !fname2.equals(fname1) || comment1 != null && !comment1.equals(comment2)) && (comment2 == null || comment2.equals(comment1))) continue;
            return true;
        }
        return false;
    }

    private boolean dataTypeSourceWasChanged(long id, DataTypeManager dtm) {
        return this.dataTypeSourceWasChanged(id, this.dtms[3], dtm);
    }

    private boolean dataTypeSourceWasChanged(long id, DataTypeManager dtm1, DataTypeManager dtm2) {
        DataType dt1 = dtm1.getDataType(id);
        DataType dt2 = dtm2.getDataType(id);
        if (dt1 != null && dt2 != null) {
            SourceArchive sourceArchive1 = dt1.getSourceArchive();
            SourceArchive sourceArchive2 = dt2.getSourceArchive();
            if (!sourceArchive1.getSourceArchiveID().equals((Object)sourceArchive2.getSourceArchiveID())) {
                return true;
            }
            UniversalID universalID1 = dt1.getUniversalID();
            UniversalID universalID2 = dt2.getUniversalID();
            if (universalID1 == null || universalID2 == null) {
                String msg = "Null Universal ID encountered for data type ID " + id + "\n    DataType1 is \"" + dt1.getPathName() + "\".\n        Universal ID = " + universalID1 + "\n        DataType Class = " + dt1.getClass().getName() + "\n        DataTypeManager = " + dtm1.getName() + "\n        Source Archive = " + sourceArchive1.getName() + "\n    DataType2 is \"" + dt2.getPathName() + "\".\n        Universal ID = " + universalID2 + "\n        DataType Class = " + dt2.getClass().getName() + "\n        DataTypeManager = " + dtm2.getName() + "\n        Source Archive = " + sourceArchive2.getName() + "        ";
                Msg.error((Object)this, (Object)msg);
            }
            if (!SystemUtilities.isEqual((Object)universalID1, (Object)universalID2)) {
                return true;
            }
        }
        return false;
    }

    private boolean dataTypeWasDeleted(long id, DataTypeManager dtm) {
        DataType dt1 = this.dtms[3].getDataType(id);
        DataType dt2 = dtm.getDataType(id);
        return dt1 != null && dt2 == null;
    }

    private void categoryRenamedOrMoved(long id) throws CancelledException {
        if (this.conflictOption == -2) {
            throw new CancelledException();
        }
        int optionToUse = this.categoryChoice == -1 ? this.conflictOption : this.categoryChoice;
        switch (optionToUse) {
            case 0: {
                break;
            }
            case 1: {
                this.useMyCategoryName(id);
                break;
            }
            case 2: {
                this.useOriginalCategoryName(id);
                break;
            }
            case -2: {
                throw new CancelledException();
            }
        }
    }

    private void useOriginalCategoryName(long id) {
        Category origCat = this.dtms[3].getCategory(id);
        Category resultCat = this.dtms[0].getCategory(id);
        this.setCategoryName(resultCat, origCat.getName());
        if (!resultCat.getCategoryPath().equals((Object)origCat.getCategoryPath())) {
            CategoryPath origParentCatPath = origCat.getCategoryPath().getParent();
            if (!this.dtms[0].containsCategory(origParentCatPath)) {
                this.dtms[0].createCategory(origParentCatPath);
            }
            Category parent = this.dtms[0].getCategory(origCat.getCategoryPath().getParent());
            this.moveCategory(parent, resultCat);
        }
    }

    private void useMyCategoryName(long id) {
        Category myCat = this.dtms[2].getCategory(id);
        Category resultCat = this.dtms[0].getCategory(id);
        if (resultCat != null) {
            this.setCategoryName(resultCat, myCat.getName());
            if (!resultCat.getCategoryPath().equals((Object)myCat.getCategoryPath())) {
                CategoryPath myParentCatPath = myCat.getCategoryPath().getParent();
                if (!this.dtms[0].containsCategory(myParentCatPath)) {
                    this.dtms[0].createCategory(myParentCatPath);
                }
                Category resultParentCat = this.dtms[0].getCategory(myCat.getCategoryPath().getParent());
                this.moveCategory(resultParentCat, resultCat);
            }
        } else {
            this.dtms[0].createCategory(myCat.getCategoryPath());
        }
    }

    private void categoryDeleted(long id) throws CancelledException {
        Category myCat = this.dtms[2].getCategory(id);
        Category latestCat = this.dtms[1].getCategory(id);
        Category origCat = this.dtms[3].getCategory(id);
        if (this.conflictOption == -2) {
            throw new CancelledException();
        }
        int optionToUse = this.categoryChoice == -1 ? this.conflictOption : this.categoryChoice;
        switch (optionToUse) {
            case 0: {
                if (latestCat == null || this.dtms[0].containsCategory(latestCat.getCategoryPath())) break;
                this.dtms[0].createCategory(latestCat.getCategoryPath());
                break;
            }
            case 1: {
                if (myCat == null) {
                    this.deleteLatestCategory(latestCat);
                    break;
                }
                this.dtms[0].createCategory(myCat.getCategoryPath());
                break;
            }
            case 2: {
                Category parentCat = this.dtms[0].getCategory(origCat.getParent().getCategoryPath());
                if (latestCat != null) {
                    if (this.categoryWasMoved(id, this.dtms[0])) {
                        Category resultCat = this.dtms[0].getCategory(id);
                        this.moveCategory(parentCat, resultCat);
                        break;
                    }
                    Category resultCat = this.dtms[0].getCategory(id);
                    if (resultCat != null) {
                        this.setCategoryName(resultCat, origCat.getName());
                        break;
                    }
                    this.dtms[0].createCategory(origCat.getCategoryPath());
                    break;
                }
                this.dtms[0].createCategory(origCat.getCategoryPath());
                break;
            }
            case -2: {
                throw new CancelledException();
            }
        }
    }

    private void deleteLatestCategory(Category latestCat) {
        Category parentCat;
        DataType[] dts = latestCat.getDataTypes();
        boolean doDelete = true;
        if (dts.length > 0) {
            for (DataType dt : dts) {
                long dtID = this.dtms[1].getID(dt);
                DataType myDt = this.dtms[2].getDataType(dtID);
                if (myDt == null || !myDt.getCategoryPath().equals((Object)dt.getCategoryPath())) continue;
                doDelete = false;
                break;
            }
        } else {
            Category[] cats;
            for (Category cat : cats = latestCat.getCategories()) {
                long catID = cat.getID();
                Category c = this.dtms[2].getCategory(catID);
                if (c == null || !c.getParent().getCategoryPath().equals((Object)cat.getParent().getCategoryPath())) continue;
                doDelete = false;
                break;
            }
        }
        if (doDelete && (parentCat = this.dtms[0].getCategory(latestCat.getParent().getCategoryPath())) != null) {
            parentCat.removeCategory(latestCat.getName(), TaskMonitorAdapter.DUMMY_MONITOR);
        }
    }

    private void showArchiveMergePanel(long id, int conflictIndex) {
        UniversalID sourceID = new UniversalID(id);
        SourceArchive mySourceArchive = this.dtms[2].getSourceArchive(sourceID);
        SourceArchive latestSourceArchive = this.dtms[1].getSourceArchive(sourceID);
        SourceArchive originalSourceArchive = this.dtms[3].getSourceArchive(sourceID);
        try {
            SwingUtilities.invokeAndWait(() -> {
                if (this.archiveMergePanel == null) {
                    this.archiveMergePanel = new SourceArchiveMergePanel(this.mergeManager, this.totalConflictCount);
                }
                this.archiveMergePanel.setConflictInfo(conflictIndex, latestSourceArchive, mySourceArchive, originalSourceArchive);
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        this.mergeManager.setApplyEnabled(false);
        this.mergeManager.showComponent((JComponent)this.archiveMergePanel, "SourceArchiveMerge", new HelpLocation("Repository", "SourceArchiveConflict"));
    }

    private void showCategoryMergePanel(long id, int conflictIndex) {
        Category myCat = this.dtms[2].getCategory(id);
        Category latestCat = this.dtms[1].getCategory(id);
        Category originalCat = this.dtms[3].getCategory(id);
        String latestPath = latestCat != null ? latestCat.getCategoryPathName() : null;
        String path = myCat != null ? myCat.getCategoryPathName() : null;
        String origPath = originalCat != null ? originalCat.getCategoryPathName() : null;
        try {
            SwingUtilities.invokeAndWait(() -> {
                if (this.catMergePanel == null) {
                    this.catMergePanel = new CategoryMergePanel(this.mergeManager, this.totalConflictCount);
                }
                this.catMergePanel.setConflictInfo(conflictIndex, latestPath, path, origPath, this.categoryWasRenamed(id, this.dtms[1]), this.categoryWasRenamed(id, this.dtms[2]), this.categoryWasMoved(id, this.dtms[1]), this.categoryWasMoved(id, this.dtms[2]), latestCat == null, myCat == null);
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        this.mergeManager.setApplyEnabled(false);
        this.mergeManager.showComponent((JComponent)this.catMergePanel, "CategoryMerge", new HelpLocation("Repository", "DataTypeConflict"));
    }

    private void showDataTypeMergePanel(int conflictIndex, DataType latestDt, DataType myDt, DataType origDt) {
        try {
            SwingUtilities.invokeAndWait(() -> {
                if (this.dtMergePanel == null) {
                    this.dtMergePanel = new DataTypeMergePanel(this.mergeManager, this.totalConflictCount);
                }
                this.dtMergePanel.setConflictInfo(conflictIndex, latestDt, myDt, origDt);
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        this.mergeManager.showComponent((JComponent)this.dtMergePanel, "DataTypeMerge", new HelpLocation("Repository", "DataTypeConflicts"));
    }

    private void processDataTypesDeleted() throws CancelledException {
        for (int i = 0; i < this.myDtChangeList.size(); ++i) {
            if (this.currentMonitor.isCancelled()) {
                throw new CancelledException();
            }
            long id = this.myDtChangeList.get(i);
            this.processDataTypeDeleted(id);
        }
    }

    private void processDataTypesAdded() throws CancelledException {
        for (int i = 0; i < this.myDtAddedList.size(); ++i) {
            if (this.currentMonitor.isCancelled()) {
                throw new CancelledException();
            }
            this.currentMonitor.setProgress((long)(++this.progressIndex));
            long myDtKey = this.myDtAddedList.get(i);
            DataType myDt = this.dtms[2].getDataType(myDtKey);
            if (this.equivalentDataTypeFound(myDtKey, myDt)) continue;
            if (myDt instanceof Composite || myDt instanceof Pointer || myDt instanceof Array || myDt instanceof TypeDef || myDt instanceof FunctionDefinition) {
                this.addDataType(myDtKey, myDt, this.myResolvedDts);
                continue;
            }
            DataType resolvedDt = this.dtms[0].addDataType(myDt, DataTypeConflictHandler.DEFAULT_HANDLER);
            this.myResolvedDts.put(myDtKey, (Object)resolvedDt);
        }
    }

    private boolean equivalentDataTypeFound(long myDtID, DataType myDt) {
        if (this.myResolvedDts.contains(myDtID)) {
            return true;
        }
        DataType resultDt = this.dtms[0].getDataType(myDt.getCategoryPath(), myDt.getName());
        if (resultDt != null) {
            SourceArchive resultSourceArchive = resultDt.getSourceArchive();
            SourceArchive mySourceArchive = myDt.getSourceArchive();
            UniversalID resultDtUniversalID = resultDt.getUniversalID();
            UniversalID myDtUniversalID = myDt.getUniversalID();
            if (!resultSourceArchive.getSourceArchiveID().equals((Object)mySourceArchive.getSourceArchiveID()) || !SystemUtilities.isEqual((Object)resultDtUniversalID, (Object)myDtUniversalID)) {
                return false;
            }
            if (resultDt.isEquivalent(myDt)) {
                this.myResolvedDts.put(myDtID, (Object)resultDt);
                return true;
            }
        }
        return false;
    }

    private void cleanUpDataTypes() {
        long[] keys;
        for (long key : keys = this.cleanupPlaceHolderList.getKeys()) {
            CleanUpInfo cleanUpInfo = (CleanUpInfo)this.cleanupPlaceHolderList.get(key);
            cleanUpInfo.cleanUp();
        }
    }

    private void fixUpDataTypes() {
        ArrayList<FixUpInfo> tempList = new ArrayList<FixUpInfo>(this.fixUpList);
        long currentID = -1L;
        long previousID = -1L;
        for (int i = 0; i < tempList.size(); ++i) {
            FixUpInfo info = tempList.get(i);
            DataType dt = (DataType)info.ht.get(info.id);
            if (dt instanceof Composite) {
                previousID = currentID;
                currentID = info.id;
                Composite destCdt = (Composite)dt;
                if (dt instanceof Union) {
                    if (previousID == currentID) continue;
                    this.fixUpUnion(info.id, (Union)destCdt);
                    continue;
                }
                this.fixUpStructure(info, (Structure)destCdt);
                continue;
            }
            if (dt instanceof FunctionDefinition) {
                this.fixUpFunctionDef(info, (FunctionDefinition)dt);
                continue;
            }
            DataTypeManager dtm = info.getDataTypeManager();
            if (this.resolve(info.compID, dtm, info.ht) != null) {
                this.resolve(info.id, dtm, info.ht);
            }
            this.fixUpList.remove(info);
        }
    }

    private void fixUpFunctionDef(FixUpInfo info, FunctionDefinition fd) {
        long lastChangeTime = fd.getLastChangeTime();
        DataType dt = this.resolve(info.compID, info.getDataTypeManager(), info.ht);
        if (dt != null) {
            if (info.index < 0) {
                fd.setReturnType(dt);
            } else {
                ParameterDefinition[] vars = fd.getArguments();
                try {
                    vars[info.index].setDataType(dt);
                }
                catch (InvalidInputException invalidInputException) {
                    // empty catch block
                }
            }
        }
        fd.setLastChangeTime(lastChangeTime);
        this.fixUpList.remove(info);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void fixUpStructure(FixUpInfo info, Structure struct) {
        long lastChangeTime;
        block13: {
            lastChangeTime = struct.getLastChangeTime();
            DataType compDt = this.resolve(info.compID, info.getDataTypeManager(), info.ht);
            if (compDt != null) {
                int length = compDt.getLength();
                if (length == 0) {
                    length = 1;
                }
                if (struct.isInternallyAligned()) {
                    int ordinal = info.index;
                    int numComponents = struct.getNumComponents();
                    if (ordinal >= 0 && ordinal < numComponents) {
                        DataTypeComponent dtc = struct.getComponent(ordinal);
                        dtc = struct.replace(ordinal, compDt, length, dtc.getFieldName(), dtc.getComment());
                        break block13;
                    } else {
                        Msg.warn((Object)this, (Object)("Data Type Merge: Couldn't get component " + ordinal + " in " + struct.getPathName() + " data type during fix up."));
                        return;
                    }
                }
                int offset = info.index;
                DataTypeComponent dtc = struct.getComponentAt(offset);
                if (dtc != null) {
                    int bytesAvailable;
                    int bytesNeeded;
                    int ordinal = dtc.getOrdinal();
                    int dtcLength = dtc.getLength();
                    if (length < 0) {
                        length = dtcLength;
                    }
                    if ((bytesNeeded = length - dtcLength) > 0 && (bytesAvailable = this.getNumUndefinedBytes(struct, ordinal + 1)) < bytesNeeded) {
                        length = dtcLength + bytesAvailable;
                        String message = "Merging Data Types: Not enough undefined bytes to fit " + compDt.getPathName() + " in structure " + struct.getPathName() + " at offset 0x" + Integer.toHexString(offset) + ".\nIt needs " + (bytesNeeded - bytesAvailable) + " more byte(s) to be able to fit.";
                        Msg.warn((Object)this, (Object)message);
                    }
                    dtc = struct.replaceAtOffset(offset, compDt, length, dtc.getFieldName(), dtc.getComment());
                } else {
                    Msg.warn((Object)this, (Object)("Couldn't get component at offset " + offset + " in " + struct.getPathName()));
                }
            }
        }
        if (struct.isInternallyAligned()) {
            DataTypeComponent component;
            DataType dataType;
            int ordinal = info.index;
            int numComponents = struct.getNumComponents();
            if (ordinal >= 0 && ordinal < numComponents && (dataType = (component = struct.getComponent(ordinal)).getDataType()) == BadDataType.dataType) {
                this.addToCleanupList(info);
            }
        } else {
            DataType dataType;
            int offset = info.index;
            DataTypeComponent component = struct.getComponentAt(offset);
            if (component != null && (dataType = component.getDataType()) == BadDataType.dataType) {
                struct.clearComponent(component.getOrdinal());
            }
        }
        struct.setLastChangeTime(lastChangeTime);
        this.fixUpList.remove(info);
    }

    private int getNumUndefinedBytes(Structure struct, int ordinal) {
        if (struct.isInternallyAligned()) {
            return 0;
        }
        int numComponents = struct.getNumComponents();
        if (ordinal >= numComponents) {
            return 0;
        }
        for (int index = ordinal; index < numComponents; ++index) {
            DataTypeComponent component = struct.getComponent(index);
            if (component == null) {
                return 0;
            }
            DataType dataType = component.getDataType();
            if (DataType.DEFAULT == dataType) continue;
            return index - ordinal;
        }
        return numComponents - ordinal;
    }

    private void addToCleanupList(FixUpInfo info) {
        long id = info.id;
        int index = info.index;
        LongObjectHashtable<DataType> ht = info.ht;
        CleanUpInfo cleanUpInfo = (CleanUpInfo)this.cleanupPlaceHolderList.get(id);
        if (cleanUpInfo == null) {
            cleanUpInfo = new CleanUpInfo(id);
            this.cleanupPlaceHolderList.put(id, (Object)cleanUpInfo);
        }
        cleanUpInfo.add(index, ht);
    }

    private void fixUpUnion(long id, Union union) {
        long lastChangeTime = union.getLastChangeTime();
        int preFixupLength = union.getLength();
        DataTypeComponent[] dtcs = union.getComponents();
        union.add((DataType)BadDataType.dataType, preFixupLength);
        while (union.getNumComponents() > 1) {
            union.delete(0);
        }
        for (int ordinal = 0; ordinal < dtcs.length; ++ordinal) {
            DataType compDt;
            DataTypeComponent rdtc = null;
            FixUpInfo info = this.findFixUpInfo(id, ordinal);
            if (info != null) {
                DataTypeComponent component;
                DataType dataType;
                compDt = this.resolve(info.compID, info.getDataTypeManager(), info.ht);
                if (compDt != null) {
                    int length = compDt.getLength();
                    if (length == 0) {
                        length = 1;
                    }
                    rdtc = union.insert(ordinal, compDt, length);
                }
                if ((dataType = (component = union.getComponent(ordinal)).getDataType()) == BadDataType.dataType) {
                    if (rdtc == null) {
                        rdtc = union.insert(ordinal, (DataType)BadDataType.dataType, dtcs[ordinal].getLength());
                    }
                    this.addToCleanupList(info);
                }
                this.fixUpList.remove(info);
            } else {
                compDt = dtcs[ordinal].getDataType();
                rdtc = union.insert(ordinal, compDt);
            }
            if (rdtc == null) continue;
            try {
                rdtc.setFieldName(dtcs[ordinal].getFieldName());
            }
            catch (DuplicateNameException duplicateNameException) {
                // empty catch block
            }
            rdtc.setComment(dtcs[ordinal].getComment());
        }
        int lastIndex = union.getNumComponents() - 1;
        DataType dataType = union.getComponent(lastIndex).getDataType();
        if (dataType == BadDataType.dataType) {
            union.delete(lastIndex);
        }
        union.setLastChangeTime(lastChangeTime);
    }

    private DataType resolve(long id, DataTypeManager dtm, LongObjectHashtable<DataType> resolvedDataTypes) {
        DataType otherDt;
        DataType dt = this.getResolvedComponent(id, resolvedDataTypes);
        if (dt == null && ((otherDt = dtm.getDataType(id)) instanceof TypeDef || otherDt instanceof Pointer || otherDt instanceof Array)) {
            DataType baseDt = this.getBaseDataType(otherDt);
            if (baseDt != DataType.DEFAULT) {
                long baseID = dtm.getID(baseDt);
                DataType rdt = (DataType)resolvedDataTypes.get(baseID);
                if (rdt != null) {
                    return this.addDataType(id, otherDt, resolvedDataTypes);
                }
                return null;
            }
            if (!this.myDtAddedList.contains(new Long(id))) {
                return this.dtms[0].getDataType(id);
            }
        }
        return dt;
    }

    private FixUpInfo findFixUpInfo(long id, int index) {
        for (int i = 0; i < this.fixUpList.size(); ++i) {
            FixUpInfo info = this.fixUpList.get(i);
            if (info.id != id || info.index != index) continue;
            return info;
        }
        return null;
    }

    private void processDataTypeSourceChanged(long id) {
        if (this.dataTypeSourceWasChanged(id, this.dtms[2])) {
            this.updateDataTypeSource(id, this.dtms[2], this.myResolvedDts);
        }
    }

    private void processDataTypeRenamed(long id) {
        DataType myDt = this.dtms[2].getDataType(id);
        DataType dt = this.dtms[0].getDataType(id);
        if (this.dataTypeWasRenamed(id, this.dtms[2]) && dt != null) {
            this.setDataTypeName(dt, myDt.getName());
        }
    }

    private void processDataTypeEdited(long id) {
        if (this.dataTypeWasChanged(id, this.dtms[2])) {
            this.updateDataType(id, this.dtms[2], this.myResolvedDts, false);
        }
    }

    private void processDataTypeDeleted(long myDtID) {
        DataType myDt = this.dtms[2].getDataType(myDtID);
        if (myDt == null && (myDt = this.dtms[0].getDataType(myDtID)) != null) {
            this.dtms[0].remove(myDt, this.currentMonitor);
        }
    }

    private void processDataTypeMoved(long id) {
        DataType resultDt;
        DataType myDt;
        CategoryPath myParentPath;
        if (this.dataTypeWasMoved(id, this.dtms[2]) && !(myParentPath = (myDt = this.dtms[2].getDataType(id)).getCategoryPath()).equals((Object)(resultDt = this.dtms[0].getDataType(id)).getCategoryPath())) {
            Category resultParent = this.dtms[0].createCategory(myParentPath);
            try {
                resultParent.moveDataType(resultDt, DataTypeConflictHandler.DEFAULT_HANDLER);
            }
            catch (DataTypeDependencyException e) {
                String msg = "Move data type named " + resultDt.getName() + " failed.\nProblem: " + e.getMessage();
                Msg.showError((Object)this, null, (String)"Error Moving Data Type", (Object)msg);
            }
        }
    }

    private void setupSourceArchiveChanges(DataTypeChangeSet latestChanges, DataTypeChangeSet myChanges) {
        long[] latestArchiveChanges = latestChanges.getSourceArchiveChanges();
        long[] latestArchiveAdds = latestChanges.getSourceArchiveAdditions();
        Arrays.sort(latestArchiveChanges);
        Arrays.sort(latestArchiveAdds);
        long[] myArchiveChanges = myChanges.getSourceArchiveChanges();
        long[] myArchiveAdds = myChanges.getSourceArchiveAdditions();
        this.dirtyMap = new HashMap();
        this.archiveConflictList = new ArrayList();
        this.myArchiveChangeList = new ArrayList();
        this.myArchiveAddedList = new ArrayList();
        this.determineSourceArchiveAddConflicts(latestArchiveAdds, myArchiveAdds);
        this.determineSourceArchiveChangeConflicts(latestArchiveChanges, myArchiveChanges);
        this.totalConflictCount += this.archiveConflictList.size();
    }

    private void determineSourceArchiveChangeConflicts(long[] latestArchiveChanges, long[] myArchiveChanges) {
        for (long myChangeID : myArchiveChanges) {
            boolean changedInLatest;
            UniversalID sourceID = new UniversalID(myChangeID);
            Long myChangeIDObject = new Long(myChangeID);
            if (this.myArchiveAddedList.contains(myChangeIDObject) || this.archiveConflictList.contains(myChangeIDObject)) continue;
            SourceArchive mySourceArchive = this.dtms[2].getSourceArchive(sourceID);
            this.loadDirtyMap(sourceID, mySourceArchive);
            int searchIndex = Arrays.binarySearch(latestArchiveChanges, myChangeID);
            boolean bl = changedInLatest = searchIndex >= 0;
            if (changedInLatest) {
                boolean myChangedName;
                boolean removedLatest;
                SourceArchive origSourceArchive = this.dtms[3].getSourceArchive(sourceID);
                if (origSourceArchive == null) continue;
                SourceArchive latestSourceArchive = this.dtms[1].getSourceArchive(sourceID);
                boolean removedMy = mySourceArchive == null;
                boolean bl2 = removedLatest = latestSourceArchive == null;
                if (removedMy && removedLatest) continue;
                if (removedMy || removedLatest) {
                    this.archiveConflictList.add(myChangeIDObject);
                    continue;
                }
                String origName = origSourceArchive.getName();
                String latestName = latestSourceArchive.getName();
                String myName = mySourceArchive.getName();
                boolean sameName = StringUtils.equals((CharSequence)myName, (CharSequence)latestName);
                boolean latestChangedName = !StringUtils.equals((CharSequence)origName, (CharSequence)latestName);
                boolean bl3 = myChangedName = !StringUtils.equals((CharSequence)origName, (CharSequence)myName);
                if (!sameName && latestChangedName && myChangedName) {
                    this.archiveConflictList.add(myChangeIDObject);
                    continue;
                }
            }
            this.myArchiveChangeList.add(new Long(myChangeID));
        }
    }

    private void determineSourceArchiveAddConflicts(long[] latestArchiveAdds, long[] myArchiveAdds) {
        for (long myAddID : myArchiveAdds) {
            UniversalID sourceID = new UniversalID(myAddID);
            SourceArchive mySourceArchive = this.dtms[2].getSourceArchive(sourceID);
            if (mySourceArchive == null) continue;
            this.loadDirtyMap(sourceID, mySourceArchive);
            boolean foundConflict = false;
            for (long latestAddID : latestArchiveAdds) {
                if (myAddID != latestAddID) continue;
                SourceArchive latestSourceArchive = this.dtms[1].getSourceArchive(new UniversalID(latestAddID));
                if (StringUtils.equals((CharSequence)mySourceArchive.getName(), (CharSequence)latestSourceArchive.getName())) continue;
                this.archiveConflictList.add(new Long(myAddID));
                foundConflict = true;
                break;
            }
            if (foundConflict) continue;
            this.myArchiveAddedList.add(new Long(myAddID));
        }
    }

    private void loadDirtyMap(UniversalID sourceID, SourceArchive mySourceArchive) {
        if (mySourceArchive == null) {
            return;
        }
        if (!this.dirtyMap.containsKey(sourceID)) {
            SourceArchive latestSourceArchive = this.dtms[1].getSourceArchive(sourceID);
            boolean latestDirty = latestSourceArchive != null ? latestSourceArchive.isDirty() : false;
            boolean myDirty = mySourceArchive.isDirty();
            this.dirtyMap.put(sourceID, new Boolean(myDirty || latestDirty));
        }
    }

    private void setupDataTypeChanges(DataTypeChangeSet latestChanges, DataTypeChangeSet myChanges) {
        long[] latestDtChanges = latestChanges.getDataTypeChanges();
        long[] latestDtAdds = latestChanges.getDataTypeAdditions();
        long[] myDtChanges = myChanges.getDataTypeChanges();
        long[] myDtAdds = myChanges.getDataTypeAdditions();
        this.dtConflictList = new ArrayList();
        this.dtSourceConflictList = new ArrayList();
        this.myDtChangeList = new ArrayList();
        for (long myDtChange : myDtChanges) {
            this.myDtChangeList.add(new Long(myDtChange));
        }
        this.processAddIDs(myDtAdds);
        ArrayList<Long> resultDtChangeList = new ArrayList<Long>();
        for (long latestDtChange : latestDtChanges) {
            resultDtChangeList.add(new Long(latestDtChange));
        }
        ArrayList<Long> resultDtAddList = new ArrayList<Long>();
        for (long latestDtAdd : latestDtAdds) {
            resultDtAddList.add(new Long(latestDtAdd));
        }
        this.myDtChangeList.removeAll(this.myDtAddedList);
        this.myDtChangeList.removeAll(this.dtConflictList);
        this.dtConflictList.addAll(this.myDtChangeList);
        this.myDtChangeList.removeAll(resultDtChangeList);
        ArrayList<Long> resultDtCombinedList = new ArrayList<Long>();
        resultDtCombinedList.addAll(resultDtChangeList);
        resultDtCombinedList.addAll(resultDtAddList);
        this.dtConflictList.retainAll(resultDtCombinedList);
        resultDtCombinedList = null;
        this.eliminateFakeConflicts();
        this.origDtConflictList = new ArrayList<Long>(this.dtConflictList);
        this.myResolvedDts = new LongObjectHashtable();
        this.latestResolvedDts = new LongObjectHashtable();
        this.origResolvedDts = new LongObjectHashtable();
        this.fixUpList = new ArrayList<FixUpInfo>();
        this.totalConflictCount += this.dtConflictList.size();
        this.cleanupPlaceHolderList = new LongObjectHashtable();
    }

    private void processAddIDs(long[] myDtAdds) {
        this.myDtAddedList = new ArrayList();
        for (long myDtAdd : myDtAdds) {
            DataType myDt = this.dtms[2].getDataType(myDtAdd);
            if (myDt != null) {
                DataType resultDt;
                SourceArchive sourceArchive = myDt.getSourceArchive();
                UniversalID dataTypeID = myDt.getUniversalID();
                DataType dataType = resultDt = dataTypeID != null ? this.dtms[0].getDataType(sourceArchive, dataTypeID) : null;
                if (!(resultDt == null || resultDt.getCategoryPath().equals((Object)myDt.getCategoryPath()) && DataTypeUtilities.equalsIgnoreConflict((String)resultDt.getName(), (String)myDt.getName()) && resultDt.isEquivalent(myDt))) {
                    this.dtConflictList.add(new Long(myDtAdd));
                    this.dtSourceConflictList.add(new Long(myDtAdd));
                    continue;
                }
                this.myDtAddedList.add(new Long(myDtAdd));
                continue;
            }
            Long l = new Long(myDtAdd);
            if (this.myDtChangeList.contains(l)) continue;
            this.myDtChangeList.add(l);
        }
    }

    private void eliminateFakeConflicts() {
        for (int i = 0; i < this.dtConflictList.size(); ++i) {
            boolean wasDeleted;
            DataType latestDt;
            long id = this.dtConflictList.get(i);
            DataType myDt = this.dtms[2].getDataType(id);
            if (myDt instanceof Pointer || myDt instanceof Array) {
                this.dtConflictList.remove(i);
                --i;
                continue;
            }
            if (myDt == null && ((latestDt = this.dtms[1].getDataType(id)) instanceof Pointer || latestDt instanceof Array)) {
                this.dtConflictList.remove(i);
                --i;
                continue;
            }
            boolean renamedMy = this.dataTypeWasRenamed(id, this.dtms[2]) || this.dataTypeWasMoved(id, this.dtms[2]);
            boolean renamedLatest = this.dataTypeWasRenamed(id, this.dtms[1]) || this.dataTypeWasMoved(id, this.dtms[1]);
            boolean myChanged = this.dataTypeWasChanged(id, this.dtms[2]);
            boolean latestChanged = this.dataTypeWasChanged(id, this.dtms[1]);
            boolean sameSource = !this.dataTypeSourceWasChanged(id, this.dtms[1], this.dtms[2]);
            boolean mySourceChanged = sameSource ? false : this.dataTypeSourceWasChanged(id, this.dtms[2]);
            boolean latestSourceChanged = sameSource ? false : this.dataTypeSourceWasChanged(id, this.dtms[1]);
            boolean bl = wasDeleted = this.dataTypeWasDeleted(id, this.dtms[2]) || this.dataTypeWasDeleted(id, this.dtms[1]);
            if (!(this.dataTypeWasDeleted(id, this.dtms[2]) || this.dataTypeWasDeleted(id, this.dtms[1]) || this.dataTypeWasChanged(id, this.dtms[1], this.dtms[2]))) {
                myChanged = false;
                latestChanged = false;
            }
            if (!(wasDeleted || this.dataTypeWasRenamed(id, this.dtms[1], this.dtms[2]) || this.dataTypeWasMoved(id, this.dtms[1], this.dtms[2]))) {
                renamedMy = false;
                renamedLatest = false;
            }
            if (this.dtSourceConflictList.contains(id) || renamedMy && renamedLatest || renamedMy && wasDeleted || renamedLatest && wasDeleted || myChanged && latestChanged || (myChanged || latestChanged) && wasDeleted || mySourceChanged && latestSourceChanged || (mySourceChanged || latestSourceChanged) && wasDeleted) continue;
            this.dtConflictList.remove(i);
            if (myChanged || renamedMy || mySourceChanged) {
                this.myDtChangeList.add(new Long(id));
            }
            --i;
        }
        Collections.sort(this.dtConflictList);
    }

    private void setupCategoryChanges(DataTypeChangeSet latestChanges, DataTypeChangeSet myChanges) {
        this.myCatChangeList = new ArrayList();
        long[] myCatChanges = myChanges.getCategoryChanges();
        Arrays.sort(myCatChanges);
        for (long myCatChange : myCatChanges) {
            this.myCatChangeList.add(new Long(myCatChange));
        }
        this.myCatAddedList = new ArrayList();
        long[] myCatAdds = myChanges.getCategoryAdditions();
        Arrays.sort(myCatAdds);
        for (long myCatAdd : myCatAdds) {
            if (this.dtms[2].getCategory(myCatAdd) != null) {
                this.myCatAddedList.add(new Long(myCatAdd));
                continue;
            }
            Long l = new Long(myCatAdd);
            if (this.myCatChangeList.contains(l)) continue;
            this.myCatChangeList.add(l);
        }
        Collections.sort(this.myCatChangeList);
        long[] latestCatChanges = latestChanges.getCategoryChanges();
        Arrays.sort(latestCatChanges);
        ArrayList<Long> resultCatChangeList = new ArrayList<Long>();
        for (long latestCatChange : latestCatChanges) {
            resultCatChangeList.add(new Long(latestCatChange));
        }
        this.myCatChangeList.removeAll(this.myCatAddedList);
        this.catConflictList = new ArrayList<Long>(this.myCatChangeList);
        this.myCatChangeList.removeAll(resultCatChangeList);
        this.catConflictList.retainAll(resultCatChangeList);
        for (int i = 0; i < this.catConflictList.size(); ++i) {
            boolean wasDeleted;
            long id = this.catConflictList.get(i);
            if (this.dtms[2].getCategory(id) == null && this.dtms[1].getCategory(id) == null) {
                this.catConflictList.remove(i);
                --i;
                continue;
            }
            boolean renamedMy = this.categoryWasRenamed(id, this.dtms[2]) || this.categoryWasMoved(id, this.dtms[2]);
            boolean renamedLatest = this.categoryWasRenamed(id, this.dtms[1]) || this.categoryWasMoved(id, this.dtms[1]);
            boolean bl = wasDeleted = this.dtms[2].getCategory(id) == null || this.dtms[1].getCategory(id) == null;
            if (this.dtms[2].getCategory(id) != null && this.dtms[1].getCategory(id) != null && !this.categoryWasRenamed(id, this.dtms[2], this.dtms[1]) && !this.categoryWasMoved(id, this.dtms[2], this.dtms[1])) {
                renamedMy = false;
                renamedLatest = false;
            }
            if (renamedMy && renamedLatest || renamedMy && wasDeleted || renamedLatest && wasDeleted) continue;
            if (renamedMy) {
                this.myCatChangeList.add(new Long(id));
            }
            this.catConflictList.remove(i);
            --i;
        }
        this.totalConflictCount += this.catConflictList.size();
    }

    private DataType getBaseDataType(DataType dt) {
        DataType baseDt = dt;
        while (baseDt instanceof Pointer || baseDt instanceof Array || baseDt instanceof TypeDef) {
            if (baseDt instanceof Pointer) {
                baseDt = ((Pointer)baseDt).getDataType();
                continue;
            }
            if (baseDt instanceof Array) {
                baseDt = ((Array)baseDt).getDataType();
                continue;
            }
            baseDt = ((TypeDef)baseDt).getDataType();
        }
        return baseDt;
    }

    private void resetOption() {
        if (this.mergeManager != null) {
            this.conflictOption = this.originalConflictOption;
        }
    }

    private void showMessage(String title, String msg) {
        try {
            SwingUtilities.invokeAndWait(() -> Msg.showInfo(this.getClass(), null, (String)title, (Object)msg));
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    @Override
    public String[][] getPhases() {
        return new String[][]{DATA_TYPES_PHASE};
    }

    private DataTypeManager getDataTypeManager(LongObjectHashtable<DataType> dataTypeMap) {
        if (dataTypeMap == this.origResolvedDts) {
            return this.dtms[3];
        }
        if (dataTypeMap == this.latestResolvedDts) {
            return this.dtms[0];
        }
        return this.dtms[2];
    }

    private class CleanUpInfo {
        long id;
        HashMap<LongObjectHashtable<DataType>, int[]> map;

        CleanUpInfo(long id) {
            this.id = id;
        }

        public void add(int index, LongObjectHashtable<DataType> resolvedDataTypes) {
            int[] indices;
            if (this.map == null) {
                this.map = new HashMap();
            }
            if ((indices = this.map.get(resolvedDataTypes)) == null) {
                indices = new int[]{};
            }
            int length = indices.length;
            int[] destIndices = new int[length + 1];
            System.arraycopy(indices, 0, destIndices, 0, length);
            destIndices[length] = index;
            this.map.put(resolvedDataTypes, destIndices);
        }

        private void cleanUp() {
            if (this.map == null) {
                return;
            }
            Set<LongObjectHashtable<DataType>> keySet = this.map.keySet();
            for (LongObjectHashtable<DataType> ht : keySet) {
                DataType dt = (DataType)ht.get(this.id);
                if (!(dt instanceof Composite)) continue;
                int[] indexArray = this.map.get(ht);
                if (dt instanceof Union) {
                    this.cleanUpUnion(indexArray, (Union)dt);
                } else {
                    this.cleanUpStructure(indexArray, (Structure)dt);
                }
                this.map.remove(ht);
            }
            this.map = null;
        }

        private void cleanUpUnion(int[] indexArray, Union dt) {
            Arrays.sort(indexArray);
            for (int i = indexArray.length - 1; i >= 0; --i) {
                int ordinal = indexArray[i];
                if (ordinal < 0 || ordinal >= dt.getNumComponents() || dt.getComponent(ordinal).getDataType() != BadDataType.dataType) continue;
                dt.delete(ordinal);
            }
        }

        private void cleanUpStructure(int[] indexArray, Structure dt) {
            boolean aligned = dt.isInternallyAligned();
            Arrays.sort(indexArray);
            for (int i = indexArray.length - 1; i >= 0; --i) {
                if (aligned) {
                    int ordinal = indexArray[i];
                    if (ordinal < 0 || ordinal >= dt.getNumComponents() || dt.getComponent(ordinal).getDataType() != BadDataType.dataType) continue;
                    dt.delete(ordinal);
                    continue;
                }
                int offset = indexArray[i];
                DataTypeComponent component = dt.getComponentAt(offset);
                if (component == null || component.getDataType() != BadDataType.dataType) continue;
                dt.clearComponent(component.getOrdinal());
            }
        }
    }

    private class FixUpInfo {
        long id;
        long compID;
        int index;
        LongObjectHashtable<DataType> ht;

        FixUpInfo(long id, long compID, int index, LongObjectHashtable<DataType> resolvedDataTypes) {
            this.id = id;
            this.compID = compID;
            this.index = index;
            this.ht = resolvedDataTypes;
        }

        public String toString() {
            String htStr = "MY";
            DataTypeManager dtm = DataTypeMergeManager.this.dtms[2];
            if (this.ht == DataTypeMergeManager.this.origResolvedDts) {
                htStr = "ORIGINAL";
                dtm = DataTypeMergeManager.this.dtms[3];
            } else if (this.ht == DataTypeMergeManager.this.latestResolvedDts) {
                htStr = "LATEST/RESULTS";
                dtm = DataTypeMergeManager.this.dtms[1];
            }
            return "\nID = " + Long.toHexString(this.id) + ",\ndt = " + dtm.getDataType(this.id) + ",\ncomponent ID = " + Long.toHexString(this.compID) + ",\ncomponent dt = " + dtm.getDataType(this.compID) + ",\noffset/index = " + this.index + ",\nht = " + htStr + "\n";
        }

        DataTypeManager getDataTypeManager() {
            if (this.ht == DataTypeMergeManager.this.origResolvedDts) {
                return DataTypeMergeManager.this.dtms[3];
            }
            if (this.ht == DataTypeMergeManager.this.latestResolvedDts) {
                return DataTypeMergeManager.this.dtms[0];
            }
            return DataTypeMergeManager.this.dtms[2];
        }
    }
}

