/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge;

import ghidra.util.Msg;
import ghidra.util.layout.VerticalLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import resources.ResourceManager;

public class MergeProgressPanel
extends JPanel {
    public static ImageIcon DEFINED_ICON = ResourceManager.loadImage((String)"images/bullet_green.png");
    public static ImageIcon IN_PROGRESS_ICON = ResourceManager.loadImage((String)"images/right.png");
    public static ImageIcon COMPLETED_ICON = ResourceManager.loadImage((String)"images/checkmark_green.gif");
    private HashMap<String, JLabel> imageMap = new HashMap();
    private static int INDENT_IN_PIXELS = 20;

    public MergeProgressPanel() {
        this.setLayout((LayoutManager)new VerticalLayout(5));
        this.add(this.getProgressTitlePanel());
    }

    private JPanel getProgressTitlePanel() {
        JPanel phasesTitlePanel = new JPanel();
        Border insideBorder = BorderFactory.createEmptyBorder(0, 0, 2, 0);
        MatteBorder outsideBorder = BorderFactory.createMatteBorder(0, 0, 2, 0, Color.BLUE);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(outsideBorder, insideBorder);
        phasesTitlePanel.setBorder(compoundBorder);
        BoxLayout bl = new BoxLayout(phasesTitlePanel, 0);
        phasesTitlePanel.setLayout(bl);
        phasesTitlePanel.add(Box.createHorizontalStrut(5));
        phasesTitlePanel.add(new JLabel("Merge Status"));
        phasesTitlePanel.add(Box.createHorizontalStrut(15));
        phasesTitlePanel.add(new JLabel("( "));
        phasesTitlePanel.add(new JLabel(DEFINED_ICON));
        phasesTitlePanel.add(new JLabel(" = Pending"));
        phasesTitlePanel.add(Box.createHorizontalStrut(10));
        phasesTitlePanel.add(new JLabel(IN_PROGRESS_ICON));
        phasesTitlePanel.add(new JLabel(" = In Progress"));
        phasesTitlePanel.add(Box.createHorizontalStrut(10));
        phasesTitlePanel.add(new JLabel(COMPLETED_ICON));
        phasesTitlePanel.add(new JLabel(" = Completed"));
        phasesTitlePanel.add(new JLabel(" )"));
        phasesTitlePanel.add(Box.createHorizontalStrut(5));
        return phasesTitlePanel;
    }

    public JPanel addInfo(String[] phase) {
        int phaseDepth = phase.length - 1;
        JLabel imageLabel = new JLabel(DEFINED_ICON);
        JLabel infoLabel = new JLabel(phase[phaseDepth]);
        JPanel labelPanel = new JPanel();
        labelPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        BoxLayout bl = new BoxLayout(labelPanel, 0);
        labelPanel.setLayout(bl);
        labelPanel.add(Box.createHorizontalStrut(INDENT_IN_PIXELS * phaseDepth));
        labelPanel.add(Box.createHorizontalStrut(5));
        labelPanel.add(imageLabel);
        labelPanel.add(Box.createHorizontalStrut(5));
        labelPanel.add(infoLabel);
        this.imageMap.put(this.getPhaseString(phase), imageLabel);
        this.add(labelPanel);
        return labelPanel;
    }

    public void setInProgress(String[] phase) {
        JLabel iconLabel = this.imageMap.get(this.getPhaseString(phase));
        if (iconLabel != null) {
            iconLabel.setIcon(IN_PROGRESS_ICON);
        }
    }

    public void setCompleted(String[] phase) {
        JLabel iconLabel = this.imageMap.get(this.getPhaseString(phase));
        if (iconLabel != null) {
            iconLabel.setIcon(COMPLETED_ICON);
        }
    }

    private String getPhaseString(String[] phase) {
        StringBuffer buf = new StringBuffer();
        buf.append(phase[0]);
        for (int i = 1; i < phase.length; ++i) {
            buf.append(":" + phase[i]);
        }
        return buf.toString();
    }

    public static void main(String[] args) {
        MergeProgressPanel panel = new MergeProgressPanel();
        String[] MEMORY = new String[]{"Memory"};
        String[] PROGRAM_TREE = new String[]{"Program Tree"};
        String[] DATA_TYPES = new String[]{"Data Types"};
        String[] PROGRAM_CONTEXT = new String[]{"Program Context"};
        String[] LISTING = new String[]{"Listing"};
        String[] BYTES = new String[]{"Listing", "Bytes"};
        String[] CODE_UNITS = new String[]{"Listing", "Code Units"};
        String[] FUNCTIONS = new String[]{"Listing", "Functions"};
        String[] SYMBOLS = new String[]{"Listing", "Symbols"};
        String[] COMMENTS = new String[]{"Listing", "Comments, References & User Defined Properties"};
        String[] EXTERNAL_PROGRAM = new String[]{"External Program"};
        String[] PROPERTY_LIST = new String[]{"Property List"};
        panel.addInfo(MEMORY);
        panel.addInfo(PROGRAM_TREE);
        panel.addInfo(DATA_TYPES);
        panel.addInfo(PROGRAM_CONTEXT);
        panel.addInfo(LISTING);
        panel.addInfo(BYTES);
        panel.addInfo(CODE_UNITS);
        panel.addInfo(FUNCTIONS);
        panel.addInfo(SYMBOLS);
        panel.addInfo(COMMENTS);
        panel.addInfo(EXTERNAL_PROGRAM);
        panel.addInfo(PROPERTY_LIST);
        JFrame frame = new JFrame();
        frame.setSize(800, 400);
        frame.setVisible(true);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)panel, "Center");
        frame.validate();
        frame.setVisible(true);
        try {
            panel.setInProgress(MEMORY);
            Thread.sleep(2000L);
            panel.setCompleted(MEMORY);
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            Msg.error(null, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
        }
        frame.setVisible(false);
        System.exit(0);
    }
}

