/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.refs;

import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;

public class RemoveExternalRefCmd
implements Command {
    private Address fromAddr;
    private int opIndex;

    public RemoveExternalRefCmd(Address fromAddr, int opIndex) {
        this.fromAddr = fromAddr;
        this.opIndex = opIndex;
    }

    public boolean applyTo(DomainObject obj) {
        ReferenceManager refMgr = ((Program)obj).getReferenceManager();
        Reference[] refs = refMgr.getReferencesFrom(this.fromAddr, this.opIndex);
        for (int i = 0; i < refs.length; ++i) {
            Reference ref = refs[i];
            if (!ref.isExternalReference()) continue;
            refMgr.delete(ref);
        }
        return true;
    }

    public String getStatusMsg() {
        return null;
    }

    public String getName() {
        return "Remove External Reference";
    }
}

