/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.memory;

import ghidra.app.cmd.memory.DeleteBlockListener;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.DomainObject;
import ghidra.framework.store.LockException;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.Msg;
import ghidra.util.task.TaskMonitor;

public class DeleteBlockCmd
extends BackgroundCommand {
    private Address[] blockAddresses;
    private DeleteBlockListener listener;
    private boolean status;

    public DeleteBlockCmd(Address[] blockAddresses, DeleteBlockListener listener) {
        super("Delete Memory Block", false, true, true);
        this.blockAddresses = blockAddresses;
        this.listener = listener;
    }

    public boolean applyTo(DomainObject obj, TaskMonitor monitor) {
        Program program = (Program)obj;
        Memory mem = program.getMemory();
        if (!program.hasExclusiveAccess()) {
            this.setStatusMsg("Exclusive access required");
            return false;
        }
        monitor.initialize((long)this.blockAddresses.length);
        for (Address blockAddresse : this.blockAddresses) {
            if (monitor.isCancelled()) break;
            MemoryBlock block = mem.getBlock(blockAddresse);
            monitor.setMessage("Deleting block '" + block.getName() + "'...");
            try {
                mem.removeBlock(block, monitor);
            }
            catch (LockException e) {
                Msg.debug((Object)((Object)this), (Object)("Unable to delete block--do not have lock: '" + block.getName() + "'"), (Throwable)e);
            }
            monitor.initialize(block.getSize());
        }
        this.status = true;
        return this.status;
    }

    public boolean getStatus() {
        return this.status;
    }

    public void taskCompleted() {
        this.listener.deleteBlockCompleted(this);
    }
}

