/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.function;

import ghidra.app.cmd.function.CreateFunctionCmd;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Program;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.Reference;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class FunctionPurgeAnalysisCmd
extends BackgroundCommand {
    private AddressSetView entryPoints;
    private Program program;

    public FunctionPurgeAnalysisCmd(AddressSetView entries) {
        super("Compute Function Purge", true, true, false);
        this.entryPoints = entries;
    }

    public boolean applyTo(DomainObject obj, TaskMonitor monitor) {
        this.program = (Program)obj;
        Processor processor = this.program.getLanguage().getProcessor();
        if (this.program.getLanguage().getDefaultSpace().getSize() > 32 || !processor.equals((Object)Processor.findOrPossiblyCreateProcessor((String)"x86"))) {
            Msg.error((Object)((Object)this), (Object)("Unsupported operation for language " + this.program.getLanguage().getLanguageID()));
            return false;
        }
        AddressSetView set = this.entryPoints;
        long maxCount = set.getNumAddresses();
        monitor.setMaximum(maxCount);
        monitor.setProgress(0L);
        for (Function function : this.program.getFunctionManager().getFunctions(this.entryPoints, true)) {
            if (monitor.isCancelled()) break;
            set = set.subtract((AddressSetView)new AddressSet(this.program, this.entryPoints.getMinAddress(), function.getEntryPoint()));
            monitor.setProgress(maxCount - set.getNumAddresses());
            monitor.setMessage("Purge " + function.getName());
            try {
                this.analyzeFunction(function, monitor);
            }
            catch (CancelledException cancelledException) {}
        }
        if (monitor.isCancelled()) {
            this.setStatusMsg("Function Purge analysis cancelled");
            return false;
        }
        return true;
    }

    private void analyzeFunction(Function function, TaskMonitor monitor) throws CancelledException {
        int purge = -1;
        if (function != null) {
            purge = function.getStackPurgeSize();
        }
        if ((purge == -1 || purge > 128 || purge < -128) && (purge = this.locatePurgeReturn(this.program, function, monitor)) != -1) {
            function.setStackPurgeSize(purge);
        }
    }

    private int locatePurgeReturn(Program program, Function func, TaskMonitor monitor) {
        AddressSetView body = func.getBody();
        int returnPurge = this.findReturnPurge(program, body);
        if (returnPurge != -1) {
            return returnPurge;
        }
        body = CreateFunctionCmd.getFunctionBody(program, func.getEntryPoint(), monitor);
        returnPurge = this.findReturnPurge(program, body);
        return returnPurge;
    }

    private int findReturnPurge(Program program, AddressSetView body) {
        InstructionIterator iter = program.getListing().getInstructions(body, true);
        int count = 2048;
        while (iter.hasNext() && count > 0) {
            Reference[] referencesFrom;
            --count;
            Instruction instr = iter.next();
            FlowType ftype = instr.getFlowType();
            if (!ftype.isTerminal()) continue;
            if (instr.getMnemonicString().compareToIgnoreCase("ret") == 0) {
                int tempPurge = 0;
                Scalar scalar = instr.getScalar(0);
                if (scalar != null) {
                    tempPurge = (int)scalar.getSignedValue();
                    return tempPurge;
                }
                return 0;
            }
            if (!ftype.isCall()) continue;
            for (Reference reference : referencesFrom = instr.getReferencesFrom()) {
                Function functionAt;
                if (!reference.getReferenceType().isFlow() || (functionAt = program.getFunctionManager().getFunctionAt(reference.getToAddress())) == null || functionAt.hasNoReturn()) continue;
                return functionAt.getStackPurgeSize();
            }
        }
        return -1;
    }
}

