/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.comments;

import ghidra.app.util.viewer.field.CommentUtils;
import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;

public class SetCommentsCmd
implements Command {
    private Address address;
    private String preComment;
    private String postComment;
    private String eolComment;
    private String plateComment;
    private String repeatableComment;
    private String msg;

    public SetCommentsCmd(Address addr, String newPreComment, String newPostComment, String newEolComment, String newPlateComment, String newRepeatableComment) {
        this.address = addr;
        this.preComment = newPreComment;
        this.postComment = newPostComment;
        this.eolComment = newEolComment;
        this.plateComment = newPlateComment;
        this.repeatableComment = newRepeatableComment;
    }

    public String getName() {
        return "Set Comments";
    }

    private boolean commentChanged(String newValue, String oldValue) {
        if (newValue == null && oldValue == null) {
            return false;
        }
        if (newValue != null) {
            return !newValue.equals(oldValue);
        }
        return !oldValue.equals(newValue);
    }

    public boolean applyTo(DomainObject obj) {
        Program program = (Program)obj;
        CodeUnit cu = this.getCodeUnit(program);
        if (cu != null) {
            if (this.commentChanged(cu.getComment(1), this.preComment)) {
                String updatedPreComment = CommentUtils.fixupAnnoations(this.preComment, program);
                cu.setComment(1, updatedPreComment);
            }
            if (this.commentChanged(cu.getComment(2), this.postComment)) {
                String updatedPostComment = CommentUtils.fixupAnnoations(this.postComment, program);
                cu.setComment(2, updatedPostComment);
            }
            if (this.commentChanged(cu.getComment(0), this.eolComment)) {
                String updatedEOLComment = CommentUtils.fixupAnnoations(this.eolComment, program);
                cu.setComment(0, updatedEOLComment);
            }
            if (this.commentChanged(cu.getComment(3), this.plateComment)) {
                String updatedPlateComment = CommentUtils.fixupAnnoations(this.plateComment, program);
                cu.setComment(3, updatedPlateComment);
            }
            if (this.commentChanged(cu.getComment(4), this.repeatableComment)) {
                String updatedRepeatableComment = CommentUtils.fixupAnnoations(this.repeatableComment, program);
                cu.setComment(4, updatedRepeatableComment);
            }
        }
        return true;
    }

    private CodeUnit getCodeUnit(Program program) {
        Listing listing = program.getListing();
        CodeUnit cu = listing.getCodeUnitContaining(this.address);
        if (cu == null) {
            return null;
        }
        Address cuAddr = cu.getMinAddress();
        if (cu instanceof Data && !this.address.equals((Object)cuAddr)) {
            Data data = (Data)cu;
            return data.getPrimitiveAt((int)this.address.subtract(cuAddr));
        }
        return cu;
    }

    public String getStatusMsg() {
        return this.msg;
    }

    public static void createComment(Program program, Address addr, String comment, int commentType) {
        SetCommentsCmd commentCmd = null;
        switch (commentType) {
            case 1: {
                commentCmd = new SetCommentsCmd(addr, comment, null, null, null, null);
                break;
            }
            case 2: {
                commentCmd = new SetCommentsCmd(addr, null, comment, null, null, null);
                break;
            }
            case 0: {
                commentCmd = new SetCommentsCmd(addr, null, null, comment, null, null);
                break;
            }
            case 3: {
                commentCmd = new SetCommentsCmd(addr, null, null, null, comment, null);
                break;
            }
            case 4: {
                commentCmd = new SetCommentsCmd(addr, null, null, null, null, comment);
                break;
            }
            default: {
                commentCmd = new SetCommentsCmd(addr, null, null, comment, null, null);
            }
        }
        commentCmd.applyTo((DomainObject)program);
    }
}

