/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.vertex;

import docking.GenericHeader;
import ghidra.graph.viewer.vertex.AbstractVisualVertex;
import ghidra.util.MathUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class DockingVisualVertex
extends AbstractVisualVertex {
    private JPanel mainPanel = new JPanel(new BorderLayout());
    private JTextArea textArea;
    private GenericHeader genericHeader;
    private String name;
    private int maxWidth = 200;

    public DockingVisualVertex(String name) {
        PropertyChangeListener[] listeners;
        this.name = name;
        this.textArea = new JTextArea(){

            @Override
            public Dimension getPreferredSize() {
                Dimension preferredSize = super.getPreferredSize();
                int width = preferredSize.width;
                preferredSize.width = MathUtilities.clamp((int)width, (int)width, (int)DockingVisualVertex.this.maxWidth);
                return preferredSize;
            }
        };
        this.textArea.setText(name);
        this.textArea.setPreferredSize(new Dimension(200, 50));
        this.textArea.setBackground(Color.YELLOW.darker());
        this.textArea.setCaretColor(Color.PINK);
        this.textArea.setBorder(BorderFactory.createRaisedBevelBorder());
        this.textArea.setLineWrap(true);
        for (PropertyChangeListener l : listeners = this.textArea.getPropertyChangeListeners()) {
            if (!l.getClass().getSimpleName().contains("AquaCaret")) continue;
            this.textArea.removePropertyChangeListener(l);
        }
        this.textArea.setVisible(true);
        this.textArea.getCaret().setSelectionVisible(true);
        this.genericHeader = new GenericHeader(){

            public Dimension getPreferredSize() {
                Dimension preferredSize = super.getPreferredSize();
                int width = DockingVisualVertex.this.textArea.getPreferredSize().width;
                int preferredWidth = MathUtilities.clamp((int)width, (int)width, (int)DockingVisualVertex.this.maxWidth);
                if (preferredWidth <= 0) {
                    return preferredSize;
                }
                int toolBarWidth = this.getToolBarWidth();
                int minimumGrabArea = 60;
                int minimumWidth = minimumGrabArea + toolBarWidth;
                preferredSize.width = MathUtilities.clamp((int)preferredWidth, (int)minimumWidth, (int)DockingVisualVertex.this.maxWidth);
                return preferredSize;
            }
        };
        this.genericHeader.setComponent((Component)this.textArea);
        this.genericHeader.setTitle(name);
        this.genericHeader.setNoWrapToolbar(true);
        this.mainPanel.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (!DockingVisualVertex.this.textArea.isEditable()) {
                    return;
                }
                KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                kfm.redispatchEvent(DockingVisualVertex.this.textArea, e);
                e.consume();
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (!DockingVisualVertex.this.textArea.isEditable()) {
                    return;
                }
                KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                kfm.redispatchEvent(DockingVisualVertex.this.textArea, e);
                e.consume();
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (!DockingVisualVertex.this.textArea.isEditable()) {
                    return;
                }
                KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                kfm.redispatchEvent(DockingVisualVertex.this.textArea, e);
                e.consume();
            }
        });
        this.mainPanel.add((Component)this.genericHeader, "North");
        this.mainPanel.add((Component)this.textArea, "Center");
    }

    @Override
    public boolean isGrabbable(Component c) {
        return c != this.textArea;
    }

    @Override
    public JComponent getComponent() {
        return this.mainPanel;
    }

    public JTextArea getTextArea() {
        return this.textArea;
    }

    public String getText() {
        return this.textArea.getText();
    }

    public String getName() {
        return this.name;
    }

    public void setMaxWidth(int width) {
        this.maxWidth = width;
    }

    @Override
    public void setFocused(boolean focused) {
        super.setFocused(focused);
        this.textArea.getCaret().setVisible(focused);
    }

    @Override
    public void setSelected(boolean selected) {
        super.setSelected(selected);
        this.genericHeader.setSelected(selected);
    }

    @Override
    public void dispose() {
        this.genericHeader.dispose();
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DockingVisualVertex other = (DockingVisualVertex)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

