/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer;

import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.control.ScalingControl;
import ghidra.graph.VisualGraph;
import ghidra.graph.viewer.GraphComponent;
import ghidra.graph.viewer.GraphPerspectiveInfo;
import ghidra.graph.viewer.GraphSatelliteListener;
import ghidra.graph.viewer.GraphViewer;
import ghidra.graph.viewer.GraphViewerUtils;
import ghidra.graph.viewer.PathHighlightMode;
import ghidra.graph.viewer.SatelliteGraphViewer;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualGraphScalingControl;
import ghidra.graph.viewer.VisualGraphViewUpdater;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.event.mouse.VertexTooltipProvider;
import ghidra.graph.viewer.layout.LayoutProvider;
import ghidra.graph.viewer.options.VisualGraphOptions;
import ghidra.graph.viewer.vertex.VertexClickListener;
import ghidra.graph.viewer.vertex.VertexFocusListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class VisualGraphView<V extends VisualVertex, E extends VisualEdge<V>, G extends VisualGraph<V, E>> {
    private static final float ZOOM_OUT_AMOUNT = 0.9f;
    private static final float ZOOM_IN_AMOUNT = 1.1f;
    private JPanel viewPanel;
    private JPanel viewContentPanel;
    private JPanel undockedSatelliteContentPanel;
    private G graph;
    protected GraphComponent<V, E, G> graphComponent;
    private Optional<VertexFocusListener<V>> clientFocusListener = Optional.empty();
    private VertexFocusListener<V> internalFocusListener = v -> this.clientFocusListener.ifPresent(l -> l.vertexFocused(v));
    private Optional<VertexClickListener<V, E>> clientVertexClickListener = Optional.empty();
    private VertexClickListener<V, E> internalVertexClickListener = (v, info) -> {
        AtomicBoolean result = new AtomicBoolean();
        this.clientVertexClickListener.ifPresent(l -> result.set(l.vertexDoubleClicked(v, info)));
        return result.get();
    };
    private Optional<GraphSatelliteListener> clientSatelliteListener = Optional.empty();
    private GraphSatelliteListener internalSatelliteListener = (docked, visible) -> {
        this.showSatellite = visible;
        this.satelliteDocked = docked;
        this.clientSatelliteListener.ifPresent(l -> l.satelliteVisibilityChanged(docked, visible));
    };
    private boolean satelliteDocked = true;
    private boolean showSatellite = true;
    private boolean showPopups = true;
    private VertexTooltipProvider<V, E> tooltipProvider;
    private GraphPerspectiveInfo<V, E> graphInfo;
    private PathHighlightMode vertexHoverHighlightMode = PathHighlightMode.OFF;
    private PathHighlightMode vertexFocusHighlightMode = PathHighlightMode.OFF;
    protected LayoutProvider<V, E, G> layoutProvider;
    private final ScalingControl scaler = new VisualGraphScalingControl();

    public VisualGraphView() {
        this.build();
    }

    private void build() {
        this.viewPanel = new JPanel(new BorderLayout()){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(1000, 1000);
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.viewContentPanel = new JPanel(new BorderLayout());
        this.viewPanel.add(this.viewContentPanel);
        this.undockedSatelliteContentPanel = new JPanel(new BorderLayout());
    }

    public JComponent getViewComponent() {
        return this.viewPanel;
    }

    protected void setSouthComponent(JComponent component) {
        this.viewPanel.add((Component)component, "South");
    }

    protected void removeSatellite() {
        this.undockedSatelliteContentPanel.removeAll();
        this.undockedSatelliteContentPanel.validate();
    }

    public void setLayoutProvider(LayoutProvider<V, E, G> newLayoutProvider) {
        this.layoutProvider = newLayoutProvider;
    }

    public void setGraph(G graph) {
        this.stopAllAnimation();
        this.graph = graph;
        this.installGraphViewer();
    }

    public void setSatelliteListener(GraphSatelliteListener l) {
        this.clientSatelliteListener = Optional.ofNullable(l);
    }

    public void setVertexFocusListener(VertexFocusListener<V> l) {
        this.clientFocusListener = Optional.ofNullable(l);
    }

    public void setVertexClickListener(VertexClickListener<V, E> l) {
        this.clientVertexClickListener = Optional.ofNullable(l);
    }

    private void stopAllAnimation() {
        VisualGraphViewUpdater<V, E> updater = this.getViewUpdater();
        if (updater != null) {
            updater.stopAllAnimation();
        }
    }

    protected void installGraphViewer() {
        GraphComponent newGraphComponent = new GraphComponent(this.graph);
        newGraphComponent.setGraphOptions(new VisualGraphOptions());
        this.setGraphComponent(newGraphComponent);
    }

    protected void setGraphComponent(GraphComponent<V, E, G> newComponent) {
        this.disposeViewer();
        this.graphComponent = newComponent;
        this.graphComponent.setPopupsVisible(this.showPopups);
        if (this.graphInfo != null) {
            this.graphComponent.setGraphPerspective(this.graphInfo);
            this.graphInfo = null;
        }
        this.graphComponent.setVertexHoverPathHighlightMode(this.vertexHoverHighlightMode);
        this.graphComponent.setVertexFocusPathHighlightMode(this.vertexFocusHighlightMode);
        GraphViewer<V, E> viewer = this.graphComponent.getPrimaryViewer();
        if (this.tooltipProvider != null) {
            viewer.setVertexTooltipProvider(this.tooltipProvider);
        }
        JComponent component = this.graphComponent.getComponent();
        Rectangle viewPanelBounds = this.viewContentPanel.getBounds();
        component.setBounds(viewPanelBounds);
        component.doLayout();
        this.viewContentPanel.removeAll();
        this.viewContentPanel.add(component);
        this.viewContentPanel.validate();
        this.undockedSatelliteContentPanel.removeAll();
        this.graphComponent.setVertexFocusListener(this.internalFocusListener);
        this.graphComponent.setVertexClickListener(this.internalVertexClickListener);
        this.graphComponent.setSatelliteLisetener(this.internalSatelliteListener);
        this.graphComponent.setInitialSatelliteState(this.showSatellite, this.satelliteDocked);
        if (!this.satelliteDocked) {
            this.undockedSatelliteContentPanel.add(this.graphComponent.getSatelliteContentComponent());
            this.undockedSatelliteContentPanel.validate();
        }
    }

    protected void setContent(Component c) {
        this.viewContentPanel.removeAll();
        this.viewContentPanel.add(c);
        this.viewPanel.validate();
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T getWithBusyCursor(Supplier<T> s) {
        Cursor originalCursor = this.viewPanel.getCursor();
        try {
            T t;
            this.viewPanel.setCursor(Cursor.getPredefinedCursor(3));
            T t2 = t = s.get();
            return t2;
        }
        finally {
            this.viewPanel.setCursor(originalCursor);
        }
    }

    public G getVisualGraph() {
        return this.graph;
    }

    public GraphViewer<V, E> getPrimaryGraphViewer() {
        if (this.graphComponent == null) {
            return null;
        }
        return this.graphComponent.getPrimaryViewer();
    }

    public SatelliteGraphViewer<V, E> getSatelliteViewer() {
        return this.graphComponent.getSatelliteViewer();
    }

    public void setGraphPerspective(GraphPerspectiveInfo<V, E> newPerspective) {
        if (this.graphComponent != null) {
            this.graphComponent.setGraphPerspective(newPerspective);
            this.graphInfo = null;
        } else {
            this.graphInfo = newPerspective;
        }
    }

    public GraphPerspectiveInfo<V, E> generateGraphPerspective() {
        RenderContext<V, E> context = this.graphComponent.getRenderContext();
        return new GraphPerspectiveInfo<V, E>(context, this.getZoom());
    }

    private double getZoom() {
        if (this.graphComponent == null) {
            if (this.graphInfo != null) {
                return this.graphInfo.getZoom();
            }
            return 1.0;
        }
        return GraphViewerUtils.getGraphScale(this.getPrimaryGraphViewer());
    }

    public void showErrorView(String errorMessage) {
        this.stopAllAnimation();
        this.graph = null;
        this.removeSatellite();
        this.viewContentPanel.removeAll();
        this.viewContentPanel.paintImmediately(this.viewContentPanel.getBounds());
        JLabel messageLabel = new JLabel(errorMessage);
        Font font = messageLabel.getFont();
        messageLabel.setFont(font.deriveFont(22.0f));
        messageLabel.setHorizontalAlignment(0);
        messageLabel.setFocusable(true);
        this.viewContentPanel.add((Component)messageLabel, "North");
        this.viewContentPanel.validate();
        this.disposeViewer();
    }

    public void setStatusMessage(String message) {
        if (this.graphComponent != null) {
            this.graphComponent.setStatusMessage(message);
        }
    }

    public GraphComponent<V, E, G> getGraphComponent() {
        return this.graphComponent;
    }

    public boolean isSatelliteVisible() {
        return this.showSatellite;
    }

    public void setSatelliteVisible(boolean visible) {
        if (this.showSatellite == visible) {
            return;
        }
        this.showSatellite = visible;
        if (this.graphComponent != null) {
            this.graphComponent.setSatelliteVisible(visible);
        }
    }

    public void setSatelliteDocked(boolean docked) {
        if (this.satelliteDocked == docked) {
            return;
        }
        this.satelliteDocked = docked;
        if (this.graphComponent == null) {
            return;
        }
        this.graphComponent.setSatelliteDocked(docked);
        if (!docked) {
            this.undockedSatelliteContentPanel.removeAll();
            this.undockedSatelliteContentPanel.add(this.graphComponent.getSatelliteContentComponent());
            this.undockedSatelliteContentPanel.validate();
        }
    }

    public boolean isSatelliteDocked() {
        return this.satelliteDocked;
    }

    public void setPopupsVisible(boolean visible) {
        this.showPopups = visible;
        if (this.graphComponent != null) {
            this.graphComponent.setPopupsVisible(visible);
        }
    }

    public boolean arePopupsEnabled() {
        return this.showPopups;
    }

    public JComponent getUndockedSatelliteComponent() {
        return this.undockedSatelliteContentPanel;
    }

    public boolean isSatelliteComponent(Component c) {
        if (this.graphComponent != null) {
            return this.graphComponent.isSatelliteComponent(c);
        }
        return false;
    }

    public void setVertexHoverPathHighlightMode(PathHighlightMode mode) {
        this.vertexHoverHighlightMode = mode;
        if (this.graphComponent != null) {
            this.graphComponent.setVertexHoverPathHighlightMode(mode);
        }
    }

    public void setVertexFocusPathHighlightMode(PathHighlightMode mode) {
        this.vertexFocusHighlightMode = mode;
        if (this.graphComponent != null) {
            this.graphComponent.setVertexFocusPathHighlightMode(mode);
        }
    }

    public PathHighlightMode getVertexFocusPathHighlightMode() {
        return this.vertexFocusHighlightMode;
    }

    public PathHighlightMode getVertexHoverPathHighlightMode() {
        return this.vertexHoverHighlightMode;
    }

    public void setTooltipProvider(VertexTooltipProvider<V, E> provider) {
        this.tooltipProvider = provider;
        if (this.graphComponent != null) {
            GraphViewer<V, E> viewer = this.graphComponent.getPrimaryViewer();
            viewer.setVertexTooltipProvider(provider);
        }
    }

    public void zoomOutGraph() {
        GraphViewer<V, E> primaryViewer = this.getPrimaryGraphViewer();
        this.scaler.scale(primaryViewer, 0.9f, primaryViewer.getCenter());
    }

    public void zoomInGraph() {
        GraphViewer<V, E> primaryViewer = this.getPrimaryGraphViewer();
        this.scaler.scale(primaryViewer, 1.1f, primaryViewer.getCenter());
    }

    public void zoomToVertex(V v) {
        VisualGraphViewUpdater<V, E> updater = this.getViewUpdater();
        updater.zoomInCompletely(v);
    }

    public void zoomToWindow() {
        VisualGraphViewUpdater<V, E> updater = this.getViewUpdater();
        updater.fitGraphToViewerNow();
    }

    public VisualGraphViewUpdater<V, E> getViewUpdater() {
        if (this.graphComponent == null) {
            return null;
        }
        GraphViewer<V, E> viewer = this.getPrimaryGraphViewer();
        VisualGraphViewUpdater<V, E> updater = viewer.getViewUpdater();
        return updater;
    }

    public Point getVertexPointInViewSpace(V v) {
        return GraphViewerUtils.getPointInViewSpaceForVertex(this.getPrimaryGraphViewer(), v);
    }

    public Point translatePointFromVertexToViewSpace(V v, Point p) {
        return GraphViewerUtils.translatePointFromVertexRelativeSpaceToViewSpace(this.getPrimaryGraphViewer(), v, p);
    }

    public Rectangle translateRectangleFromVertexToViewSpace(V v, Rectangle r) {
        return GraphViewerUtils.translateRectangleFromVertexRelativeSpaceToViewSpace(this.getPrimaryGraphViewer(), v, r);
    }

    public MouseEvent translateMouseEventFromVertexToViewSpace(V v, MouseEvent e) {
        Point viewerPoint = this.translatePointFromVertexToViewSpace(v, e.getPoint());
        GraphViewer<V, E> newSource = this.getPrimaryGraphViewer();
        return new MouseEvent((Component)((Object)newSource), e.getID(), e.getWhen(), e.getModifiers(), (int)viewerPoint.getX(), (int)viewerPoint.getY(), e.getClickCount(), e.isPopupTrigger(), e.getButton());
    }

    public boolean isScaledPastInteractionThreshold() {
        if (this.graphComponent == null) {
            return true;
        }
        return GraphViewerUtils.isScaledPastVertexInteractionThreshold(this.getPrimaryGraphViewer());
    }

    protected void maybeTwinkleVertex(V twinkleVertex, boolean doTwinkle) {
        if (!doTwinkle) {
            return;
        }
        this.graphComponent.twinkleVertex(twinkleVertex);
    }

    public void requestFocus() {
        this.viewPanel.requestFocus();
    }

    public void repaint() {
        this.viewPanel.repaint();
    }

    public V getFocusedVertex() {
        if (this.graph == null) {
            return null;
        }
        return this.graph.getFocusedVertex();
    }

    public Set<V> getSelectedVertices() {
        if (this.graph == null) {
            return Collections.emptySet();
        }
        return this.graph.getSelectedVertices();
    }

    public LayoutProvider<V, E, G> getLayoutProvider() {
        return this.layoutProvider;
    }

    public void cleanup() {
        this.disposeViewer();
    }

    protected void disposeViewer() {
        if (this.graphComponent != null) {
            this.graphComponent.dispose();
            this.graphComponent = null;
        }
        this.removeSatellite();
    }
}

