/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.widgets.OptionDialog;
import ghidra.app.decompiler.ClangFuncNameToken;
import ghidra.app.decompiler.ClangFunction;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.component.DecompilerController;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.function.EditFunctionSignatureDialog;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.GenericCallingConvention;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionSignature;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighFunctionDBUtil;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.PcodeOpAST;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.Msg;
import ghidra.util.UndefinedFunction;
import java.awt.Component;
import java.util.Iterator;

public class OverridePrototypeAction
extends DockingAction {
    private final DecompilerController controller;
    private final PluginTool tool;

    public OverridePrototypeAction(String owner, PluginTool tool, DecompilerController controller) {
        super("Override Signature", owner);
        this.tool = tool;
        this.controller = controller;
        this.setPopupMenuData(new MenuData(new String[]{"Override Signature"}, "Decompile"));
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context instanceof DecompilerActionContext)) {
            return false;
        }
        Function function = this.controller.getFunction();
        if (function == null || function instanceof UndefinedFunction) {
            return false;
        }
        DecompilerActionContext decompilerActionContext = (DecompilerActionContext)context;
        if (decompilerActionContext.isDecompiling()) {
            return true;
        }
        return OverridePrototypeAction.getCallOp(this.controller) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionContext context) {
        DecompilerActionContext decompilerActionContext = (DecompilerActionContext)context;
        if (decompilerActionContext.isDecompiling()) {
            Msg.showInfo(((Object)((Object)this)).getClass(), (Component)context.getComponentProvider().getComponent(), (String)"Decompiler Action Blocked", (Object)"You cannot perform Decompiler actions while the Decompiler is busy");
            return;
        }
        Function func = this.controller.getFunction();
        Program program = func.getProgram();
        PcodeOp op = OverridePrototypeAction.getCallOp(this.controller);
        Function calledfunc = this.getCalledFunction(op);
        boolean varargs = false;
        if (calledfunc != null) {
            varargs = calledfunc.hasVarArgs();
        }
        if (op.getOpcode() == 7 && !varargs && OptionDialog.showOptionDialog((Component)this.controller.getDecompilerPanel(), (String)"Warning : Localized Override", (String)"Incorrect information entered here may hide other good information.\nFor direct calls, it is usually better to alter the prototype on the function\nitself, rather than overriding the local call. Proceed anyway?", (String)"Proceed") != 1) {
            return;
        }
        Address addr = op.getSeqnum().getTarget();
        String name = "func";
        String conv = program.getCompilerSpec().getDefaultCallingConvention().getName();
        if (calledfunc != null) {
            name = calledfunc.getName();
            conv = calledfunc.getCallingConventionName();
        }
        String signature = this.generateSignature(op, name);
        ProtoOverrideDialog dialog = new ProtoOverrideDialog(this.tool, func, signature, conv);
        this.tool.showDialog((DialogComponentProvider)dialog);
        FunctionDefinition fdef = dialog.getFunctionDefinition();
        if (fdef == null) {
            return;
        }
        int transaction = program.startTransaction("Override Signature");
        boolean commit = false;
        try {
            HighFunctionDBUtil.writeOverride((Function)func, (Address)addr, (FunctionSignature)fdef);
            commit = true;
        }
        catch (Exception e) {
            Msg.showError(((Object)((Object)this)).getClass(), (Component)this.controller.getDecompilerPanel(), (String)"Override Signature Failed", (Object)("Error overriding signature: " + e));
        }
        finally {
            program.endTransaction(transaction, commit);
        }
    }

    public static PcodeOp getCallOp(DecompilerController controller) {
        DecompilerPanel decompilerPanel = controller.getDecompilerPanel();
        ClangToken tokenAtCursor = decompilerPanel.getTokenAtCursor();
        if (tokenAtCursor == null) {
            return null;
        }
        if (tokenAtCursor instanceof ClangFuncNameToken) {
            return ((ClangFuncNameToken)tokenAtCursor).getPcodeOp();
        }
        Address addr = tokenAtCursor.getMinAddress();
        if (addr == null) {
            return null;
        }
        Instruction instr = controller.getProgram().getListing().getInstructionAt(addr);
        if (instr == null) {
            return null;
        }
        if (!instr.getFlowType().isCall()) {
            return null;
        }
        ClangFunction cfunc = tokenAtCursor.getClangFunction();
        if (cfunc == null) {
            return null;
        }
        HighFunction hfunc = cfunc.getHighFunction();
        Iterator iter = hfunc.getPcodeOps(addr);
        while (iter.hasNext()) {
            PcodeOpAST op = (PcodeOpAST)iter.next();
            if (op.getOpcode() != 7 && op.getOpcode() != 8) continue;
            return op;
        }
        return null;
    }

    private Function getCalledFunction(PcodeOp op) {
        if (op.getOpcode() != 7) {
            return null;
        }
        Address addr = op.getInput(0).getAddress();
        Program program = this.controller.getProgram();
        return program.getFunctionManager().getFunctionAt(addr);
    }

    private String generateSignature(PcodeOp op, String name) {
        StringBuffer buf = new StringBuffer();
        Varnode vn = op.getOutput();
        DataType dt = null;
        if (vn != null) {
            dt = vn.getHigh().getDataType();
        }
        if (dt != null) {
            buf.append(dt.getDisplayName());
        } else {
            buf.append(DataType.VOID.getDisplayName());
        }
        buf.append(' ').append(name).append('(');
        for (int i = 1; i < op.getNumInputs(); ++i) {
            vn = op.getInput(i);
            dt = null;
            if (vn != null) {
                dt = vn.getHigh().getDataType();
            }
            if (dt != null) {
                buf.append(dt.getDisplayName());
            } else {
                buf.append("BAD");
            }
            if (i == op.getNumInputs() - 1) continue;
            buf.append(',');
        }
        buf.append(')');
        return buf.toString();
    }

    public class ProtoOverrideDialog
    extends EditFunctionSignatureDialog {
        private FunctionDefinition functionDefinition;

        public FunctionDefinition getFunctionDefinition() {
            return this.functionDefinition;
        }

        public ProtoOverrideDialog(PluginTool tool, Function func, String signature, String conv) {
            super(tool, "Override Signature", func);
            this.setSignature(signature);
            this.setCallingConvention(conv);
            this.functionDefinition = null;
        }

        protected void okCallback() {
            if (this.testResult()) {
                this.close();
            }
        }

        protected boolean testResult() {
            this.functionDefinition = this.parseSignature();
            if (this.functionDefinition == null) {
                return false;
            }
            GenericCallingConvention convention = GenericCallingConvention.guessFromName((String)this.getCallingConvention());
            this.functionDefinition.setGenericCallingConvention(convention);
            return true;
        }
    }
}

