/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.ToolBarData;
import docking.widgets.OptionDialog;
import docking.widgets.filechooser.GhidraFileChooser;
import ghidra.app.decompiler.ClangTokenGroup;
import ghidra.app.decompiler.DecompiledFunction;
import ghidra.app.decompiler.PrettyPrinter;
import ghidra.app.decompiler.component.DecompilerController;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.framework.preferences.Preferences;
import ghidra.util.Msg;
import ghidra.util.filechooser.ExtensionFileFilter;
import ghidra.util.filechooser.GhidraFileFilter;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.ResourceManager;

public class ExportToCAction
extends DockingAction {
    private static final ImageIcon EXPORT_ICON = ResourceManager.loadImage((String)"images/page_edit.png");
    private static final String LAST_USED_C_FILE = "last.used.decompiler.c.export.file";
    private final DecompilerController controller;

    public ExportToCAction(String owner, DecompilerController controller) {
        super("Export to C", owner);
        this.controller = controller;
        this.setToolBarData(new ToolBarData((Icon)EXPORT_ICON, "Local"));
        this.setDescription("Export the current function to C");
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context instanceof DecompilerActionContext)) {
            return false;
        }
        DecompilerActionContext decompilerActionContext = (DecompilerActionContext)context;
        if (decompilerActionContext.isDecompiling()) {
            return true;
        }
        return this.controller.getFunction() != null && this.controller.getCCodeModel() != null;
    }

    private File readLastUsedFile() {
        String filename = Preferences.getProperty((String)LAST_USED_C_FILE);
        if (filename == null) {
            return null;
        }
        return new File(filename);
    }

    private void saveLastUsedFileFile(File file) {
        Preferences.setProperty((String)LAST_USED_C_FILE, (String)file.getAbsolutePath());
        Preferences.store();
    }

    public void actionPerformed(ActionContext context) {
        File file;
        DecompilerActionContext decompilerActionContext = (DecompilerActionContext)context;
        if (decompilerActionContext.isDecompiling()) {
            Msg.showInfo(((Object)((Object)this)).getClass(), (Component)context.getComponentProvider().getComponent(), (String)"Decompiler Action Blocked", (Object)"You cannot perform Decompiler actions while the Decompiler is busy");
            return;
        }
        File lastUsedFile = this.readLastUsedFile();
        String[] extensions = new String[]{"h", "c", "cpp"};
        GhidraFileChooser fileChooser = new GhidraFileChooser((Component)this.controller.getDecompilerPanel());
        fileChooser.setFileFilter((GhidraFileFilter)new ExtensionFileFilter(extensions, "C/C++ Files"));
        if (lastUsedFile != null) {
            fileChooser.setSelectedFile(lastUsedFile);
        }
        if ((file = fileChooser.getSelectedFile()) == null) {
            return;
        }
        this.saveLastUsedFileFile(file);
        boolean hasExtension = false;
        String path = file.getAbsolutePath();
        for (String element : extensions) {
            if (!path.toLowerCase().endsWith("." + element)) continue;
            hasExtension = true;
        }
        if (!hasExtension) {
            file = new File(path + ".c");
        }
        if (file.exists() && OptionDialog.showYesNoDialog((Component)this.controller.getDecompilerPanel(), (String)"Overwrite Existing File?", (String)"Do you want to overwrite the existing file?") == 2) {
            return;
        }
        try {
            PrintWriter writer = new PrintWriter(new FileOutputStream(file));
            ClangTokenGroup grp = this.controller.getCCodeModel();
            PrettyPrinter printer = new PrettyPrinter(this.controller.getFunction(), grp);
            DecompiledFunction decompFunc = printer.print(true);
            writer.write(decompFunc.getC());
            writer.close();
            this.controller.setStatusMessage("Successfully exported function(s) to " + file.getAbsolutePath());
        }
        catch (IOException e) {
            Msg.showError(((Object)((Object)this)).getClass(), (Component)this.controller.getDecompilerPanel(), (String)"Export to C Failed", (Object)("Error exporting to C: " + e));
        }
    }
}

