/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler.component;

import docking.widgets.fieldpanel.support.ViewerPosition;
import ghidra.app.decompiler.DecompileException;
import ghidra.app.decompiler.DecompileOptions;
import ghidra.app.decompiler.DecompileResults;
import ghidra.app.decompiler.component.DecompileData;
import ghidra.app.decompiler.component.DecompileRunnable;
import ghidra.app.decompiler.component.Decompiler;
import ghidra.app.decompiler.component.DecompilerController;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.task.MonitoredRunnable;
import ghidra.util.task.RunManager;
import ghidra.util.task.SwingUpdateManager;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import javax.swing.JComponent;

public class DecompilerManager {
    private DecompilerController decompilerController;
    private Decompiler decompiler;
    private DecompileRunnable currentDecompileRunnable;
    private DecompileRunnable pendingDecompileRunnable;
    private RunManager runManager;
    private SwingUpdateManager updateManager;

    public DecompilerManager(DecompilerController decompilerController, DecompileOptions options) {
        this.decompilerController = decompilerController;
        this.runManager = new RunManager("Decompiler", null);
        this.decompiler = new Decompiler(options, 0);
        this.updateManager = new SwingUpdateManager(500, () -> this.doPendingDecompile());
    }

    void setOptions(DecompileOptions decompilerOptions) {
        this.decompiler.setOptions(decompilerOptions);
    }

    JComponent getTaskMonitorComponent() {
        return this.runManager.getMonitorComponent();
    }

    synchronized void decompile(Program program, ProgramLocation location, ViewerPosition viewerPosition, File debugFile, boolean forceDecompile) {
        DecompileRunnable newDecompileRunnable = new DecompileRunnable(program, location, debugFile, viewerPosition, this);
        if (forceDecompile) {
            this.cancelAll();
            this.setPendingRunnable(newDecompileRunnable);
            return;
        }
        if (this.updateCurrentRunnable(newDecompileRunnable)) {
            return;
        }
        this.setPendingRunnable(newDecompileRunnable);
    }

    private synchronized void setPendingRunnable(DecompileRunnable newDecompileRunnable) {
        this.pendingDecompileRunnable = newDecompileRunnable;
        this.updateManager.update();
    }

    private synchronized boolean updateCurrentRunnable(DecompileRunnable newDecompileRunnable) {
        if (this.pendingDecompileRunnable != null) {
            return false;
        }
        if (this.currentDecompileRunnable == null) {
            return false;
        }
        return this.currentDecompileRunnable.update(newDecompileRunnable);
    }

    public synchronized boolean isBusy() {
        return this.currentDecompileRunnable != null || this.pendingDecompileRunnable != null;
    }

    public synchronized void cancelAll() {
        this.cancelCurrentRunnable();
        this.pendingDecompileRunnable = null;
    }

    private synchronized void cancelCurrentRunnable() {
        if (this.currentDecompileRunnable != null) {
            this.runManager.cancelAllRunnables();
            this.decompiler.cancelCurrentAction();
            this.currentDecompileRunnable = null;
        }
    }

    public void dispose() {
        this.updateManager.dispose();
        this.runManager.dispose();
        this.cancelAll();
        this.decompiler.dispose();
    }

    private synchronized void doPendingDecompile() {
        if (this.pendingDecompileRunnable == null) {
            return;
        }
        this.cancelCurrentRunnable();
        this.currentDecompileRunnable = this.pendingDecompileRunnable;
        this.pendingDecompileRunnable = null;
        this.decompilerController.decompilerStatusChanged();
        this.runManager.runNow((MonitoredRunnable)this.currentDecompileRunnable, "Decompiler", 500);
    }

    DecompileResults decompile(Program program, Function functionToDecompile, File debugFile, TaskMonitor monitor) throws DecompileException {
        return this.decompiler.decompile(program, functionToDecompile, debugFile, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDecompileData(DecompileRunnable runnable, DecompileData decompileData) {
        if (this.decompilerController == null) {
            return;
        }
        DecompilerManager decompilerManager = this;
        synchronized (decompilerManager) {
            if (this.currentDecompileRunnable != runnable) {
                return;
            }
            this.currentDecompileRunnable = null;
        }
        this.decompilerController.setDecompileData(decompileData);
    }
}

