/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.types.resff;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.catacombae.csjc.PrintableStruct;
import org.catacombae.hfsexplorer.Util;
import org.catacombae.hfsexplorer.io.SynchronizedReadableRandomAccess;
import org.catacombae.hfsexplorer.types.resff.ReferenceListEntry;
import org.catacombae.hfsexplorer.types.resff.ResourceName;
import org.catacombae.hfsexplorer.types.resff.ResourceType;
import org.catacombae.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceMap
implements PrintableStruct {
    public static final int STRUCTSIZE = 46;
    private final byte[] reserved1 = new byte[16];
    private final byte[] reserved2 = new byte[4];
    private final byte[] reserved3 = new byte[2];
    private final byte[] resourceForkAttributes = new byte[2];
    private final byte[] typeListOffset = new byte[2];
    private final byte[] nameListOffset = new byte[2];
    private final byte[] typeCount = new byte[2];
    private final ResourceType[] resourceTypeList;
    private final List<Util.Pair<ResourceType, ReferenceListEntry[]>> referenceList;
    private final List<Util.Pair<ReferenceListEntry, ResourceName>> resourceNameList;

    public ResourceMap(SynchronizedReadableRandomAccess stream, long offset) {
        byte[] data = new byte[30];
        stream.readFullyFrom(offset, data);
        System.arraycopy(data, 0, this.reserved1, 0, 16);
        System.arraycopy(data, 16, this.reserved2, 0, 4);
        System.arraycopy(data, 20, this.reserved3, 0, 2);
        System.arraycopy(data, 22, this.resourceForkAttributes, 0, 2);
        System.arraycopy(data, 24, this.typeListOffset, 0, 2);
        System.arraycopy(data, 26, this.nameListOffset, 0, 2);
        System.arraycopy(data, 28, this.typeCount, 0, 2);
        long resourceTypeListOffset = Util.unsign((short)this.getTypeListOffset());
        long resourceNameListOffset = Util.unsign((short)this.getNameListOffset());
        long curOffset = offset + resourceTypeListOffset + 2L;
        byte[] curResTypeData = new byte[ResourceType.length()];
        this.resourceTypeList = new ResourceType[this.getTypeCount() + 1];
        for (int i = 0; i < this.resourceTypeList.length; ++i) {
            stream.readFullyFrom(curOffset, curResTypeData);
            this.resourceTypeList[i] = new ResourceType(curResTypeData, 0);
            curOffset += (long)curResTypeData.length;
        }
        int numberOfRefListEntries = 0;
        byte[] curListEntryData = new byte[ReferenceListEntry.length()];
        this.referenceList = new ArrayList<Util.Pair<ResourceType, ReferenceListEntry[]>>(this.resourceTypeList.length);
        for (int i = 0; i < this.resourceTypeList.length; ++i) {
            ResourceType curType = this.resourceTypeList[i];
            ReferenceListEntry[] curList = new ReferenceListEntry[curType.getInstanceCount() + 1];
            long curOffset2 = offset + resourceTypeListOffset + (long)Util.unsign((short)curType.getReferenceListOffset());
            for (int j = 0; j < curList.length; ++j) {
                stream.readFullyFrom(curOffset2, curListEntryData);
                curList[j] = new ReferenceListEntry(curListEntryData, 0);
                curOffset2 += (long)curListEntryData.length;
            }
            numberOfRefListEntries += curList.length;
            this.referenceList.add((Util.Pair<ResourceType, ReferenceListEntry[]>)new Util.Pair((Object)curType, (Object)curList));
        }
        this.resourceNameList = new ArrayList<Util.Pair<ReferenceListEntry, ResourceName>>(numberOfRefListEntries);
        for (Util.Pair<ResourceType, ReferenceListEntry[]> p : this.referenceList) {
            for (ReferenceListEntry e : (ReferenceListEntry[])p.getB()) {
                long resNameOffset = e.getResourceNameOffset();
                if (resNameOffset == -1L) continue;
                long nameOffset = offset + resourceNameListOffset + resNameOffset;
                ResourceName resName = new ResourceName(stream, nameOffset);
                this.resourceNameList.add((Util.Pair<ReferenceListEntry, ResourceName>)new Util.Pair((Object)e, (Object)resName));
            }
        }
    }

    public static int length() {
        return 46;
    }

    public int maxSize() {
        return 30 + ResourceType.length() * 65536;
    }

    public int occupiedSize() {
        return 30 + this.resourceTypeList.length * ResourceType.length();
    }

    public byte[] getReserved1() {
        return Util.readByteArrayBE((byte[])this.reserved1);
    }

    public int getReserved2() {
        return Util.readIntBE((byte[])this.reserved2);
    }

    public short getReserved3() {
        return Util.readShortBE((byte[])this.reserved3);
    }

    public short getResourceForkAttributes() {
        return Util.readShortBE((byte[])this.resourceForkAttributes);
    }

    public short getTypeListOffset() {
        return Util.readShortBE((byte[])this.typeListOffset);
    }

    public short getNameListOffset() {
        return Util.readShortBE((byte[])this.nameListOffset);
    }

    public short getTypeCount() {
        return Util.readShortBE((byte[])this.typeCount);
    }

    public ResourceType[] getResourceTypeList() {
        return (ResourceType[])Util.arrayCopy((Object[])this.resourceTypeList, (Object[])new ResourceType[this.resourceTypeList.length]);
    }

    public List<Util.Pair<ResourceType, ReferenceListEntry[]>> getReferenceList() {
        return new ArrayList<Util.Pair<ResourceType, ReferenceListEntry[]>>(this.referenceList);
    }

    public List<Util.Pair<ReferenceListEntry, ResourceName>> getResourceNameList() {
        return new ArrayList<Util.Pair<ReferenceListEntry, ResourceName>>(this.resourceNameList);
    }

    public ReferenceListEntry[] getReferencesByType(ResourceType resType) {
        for (Util.Pair<ResourceType, ReferenceListEntry[]> entry : this.referenceList) {
            if (entry.getA() != resType) continue;
            return (ReferenceListEntry[])Util.arrayCopy((Object[])((Object[])entry.getB()), (Object[])new ReferenceListEntry[((ReferenceListEntry[])entry.getB()).length]);
        }
        return null;
    }

    public ResourceName getNameByReferenceListEntry(ReferenceListEntry entry) {
        for (Util.Pair<ReferenceListEntry, ResourceName> listEntry : this.resourceNameList) {
            if (listEntry.getA() != entry) continue;
            return (ResourceName)listEntry.getB();
        }
        return null;
    }

    @Override
    public void printFields(PrintStream ps, String prefix) {
        int i;
        ps.println(prefix + " reserved1: " + this.getReserved1());
        ps.println(prefix + " reserved2: " + this.getReserved2());
        ps.println(prefix + " reserved3: " + this.getReserved3());
        ps.println(prefix + " resourceForkAttributes: " + this.getResourceForkAttributes());
        ps.println(prefix + " typeListOffset: " + this.getTypeListOffset());
        ps.println(prefix + " nameListOffset: " + this.getNameListOffset());
        ps.println(prefix + " typeCount: " + this.getTypeCount());
        ps.println(prefix + " resourceTypeList: ");
        for (i = 0; i < this.resourceTypeList.length; ++i) {
            ps.println(prefix + "  [" + i + "]:");
            this.resourceTypeList[i].print(ps, prefix + "   ");
        }
        ps.println(prefix + " referenceList: ");
        i = 0;
        for (Util.Pair<ResourceType, ReferenceListEntry[]> pair : this.referenceList) {
            for (ReferenceListEntry refListEntry : (ReferenceListEntry[])pair.getB()) {
                ps.println(prefix + "  [" + i++ + "]:");
                refListEntry.print(ps, prefix + "   ");
            }
        }
        ps.println(prefix + " resourceNameList: ");
        i = 0;
        for (Util.Pair pair : this.resourceNameList) {
            ps.println(prefix + "  [" + i++ + "]:");
            ((ResourceName)pair.getB()).print(ps, prefix + "   ");
        }
    }

    @Override
    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "ResourceMap:");
        this.printFields(ps, prefix);
    }
}

