/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.types.hfscommon;

import java.io.PrintStream;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.hfsexplorer.Util;
import org.catacombae.hfsexplorer.types.hfs.ExtKeyRec;
import org.catacombae.hfsexplorer.types.hfscommon.CommonBTKey;
import org.catacombae.hfsexplorer.types.hfscommon.CommonHFSCatalogNodeID;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusExtentKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommonHFSExtentKey
extends CommonBTKey<CommonHFSExtentKey>
implements StructElements {
    @Override
    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + this.getClass().getSimpleName() + ":");
        this.printFields(ps, prefix + " ");
    }

    public static CommonHFSExtentKey create(HFSPlusExtentKey key) {
        return new HFSPlusImplementation(key);
    }

    public static CommonHFSExtentKey create(ExtKeyRec key) {
        return new HFSImplementation(key);
    }

    private static int commonCompare(CommonHFSExtentKey k1, CommonHFSExtentKey k2) {
        int forkType2;
        int forkType1 = k1.getForkType();
        if (forkType1 == (forkType2 = k2.getForkType())) {
            long fileID2;
            long fileID1 = k1.getFileID().toLong();
            if (fileID1 == (fileID2 = k2.getFileID().toLong())) {
                long startBlock2;
                long startBlock1 = k1.getStartBlock();
                if (startBlock1 == (startBlock2 = k2.getStartBlock())) {
                    return 0;
                }
                if (startBlock1 < startBlock2) {
                    return -1;
                }
                return 1;
            }
            if (fileID1 < fileID2) {
                return -1;
            }
            return 1;
        }
        if (forkType1 < forkType2) {
            return -1;
        }
        return 1;
    }

    public abstract int getForkType();

    public abstract CommonHFSCatalogNodeID getFileID();

    public abstract long getStartBlock();

    public static class HFSImplementation
    extends CommonHFSExtentKey {
        private final ExtKeyRec key;

        public HFSImplementation(ExtKeyRec key) {
            this.key = key;
        }

        public int getForkType() {
            return Util.unsign((byte)this.key.getXkrFkType());
        }

        public CommonHFSCatalogNodeID getFileID() {
            return CommonHFSCatalogNodeID.create(this.key.getXkrFNum());
        }

        public long getStartBlock() {
            return Util.unsign((short)this.key.getXkrFABN());
        }

        public byte[] getBytes() {
            return this.key.getBytes();
        }

        public int maxSize() {
            HFSImplementation hFSImplementation = this;
            return hFSImplementation.key.length();
        }

        public int occupiedSize() {
            HFSImplementation hFSImplementation = this;
            return hFSImplementation.key.length();
        }

        public void printFields(PrintStream ps, String prefix) {
            ps.println(prefix + "key:");
            this.key.print(ps, prefix + " ");
        }

        public Dictionary getStructElements() {
            return this.key.getStructElements();
        }

        public int compareTo(CommonHFSExtentKey o) {
            if (o instanceof HFSImplementation) {
                return CommonHFSExtentKey.commonCompare((CommonHFSExtentKey)this, o);
            }
            if (o != null) {
                throw new RuntimeException("Can't compare a " + o.getClass() + " with a " + this.getClass());
            }
            throw new RuntimeException("o == null !!");
        }
    }

    public static class HFSPlusImplementation
    extends CommonHFSExtentKey {
        private final HFSPlusExtentKey key;

        public HFSPlusImplementation(HFSPlusExtentKey key) {
            this.key = key;
        }

        public int getForkType() {
            return this.key.getUnsignedForkType();
        }

        public CommonHFSCatalogNodeID getFileID() {
            return CommonHFSCatalogNodeID.create(this.key.getFileID());
        }

        public long getStartBlock() {
            return this.key.getUnsignedStartBlock();
        }

        public byte[] getBytes() {
            return this.key.getBytes();
        }

        public int maxSize() {
            return this.key.length();
        }

        public int occupiedSize() {
            return this.key.length();
        }

        public void printFields(PrintStream ps, String prefix) {
            ps.println(prefix + "key:");
            this.key.print(ps, prefix + " ");
        }

        public Dictionary getStructElements() {
            return this.key.getStructElements();
        }

        public int compareTo(CommonHFSExtentKey o) {
            if (o instanceof HFSPlusImplementation) {
                return CommonHFSExtentKey.commonCompare((CommonHFSExtentKey)this, o);
            }
            if (o != null) {
                throw new RuntimeException("Can't compare a " + o.getClass() + " with a " + this.getClass());
            }
            throw new RuntimeException("o == null !!");
        }
    }
}

