/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.tree.support;

import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class BreadthFirstIterator
implements Iterator<GTreeNode> {
    Queue<GTreeNode> nodeQueue = new LinkedList<GTreeNode>();
    GTreeNode lastNode;
    private boolean filtered;
    private long mod;
    private GTree tree;

    public BreadthFirstIterator(GTree tree, GTreeNode node) {
        this(tree, node, true);
    }

    public BreadthFirstIterator(GTree tree, GTreeNode node, boolean filtered) {
        this.nodeQueue.add(node);
        this.mod = tree.getModificationID();
        this.tree = tree;
        this.filtered = filtered;
    }

    public Stream<GTreeNode> stream() {
        Iterable iterable = () -> this;
        Stream<GTreeNode> stream = StreamSupport.stream(iterable.spliterator(), false);
        return stream;
    }

    @Override
    public boolean hasNext() {
        return !this.nodeQueue.isEmpty();
    }

    @Override
    public GTreeNode next() {
        this.checkForConcurrentModification();
        this.lastNode = this.nodeQueue.poll();
        if (this.lastNode != null) {
            if (this.filtered) {
                List<GTreeNode> children = this.lastNode.getChildren();
                this.nodeQueue.addAll(children);
            } else {
                List<GTreeNode> children = this.lastNode.getAllChildren();
                this.nodeQueue.addAll(children);
            }
        }
        return this.lastNode;
    }

    @Override
    public void remove() {
        this.checkForConcurrentModification();
        GTreeNode parent = this.lastNode.getParent();
        if (parent == null) {
            throw new IllegalArgumentException("Can't delete root node!");
        }
        parent.removeNode(this.lastNode);
        if (this.filtered) {
            this.nodeQueue.removeAll(this.lastNode.getChildren());
        } else {
            this.nodeQueue.removeAll(this.lastNode.getAllChildren());
        }
    }

    private void checkForConcurrentModification() {
        if (this.tree.getModificationID() != this.mod) {
            throw new ConcurrentModificationException();
        }
    }
}

