/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.textfield;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.InputVerifier;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class HintTextField
extends JTextField {
    private InputVerifier verifier;
    private boolean required;
    private String hint;
    private Color INVALID_COLOR = new Color(255, 225, 225);
    private Color VALID_COLOR = Color.WHITE;

    public HintTextField(String hint) {
        this(hint, false, null);
    }

    public HintTextField(String hint, boolean required) {
        this(hint, required, null);
    }

    public HintTextField(String hint, boolean required, InputVerifier verifier) {
        this.hint = hint;
        this.required = required;
        this.verifier = verifier;
        this.addListeners();
        this.setAttributes();
        this.validateField();
    }

    public void addListeners() {
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                HintTextField.this.validateField();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                HintTextField.this.validateField();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.validateField();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.getText().isEmpty() && g instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(Color.lightGray);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.hint != null) {
                g2.drawString(this.hint, 7, 19);
            }
        }
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public boolean isFieldValid() {
        if (this.required && this.getText().isEmpty()) {
            return false;
        }
        return this.verifier == null || this.verifier.verify(this);
    }

    private void setAttributes() {
        this.setFont(this.getFont().deriveFont(0));
        this.setForeground(Color.BLACK);
    }

    private void validateField() {
        this.setBackground(this.isFieldValid() ? this.VALID_COLOR : this.INVALID_COLOR);
    }
}

