/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import docking.widgets.table.RowObjectTableModel;
import docking.widgets.table.SelectionStorage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public abstract class AbstractGTableModel<T>
extends AbstractTableModel
implements RowObjectTableModel<T>,
SelectionStorage<T> {
    public static final int WIDTH_UNDEFINED = -1;
    private List<T> lastSelectedObjects = new ArrayList<T>();

    @Override
    public T getRowObject(int row) {
        List data = this.getModelData();
        if (row < 0 || row >= data.size()) {
            return null;
        }
        return data.get(row);
    }

    @Override
    public int getRowIndex(T rowObject) {
        if (rowObject == null) {
            return -1;
        }
        return this.getIndexForRowObject(rowObject);
    }

    @Override
    public int getRowCount() {
        List modelData = this.getModelData();
        if (modelData == null) {
            return 0;
        }
        return modelData.size();
    }

    public void refresh() {
        this.fireTableDataChanged();
    }

    @Override
    public List<T> getLastSelectedObjects() {
        return this.lastSelectedObjects;
    }

    @Override
    public void setLastSelectedObjects(List<T> lastSelectedObjects) {
        this.lastSelectedObjects = lastSelectedObjects;
    }

    public int getPreferredColumnWidth(int columnIndex) {
        return -1;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        List modelData = this.getModelData();
        if (rowIndex < 0 || rowIndex >= modelData.size()) {
            return null;
        }
        Object t = modelData.get(rowIndex);
        return this.getColumnValueForRow(t, columnIndex);
    }

    protected int getIndexForRowObject(T rowObject) {
        return this.getIndexForRowObject(rowObject, this.getModelData());
    }

    protected int getIndexForRowObject(T rowObject, List<T> data) {
        return data.indexOf(rowObject);
    }

    public void dispose() {
        this.lastSelectedObjects.clear();
        this.getModelData().clear();
    }
}

