/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.filter;

import docking.util.AnimationUtils;
import ghidra.util.SystemUtilities;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;
import org.jdesktop.animation.timing.TimingTargetAdapter;
import org.jdesktop.animation.timing.interpolation.PropertySetter;
import resources.Icons;
import resources.ResourceManager;

public class ClearFilterLabel
extends JLabel {
    private Icon RAW_ICON = Icons.DELETE_ICON;
    private Icon ICON = ResourceManager.getScaledIcon((Icon)this.RAW_ICON, (int)10, (int)10);
    private static final float FULLY_TRANSPARENT = 0.0f;
    private static final float FULLY_OPAQUE = 0.6f;
    private static final float PARTIALLY_HIDDEN = 0.2f;
    private static final int FADE_IN_MS = 1500;
    private JTextField textField;
    private float transparency;
    private Animator animator;

    public ClearFilterLabel(JTextField textField) {
        this.textField = textField;
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                ClearFilterLabel.this.resetBounds();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ClearFilterLabel.this.resetBounds();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ClearFilterLabel.this.resetBounds();
            }
        });
        textField.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ClearFilterLabel.this.resetBounds();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ClearFilterLabel.this.clearFilter();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                ClearFilterLabel.this.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ClearFilterLabel.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        this.setIcon(this.ICON);
        this.setToolTipText("Clear filter");
    }

    private void clearFilter() {
        this.textField.setText("");
        this.cancelAnimation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Composite oldComposite = g2d.getComposite();
        try {
            AlphaComposite alpha = AlphaComposite.getInstance(AlphaComposite.SrcOver.getRule(), this.transparency);
            g2d.setComposite(alpha);
            super.paintComponent(g);
        }
        finally {
            g2d.setComposite(oldComposite);
        }
    }

    public void setTransparency(float transparency) {
        this.transparency = transparency;
        this.repaint();
    }

    public void showFilterButton() {
        if (this.isVisible()) {
            return;
        }
        this.transparency = 0.0f;
        this.setVisible(true);
        this.reanimate();
    }

    private void reanimate() {
        if (!AnimationUtils.isAnimationEnabled()) {
            this.transparency = 0.6f;
            return;
        }
        if (this.animator != null) {
            return;
        }
        this.animator = PropertySetter.createAnimator((int)1500, (Object)this, (String)"transparency", (Object[])new Float[]{Float.valueOf(0.0f), Float.valueOf(0.6f)});
        this.animator.setAcceleration(0.0f);
        this.animator.setDeceleration(0.8f);
        this.animator.addTarget((TimingTarget)new TimingTargetAdapter(){

            public void end() {
                ClearFilterLabel.this.animator = null;
            }
        });
        this.animator.start();
    }

    private void cancelAnimation() {
        if (this.animator != null) {
            this.animator.cancel();
            this.animator = null;
        }
    }

    public void hideFilterButton() {
        this.cancelAnimation();
        this.setVisible(false);
    }

    private void resetBounds() {
        SystemUtilities.runIfSwingOrPostSwingLater(() -> this.doResetBounds());
    }

    private void doResetBounds() {
        Container myParent = this.getParent();
        if (myParent == null) {
            return;
        }
        Rectangle textBounds = this.textField.getBounds();
        Insets textInsets = this.textField.getInsets();
        Point location = textBounds.getLocation();
        Dimension size = this.getPreferredSize();
        int half = (textBounds.height - size.height) / 2;
        int y = textBounds.y + half;
        int end = location.x + textBounds.width;
        int x = end - textInsets.right - size.width;
        this.checkForTouchyText(x);
        this.setBounds(x, y, size.width, size.height);
        myParent.validate();
    }

    private void checkForTouchyText(int x) {
        if (this.touchesText(x)) {
            this.transparency = 0.2f;
            return;
        }
        if (this.transparency == 0.2f) {
            this.transparency = 0.6f;
        }
    }

    private boolean touchesText(int x) {
        int padding;
        FontMetrics fm = this.textField.getFontMetrics(this.textField.getFont());
        Rectangle textBounds = this.textField.getBounds();
        Point location = textBounds.getLocation();
        String text = this.textField.getText();
        Rectangle2D bounds = fm.getStringBounds(text, this.textField.getGraphics());
        double textWidth = bounds.getWidth() + bounds.getX();
        return (double)location.x + textWidth + (double)(padding = 5) > (double)x;
    }
}

