/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.filechooser;

import docking.dnd.DropTgtAdapter;
import docking.dnd.Droppable;
import docking.widgets.OptionDialog;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import docking.widgets.filechooser.GhidraFileChooserPanelListener;
import ghidra.framework.preferences.Preferences;
import ghidra.util.filechooser.GhidraFileFilter;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.io.File;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class GhidraFileChooserPanel
extends JPanel
implements Droppable {
    private static final long serialVersionUID = 1L;
    public static final int INPUT_MODE = 0;
    public static final int OUTPUT_MODE = 1;
    private GhidraFileChooser fileChooser;
    private GhidraFileFilter filter = GhidraFileFilter.ALL;
    private JTextField filenameTextField;
    private JButton chooseButton;
    private String title;
    private String propertyName;
    private String defaultFileName;
    private boolean createBorder;
    private int mode = 1;
    private GhidraFileChooserPanelListener listener;
    private DropTarget dropTarget;
    private DropTgtAdapter dropTargetAdapter;
    private DataFlavor[] acceptableFlavors;
    private GhidraFileChooserMode selectionMode = GhidraFileChooserMode.FILES_ONLY;

    public GhidraFileChooserPanel(String title, String propertyName, String defaultFileName, boolean createBorder, int mode) {
        this.title = title;
        this.propertyName = propertyName;
        this.defaultFileName = defaultFileName;
        this.createBorder = createBorder;
        this.mode = mode;
        this.build();
        this.setupDragAndDrop();
    }

    public void setListener(GhidraFileChooserPanelListener listener) {
        this.listener = listener;
    }

    public void setFileFilter(GhidraFileFilter filter) {
        this.filter = filter;
    }

    private void build() {
        if (this.createBorder) {
            this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), this.title));
        }
        this.filenameTextField = new JTextField(20);
        this.filenameTextField.setText(this.defaultFileName);
        this.filenameTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                GhidraFileChooserPanel.this.fileChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                GhidraFileChooserPanel.this.fileChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                GhidraFileChooserPanel.this.fileChanged();
            }
        });
        this.chooseButton = new JButton("...");
        this.chooseButton.addActionListener(evt -> {
            File log = this.chooseFile(this.chooseButton, "Select " + (this.title == null ? "" : this.title));
            if (log != null) {
                boolean ok = true;
                if (this.mode == 1 && log.exists()) {
                    String buttonText;
                    String questionTitle = "Overwrite Existing File?";
                    String questionText = "The file " + log.getAbsolutePath() + " already exists.\nDo you wish to overwrite it?";
                    int response = OptionDialog.showOptionDialog((Component)this.chooseButton, questionTitle, questionText, buttonText = "Yes", 3);
                    boolean bl = ok = response == 1;
                }
                if (ok) {
                    this.filenameTextField.setText(log.getAbsolutePath());
                } else {
                    this.filenameTextField.setText("");
                }
                this.filenameTextField.requestFocus();
                this.filenameTextField.selectAll();
            }
        });
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        if (!this.createBorder && this.title != null) {
            this.add((Component)new JLabel(this.title), gbc);
        }
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        ++gbc.gridx;
        this.add((Component)this.filenameTextField, gbc);
        gbc.fill = 0;
        gbc.weightx = 0.0;
        ++gbc.gridx;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.chooseButton, gbc);
    }

    private void fileChanged() {
        if (this.listener != null) {
            String file = this.filenameTextField.getText();
            if (file.length() == 0) {
                this.listener.fileChanged(null);
            } else {
                this.listener.fileChanged(new File(file));
            }
        }
    }

    public void addDocumentListener(DocumentListener dl) {
        this.filenameTextField.getDocument().addDocumentListener(dl);
    }

    public String getFileName() {
        return this.filenameTextField.getText();
    }

    public String getCurrentDirectory() {
        if (this.fileChooser == null) {
            return "";
        }
        return this.fileChooser.getCurrentDirectory().getAbsolutePath();
    }

    public void setFileName(String path) {
        this.filenameTextField.setText(path);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.filenameTextField.setEnabled(enabled);
        this.filenameTextField.setOpaque(enabled);
        this.chooseButton.setEnabled(enabled);
    }

    private File chooseFile(Component parent, String buttonText) {
        if (this.fileChooser == null) {
            this.fileChooser = new GhidraFileChooser(parent);
        }
        this.fileChooser.setFileFilter(this.filter);
        this.fileChooser.setFileSelectionMode(this.selectionMode);
        File directory = new File(Preferences.getProperty((String)this.propertyName, (String)System.getProperty("user.home")));
        this.fileChooser.setCurrentDirectory(directory);
        this.fileChooser.setSelectedFile(directory);
        File file = this.fileChooser.getSelectedFile();
        if (file != null) {
            Preferences.setProperty((String)this.propertyName, (String)file.getAbsolutePath());
        }
        return file;
    }

    private void setupDragAndDrop() {
        this.acceptableFlavors = new DataFlavor[]{DataFlavor.javaFileListFlavor};
        this.dropTargetAdapter = new DropTgtAdapter(this, 3, this.acceptableFlavors);
        this.dropTarget = new DropTarget(this.filenameTextField, 3, this.dropTargetAdapter, true);
        this.dropTarget.setActive(true);
    }

    @Override
    public void add(Object obj, DropTargetDropEvent e, DataFlavor f) {
        List files;
        if (f == DataFlavor.javaFileListFlavor && (files = (List)obj).size() > 0) {
            File file = (File)files.get(0);
            this.filenameTextField.setText(file.getAbsolutePath());
            if (this.listener != null) {
                this.listener.fileDropped(file);
            }
        }
    }

    public void setFileSelectionMode(GhidraFileChooserMode mode) {
        this.selectionMode = mode;
    }

    @Override
    public void dragUnderFeedback(boolean ok, DropTargetDragEvent e) {
    }

    @Override
    public boolean isDropOk(DropTargetDragEvent e) {
        return true;
    }

    @Override
    public void undoDragUnderFeedback() {
    }
}

