/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets;

import docking.widgets.DialogRememberOption;
import docking.widgets.OptionDialog;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

public class OptionDialogBuilder {
    private String title;
    private String message;
    private Icon icon;
    private int messageType;
    private boolean addCancelButton;
    private List<String> options;
    private String defaultOption;
    private DialogRememberOption rememberOption;

    public OptionDialogBuilder() {
        this(null, null);
    }

    public OptionDialogBuilder(String title) {
        this(title, null);
    }

    public OptionDialogBuilder(String title, String message) {
        this.title = title;
        this.message = message;
        this.options = new ArrayList<String>();
        this.messageType = -1;
    }

    public OptionDialogBuilder setTitle(String title) {
        this.title = title;
        return this;
    }

    public OptionDialogBuilder setMessage(String message) {
        this.message = message;
        return this;
    }

    public OptionDialogBuilder setIcon(Icon icon) {
        this.icon = icon;
        return this;
    }

    public OptionDialogBuilder setMessageType(int messageType) {
        this.messageType = messageType;
        return this;
    }

    public OptionDialogBuilder addCancel() {
        this.addCancelButton = true;
        return this;
    }

    public OptionDialogBuilder addOption(String optionName) {
        this.options.add(optionName);
        return this;
    }

    public OptionDialogBuilder setDefaultButton(String optionName) {
        this.defaultOption = optionName;
        return this;
    }

    public OptionDialogBuilder addApplyToAllOption() {
        this.rememberOption = new DialogRememberOption("Apply to all");
        return this;
    }

    public OptionDialogBuilder addDontShowAgainOption() {
        this.rememberOption = new DialogRememberOption("Don't show again");
        return this;
    }

    public OptionDialogBuilder addRememberMyDecisionOption() {
        this.rememberOption = new DialogRememberOption("Remember my decision");
        return this;
    }

    public OptionDialog build() {
        return new OptionDialog(this.title, this.message, this.messageType, this.icon, this.addCancelButton, this.rememberOption, this.options, this.defaultOption);
    }

    public int show() {
        return this.show(null);
    }

    public int show(Component parent) {
        if (this.rememberOption != null && this.rememberOption.hasRememberedResult()) {
            return this.rememberOption.getRememberedResult();
        }
        OptionDialog dialog = this.build();
        dialog.show(parent);
        return dialog.getResult();
    }
}

