/*
 * Decompiled with CFR 0.152.
 */
package docking.menu;

import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.menu.MenuGroupListener;
import docking.menu.MenuGroupMap;
import docking.menu.MenuHandler;
import docking.menu.MenuManager;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JMenuBar;

public class MenuBarManager
implements MenuGroupListener {
    private MenuHandler menuHandler;
    private Map<String, MenuManager> menuManagers;
    private final MenuGroupMap menuGroupMap;

    public MenuBarManager(MenuHandler actionHandler, MenuGroupMap menuGroupMap) {
        this.menuGroupMap = menuGroupMap;
        this.menuManagers = new TreeMap<String, MenuManager>();
        this.menuHandler = actionHandler;
    }

    public void clearActions() {
        this.menuManagers = new TreeMap<String, MenuManager>();
    }

    public void addAction(DockingActionIf action) {
        MenuData menuBarData = action.getMenuBarData();
        if (menuBarData == null) {
            return;
        }
        String[] menuPath = menuBarData.getMenuPath();
        if (menuPath == null || menuPath.length <= 1) {
            return;
        }
        MenuManager menuMgr = this.getMenuManager(menuPath[0]);
        menuMgr.addAction(action);
    }

    public void removeAction(DockingActionIf action) {
        Iterator<MenuManager> it = this.menuManagers.values().iterator();
        while (it.hasNext()) {
            MenuManager mgr = it.next();
            mgr.removeAction(action);
            if (!mgr.isEmpty()) continue;
            it.remove();
        }
    }

    public void dispose() {
        for (MenuManager mgr : this.menuManagers.values()) {
            mgr.dispose();
        }
        this.menuManagers.clear();
    }

    private MenuManager getMenuManager(String menuName) {
        char mk = MenuManager.getMnemonicKey(menuName);
        MenuManager mgr = this.menuManagers.get(menuName = MenuManager.stripMnemonicAmp(menuName));
        if (mgr == null) {
            mgr = new MenuManager(menuName, new String[]{menuName}, mk, 1, null, false, this.menuHandler, this.menuGroupMap);
            this.menuManagers.put(menuName, mgr);
        }
        return mgr;
    }

    public JMenuBar getMenuBar() {
        MenuManager fileMenu = this.menuManagers.get("File");
        MenuManager editMenu = this.menuManagers.get("Edit");
        MenuManager windowMenu = this.menuManagers.get("Window");
        MenuManager helpMenu = this.menuManagers.get("Help");
        JMenuBar menuBar = new JMenuBar();
        if (fileMenu != null) {
            menuBar.add(fileMenu.getMenu());
        }
        if (editMenu != null) {
            menuBar.add(editMenu.getMenu());
        }
        for (MenuManager mgr : this.menuManagers.values()) {
            if (mgr == fileMenu || mgr == editMenu || mgr == windowMenu || mgr == helpMenu) continue;
            menuBar.add(mgr.getMenu());
        }
        if (windowMenu != null) {
            menuBar.add(windowMenu.getMenu());
        }
        if (helpMenu != null) {
            menuBar.add(helpMenu.getMenu());
        }
        return menuBar;
    }

    @Override
    public void menuGroupChanged(String[] menuPath, String group) {
        MenuManager mgr;
        if (menuPath != null && menuPath.length > 1 && (mgr = this.getMenuManager(menuPath[0])) != null) {
            mgr.menuGroupChanged(menuPath, 1, group);
        }
    }
}

