/*
 * Decompiled with CFR 0.152.
 */
package docking.dnd;

import docking.dnd.Droppable;
import ghidra.util.Msg;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.ArrayList;

public class DropTgtAdapter
implements DropTargetListener {
    private Droppable dropComponent;
    private int dropActions;
    private DataFlavor[] dropFlavors;

    public DropTgtAdapter(Droppable dropComponent, int acceptableDropActions, DataFlavor[] acceptableDropFlavors) {
        this.dropComponent = dropComponent;
        this.dropActions = acceptableDropActions;
        this.dropFlavors = acceptableDropFlavors;
    }

    public void setAcceptableDropFlavors(DataFlavor[] dropFlavors) {
        this.dropFlavors = dropFlavors;
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
        if (this.isDropOk(e)) {
            e.acceptDrag(e.getDropAction());
        } else {
            this.dropComponent.dragUnderFeedback(false, e);
            e.rejectDrag();
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
        if (this.isDropOk(e)) {
            this.dropComponent.dragUnderFeedback(true, e);
            e.acceptDrag(e.getDropAction());
        } else {
            this.dropComponent.dragUnderFeedback(false, e);
            e.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent e) {
        this.dropComponent.undoDragUnderFeedback();
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
        this.dragOver(e);
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        int sourceActions;
        Transferable t = e.getTransferable();
        int flavorIndex = -1;
        for (int i = 0; i < this.dropFlavors.length; ++i) {
            if (!t.isDataFlavorSupported(this.dropFlavors[i])) continue;
            flavorIndex = i;
            break;
        }
        if (flavorIndex < 0) {
            e.rejectDrop();
            this.dropComponent.undoDragUnderFeedback();
            return;
        }
        int dropAction = e.getDropAction();
        if ((dropAction & (sourceActions = e.getSourceActions())) == 0) {
            e.rejectDrop();
            this.dropComponent.undoDragUnderFeedback();
            return;
        }
        e.acceptDrop(e.getDropAction());
        Object data = null;
        boolean error = false;
        Throwable th = null;
        try {
            data = t.getTransferData(this.dropFlavors[flavorIndex]);
        }
        catch (Throwable thr) {
            error = true;
            th = thr;
        }
        if (error) {
            e.dropComplete(false);
            this.dropComponent.undoDragUnderFeedback();
            Msg.showError((Object)this, null, (String)"Drop Failed", (Object)"Could not get transfer data.", (Throwable)th);
        } else {
            DataFlavor flavor = this.dropFlavors[flavorIndex];
            try {
                this.dropComponent.add(data, e, flavor);
                e.dropComplete(true);
                this.dropComponent.undoDragUnderFeedback();
            }
            catch (Throwable thr) {
                e.dropComplete(false);
                this.dropComponent.undoDragUnderFeedback();
                String message = thr.getMessage();
                if (message == null) {
                    message = "";
                }
                Msg.showError((Object)this, null, (String)"Unexpected Drag and Drop Exception", (Object)message, (Throwable)thr);
            }
        }
    }

    protected boolean isDropOk(DropTargetDragEvent e) {
        int da = e.getDropAction();
        if ((da & this.dropActions) == 0) {
            return false;
        }
        if (!this.isDragFlavorSupported(e)) {
            return false;
        }
        return this.dropComponent.isDropOk(e);
    }

    protected boolean isDragFlavorSupported(DropTargetDragEvent e) {
        if (this.dropFlavors == null) {
            return false;
        }
        for (int i = 0; i < this.dropFlavors.length; ++i) {
            if (!e.isDataFlavorSupported(this.dropFlavors[i])) continue;
            return true;
        }
        return false;
    }

    public static DataFlavor getFirstMatchingFlavor(DropTargetDragEvent e, DataFlavor[] acceptableFlavors) {
        DataFlavor[] transferFlavors = e.getCurrentDataFlavors();
        for (DataFlavor acceptableFlavor : acceptableFlavors) {
            for (DataFlavor transferFlavor : transferFlavors) {
                if (!acceptableFlavor.equals(transferFlavor)) continue;
                return transferFlavor;
            }
        }
        return null;
    }

    public static DataFlavor[] getAllMatchingFlavors(DropTargetDragEvent e, DataFlavor[] acceptableFlavors) {
        ArrayList<DataFlavor> list = new ArrayList<DataFlavor>();
        DataFlavor[] transferFlavors = e.getCurrentDataFlavors();
        block0: for (DataFlavor acceptableFlavor : acceptableFlavors) {
            for (DataFlavor transferFlavor : transferFlavors) {
                if (!acceptableFlavor.equals(transferFlavor)) continue;
                list.add(transferFlavor);
                continue block0;
            }
        }
        return list.toArray(new DataFlavor[list.size()]);
    }
}

