/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.DockingWindowManager;
import docking.KeyBindingPrecedence;
import docking.action.DockingActionIf;
import ghidra.util.Msg;
import ghidra.util.StringUtilities;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;

public class DockingKeyBindingAction
extends AbstractAction {
    private static final String RELEASED = "released";
    private static final String TYPED = "typed";
    private static final String PRESSED = "pressed";
    private static final String SHIFT = "Shift";
    private static final String CTRL = "Ctrl";
    private static final String CONTROL = "Control";
    private static final String ALT = "Alt";
    private static final String META = "Meta";
    private static final String MODIFIER_SEPARATOR = "-";
    private DockingActionIf docakbleAction;
    protected KeyStroke keyStroke;
    protected final DockingWindowManager winMgr;

    public DockingKeyBindingAction(DockingWindowManager winMgr, DockingActionIf action, KeyStroke keyStroke) {
        super(DockingKeyBindingAction.parseKeyStroke(keyStroke));
        this.winMgr = winMgr;
        this.docakbleAction = action;
        this.keyStroke = keyStroke;
    }

    KeyStroke getKeyStroke() {
        return this.keyStroke;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public boolean isReservedKeybindingPrecedence() {
        return this.getKeyBindingPrecedence() == KeyBindingPrecedence.ReservedActionsLevel;
    }

    public KeyBindingPrecedence getKeyBindingPrecedence() {
        return KeyBindingPrecedence.ReservedActionsLevel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.winMgr.setStatusText("");
        ComponentProvider provider = this.winMgr.getActiveComponentProvider();
        ActionContext context = this.getLocalContext(provider);
        context.setSource(e.getSource());
        this.docakbleAction.actionPerformed(context);
    }

    protected ActionContext getLocalContext(ComponentProvider localProvider) {
        if (localProvider == null) {
            return new ActionContext();
        }
        ActionContext actionContext = localProvider.getActionContext(null);
        if (actionContext != null) {
            return actionContext;
        }
        return new ActionContext(localProvider, null);
    }

    public static String parseKeyStroke(KeyStroke keyStroke) {
        int metaIndex;
        int shiftIndex;
        int altIndex;
        String keyPressSuffix = "-P";
        String keyString = keyStroke.toString();
        int type = keyStroke.getKeyEventType();
        if (type == 400) {
            return String.valueOf(keyStroke.getKeyChar());
        }
        int firstIndex = keyString.lastIndexOf(32) + 1;
        int ctrlIndex = keyString.indexOf(CTRL, firstIndex);
        if (ctrlIndex >= 0) {
            firstIndex = ctrlIndex + CTRL.length();
        }
        if ((altIndex = keyString.indexOf(ALT, firstIndex)) >= 0) {
            firstIndex = altIndex + ALT.length();
        }
        if ((shiftIndex = keyString.indexOf(SHIFT, firstIndex)) >= 0) {
            firstIndex = shiftIndex + SHIFT.length();
        }
        if ((metaIndex = keyString.indexOf(META, firstIndex)) >= 0) {
            firstIndex = metaIndex + META.length();
        }
        int lastIndex = keyString.length();
        if (keyString.endsWith("-P")) {
            lastIndex -= "-P".length();
        }
        if (lastIndex >= 0) {
            keyString = keyString.substring(firstIndex, lastIndex);
        }
        int modifiers = keyStroke.getModifiers();
        StringBuffer buffer = new StringBuffer();
        if ((modifiers & 1) != 0) {
            buffer.insert(0, "Shift-");
        }
        if ((modifiers & 8) != 0) {
            buffer.insert(0, "Alt-");
        }
        if ((modifiers & 2) != 0) {
            buffer.insert(0, "Ctrl-");
        }
        if ((modifiers & 4) != 0) {
            buffer.insert(0, "Meta-");
        }
        buffer.append(keyString);
        return buffer.toString();
    }

    public static KeyStroke parseKeyStroke(String keyStroke) {
        ArrayList<String> pieces = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(keyStroke, "- ");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (pieces.contains(token)) continue;
            pieces.add(token);
        }
        StringBuffer keyStrokeBuff = new StringBuffer();
        Iterator iterator = pieces.iterator();
        while (iterator.hasNext()) {
            String piece = (String)iterator.next();
            if (StringUtilities.indexOfIgnoreCase((String)piece, (String)SHIFT) != -1) {
                keyStrokeBuff.append("shift ");
                iterator.remove();
                continue;
            }
            if (StringUtilities.indexOfIgnoreCase((String)piece, (String)CTRL) != -1) {
                keyStrokeBuff.append("ctrl ");
                iterator.remove();
                continue;
            }
            if (StringUtilities.indexOfIgnoreCase((String)piece, (String)CONTROL) != -1) {
                keyStrokeBuff.append("ctrl ");
                iterator.remove();
                continue;
            }
            if (StringUtilities.indexOfIgnoreCase((String)piece, (String)ALT) != -1) {
                keyStrokeBuff.append("alt ");
                iterator.remove();
                continue;
            }
            if (StringUtilities.indexOfIgnoreCase((String)piece, (String)META) != -1) {
                keyStrokeBuff.append("meta ");
                iterator.remove();
                continue;
            }
            if (StringUtilities.indexOfIgnoreCase((String)piece, (String)PRESSED) != -1) {
                iterator.remove();
                continue;
            }
            if (StringUtilities.indexOfIgnoreCase((String)piece, (String)TYPED) != -1) {
                iterator.remove();
                continue;
            }
            if (StringUtilities.indexOfIgnoreCase((String)piece, (String)RELEASED) == -1) continue;
            iterator.remove();
        }
        keyStrokeBuff.append(PRESSED).append(' ');
        int leftover = pieces.size();
        if (leftover > 1 || leftover == 0) {
            Msg.warn(DockingKeyBindingAction.class, (Object)("Invalid keystroke string found.  Expected format of '[modifier] ... key'.  Found: '" + keyStroke + "'"));
            if (leftover == 0) {
                return null;
            }
        }
        String key = (String)pieces.get(0);
        keyStrokeBuff.append(key.toUpperCase());
        return KeyStroke.getKeyStroke(keyStrokeBuff.toString());
    }
}

