/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.DockingActionManager;
import docking.DockingWindowManager;
import docking.action.DockingActionIf;
import docking.action.DockingActionProviderIf;
import docking.action.MenuData;
import docking.action.ToggleDockingActionIf;
import docking.menu.MenuGroupMap;
import docking.menu.MenuHandler;
import docking.menu.MenuManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class DialogComponentProviderPopupActionManager {
    private List<DockingActionIf> popupActions = new ArrayList<DockingActionIf>();
    private DialogComponentProvider provider;

    public DialogComponentProviderPopupActionManager(DialogComponentProvider provider) {
        this.provider = provider;
    }

    void addAction(DockingActionIf action) {
        MenuData popupMenuData = action.getPopupMenuData();
        if (popupMenuData == null) {
            return;
        }
        this.popupActions.add(action);
    }

    void popupMenu(ActionContext actionContext, MouseEvent e) {
        if (e.isConsumed()) {
            return;
        }
        if (actionContext == null) {
            actionContext = new ActionContext();
        }
        if (actionContext.getSourceObject() == null) {
            actionContext.setSource(e.getSource());
        }
        PopupMenuHandler popupMenuHandler = new PopupMenuHandler(actionContext);
        DockingWindowManager dwm = DockingWindowManager.getInstance(this.provider.getComponent());
        if (dwm == null) {
            return;
        }
        DockingActionManager actionManager = dwm.getActionManager();
        MenuGroupMap menuGroupMap = actionManager.getMenuGroupMap();
        MenuManager menuMgr = new MenuManager("Popup", '\u0000', null, true, popupMenuHandler, menuGroupMap);
        this.populatePopupMenuActions(actionContext, menuMgr);
        if (menuMgr.isEmpty()) {
            return;
        }
        JPopupMenu popupMenu = menuMgr.getPopupMenu();
        Component c = (Component)e.getSource();
        popupMenu.addPopupMenuListener(popupMenuHandler);
        popupMenu.show(c, e.getX(), e.getY());
    }

    private void populatePopupMenuActions(ActionContext actionContext, MenuManager menuMgr) {
        for (DockingActionIf action : this.popupActions) {
            MenuData popupMenuData = action.getPopupMenuData();
            if (popupMenuData == null || !action.isValidContext(actionContext) || !action.isAddToPopup(actionContext)) continue;
            action.setEnabled(action.isEnabledForContext(actionContext));
            menuMgr.addAction(action);
        }
        Object source = actionContext.getSourceObject();
        if (source instanceof DockingActionProviderIf) {
            DockingActionProviderIf actionProvider = (DockingActionProviderIf)source;
            List<DockingActionIf> dockingActions = actionProvider.getDockingActions(actionContext);
            for (DockingActionIf action : dockingActions) {
                MenuData popupMenuData = action.getPopupMenuData();
                if (popupMenuData == null || !action.isValidContext(actionContext) || !action.isAddToPopup(actionContext)) continue;
                action.setEnabled(action.isEnabledForContext(actionContext));
                menuMgr.addAction(action);
            }
        }
    }

    private class PopupMenuHandler
    extends MenuHandler {
        private final ActionContext actionContext;

        public PopupMenuHandler(ActionContext context) {
            this.actionContext = context;
        }

        @Override
        public void menuItemEntered(DockingActionIf action) {
            DockingWindowManager.setMouseOverAction(action);
        }

        @Override
        public void menuItemExited(DockingActionIf action) {
            DockingWindowManager.clearMouseOverHelp();
        }

        @Override
        public void processMenuAction(DockingActionIf action, ActionEvent event) {
            DockingWindowManager.clearMouseOverHelp();
            this.actionContext.setSource(event.getSource());
            SwingUtilities.invokeLater(() -> {
                if (action.isEnabledForContext(this.actionContext)) {
                    if (action instanceof ToggleDockingActionIf) {
                        ToggleDockingActionIf toggleAction;
                        toggleAction.setSelected(!(toggleAction = (ToggleDockingActionIf)action).isSelected());
                    }
                    action.actionPerformed(this.actionContext);
                }
            });
        }
    }
}

