/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb;

import ghidra.app.cmd.function.CallDepthChangeInfo;
import ghidra.app.util.bin.format.pdb.PdbMember;
import ghidra.app.util.bin.format.pdb.PdbParserNEW;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.LocalVariableImpl;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.StackFrame;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableFilter;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;

class ApplyStackVariables {
    private PdbParserNEW pdbParser;
    private XmlPullParser xmlParser;
    private Function function;

    ApplyStackVariables(PdbParserNEW pdbParser, XmlPullParser xmlParser, Function function) {
        this.pdbParser = pdbParser;
        this.xmlParser = xmlParser;
        this.function = function;
    }

    void applyTo(TaskMonitor monitor, MessageLog log) throws CancelledException {
        int frameBase = this.getFrameBaseOffset(monitor);
        while (this.xmlParser.hasNext()) {
            monitor.checkCanceled();
            XmlElement elem = this.xmlParser.peek();
            if (elem.isEnd() && elem.getName().equals("function") || elem.isStart() && elem.getName().equals("line_number")) break;
            elem = this.xmlParser.next();
            PdbMember member = new PdbMember(elem, monitor);
            if ("StaticLocal".equals(member.memberKind)) {
                this.xmlParser.next();
                continue;
            }
            DataType dt = this.getDataType(member, log, monitor);
            if (dt == null) continue;
            if ("ObjectPointer".equals(member.memberKind)) {
                this.createRegisterParameter(member.memberName, dt, log);
            } else if ("Parameter".equals(member.memberKind)) {
                this.createStackVariable(member.memberName, frameBase + member.memberOffset, dt, log);
            } else if ("Local".equals(member.memberKind)) {
                this.createStackVariable(member.memberName, frameBase + member.memberOffset, dt, log);
            }
            this.xmlParser.next();
        }
    }

    private int getFrameBaseOffset(TaskMonitor monitor) throws CancelledException {
        int retAddrSize = this.function.getProgram().getDefaultPointerSize();
        if (retAddrSize != 8) {
            return -retAddrSize;
        }
        Register frameReg = this.function.getProgram().getCompilerSpec().getStackPointer();
        Address entryAddr = this.function.getEntryPoint();
        AddressSet scopeSet = new AddressSet();
        scopeSet.addRange(entryAddr, entryAddr.add(64L));
        CallDepthChangeInfo valueChange = new CallDepthChangeInfo(this.function, (AddressSetView)scopeSet, frameReg, monitor);
        InstructionIterator instructions = this.function.getProgram().getListing().getInstructions((AddressSetView)scopeSet, true);
        int max = 0;
        while (instructions.hasNext()) {
            monitor.checkCanceled();
            Instruction next = instructions.next();
            int newValue = valueChange.getDepth(next.getMinAddress());
            if (newValue < -20480 || newValue > 20480 || Math.abs(newValue) <= Math.abs(max)) continue;
            max = newValue;
        }
        return max;
    }

    private Variable createRegisterParameter(String name, DataType dt, MessageLog log) {
        Register ecx = this.function.getProgram().getLanguage().getRegister("ECX");
        try {
            Parameter[] parameters;
            for (Parameter parameter : parameters = this.function.getParameters(VariableFilter.REGISTER_VARIABLE_FILTER)) {
                if (!parameter.getRegister().equals((Object)ecx)) continue;
                parameter.setDataType(dt, false, true, SourceType.ANALYSIS);
                try {
                    parameter.setName(name, SourceType.IMPORTED);
                }
                catch (DuplicateNameException duplicateNameException) {
                    // empty catch block
                }
                return parameter;
            }
            LocalVariableImpl variable = new LocalVariableImpl(name, 0, dt, ecx, this.function.getProgram());
            try {
                return this.function.addParameter((Variable)variable, SourceType.IMPORTED);
            }
            catch (DuplicateNameException e) {
                variable.setName((Variable)variable + "_" + ecx.getName(), SourceType.IMPORTED);
                return this.function.addParameter((Variable)variable, SourceType.IMPORTED);
            }
        }
        catch (Exception e) {
            log.appendMsg("Unable to create register variable " + name + " in " + this.function.getName());
            return null;
        }
    }

    private Variable createStackVariable(String name, int offset, DataType dt, MessageLog log) {
        StackFrame stackFrame = this.function.getStackFrame();
        Variable variable = stackFrame.getVariableContaining(offset);
        try {
            if (variable == null || variable.getStackOffset() != offset) {
                if (variable != null) {
                    stackFrame.clearVariable(variable.getStackOffset());
                }
                try {
                    variable = stackFrame.createVariable(name, offset, dt, SourceType.IMPORTED);
                }
                catch (DuplicateNameException e) {
                    variable = stackFrame.createVariable(name + "@" + Integer.toHexString(offset), offset, dt, SourceType.IMPORTED);
                }
            } else {
                variable.setDataType(dt, false, true, SourceType.ANALYSIS);
                try {
                    variable.setName(name, SourceType.IMPORTED);
                }
                catch (DuplicateNameException e) {
                    variable.setName(name + "@" + Integer.toHexString(offset), SourceType.IMPORTED);
                }
            }
        }
        catch (Exception e) {
            log.appendMsg("Unable to create stack variable " + name + " at offset " + offset + " in " + this.function.getName());
        }
        return variable;
    }

    private DataType getDataType(PdbMember member, MessageLog log, TaskMonitor monitor) throws CancelledException {
        PdbParserNEW.WrappedDataType wrappedDataType = this.pdbParser.findDataType(member.memberDataTypeName, monitor);
        if (wrappedDataType == null) {
            log.appendMsg("Error: failed to resolve data type for " + member.memberKind + ": " + member.memberDataTypeName);
            return null;
        }
        if (wrappedDataType.isZeroLengthArray) {
            log.appendMsg("Error: zero length array not supported for for " + member.memberKind + ": " + member.memberDataTypeName);
            return null;
        }
        return wrappedDataType.dataType;
    }
}

