/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugins.fileformats;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.widgets.OptionDialog;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import ghidra.app.services.ProgramManager;
import ghidra.file.crypto.CryptoKeyFileTemplateWriter;
import ghidra.file.eclipse.AndroidProjectCreator;
import ghidra.file.formats.ios.prelink.PrelinkFileSystem;
import ghidra.file.jad.JadProcessWrapper;
import ghidra.file.jad.JarDecompiler;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.RefdFile;
import ghidra.framework.main.FrontEndable;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.plugins.fsbrowser.FSBAction;
import ghidra.plugins.fsbrowser.FSBActionContext;
import ghidra.plugins.fsbrowser.FSBDirNode;
import ghidra.plugins.fsbrowser.FSBFileNode;
import ghidra.plugins.fsbrowser.FSBNode;
import ghidra.plugins.fsbrowser.FSBRootNode;
import ghidra.plugins.fsbrowser.FSBUtils;
import ghidra.plugins.fsbrowser.ImageManager;
import ghidra.plugins.fsbrowser.tasks.GFileSystemLoadKernelTask;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.apache.commons.io.FilenameUtils;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Common", shortDescription="File format actions", description="This plugin provides file format related actions to the File System Browser.")
public class FileFormatsPlugin
extends Plugin
implements FrontEndable {
    private GhidraFileChooser chooserEclipse;
    private GhidraFileChooser chooserJarFolder;
    private List<DockingAction> actions = new ArrayList<DockingAction>();

    public FileFormatsPlugin(PluginTool tool) {
        super(tool);
        this.chooserEclipse = new GhidraFileChooser(null);
        this.chooserJarFolder = new GhidraFileChooser(null);
    }

    protected void init() {
        super.init();
        this.actions.add(this.createEclipseProjectAction());
        this.actions.add(this.createDecompileJarAction());
        this.actions.add(this.createCryptoTemplateAction());
        this.actions.add(this.createLoadKernelAction());
        this.actions.forEach(action -> this.getTool().addAction((DockingActionIf)action));
    }

    protected void dispose() {
        super.dispose();
        this.actions.forEach(action -> this.getTool().removeAction((DockingActionIf)action));
    }

    private DockingAction createEclipseProjectAction() {
        FSBAction action = new FSBAction("Export Eclipse Project", this){

            public void actionPerformed(ActionContext context) {
                if (context instanceof FSBActionContext) {
                    FSBActionContext fsbContext = (FSBActionContext)context;
                    FSRL fsrl = FSBUtils.getFileFSRLFromContext((ActionContext)context);
                    if (fsrl == null) {
                        Msg.info((Object)((Object)this), (Object)"Unable to export eclipse project");
                        return;
                    }
                    FileFormatsPlugin.this.chooserEclipse.setFileSelectionMode(GhidraFileChooserMode.DIRECTORIES_ONLY);
                    FileFormatsPlugin.this.chooserEclipse.setTitle("Select Eclipe Project Directory");
                    FileFormatsPlugin.this.chooserEclipse.setApproveButtonText("SELECT");
                    FileFormatsPlugin.this.chooserEclipse.setSelectedFile(null);
                    File outputDirectory = FileFormatsPlugin.this.chooserEclipse.getSelectedFile();
                    if (outputDirectory == null) {
                        return;
                    }
                    fsbContext.getTree().runTask(monitor -> this.doExportToEclipse(fsrl, outputDirectory, monitor));
                }
            }

            private void doExportToEclipse(FSRL fsrl, File outputDirectory, TaskMonitor monitor) {
                try (RefdFile refdFile = FileSystemService.getInstance().getRefdFile(fsrl, monitor);){
                    AndroidProjectCreator creator = new AndroidProjectCreator(refdFile.file, outputDirectory);
                    creator.create(monitor);
                    if (creator.getLog().getMsgCount() > 0) {
                        Msg.showInfo((Object)((Object)this), (Component)FileFormatsPlugin.this.getTool().getActiveWindow(), (String)"Export to Eclipse Project", (Object)creator.getLog().toString());
                    }
                }
                catch (CancelledException | IOException e) {
                    FSUtilities.displayException((Object)((Object)this), (Component)FileFormatsPlugin.this.getTool().getActiveWindow(), (String)"Error Exporting to Eclipse", (String)e.getMessage(), (Throwable)e);
                }
            }

            public boolean isEnabledForContext(ActionContext context) {
                if (JadProcessWrapper.isJadPresent() && context instanceof FSBActionContext) {
                    FSBActionContext fsbContext = (FSBActionContext)context;
                    FSRL fsrl = FSBUtils.getFileFSRLFromContext((ActionContext)context);
                    return !fsbContext.getTree().isBusy() && fsrl != null && fsrl.getName() != null && "apk".equalsIgnoreCase(FilenameUtils.getExtension((String)fsrl.getName()));
                }
                return false;
            }

            public boolean isAddToPopup(ActionContext context) {
                return context instanceof FSBActionContext;
            }
        };
        action.setPopupMenuData(new MenuData(new String[]{action.getMenuText()}, (Icon)ImageManager.ECLIPSE, "H"));
        action.setEnabled(true);
        return action;
    }

    private DockingAction createDecompileJarAction() {
        FSBAction action = new FSBAction("Decompile JAR", this){

            public void actionPerformed(ActionContext context) {
                if (context instanceof FSBActionContext) {
                    FSBActionContext fsbContext = (FSBActionContext)context;
                    FSRL jarFSRL = FSBUtils.getFileFSRLFromContext((ActionContext)context);
                    if (jarFSRL != null) {
                        FileFormatsPlugin.this.chooserJarFolder.setFileSelectionMode(GhidraFileChooserMode.DIRECTORIES_ONLY);
                        FileFormatsPlugin.this.chooserJarFolder.setTitle("Select JAR Output Directory");
                        FileFormatsPlugin.this.chooserJarFolder.setApproveButtonText("SELECT");
                        FileFormatsPlugin.this.chooserJarFolder.setSelectedFile(null);
                        File outputDirectory = FileFormatsPlugin.this.chooserJarFolder.getSelectedFile();
                        if (outputDirectory == null) {
                            return;
                        }
                        GTree gTree = fsbContext.getTree();
                        gTree.runTask(monitor -> {
                            try {
                                JarDecompiler decompiler = new JarDecompiler(jarFSRL, outputDirectory);
                                decompiler.decompile(monitor);
                                if (decompiler.getLog().getMsgCount() > 0) {
                                    Msg.showInfo((Object)((Object)this), (Component)gTree, (String)("Decompiling Jar " + jarFSRL.getName()), (Object)decompiler.getLog().toString());
                                }
                            }
                            catch (Exception e) {
                                FSUtilities.displayException((Object)((Object)this), (Component)gTree, (String)"Error Decompiling Jar", (String)e.getMessage(), (Throwable)e);
                            }
                        });
                    }
                }
            }

            public boolean isEnabledForContext(ActionContext context) {
                if (JadProcessWrapper.isJadPresent() && context instanceof FSBActionContext) {
                    FSBActionContext fsbContext = (FSBActionContext)context;
                    FSRL fsrl = FSBUtils.getFileFSRLFromContext((ActionContext)context);
                    return !fsbContext.getTree().isBusy() && fsrl != null && JarDecompiler.isJarFilename(fsrl.getName());
                }
                return false;
            }

            public boolean isAddToPopup(ActionContext context) {
                return context instanceof FSBActionContext;
            }
        };
        action.setPopupMenuData(new MenuData(new String[]{action.getMenuText()}, (Icon)ImageManager.JAR, "J"));
        action.setEnabled(true);
        return action;
    }

    private DockingAction createCryptoTemplateAction() {
        FSBAction action = new FSBAction("Create Crypto Key Template", this){

            public void actionPerformed(ActionContext context) {
                FSRL fsrl = FSBUtils.getFSRLFromContext((ActionContext)context, (boolean)true);
                if (context.getContextObject() instanceof FSBRootNode && fsrl != null) {
                    FileFormatsPlugin.this.createCryptoTemplate(fsrl, (FSBRootNode)context.getContextObject());
                }
            }

            public boolean isEnabledForContext(ActionContext context) {
                if (context instanceof FSBActionContext) {
                    FSBActionContext fsbContext = (FSBActionContext)context;
                    FSRL fsrl = FSBUtils.getFSRLFromContext((ActionContext)context, (boolean)true);
                    return !fsbContext.getTree().isBusy() && fsrl != null && context.getContextObject() instanceof FSBRootNode;
                }
                return false;
            }

            public boolean isAddToPopup(ActionContext context) {
                return context instanceof FSBActionContext;
            }
        };
        action.setPopupMenuData(new MenuData(new String[]{action.getMenuText() + "..."}, (Icon)ImageManager.KEY, "Z", -1, "B"));
        action.setEnabled(true);
        return action;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createCryptoTemplate(FSRL fsrl, FSBRootNode node) {
        try {
            int answer;
            String fsContainerName = fsrl.getFS().getContainer().getName();
            CryptoKeyFileTemplateWriter writer = new CryptoKeyFileTemplateWriter(fsContainerName);
            if (writer.exists() && (answer = OptionDialog.showYesNoDialog((Component)this.getTool().getActiveWindow(), (String)"WARNING!! Crypto Key File Already Exists", (String)"WARNING!!\nThe crypto key file already exists. Are you really sure that you want to overwrite it?")) == 2) {
                return;
            }
            writer.open();
            try {
                this.writeFile(writer, node.getAllChildren());
            }
            finally {
                writer.close();
            }
        }
        catch (IOException e) {
            FSUtilities.displayException((Object)((Object)this), (Component)this.getTool().getActiveWindow(), (String)"Error writing crypt key file", (String)e.getMessage(), (Throwable)e);
        }
    }

    private void writeFile(CryptoKeyFileTemplateWriter writer, List<GTreeNode> children) throws IOException {
        if (children == null || children.isEmpty()) {
            return;
        }
        for (GTreeNode child : children) {
            if (child instanceof FSBFileNode) {
                FSRL childFSRL = ((FSBFileNode)child).getFSRL();
                writer.write(childFSRL.getName());
                continue;
            }
            this.writeFile(writer, child.getAllChildren());
        }
    }

    private DockingAction createLoadKernelAction() {
        FSBAction action = new FSBAction("Load iOS Kernel", this){

            public void actionPerformed(ActionContext context) {
                if (context instanceof FSBActionContext) {
                    FSBActionContext fsbContext = (FSBActionContext)context;
                    Object contextObject = fsbContext.getContextObject();
                    FSRL fsrl = FSBUtils.getFSRLFromContext((ActionContext)context, (boolean)true);
                    ArrayList<FSRL> fileList = new ArrayList<FSRL>();
                    if (fsrl != null) {
                        if (contextObject instanceof FSBRootNode) {
                            List children = ((FSBRootNode)contextObject).getChildren();
                            for (GTreeNode childNode : children) {
                                if (!(childNode instanceof FSBNode)) continue;
                                FSBNode baseNode = (FSBNode)childNode;
                                fileList.add(baseNode.getFSRL());
                            }
                        } else if (contextObject instanceof FSBFileNode || contextObject instanceof FSBDirNode) {
                            fileList.add(fsrl);
                        }
                    }
                    if (!fileList.isEmpty()) {
                        if (OptionDialog.showYesNoDialog(null, (String)"Load iOS Kernel?", (String)"Performing this action will load the entire kernel and all KEXT files.\nDo you want to continue?") == 1) {
                            FileFormatsPlugin.this.loadIOSKernel(fileList);
                        }
                    } else {
                        FileFormatsPlugin.this.getTool().setStatusInfo("Load iOS kernel -- nothing to do.");
                    }
                }
            }

            public boolean isEnabledForContext(ActionContext context) {
                if (context instanceof FSBActionContext) {
                    FSBActionContext fsbContext = (FSBActionContext)context;
                    if (fsbContext.getTree().isBusy()) {
                        return false;
                    }
                    Object contextObject = context.getContextObject();
                    if (contextObject instanceof FSBFileNode || contextObject instanceof FSBDirNode) {
                        contextObject = FSBUtils.getNodesRoot((FSBNode)((FSBNode)contextObject));
                    }
                    if (contextObject instanceof FSBRootNode) {
                        FSBRootNode node = (FSBRootNode)contextObject;
                        return node.getFSRef() != null && node.getFSRef().getFilesystem() instanceof PrelinkFileSystem;
                    }
                }
                return false;
            }

            public boolean isAddToPopup(ActionContext context) {
                return context instanceof FSBActionContext;
            }
        };
        action.setPopupMenuData(new MenuData(new String[]{action.getMenuText()}, (Icon)ImageManager.iOS, "I"));
        action.setEnabled(true);
        return action;
    }

    private void loadIOSKernel(List<FSRL> fileList) {
        ProgramManager pm = FSBUtils.getProgramManager((PluginTool)this.getTool(), (boolean)true);
        if (pm != null) {
            TaskLauncher.launch((Task)new GFileSystemLoadKernelTask((Plugin)this, pm, fileList));
        }
    }
}

