/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.jad;

import ghidra.file.jad.Radix;
import ghidra.framework.Application;
import ghidra.framework.Platform;
import ghidra.util.SystemUtilities;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

class OldJad {
    public File outputDirectory;
    public boolean shouldDecompileDeadCode;
    public boolean shouldOutputFieldsBeforeMethods;
    public boolean shouldInsertNewLineBeforeOpeningBrace;
    public boolean shouldOverwriteOutputFiles;
    public Radix radix = Radix.TEN;
    public String outputFileExtension;
    public boolean shouldUseTabsForIndentation;
    public boolean shouldOutputSpaceBetweenKeywords;
    public boolean verbose;
    public boolean shouldRestoreDirectoryStructure;

    OldJad() {
    }

    public File decompile(String className, File classFile, TaskMonitor monitor) throws IOException {
        int lastDotPos = className.lastIndexOf(46);
        String baseName = className.substring(0, lastDotPos);
        File javaOutputFile = new File(classFile.getParentFile(), baseName + ".java");
        Runtime runtime = Runtime.getRuntime();
        ArrayList<Object> commandsList = new ArrayList<Object>();
        commandsList.add(this.getJadPath());
        if (this.shouldDecompileDeadCode) {
            commandsList.add("-dead");
        }
        if (this.shouldOutputFieldsBeforeMethods) {
            commandsList.add("-ff");
        }
        if (!this.shouldInsertNewLineBeforeOpeningBrace) {
            commandsList.add("-nonlb");
        }
        if (this.shouldOverwriteOutputFiles) {
            commandsList.add("-o");
        }
        if (this.shouldRestoreDirectoryStructure) {
            commandsList.add("-r");
        }
        commandsList.add("-radix" + this.radix.toString());
        if (this.outputFileExtension != null) {
            commandsList.add("-s" + this.outputFileExtension);
        }
        if (this.shouldOutputSpaceBetweenKeywords) {
            commandsList.add("-space");
        }
        if (this.shouldUseTabsForIndentation) {
            commandsList.add("-t");
        }
        if (this.verbose) {
            commandsList.add("-v");
        }
        commandsList.add(classFile.getAbsolutePath());
        String[] commands = commandsList.toArray(new String[commandsList.size()]);
        String[] environment = new String[]{};
        File workingDirectory = classFile.getParentFile();
        Process process = runtime.exec(commands, environment, workingDirectory);
        this.waitForProcessToRespond(process);
        String stdinMessages = this.readStdinMessagesFromProcess(process, monitor);
        if (SystemUtilities.isInDevelopmentMode() && stdinMessages != null && stdinMessages.length() > 0) {
            System.out.println(stdinMessages);
        }
        String stderrMessages = this.readStderrMessagesFromProcess(process, monitor);
        if (SystemUtilities.isInDevelopmentMode() && stderrMessages != null && stderrMessages.length() > 0) {
            System.out.println(stderrMessages);
        }
        return javaOutputFile;
    }

    private void waitForProcessToRespond(Process process) {
        try {
            process.waitFor();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private String getJadPath() throws FileNotFoundException {
        if (Platform.CURRENT_PLATFORM == Platform.WIN_32 || Platform.CURRENT_PLATFORM == Platform.WIN_64) {
            File jadExecutableFile = Application.getOSFile((String)"jad.exe");
            String jadPath = jadExecutableFile.getAbsolutePath();
            return jadPath;
        }
        File jadExecutableFile = Application.getOSFile((String)"jad");
        String jadPath = jadExecutableFile.getAbsolutePath();
        return jadPath;
    }

    private String readStdinMessagesFromProcess(Process process, TaskMonitor monitor) throws IOException {
        int nRead;
        StringBuffer buffer = new StringBuffer();
        byte[] bytes = new byte[4096];
        InputStream inputStream = process.getInputStream();
        while (!monitor.isCancelled() && (nRead = inputStream.read(bytes)) != -1) {
            buffer.append(new String(bytes, 0, nRead));
        }
        return buffer.toString();
    }

    private String readStderrMessagesFromProcess(Process process, TaskMonitor monitor) throws IOException {
        int nRead;
        StringBuffer buffer = new StringBuffer();
        byte[] bytes = new byte[4096];
        InputStream processErrorStream = process.getErrorStream();
        while (!monitor.isCancelled() && (nRead = processErrorStream.read(bytes)) != -1) {
            buffer.append(new String(bytes, 0, nRead));
        }
        return buffer.toString();
    }
}

