/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.xml;

import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.ByteProviderInputStream;
import ghidra.app.util.bin.RandomAccessByteProvider;
import ghidra.file.formats.android.xml.AndroidXmlConvertor;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileImpl;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.GFileSystemBase;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.formats.gfilesystem.factory.GFileSystemBaseFactory;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.CryptoException;
import ghidra.util.task.TaskMonitor;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@FileSystemInfo(type="androidxml", description="Android XML", factory=GFileSystemBaseFactory.class)
public class AndroidXmlFileSystem
extends GFileSystemBase {
    private GFileImpl payloadFile;
    private byte[] payloadBytes;

    public static boolean isAndroidXmlFile(File f, TaskMonitor monitor) throws IOException {
        try (RandomAccessByteProvider rabp = new RandomAccessByteProvider(f);){
            boolean bl = AndroidXmlFileSystem.isAndroidXmlFile((ByteProvider)rabp, monitor);
            return bl;
        }
    }

    public static boolean isAndroidXmlFile(ByteProvider provider, TaskMonitor monitor) throws IOException {
        boolean bl;
        byte[] actualBytes = provider.readBytes(0L, (long)AndroidXmlConvertor.ANDROID_BINARY_XML_MAGIC.length);
        if (!Arrays.equals(actualBytes, AndroidXmlConvertor.ANDROID_BINARY_XML_MAGIC)) {
            return false;
        }
        ByteProviderInputStream is = new ByteProviderInputStream(provider, 0L, provider.length());
        try {
            StringWriter sw = new StringWriter();
            AndroidXmlConvertor.convert((InputStream)is, new PrintWriter(sw), monitor);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (CancelledException | IOException e) {
                return false;
            }
        }
        is.close();
        return bl;
    }

    public AndroidXmlFileSystem(String fileSystemName, ByteProvider provider) {
        super(fileSystemName, provider);
    }

    public GFile getPayloadFile() {
        return this.payloadFile;
    }

    public boolean isValid(TaskMonitor monitor) throws IOException {
        return AndroidXmlFileSystem.isAndroidXmlFile(this.provider, monitor);
    }

    public void open(TaskMonitor monitor) throws IOException, CryptoException, CancelledException {
        try (ByteProviderInputStream is = new ByteProviderInputStream(this.provider, 0L, this.provider.length());){
            StringWriter sw = new StringWriter();
            AndroidXmlConvertor.convert((InputStream)is, new PrintWriter(sw), monitor);
            this.payloadBytes = sw.toString().getBytes();
        }
        catch (IOException e) {
            this.payloadBytes = "failed to convert".getBytes();
        }
        this.payloadFile = GFileImpl.fromFilename((GFileSystem)this, (GFile)this.root, (String)"XML", (boolean)false, (long)this.payloadBytes.length, null);
    }

    protected InputStream getData(GFile file, TaskMonitor monitor) throws IOException, CancelledException, CryptoException {
        return new ByteArrayInputStream(this.payloadBytes);
    }

    public String getInfo(GFile file, TaskMonitor monitor) throws IOException {
        return null;
    }

    public List<GFile> getListing(GFile directory) throws IOException {
        ArrayList<GFile> tmp = new ArrayList<GFile>();
        tmp.add((GFile)this.payloadFile);
        return tmp;
    }
}

