/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.filechooser;

import ghidra.util.filechooser.GhidraFileChooserModel;
import ghidra.util.filechooser.GhidraFileFilter;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;

public class ExtensionFileFilter
implements GhidraFileFilter {
    private Hashtable<String, ExtensionFileFilter> filters = null;
    private String description = null;
    private String fullDescription = null;
    private boolean useExtensionsInDescription = true;

    public static ExtensionFileFilter forExtensions(String description, String ... exts) {
        ExtensionFileFilter eff = new ExtensionFileFilter(exts, description);
        return eff;
    }

    public ExtensionFileFilter(String extension, String description) {
        this(new String[]{extension}, description);
    }

    public ExtensionFileFilter(String[] filters, String description) {
        this.filters = new Hashtable(filters.length);
        for (int i = 0; i < filters.length; ++i) {
            this.addExtension(filters[i]);
        }
        this.setDescription(description);
    }

    @Override
    public boolean accept(File f, GhidraFileChooserModel model) {
        if (f == null) {
            return false;
        }
        if (model.isDirectory(f)) {
            return true;
        }
        if (this.filters.size() == 0) {
            return true;
        }
        String extension = this.getExtension(f);
        return extension != null && this.filters.get(extension) != null;
    }

    public String getExtension(File f) {
        String filename;
        int i;
        if (f != null && (i = (filename = f.getName()).lastIndexOf(46)) > 0 && i < filename.length() - 1) {
            return filename.substring(i + 1).toLowerCase();
        }
        return null;
    }

    public void addExtension(String extension) {
        if (this.filters == null) {
            this.filters = new Hashtable(5);
        }
        this.filters.put(extension.toLowerCase(), this);
        this.fullDescription = null;
    }

    @Override
    public String getDescription() {
        if (this.fullDescription == null) {
            this.fullDescription = "";
            if (this.description == null || this.isExtensionListInDescription()) {
                if (this.description != null) {
                    this.fullDescription = this.description;
                }
                this.fullDescription = this.fullDescription + " (";
                if (this.filters.size() == 0) {
                    this.fullDescription = this.fullDescription + "*.*";
                } else {
                    boolean firstExt = true;
                    Enumeration<String> extensions = this.filters.keys();
                    if (extensions != null) {
                        while (extensions.hasMoreElements()) {
                            if (!firstExt) {
                                this.fullDescription = this.fullDescription + ",";
                            } else {
                                firstExt = false;
                            }
                            this.fullDescription = this.fullDescription + "*." + extensions.nextElement();
                        }
                    }
                }
                this.fullDescription = this.fullDescription + ")";
            } else {
                this.fullDescription = this.description;
            }
        }
        return this.fullDescription;
    }

    public void setDescription(String description) {
        this.description = description;
        this.fullDescription = null;
    }

    public void setExtensionListInDescription(boolean b) {
        this.useExtensionsInDescription = b;
        this.fullDescription = null;
    }

    public final boolean isExtensionListInDescription() {
        return this.useExtensionsInDescription;
    }
}

