/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.WeakHashMap;
import java.util.stream.Stream;

public abstract class WeakSet<T>
implements Iterable<T> {
    private static final boolean WARN_ON_ANONYMOUS_VALUE = SystemUtilities.isInDevelopmentMode() || SystemUtilities.isInTestingMode();
    private static final String WARNING_MESSAGE = "Added an anonymous class from a method or constructor.  Ghidra now has a policy of creating classes as top-level elements or creating inline classes where the field of the class is being declared.  This prevents accidental bugs whereby programmers add listeners to objects without maintaining a reference to that listener.\nSee SCR 8267 for an example.";
    protected WeakHashMap<T, T> weakHashStorage = new WeakHashMap();

    protected void maybeWarnAboutAnonymousValue(T t) {
        if (!WARN_ON_ANONYMOUS_VALUE) {
            return;
        }
        Class<?> clazz = t.getClass();
        if (!clazz.isAnonymousClass()) {
            return;
        }
        Method enclosingMethod = clazz.getEnclosingMethod();
        if (enclosingMethod != null) {
            Msg.debug((Object)this, (Object)("added an anonymous class created in a method: " + clazz.getName()), (Throwable)new Throwable());
            return;
        }
        Constructor<?> enclosingConstructor = clazz.getEnclosingConstructor();
        if (enclosingConstructor != null) {
            Msg.debug((Object)this, (Object)("Added an anonymous class from a method or constructor.  Ghidra now has a policy of creating classes as top-level elements or creating inline classes where the field of the class is being declared.  This prevents accidental bugs whereby programmers add listeners to objects without maintaining a reference to that listener.\nSee SCR 8267 for an example.\nClass name: " + clazz.getName()), (Throwable)new Throwable());
        }
    }

    public abstract void add(T var1);

    public abstract void remove(T var1);

    public abstract boolean contains(T var1);

    public abstract void clear();

    public abstract int size();

    public abstract boolean isEmpty();

    public abstract Collection<T> values();

    public Stream<T> stream() {
        return this.values().stream();
    }
}

