/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.EncodedValue;

import org.jf.dexlib.EncodedValue.EncodedValue;
import org.jf.dexlib.EncodedValue.ValueType;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.EncodedValueUtils;
import org.jf.dexlib.Util.Input;

public class FloatEncodedValue
extends EncodedValue {
    public final float value;

    protected FloatEncodedValue(Input in, byte valueArg) {
        long longValue = EncodedValueUtils.decodeRightZeroExtendedValue(in.readBytes(valueArg + 1));
        this.value = Float.intBitsToFloat((int)(longValue >> 32 & 0xFFFFFFFFL));
    }

    public FloatEncodedValue(float value) {
        this.value = value;
    }

    @Override
    public void writeValue(AnnotatedOutput out) {
        byte[] bytes = EncodedValueUtils.encodeRightZeroExtendedValue((long)Float.floatToRawIntBits(this.value) << 32);
        if (out.annotates()) {
            out.annotate(1, "value_type=" + ValueType.VALUE_FLOAT.name() + ",value_arg=" + (bytes.length - 1));
            out.annotate(bytes.length, "value: " + this.value);
        }
        out.writeByte(ValueType.VALUE_FLOAT.value | bytes.length - 1 << 5);
        out.write(bytes);
    }

    @Override
    public int placeValue(int offset) {
        return offset + 1 + EncodedValueUtils.getRequiredBytesForRightZeroExtendedValue((long)Float.floatToRawIntBits(this.value) << 32);
    }

    @Override
    protected int compareValue(EncodedValue o) {
        FloatEncodedValue other = (FloatEncodedValue)o;
        return Float.compare(this.value, other.value);
    }

    @Override
    public ValueType getValueType() {
        return ValueType.VALUE_FLOAT;
    }

    public int hashCode() {
        return Float.floatToRawIntBits(this.value);
    }
}

