/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code;

import org.jf.dexlib.Code.Format.ArrayDataPseudoInstruction;
import org.jf.dexlib.Code.Format.Instruction10x;
import org.jf.dexlib.Code.Format.PackedSwitchDataPseudoInstruction;
import org.jf.dexlib.Code.Format.SparseSwitchDataPseudoInstruction;
import org.jf.dexlib.Code.Format.UnknownInstruction;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Util.ExceptionWithContext;

public class InstructionIterator {
    public static void IterateInstructions(DexFile dexFile, byte[] insns, ProcessInstructionDelegate delegate) {
        Instruction instruction;
        for (int insnsPosition = 0; insnsPosition < insns.length; insnsPosition += instruction.getSize(insnsPosition / 2) * 2) {
            try {
                short opcodeValue = (short)(insns[insnsPosition] & 0xFF);
                if (opcodeValue == 255) {
                    opcodeValue = (short)(0xFF00 | insns[insnsPosition + 1]);
                }
                Opcode opcode = Opcode.getOpcodeByValue(opcodeValue);
                instruction = null;
                if (opcode == null) {
                    System.err.println(String.format("unknown opcode encountered - %x. Treating as nop.", opcodeValue & 0xFFFF));
                    instruction = new UnknownInstruction(opcodeValue);
                } else if (opcode == Opcode.NOP) {
                    byte secondByte = insns[insnsPosition + 1];
                    switch (secondByte) {
                        case 0: {
                            instruction = new Instruction10x(Opcode.NOP, insns, insnsPosition);
                            break;
                        }
                        case 1: {
                            instruction = new PackedSwitchDataPseudoInstruction(insns, insnsPosition);
                            break;
                        }
                        case 2: {
                            instruction = new SparseSwitchDataPseudoInstruction(insns, insnsPosition);
                            break;
                        }
                        case 3: {
                            instruction = new ArrayDataPseudoInstruction(insns, insnsPosition);
                        }
                    }
                } else {
                    instruction = opcode.format.Factory.makeInstruction(dexFile, opcode, insns, insnsPosition);
                }
                assert (instruction != null);
                delegate.ProcessInstruction(insnsPosition / 2, instruction);
                continue;
            }
            catch (Exception ex) {
                throw ExceptionWithContext.withContext(ex, "Error occured at code address " + insnsPosition * 2);
            }
        }
    }

    public static interface ProcessInstructionDelegate {
        public void ProcessInstruction(int var1, Instruction var2);
    }
}

