/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Analysis;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib.ClassDataItem;
import org.jf.dexlib.ClassDefItem;
import org.jf.dexlib.Code.Analysis.ValidationException;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.OdexDependencies;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.TypeListItem;
import org.jf.dexlib.Util.AccessFlags;
import org.jf.dexlib.Util.ExceptionWithContext;
import org.jf.dexlib.Util.SparseArray;

public class ClassPath {
    private static ClassPath theClassPath = null;
    private boolean checkPackagePrivateAccess;
    private final HashMap<String, ClassDef> classDefs = new HashMap();
    protected ClassDef javaLangObjectClassDef;
    private HashMap<String, UnresolvedClassInfo> unloadedClasses;
    private static final Pattern dalvikCacheOdexPattern = Pattern.compile("@([^@]+)@classes.dex$");
    private static final String arrayPrefix = "[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[";
    private static ClassDef unresolvedObjectClassDef = null;

    public static void InitializeClassPathFromOdex(String[] classPathDirs, String[] extraBootClassPathEntries, String dexFilePath, DexFile dexFile, boolean checkPackagePrivateAccess) {
        if (!dexFile.isOdex()) {
            throw new ExceptionWithContext("Cannot use InitialiazeClassPathFromOdex with a non-odex DexFile");
        }
        if (theClassPath != null) {
            throw new ExceptionWithContext("Cannot initialize ClassPath multiple times");
        }
        OdexDependencies odexDependencies = dexFile.getOdexDependencies();
        String[] bootClassPath = new String[odexDependencies.getDependencyCount()];
        for (int i = 0; i < bootClassPath.length; ++i) {
            String dependency = odexDependencies.getDependency(i);
            if (dependency.endsWith(".odex")) {
                int slashIndex = dependency.lastIndexOf("/");
                if (slashIndex != -1) {
                    dependency = dependency.substring(slashIndex + 1);
                }
            } else if (dependency.endsWith("@classes.dex")) {
                Matcher m = dalvikCacheOdexPattern.matcher(dependency);
                if (!m.find()) {
                    throw new ExceptionWithContext(String.format("Cannot parse dependency value %s", dependency));
                }
                dependency = m.group(1);
            } else {
                throw new ExceptionWithContext(String.format("Cannot parse dependency value %s", dependency));
            }
            bootClassPath[i] = dependency;
        }
        theClassPath = new ClassPath();
        theClassPath.initClassPath(classPathDirs, bootClassPath, extraBootClassPathEntries, dexFilePath, dexFile, checkPackagePrivateAccess);
    }

    public static void InitializeClassPath(String[] classPathDirs, String[] bootClassPath, String[] extraBootClassPathEntries, String dexFilePath, DexFile dexFile, boolean checkPackagePrivateAccess) {
        if (theClassPath != null) {
            throw new ExceptionWithContext("Cannot initialize ClassPath multiple times");
        }
        theClassPath = new ClassPath();
        theClassPath.initClassPath(classPathDirs, bootClassPath, extraBootClassPathEntries, dexFilePath, dexFile, checkPackagePrivateAccess);
    }

    private ClassPath() {
    }

    private void initClassPath(String[] classPathDirs, String[] bootClassPath, String[] extraBootClassPathEntries, String dexFilePath, DexFile dexFile, boolean checkPackagePrivateAccess) {
        this.checkPackagePrivateAccess = checkPackagePrivateAccess;
        this.unloadedClasses = new LinkedHashMap<String, UnresolvedClassInfo>();
        if (bootClassPath != null) {
            for (String bootClassPathEntry : bootClassPath) {
                this.loadBootClassPath(classPathDirs, bootClassPathEntry);
            }
        }
        if (extraBootClassPathEntries != null) {
            for (String bootClassPathEntry : extraBootClassPathEntries) {
                this.loadBootClassPath(classPathDirs, bootClassPathEntry);
            }
        }
        if (dexFile != null) {
            this.loadDexFile(dexFilePath, dexFile);
        }
        this.javaLangObjectClassDef = ClassPath.getClassDef("Ljava/lang/Object;", false);
        for (String primitiveType : new String[]{"Z", "B", "S", "C", "I", "J", "F", "D"}) {
            PrimitiveClassDef classDef = new PrimitiveClassDef(primitiveType);
            this.classDefs.put(primitiveType, classDef);
        }
    }

    private void loadBootClassPath(String[] classPathDirs, String bootClassPathEntry) {
        for (String classPathDir : classPathDirs) {
            File file = null;
            DexFile dexFile = null;
            int extIndex = bootClassPathEntry.lastIndexOf(".");
            String baseEntry = extIndex == -1 ? bootClassPathEntry : bootClassPathEntry.substring(0, extIndex);
            for (String ext : new String[]{"", ".odex", ".jar", ".apk", ".zip"}) {
                file = ext.length() == 0 ? new File(classPathDir, bootClassPathEntry) : new File(classPathDir, baseEntry + ext);
                if (!file.exists()) continue;
                if (!file.canRead()) {
                    System.err.println(String.format("warning: cannot open %s for reading. Will continue looking.", file.getPath()));
                    continue;
                }
                try {
                    dexFile = new DexFile(file, false, true);
                }
                catch (DexFile.NoClassesDexException ex) {
                }
                catch (Exception ex) {
                    throw ExceptionWithContext.withContext(ex, "Error while reading boot class path entry \"" + bootClassPathEntry + "\".");
                }
            }
            if (dexFile == null) continue;
            try {
                this.loadDexFile(file.getPath(), dexFile);
            }
            catch (Exception ex) {
                throw ExceptionWithContext.withContext(ex, String.format("Error while loading boot classpath entry %s", bootClassPathEntry));
            }
            return;
        }
        throw new ExceptionWithContext(String.format("Cannot locate boot class path file %s", bootClassPathEntry));
    }

    private void loadDexFile(String dexFilePath, DexFile dexFile) {
        for (ClassDefItem classDefItem : dexFile.ClassDefsSection.getItems()) {
            try {
                UnresolvedClassInfo unresolvedClassInfo = new UnresolvedClassInfo(dexFilePath, classDefItem);
                if (this.unloadedClasses.containsKey(unresolvedClassInfo.classType)) continue;
                this.unloadedClasses.put(unresolvedClassInfo.classType, unresolvedClassInfo);
            }
            catch (Exception ex) {
                throw ExceptionWithContext.withContext(ex, String.format("Error while loading class %s", classDefItem.getClassType().getTypeDescriptor()));
            }
        }
    }

    @Nullable
    private static ClassDef loadClassDef(String classType) {
        ClassDef classDef = null;
        UnresolvedClassInfo classInfo = ClassPath.theClassPath.unloadedClasses.get(classType);
        if (classInfo == null) {
            return null;
        }
        try {
            classDef = new ClassDef(classInfo);
            ClassPath.theClassPath.classDefs.put(classDef.classType, classDef);
        }
        catch (Exception ex) {
            throw ExceptionWithContext.withContext(ex, String.format("Error while loading class %s from file %s", classInfo.classType, classInfo.dexFilePath));
        }
        ClassPath.theClassPath.unloadedClasses.remove(classType);
        return classDef;
    }

    @Nonnull
    public static ClassDef getClassDef(String classType, boolean createUnresolvedClassDef) {
        ClassDef classDef = ClassPath.theClassPath.classDefs.get(classType);
        if (classDef == null) {
            if (classType.charAt(0) == '[') {
                return theClassPath.createArrayClassDef(classType);
            }
            try {
                classDef = ClassPath.loadClassDef(classType);
                if (classDef == null) {
                    throw new ExceptionWithContext(String.format("Could not find definition for class %s", classType));
                }
            }
            catch (Exception ex) {
                ExceptionWithContext exWithContext = ExceptionWithContext.withContext(ex, String.format("Error while loading ClassPath class %s", classType));
                if (createUnresolvedClassDef) {
                    return theClassPath.createUnresolvedClassDef(classType);
                }
                throw exWithContext;
            }
        }
        return classDef;
    }

    public static ClassDef getClassDef(String classType) {
        return ClassPath.getClassDef(classType, true);
    }

    public static ClassDef getClassDef(TypeIdItem classType) {
        return ClassPath.getClassDef(classType.getTypeDescriptor());
    }

    public static ClassDef getClassDef(TypeIdItem classType, boolean creatUnresolvedClassDef) {
        return ClassPath.getClassDef(classType.getTypeDescriptor(), creatUnresolvedClassDef);
    }

    private static ClassDef getArrayClassDefByElementClassAndDimension(ClassDef classDef, int arrayDimension) {
        return ClassPath.getClassDef(arrayPrefix.substring(256 - arrayDimension) + classDef.classType);
    }

    public static ClassDef getUnresolvedObjectClassDef() {
        if (unresolvedObjectClassDef == null) {
            unresolvedObjectClassDef = new UnresolvedClassDef("Ljava/lang/Object;");
        }
        return unresolvedObjectClassDef;
    }

    private ClassDef createUnresolvedClassDef(String classType) {
        assert (classType.charAt(0) == 'L');
        UnresolvedClassDef unresolvedClassDef = new UnresolvedClassDef(classType);
        this.classDefs.put(classType, unresolvedClassDef);
        return unresolvedClassDef;
    }

    private ClassDef createArrayClassDef(String arrayClassName) {
        assert (arrayClassName != null);
        assert (arrayClassName.charAt(0) == '[');
        ArrayClassDef arrayClassDef = new ArrayClassDef(arrayClassName);
        if (arrayClassDef.elementClass == null) {
            return null;
        }
        this.classDefs.put(arrayClassName, arrayClassDef);
        return arrayClassDef;
    }

    public static ClassDef getCommonSuperclass(ClassDef class1, ClassDef class2) {
        int class1Depth;
        if (class1 == class2) {
            return class1;
        }
        if (class1 == null) {
            return class2;
        }
        if (class2 == null) {
            return class1;
        }
        boolean gotInterface = false;
        if (class2.isInterface) {
            if (class1.implementsInterface(class2)) {
                return class2;
            }
            gotInterface = true;
        }
        if (class1.isInterface) {
            if (class2.implementsInterface(class1)) {
                return class1;
            }
            gotInterface = true;
        }
        if (gotInterface) {
            return ClassPath.theClassPath.javaLangObjectClassDef;
        }
        if (class1 instanceof ArrayClassDef && class2 instanceof ArrayClassDef) {
            return ClassPath.getCommonArraySuperclass((ArrayClassDef)class1, (ArrayClassDef)class2);
        }
        int class2Depth = class2.getClassDepth();
        for (class1Depth = class1.getClassDepth(); class1Depth > class2Depth; --class1Depth) {
            class1 = class1.superclass;
        }
        while (class2Depth > class1Depth) {
            class2 = class2.superclass;
            --class2Depth;
        }
        while (class1Depth > 0) {
            if (class1 == class2) {
                return class1;
            }
            class1 = class1.superclass;
            --class1Depth;
            class2 = class2.superclass;
            --class2Depth;
        }
        return class1;
    }

    private static ClassDef getCommonArraySuperclass(ArrayClassDef class1, ArrayClassDef class2) {
        assert (class1 != class2);
        if (class1.elementClass instanceof PrimitiveClassDef || class2.elementClass instanceof PrimitiveClassDef) {
            return ClassPath.theClassPath.javaLangObjectClassDef;
        }
        if (class1.arrayDimensions == class2.arrayDimensions) {
            ClassDef commonElementClass = class1.elementClass instanceof UnresolvedClassDef || class2.elementClass instanceof UnresolvedClassDef ? ClassPath.getUnresolvedObjectClassDef() : ClassPath.getCommonSuperclass(class1.elementClass, class2.elementClass);
            return ClassPath.getArrayClassDefByElementClassAndDimension(commonElementClass, class1.arrayDimensions);
        }
        int dimensions = Math.min(class1.arrayDimensions, class2.arrayDimensions);
        return ClassPath.getArrayClassDefByElementClassAndDimension(ClassPath.theClassPath.javaLangObjectClassDef, dimensions);
    }

    private static class UnresolvedClassInfo {
        public final String dexFilePath;
        public final String classType;
        public final boolean isPublic;
        public final boolean isInterface;
        public final String superclassType;
        public final String[] interfaces;
        public final boolean[] staticMethods;
        public final String[] directMethods;
        public final VirtualMethod[] virtualMethods;
        public final String[][] instanceFields;

        public UnresolvedClassInfo(String dexFilePath, ClassDefItem classDefItem) {
            this.dexFilePath = dexFilePath;
            this.classType = classDefItem.getClassType().getTypeDescriptor();
            this.isPublic = (classDefItem.getAccessFlags() & AccessFlags.PUBLIC.getValue()) != 0;
            this.isInterface = (classDefItem.getAccessFlags() & AccessFlags.INTERFACE.getValue()) != 0;
            TypeIdItem superclassType = classDefItem.getSuperclass();
            this.superclassType = superclassType == null ? null : superclassType.getTypeDescriptor();
            this.interfaces = this.loadInterfaces(classDefItem);
            ClassDataItem classDataItem = classDefItem.getClassData();
            if (classDataItem != null) {
                boolean[][] _staticMethods = new boolean[1][];
                this.directMethods = this.loadDirectMethods(classDataItem, _staticMethods);
                this.staticMethods = _staticMethods[0];
                this.virtualMethods = this.loadVirtualMethods(classDataItem);
                this.instanceFields = this.loadInstanceFields(classDataItem);
            } else {
                this.staticMethods = null;
                this.directMethods = null;
                this.virtualMethods = null;
                this.instanceFields = null;
            }
        }

        private String[] loadInterfaces(ClassDefItem classDefItem) {
            List<TypeIdItem> types;
            TypeListItem typeList = classDefItem.getInterfaces();
            if (typeList != null && (types = typeList.getTypes()) != null && types.size() > 0) {
                String[] interfaces = new String[types.size()];
                for (int i = 0; i < interfaces.length; ++i) {
                    interfaces[i] = types.get(i).getTypeDescriptor();
                }
                return interfaces;
            }
            return null;
        }

        private String[] loadDirectMethods(ClassDataItem classDataItem, boolean[][] _staticMethods) {
            List<ClassDataItem.EncodedMethod> encodedMethods = classDataItem.getDirectMethods();
            if (encodedMethods.size() > 0) {
                boolean[] staticMethods = new boolean[encodedMethods.size()];
                String[] directMethods = new String[encodedMethods.size()];
                for (int i = 0; i < encodedMethods.size(); ++i) {
                    ClassDataItem.EncodedMethod encodedMethod = encodedMethods.get(i);
                    if ((encodedMethod.accessFlags & AccessFlags.STATIC.getValue()) != 0) {
                        staticMethods[i] = true;
                    }
                    directMethods[i] = encodedMethod.method.getShortMethodString();
                }
                _staticMethods[0] = staticMethods;
                return directMethods;
            }
            return null;
        }

        private VirtualMethod[] loadVirtualMethods(ClassDataItem classDataItem) {
            List<ClassDataItem.EncodedMethod> encodedMethods = classDataItem.getVirtualMethods();
            if (encodedMethods.size() > 0) {
                VirtualMethod[] virtualMethods = new VirtualMethod[encodedMethods.size()];
                for (int i = 0; i < encodedMethods.size(); ++i) {
                    virtualMethods[i] = new VirtualMethod();
                    ClassDataItem.EncodedMethod encodedMethod = encodedMethods.get(i);
                    virtualMethods[i].isPackagePrivate = UnresolvedClassInfo.methodIsPackagePrivate(encodedMethod.accessFlags);
                    virtualMethods[i].containingClass = classDataItem.getParentType().getTypeDescriptor();
                    virtualMethods[i].method = encodedMethods.get((int)i).method.getShortMethodString();
                }
                return virtualMethods;
            }
            return null;
        }

        private static boolean methodIsPackagePrivate(int accessFlags) {
            return (accessFlags & (AccessFlags.PRIVATE.getValue() | AccessFlags.PROTECTED.getValue() | AccessFlags.PUBLIC.getValue())) == 0;
        }

        private String[][] loadInstanceFields(ClassDataItem classDataItem) {
            List<ClassDataItem.EncodedField> encodedFields = classDataItem.getInstanceFields();
            if (encodedFields.size() > 0) {
                String[][] instanceFields = new String[encodedFields.size()][2];
                for (int i = 0; i < encodedFields.size(); ++i) {
                    ClassDataItem.EncodedField encodedField = encodedFields.get(i);
                    instanceFields[i][0] = encodedField.field.getFieldName().getStringValue();
                    instanceFields[i][1] = encodedField.field.getFieldType().getTypeDescriptor();
                }
                return instanceFields;
            }
            return null;
        }
    }

    private static class VirtualMethod {
        public String containingClass;
        public String method;
        public boolean isPackagePrivate;

        private VirtualMethod() {
        }
    }

    public static class ClassDef
    implements Comparable<ClassDef> {
        private final String classType;
        private final ClassDef superclass;
        private final TreeSet<ClassDef> implementedInterfaces;
        private final boolean isInterface;
        private final int classDepth;
        private final boolean isPublic;
        private final VirtualMethod[] vtable;
        private final HashMap<String, Integer> methodLookup;
        private final SparseArray<FieldDef> instanceFields;
        public static final int ArrayClassDef = 0;
        public static final int PrimitiveClassDef = 1;
        public static final int UnresolvedClassDef = 2;
        private static final int DirectMethod = -1;
        private static final int StaticMethod = -2;
        private VirtualMethod[] virtualMethods;
        private LinkedHashMap<String, ClassDef> interfaceTable;

        protected ClassDef(String classType, int classFlavor) {
            if (classFlavor == 0) {
                assert (classType.charAt(0) == '[');
                this.classType = classType;
                this.superclass = theClassPath.javaLangObjectClassDef;
                this.implementedInterfaces = new TreeSet();
                this.implementedInterfaces.add(ClassPath.getClassDef("Ljava/lang/Cloneable;"));
                this.implementedInterfaces.add(ClassPath.getClassDef("Ljava/io/Serializable;"));
                this.isInterface = false;
                this.isPublic = true;
                this.vtable = this.superclass.vtable;
                this.methodLookup = this.superclass.methodLookup;
                this.instanceFields = this.superclass.instanceFields;
                this.classDepth = 1;
                this.virtualMethods = null;
                this.interfaceTable = null;
            } else if (classFlavor == 1) {
                assert (classType.charAt(0) != '[' && classType.charAt(0) != 'L');
                this.classType = classType;
                this.superclass = null;
                this.implementedInterfaces = null;
                this.isInterface = false;
                this.isPublic = true;
                this.vtable = null;
                this.methodLookup = null;
                this.instanceFields = null;
                this.classDepth = 0;
                this.virtualMethods = null;
                this.interfaceTable = null;
            } else {
                assert (classType.charAt(0) == 'L');
                this.classType = classType;
                this.superclass = ClassPath.getClassDef("Ljava/lang/Object;");
                this.implementedInterfaces = new TreeSet();
                this.isInterface = false;
                this.isPublic = true;
                this.vtable = this.superclass.vtable;
                this.methodLookup = this.superclass.methodLookup;
                this.instanceFields = this.superclass.instanceFields;
                this.classDepth = 1;
                this.virtualMethods = null;
                this.interfaceTable = null;
            }
        }

        protected ClassDef(UnresolvedClassInfo classInfo) {
            int i;
            this.classType = classInfo.classType;
            this.isPublic = classInfo.isPublic;
            this.isInterface = classInfo.isInterface;
            this.superclass = this.loadSuperclass(classInfo);
            this.classDepth = this.superclass == null ? 0 : this.superclass.classDepth + 1;
            this.implementedInterfaces = this.loadAllImplementedInterfaces(classInfo);
            this.interfaceTable = this.loadInterfaceTable(classInfo);
            this.virtualMethods = classInfo.virtualMethods;
            this.vtable = this.loadVtable(classInfo);
            int directMethodCount = 0;
            if (classInfo.directMethods != null) {
                directMethodCount = classInfo.directMethods.length;
            }
            this.methodLookup = new HashMap((int)Math.ceil((float)(this.vtable.length + directMethodCount) / 0.7f), 0.75f);
            for (i = 0; i < this.vtable.length; ++i) {
                this.methodLookup.put(this.vtable[i].method, i);
            }
            if (directMethodCount > 0) {
                for (i = 0; i < classInfo.directMethods.length; ++i) {
                    if (classInfo.staticMethods[i]) {
                        this.methodLookup.put(classInfo.directMethods[i], -2);
                        continue;
                    }
                    this.methodLookup.put(classInfo.directMethods[i], -1);
                }
            }
            this.instanceFields = this.loadFields(classInfo);
        }

        public String getClassType() {
            return this.classType;
        }

        public ClassDef getSuperclass() {
            return this.superclass;
        }

        public int getClassDepth() {
            return this.classDepth;
        }

        public boolean isInterface() {
            return this.isInterface;
        }

        public boolean isPublic() {
            return this.isPublic;
        }

        public boolean extendsClass(ClassDef superclassDef) {
            if (superclassDef == null) {
                return false;
            }
            if (this == superclassDef) {
                return true;
            }
            if (superclassDef instanceof UnresolvedClassDef) {
                throw ((UnresolvedClassDef)superclassDef).unresolvedValidationException();
            }
            int superclassDepth = superclassDef.classDepth;
            ClassDef ancestor = this;
            while (ancestor.classDepth > superclassDepth) {
                ancestor = ancestor.getSuperclass();
            }
            return ancestor == superclassDef;
        }

        public boolean implementsInterface(ClassDef interfaceDef) {
            assert (!(interfaceDef instanceof UnresolvedClassDef));
            return this.implementedInterfaces.contains(interfaceDef);
        }

        public boolean hasVirtualMethod(String method) {
            Integer val = this.methodLookup.get(method);
            return val != null && val >= 0;
        }

        public int getMethodType(String method) {
            Integer val = this.methodLookup.get(method);
            if (val == null) {
                return -1;
            }
            if (val >= 0) {
                return 0;
            }
            if (val == -1) {
                return 1;
            }
            if (val == -2) {
                return 2;
            }
            throw new RuntimeException("Unexpected method type");
        }

        public FieldDef getInstanceField(int fieldOffset) {
            return this.instanceFields.get(fieldOffset, null);
        }

        public String getVirtualMethod(int vtableIndex) {
            if (vtableIndex < 0 || vtableIndex >= this.vtable.length) {
                return null;
            }
            return this.vtable[vtableIndex].method;
        }

        private void swap(byte[] fieldTypes, FieldDef[] fields, int position1, int position2) {
            byte tempType = fieldTypes[position1];
            fieldTypes[position1] = fieldTypes[position2];
            fieldTypes[position2] = tempType;
            FieldDef tempField = fields[position1];
            fields[position1] = fields[position2];
            fields[position2] = tempField;
        }

        private ClassDef loadSuperclass(UnresolvedClassInfo classInfo) {
            ClassDef superclass;
            if (classInfo.classType.equals("Ljava/lang/Object;")) {
                if (classInfo.superclassType != null) {
                    throw new ExceptionWithContext("Invalid superclass " + classInfo.superclassType + " for Ljava/lang/Object;. " + "The Object class cannot have a superclass");
                }
                return null;
            }
            String superclassType = classInfo.superclassType;
            if (superclassType == null) {
                throw new ExceptionWithContext(classInfo.classType + " has no superclass");
            }
            try {
                superclass = ClassPath.getClassDef(superclassType);
            }
            catch (Exception ex) {
                throw ExceptionWithContext.withContext(ex, String.format("Could not find superclass %s", superclassType));
            }
            if (!this.isInterface && superclass.isInterface) {
                throw new ValidationException("Class " + this.classType + " has the interface " + superclass.classType + " as its superclass");
            }
            if (this.isInterface && !superclass.isInterface && superclass != theClassPath.javaLangObjectClassDef) {
                throw new ValidationException("Interface " + this.classType + " has the non-interface class " + superclass.classType + " as its superclass");
            }
            return superclass;
        }

        private static void addInterfaceToSet(Set<ClassDef> interfaces, ClassDef iface) {
            if (interfaces.add(iface)) {
                for (ClassDef subiface : iface.implementedInterfaces) {
                    ClassDef.addInterfaceToSet(interfaces, subiface);
                }
            }
        }

        private TreeSet<ClassDef> loadAllImplementedInterfaces(UnresolvedClassInfo classInfo) {
            assert (this.classType != null);
            assert (this.classType.equals("Ljava/lang/Object;") || this.superclass != null);
            assert (classInfo != null);
            TreeSet<ClassDef> implementedInterfaceSet = new TreeSet<ClassDef>();
            if (this.superclass != null) {
                for (ClassDef interfaceDef : this.superclass.implementedInterfaces) {
                    ClassDef.addInterfaceToSet(implementedInterfaceSet, interfaceDef);
                }
            }
            if (classInfo.interfaces != null) {
                for (String interfaceType : classInfo.interfaces) {
                    ClassDef interfaceDef;
                    try {
                        interfaceDef = ClassPath.getClassDef(interfaceType);
                    }
                    catch (Exception ex) {
                        throw ExceptionWithContext.withContext(ex, String.format("Could not find interface %s", interfaceType));
                    }
                    assert (interfaceDef.isInterface());
                    ClassDef.addInterfaceToSet(implementedInterfaceSet, interfaceDef);
                }
            }
            return implementedInterfaceSet;
        }

        private LinkedHashMap<String, ClassDef> loadInterfaceTable(UnresolvedClassInfo classInfo) {
            if (classInfo.interfaces == null) {
                return null;
            }
            LinkedHashMap<String, ClassDef> interfaceTable = new LinkedHashMap<String, ClassDef>();
            for (String interfaceType : classInfo.interfaces) {
                ClassDef interfaceDef;
                if (interfaceTable.containsKey(interfaceType)) continue;
                try {
                    interfaceDef = ClassPath.getClassDef(interfaceType);
                }
                catch (Exception ex) {
                    throw ExceptionWithContext.withContext(ex, String.format("Could not find interface %s", interfaceType));
                }
                interfaceTable.put(interfaceType, interfaceDef);
                if (interfaceDef.interfaceTable == null) continue;
                for (ClassDef superInterface : interfaceDef.interfaceTable.values()) {
                    if (interfaceTable.containsKey(superInterface.classType)) continue;
                    interfaceTable.put(superInterface.classType, superInterface);
                }
            }
            return interfaceTable;
        }

        private VirtualMethod[] loadVtable(UnresolvedClassInfo classInfo) {
            LinkedList<VirtualMethod> virtualMethodList = new LinkedList<VirtualMethod>();
            boolean methodIndex = false;
            if (this.superclass != null) {
                for (int i = 0; i < this.superclass.vtable.length; ++i) {
                    virtualMethodList.add(this.superclass.vtable[i]);
                }
                assert (this.superclass.instanceFields != null);
            }
            if (!this.isInterface) {
                if (classInfo.virtualMethods != null) {
                    this.addToVtable(classInfo.virtualMethods, virtualMethodList);
                }
                if (this.interfaceTable != null) {
                    for (ClassDef interfaceDef : this.interfaceTable.values()) {
                        if (interfaceDef.virtualMethods == null) continue;
                        this.addToVtable(interfaceDef.virtualMethods, virtualMethodList);
                    }
                }
            }
            VirtualMethod[] vtable = new VirtualMethod[virtualMethodList.size()];
            for (int i = 0; i < virtualMethodList.size(); ++i) {
                vtable[i] = (VirtualMethod)virtualMethodList.get(i);
            }
            return vtable;
        }

        private void addToVtable(VirtualMethod[] localMethods, List<VirtualMethod> vtable) {
            for (VirtualMethod virtualMethod : localMethods) {
                boolean found = false;
                for (int i = 0; i < vtable.size(); ++i) {
                    VirtualMethod superMethod = vtable.get(i);
                    if (!superMethod.method.equals(virtualMethod.method) || theClassPath.checkPackagePrivateAccess && !this.canAccess(superMethod)) continue;
                    found = true;
                    vtable.set(i, virtualMethod);
                    break;
                }
                if (found) continue;
                vtable.add(virtualMethod);
            }
        }

        private boolean canAccess(VirtualMethod virtualMethod) {
            if (!virtualMethod.isPackagePrivate) {
                return true;
            }
            String otherPackage = this.getPackage(virtualMethod.containingClass);
            String ourPackage = this.getPackage(this.classType);
            return otherPackage.equals(ourPackage);
        }

        private String getPackage(String classType) {
            int lastSlash = classType.lastIndexOf(47);
            if (lastSlash < 0) {
                return "";
            }
            return classType.substring(1, lastSlash);
        }

        private int getNextFieldOffset() {
            if (this.instanceFields == null || this.instanceFields.size() == 0) {
                return 8;
            }
            int lastItemIndex = this.instanceFields.size() - 1;
            int fieldOffset = this.instanceFields.keyAt(lastItemIndex);
            FieldDef lastField = this.instanceFields.valueAt(lastItemIndex);
            switch (lastField.type.charAt(0)) {
                case 'D': 
                case 'J': {
                    return fieldOffset + 8;
                }
            }
            return fieldOffset + 4;
        }

        private SparseArray<FieldDef> loadFields(UnresolvedClassInfo classInfo) {
            int fieldOffset;
            int front;
            boolean REFERENCE = false;
            boolean WIDE = true;
            int OTHER = 2;
            FieldDef[] fields = null;
            byte[] fieldTypes = null;
            if (classInfo.instanceFields != null) {
                fields = new FieldDef[classInfo.instanceFields.length];
                fieldTypes = new byte[fields.length];
                for (int i = 0; i < fields.length; ++i) {
                    String[] fieldInfo = classInfo.instanceFields[i];
                    String fieldName = fieldInfo[0];
                    String fieldType = fieldInfo[1];
                    fieldTypes[i] = this.getFieldType(fieldType);
                    fields[i] = new FieldDef(classInfo.classType, fieldName, fieldType);
                }
            }
            if (fields == null) {
                fields = new FieldDef[]{};
                fieldTypes = new byte[]{};
            }
            int back = fields.length - 1;
            for (front = 0; front < fields.length; ++front) {
                if (fieldTypes[front] != 0) {
                    while (back > front) {
                        if (fieldTypes[back] == 0) {
                            this.swap(fieldTypes, fields, front, back--);
                            break;
                        }
                        --back;
                    }
                }
                if (fieldTypes[front] != 0) break;
            }
            int startFieldOffset = 8;
            if (this.superclass != null) {
                startFieldOffset = this.superclass.getNextFieldOffset();
            }
            int fieldIndexMod = startFieldOffset % 8 == 0 ? 0 : 1;
            if (front < fields.length && front % 2 != fieldIndexMod) {
                if (fieldTypes[front] == 1) {
                    for (back = fields.length - 1; back > front; --back) {
                        if (fieldTypes[back] != 2) continue;
                        this.swap(fieldTypes, fields, front++, back);
                        break;
                    }
                } else {
                    ++front;
                }
            }
            back = fields.length - 1;
            while (front < fields.length) {
                if (fieldTypes[front] != 1) {
                    while (back > front) {
                        if (fieldTypes[back] == 1) {
                            this.swap(fieldTypes, fields, front, back--);
                            break;
                        }
                        --back;
                    }
                }
                if (fieldTypes[front] != 1) break;
                ++front;
            }
            int superFieldCount = 0;
            if (this.superclass != null) {
                superFieldCount = this.superclass.instanceFields.size();
            }
            int totalFieldCount = superFieldCount + fields.length;
            SparseArray<FieldDef> instanceFields = new SparseArray<FieldDef>(totalFieldCount);
            if (this.superclass != null && superFieldCount > 0) {
                for (int i = 0; i < superFieldCount; ++i) {
                    instanceFields.append(this.superclass.instanceFields.keyAt(i), this.superclass.instanceFields.valueAt(i));
                }
                fieldOffset = instanceFields.keyAt(superFieldCount - 1);
                FieldDef lastSuperField = this.superclass.instanceFields.valueAt(superFieldCount - 1);
                char fieldType = lastSuperField.type.charAt(0);
                fieldOffset = fieldType == 'J' || fieldType == 'D' ? (fieldOffset += 8) : (fieldOffset += 4);
            } else {
                fieldOffset = 8;
            }
            boolean gotDouble = false;
            for (int i = 0; i < fields.length; ++i) {
                FieldDef field = fields[i];
                if (fieldTypes[i] == 1 && !gotDouble && !gotDouble) {
                    if (fieldOffset % 8 != 0) {
                        assert (fieldOffset % 8 == 4);
                        fieldOffset += 4;
                    }
                    gotDouble = true;
                }
                instanceFields.append(fieldOffset, field);
                if (fieldTypes[i] == 1) {
                    fieldOffset += 8;
                    continue;
                }
                fieldOffset += 4;
            }
            return instanceFields;
        }

        private byte getFieldType(String fieldType) {
            switch (fieldType.charAt(0)) {
                case 'L': 
                case '[': {
                    return 0;
                }
                case 'D': 
                case 'J': {
                    return 1;
                }
            }
            return 2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ClassDef)) {
                return false;
            }
            ClassDef classDef = (ClassDef)o;
            return this.classType.equals(classDef.classType);
        }

        public int hashCode() {
            return this.classType.hashCode();
        }

        @Override
        public int compareTo(ClassDef classDef) {
            return this.classType.compareTo(classDef.classType);
        }
    }

    public static class FieldDef {
        public final String definingClass;
        public final String name;
        public final String type;

        public FieldDef(String definingClass, String name, String type) {
            this.definingClass = definingClass;
            this.name = name;
            this.type = type;
        }
    }

    public static class UnresolvedClassDef
    extends ClassDef {
        protected UnresolvedClassDef(String unresolvedClassDef) {
            super(unresolvedClassDef, 2);
            assert (unresolvedClassDef.charAt(0) == 'L');
        }

        protected ValidationException unresolvedValidationException() {
            return new ValidationException(String.format("class %s cannot be resolved.", this.getClassType()));
        }

        @Override
        public ClassDef getSuperclass() {
            return theClassPath.javaLangObjectClassDef;
        }

        @Override
        public int getClassDepth() {
            throw this.unresolvedValidationException();
        }

        @Override
        public boolean isInterface() {
            throw this.unresolvedValidationException();
        }

        @Override
        public boolean extendsClass(ClassDef superclassDef) {
            if (superclassDef != theClassPath.javaLangObjectClassDef && superclassDef != this) {
                throw this.unresolvedValidationException();
            }
            return true;
        }

        @Override
        public boolean implementsInterface(ClassDef interfaceDef) {
            throw this.unresolvedValidationException();
        }

        @Override
        public boolean hasVirtualMethod(String method) {
            if (!super.hasVirtualMethod(method)) {
                throw this.unresolvedValidationException();
            }
            return true;
        }
    }

    public static class PrimitiveClassDef
    extends ClassDef {
        protected PrimitiveClassDef(String primitiveClassType) {
            super(primitiveClassType, 1);
            assert (primitiveClassType.charAt(0) != 'L' && primitiveClassType.charAt(0) != '[');
        }
    }

    public static class ArrayClassDef
    extends ClassDef {
        private final ClassDef elementClass;
        private final int arrayDimensions;

        protected ArrayClassDef(String arrayClassType) {
            super(arrayClassType, 0);
            assert (arrayClassType.charAt(0) == '[');
            int i = 0;
            while (arrayClassType.charAt(i) == '[') {
                ++i;
            }
            String elementClassType = arrayClassType.substring(i);
            if (i > 256) {
                throw new ExceptionWithContext("Error while creating array class for element type " + elementClassType + " with " + i + " dimensions. The maximum number of dimensions is 256");
            }
            try {
                this.elementClass = ClassPath.getClassDef(arrayClassType.substring(i));
            }
            catch (Exception ex) {
                throw ExceptionWithContext.withContext(ex, "Error while creating array class " + arrayClassType);
            }
            this.arrayDimensions = i;
        }

        public ClassDef getBaseElementClass() {
            return this.elementClass;
        }

        public ClassDef getImmediateElementClass() {
            if (this.arrayDimensions == 1) {
                return this.elementClass;
            }
            return ClassPath.getArrayClassDefByElementClassAndDimension(this.elementClass, this.arrayDimensions - 1);
        }

        public int getArrayDimensions() {
            return this.arrayDimensions;
        }

        @Override
        public boolean extendsClass(ClassDef superclassDef) {
            if (!(superclassDef instanceof ArrayClassDef)) {
                if (superclassDef == theClassPath.javaLangObjectClassDef) {
                    return true;
                }
                if (superclassDef.isInterface) {
                    return this.implementsInterface(superclassDef);
                }
                return false;
            }
            ArrayClassDef arraySuperclassDef = (ArrayClassDef)superclassDef;
            if (this.arrayDimensions == arraySuperclassDef.arrayDimensions) {
                ClassDef baseElementClass = arraySuperclassDef.getBaseElementClass();
                if (baseElementClass.isInterface) {
                    return true;
                }
                return baseElementClass.extendsClass(arraySuperclassDef.getBaseElementClass());
            }
            if (this.arrayDimensions > arraySuperclassDef.arrayDimensions) {
                ClassDef baseElementClass = arraySuperclassDef.getBaseElementClass();
                if (baseElementClass.isInterface) {
                    return true;
                }
                return baseElementClass == theClassPath.javaLangObjectClassDef;
            }
            return false;
        }
    }
}

