/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib.AnnotationDirectoryItem;
import org.jf.dexlib.ClassDataItem;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.EncodedArrayItem;
import org.jf.dexlib.EncodedValue.ArrayEncodedSubValue;
import org.jf.dexlib.EncodedValue.EncodedValue;
import org.jf.dexlib.IndexedSection;
import org.jf.dexlib.Item;
import org.jf.dexlib.ItemType;
import org.jf.dexlib.ReadContext;
import org.jf.dexlib.StringIdItem;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.TypeListItem;
import org.jf.dexlib.Util.AccessFlags;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.Input;
import org.jf.dexlib.Util.TypeUtils;

public class ClassDefItem
extends Item<ClassDefItem> {
    private TypeIdItem classType;
    private int accessFlags;
    @Nullable
    private TypeIdItem superType;
    @Nullable
    private TypeListItem implementedInterfaces;
    @Nullable
    private StringIdItem sourceFile;
    @Nullable
    private AnnotationDirectoryItem annotations;
    @Nullable
    private ClassDataItem classData;
    @Nullable
    private EncodedArrayItem staticFieldInitializers;

    protected ClassDefItem(DexFile dexFile) {
        super(dexFile);
    }

    private ClassDefItem(DexFile dexFile, TypeIdItem classType, int accessFlags, @Nullable TypeIdItem superType, @Nullable TypeListItem implementedInterfaces, @Nullable StringIdItem sourceFile, @Nullable AnnotationDirectoryItem annotations, @Nullable ClassDataItem classData, @Nullable EncodedArrayItem staticFieldInitializers) {
        super(dexFile);
        assert (classType != null);
        this.classType = classType;
        this.accessFlags = accessFlags;
        this.superType = superType;
        this.implementedInterfaces = implementedInterfaces;
        this.sourceFile = sourceFile;
        this.annotations = annotations;
        this.classData = classData;
        this.staticFieldInitializers = staticFieldInitializers;
    }

    public static ClassDefItem internClassDefItem(DexFile dexFile, TypeIdItem classType, int accessFlags, @Nullable TypeIdItem superType, @Nullable TypeListItem implementedInterfaces, @Nullable StringIdItem sourceFile, @Nullable AnnotationDirectoryItem annotations, @Nullable ClassDataItem classData, @Nullable List<StaticFieldInitializer> staticFieldInitializers) {
        EncodedArrayItem encodedArrayItem = null;
        if (!dexFile.getInplace() && staticFieldInitializers != null && staticFieldInitializers.size() > 0) {
            assert (classData != null);
            assert (staticFieldInitializers.size() == classData.getStaticFieldCount());
            encodedArrayItem = ClassDefItem.makeStaticFieldInitializersItem(dexFile, staticFieldInitializers);
        }
        ClassDefItem classDefItem = new ClassDefItem(dexFile, classType, accessFlags, superType, implementedInterfaces, sourceFile, annotations, classData, encodedArrayItem);
        return dexFile.ClassDefsSection.intern(classDefItem);
    }

    @Override
    protected void readItem(Input in, ReadContext readContext) {
        this.classType = this.dexFile.TypeIdsSection.getItemByIndex(in.readInt());
        this.accessFlags = in.readInt();
        this.superType = this.dexFile.TypeIdsSection.getOptionalItemByIndex(in.readInt());
        this.implementedInterfaces = (TypeListItem)readContext.getOptionalOffsettedItemByOffset(ItemType.TYPE_TYPE_LIST, in.readInt());
        this.sourceFile = this.dexFile.StringIdsSection.getOptionalItemByIndex(in.readInt());
        this.annotations = (AnnotationDirectoryItem)readContext.getOptionalOffsettedItemByOffset(ItemType.TYPE_ANNOTATIONS_DIRECTORY_ITEM, in.readInt());
        this.classData = (ClassDataItem)readContext.getOptionalOffsettedItemByOffset(ItemType.TYPE_CLASS_DATA_ITEM, in.readInt());
        this.staticFieldInitializers = (EncodedArrayItem)readContext.getOptionalOffsettedItemByOffset(ItemType.TYPE_ENCODED_ARRAY_ITEM, in.readInt());
    }

    @Override
    protected int placeItem(int offset) {
        return offset + 32;
    }

    @Override
    protected void writeItem(AnnotatedOutput out) {
        if (out.annotates()) {
            out.annotate(4, "class_type: " + this.classType.getTypeDescriptor());
            out.annotate(4, "access_flags: " + AccessFlags.formatAccessFlagsForClass(this.accessFlags));
            out.annotate(4, "superclass_type: " + (this.superType == null ? "" : this.superType.getTypeDescriptor()));
            out.annotate(4, "interfaces: " + (this.implementedInterfaces == null ? "" : this.implementedInterfaces.getTypeListString(" ")));
            out.annotate(4, "source_file: " + (this.sourceFile == null ? "" : this.sourceFile.getStringValue()));
            out.annotate(4, "annotations_off: " + (this.annotations == null ? "" : "0x" + Integer.toHexString(this.annotations.getOffset())));
            out.annotate(4, "class_data_off:" + (this.classData == null ? "" : "0x" + Integer.toHexString(this.classData.getOffset())));
            out.annotate(4, "static_values_off: " + (this.staticFieldInitializers == null ? "" : "0x" + Integer.toHexString(this.staticFieldInitializers.getOffset())));
        }
        out.writeInt(this.classType.getIndex());
        out.writeInt(this.accessFlags);
        out.writeInt(this.superType == null ? -1 : this.superType.getIndex());
        out.writeInt(this.implementedInterfaces == null ? 0 : this.implementedInterfaces.getOffset());
        out.writeInt(this.sourceFile == null ? -1 : this.sourceFile.getIndex());
        out.writeInt(this.annotations == null ? 0 : this.annotations.getOffset());
        out.writeInt(this.classData == null ? 0 : this.classData.getOffset());
        out.writeInt(this.staticFieldInitializers == null ? 0 : this.staticFieldInitializers.getOffset());
    }

    @Override
    public ItemType getItemType() {
        return ItemType.TYPE_CLASS_DEF_ITEM;
    }

    @Override
    public String getConciseIdentity() {
        return "class_def_item: " + this.classType.getTypeDescriptor();
    }

    @Override
    public int compareTo(ClassDefItem o) {
        return this.getOffset() - o.getOffset();
    }

    public TypeIdItem getClassType() {
        return this.classType;
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    @Nullable
    public TypeIdItem getSuperclass() {
        return this.superType;
    }

    @Nullable
    public TypeListItem getInterfaces() {
        return this.implementedInterfaces;
    }

    @Nullable
    public StringIdItem getSourceFile() {
        return this.sourceFile;
    }

    @Nullable
    public AnnotationDirectoryItem getAnnotations() {
        return this.annotations;
    }

    @Nullable
    public ClassDataItem getClassData() {
        return this.classData;
    }

    @Nullable
    public EncodedArrayItem getStaticFieldInitializers() {
        return this.staticFieldInitializers;
    }

    public static int placeClassDefItems(IndexedSection<ClassDefItem> section, int offset) {
        ClassDefPlacer cdp = new ClassDefPlacer(section);
        return cdp.placeSection(offset);
    }

    private static EncodedArrayItem makeStaticFieldInitializersItem(DexFile dexFile, @Nonnull List<StaticFieldInitializer> staticFieldInitializers) {
        if (staticFieldInitializers.size() == 0) {
            return null;
        }
        int len = staticFieldInitializers.size();
        staticFieldInitializers = new ArrayList<StaticFieldInitializer>(staticFieldInitializers);
        Collections.sort(staticFieldInitializers);
        int lastIndex = -1;
        for (int i = len - 1; i >= 0; --i) {
            StaticFieldInitializer staticFieldInitializer = staticFieldInitializers.get(i);
            if (staticFieldInitializer.value == null || staticFieldInitializer.value.compareTo(TypeUtils.makeDefaultValueForType(staticFieldInitializer.field.field.getFieldType())) == 0) continue;
            lastIndex = i;
            break;
        }
        if (lastIndex == -1) {
            return null;
        }
        EncodedValue[] values = new EncodedValue[lastIndex + 1];
        for (int i = 0; i <= lastIndex; ++i) {
            StaticFieldInitializer staticFieldInitializer = staticFieldInitializers.get(i);
            EncodedValue encodedValue = staticFieldInitializer.value;
            if (encodedValue == null) {
                encodedValue = TypeUtils.makeDefaultValueForType(staticFieldInitializer.field.field.getFieldType());
            }
            values[i] = encodedValue;
        }
        ArrayEncodedSubValue encodedArrayValue = new ArrayEncodedSubValue(values);
        return EncodedArrayItem.internEncodedArrayItem(dexFile, encodedArrayValue);
    }

    public static class StaticFieldInitializer
    implements Comparable<StaticFieldInitializer> {
        public final EncodedValue value;
        public final ClassDataItem.EncodedField field;

        public StaticFieldInitializer(EncodedValue value, ClassDataItem.EncodedField field) {
            this.value = value;
            this.field = field;
        }

        @Override
        public int compareTo(StaticFieldInitializer other) {
            return this.field.compareTo(other.field);
        }
    }

    private static class ClassDefPlacer {
        private final IndexedSection<ClassDefItem> section;
        private final HashMap<TypeIdItem, ClassDefItem> unplacedClassDefsByType = new HashMap();
        private int currentIndex = 0;
        private int currentOffset;

        public ClassDefPlacer(IndexedSection<ClassDefItem> section) {
            this.section = section;
            for (ClassDefItem classDefItem : section.items) {
                TypeIdItem typeIdItem = classDefItem.classType;
                this.unplacedClassDefsByType.put(typeIdItem, classDefItem);
            }
        }

        public int placeSection(int offset) {
            this.currentOffset = offset;
            if (this.section.DexFile.getSortAllItems()) {
                Collections.sort(this.section.items, new Comparator<ClassDefItem>(){

                    @Override
                    public int compare(ClassDefItem a, ClassDefItem b) {
                        return a.getClassType().compareTo(b.getClassType());
                    }
                });
            }
            for (ClassDefItem classDefItem : this.section.items) {
                classDefItem.offset = -1;
            }
            for (ClassDefItem classDefItem : this.section.items) {
                this.placeClass(classDefItem);
            }
            for (ClassDefItem classDefItem : this.unplacedClassDefsByType.values()) {
                this.section.items.set(classDefItem.getIndex(), classDefItem);
            }
            return this.currentOffset;
        }

        private void placeClass(ClassDefItem classDefItem) {
            if (!classDefItem.isPlaced()) {
                TypeListItem interfaces;
                TypeIdItem superType = classDefItem.superType;
                ClassDefItem superClassDefItem = this.unplacedClassDefsByType.get(superType);
                if (superClassDefItem != null) {
                    this.placeClass(superClassDefItem);
                }
                if ((interfaces = classDefItem.implementedInterfaces) != null) {
                    for (TypeIdItem interfaceType : interfaces.getTypes()) {
                        ClassDefItem interfaceClass = this.unplacedClassDefsByType.get(interfaceType);
                        if (interfaceClass == null) continue;
                        this.placeClass(interfaceClass);
                    }
                }
                this.currentOffset = classDefItem.placeAt(this.currentOffset, this.currentIndex++);
                this.unplacedClassDefsByType.remove(classDefItem.classType);
            }
        }
    }
}

