/*
 * Decompiled with CFR 0.152.
 */
package ghidra.javaclass.format.constantpool;

import ghidra.app.util.bin.BinaryReader;
import ghidra.javaclass.format.constantpool.AbstractConstantPoolInfoJava;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ConstantPoolNameAndTypeInfo
extends AbstractConstantPoolInfoJava {
    private short nameIndex;
    private short descriptorIndex;

    public ConstantPoolNameAndTypeInfo(BinaryReader reader) throws IOException {
        super(reader);
        this.nameIndex = reader.readNextShort();
        this.descriptorIndex = reader.readNextShort();
    }

    public short getNameIndex() {
        return this.nameIndex;
    }

    public short getDescriptorIndex() {
        return this.descriptorIndex;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        String name = "CONSTANT_NameAndType_info";
        StructureDataType structure = new StructureDataType(name, 0);
        structure.add(BYTE, "tag", null);
        structure.add(WORD, "name_index", null);
        structure.add(WORD, "descriptor_index", null);
        return structure;
    }
}

