/*
 * Decompiled with CFR 0.152.
 */
package ghidra.javaclass.format.attributes;

import ghidra.app.util.bin.BinaryReader;
import ghidra.javaclass.format.attributes.AbstractAttributeInfo;
import ghidra.javaclass.format.attributes.AnnotationJava;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class RuntimeParameterAnnotationsAttribute
extends AbstractAttributeInfo {
    private boolean _isVisible;
    private byte numberOfParameters;
    private Map<Integer, AnnotationJava[]> parameterAnnotations = new HashMap<Integer, AnnotationJava[]>();

    public RuntimeParameterAnnotationsAttribute(BinaryReader reader, boolean isVisible) throws IOException {
        super(reader);
        this._isVisible = isVisible;
        this.numberOfParameters = reader.readNextByte();
        for (int i = 0; i < this.numberOfParameters; ++i) {
            int numberOfAnnotations = reader.readNextShort();
            AnnotationJava[] annotations = new AnnotationJava[numberOfAnnotations];
            for (int a = 0; a < numberOfAnnotations; ++a) {
                annotations[a] = new AnnotationJava(reader);
            }
            this.parameterAnnotations.put(i, annotations);
        }
    }

    public boolean isVisible() {
        return this._isVisible;
    }

    public byte getNumberOfParameters() {
        return this.numberOfParameters;
    }

    public AnnotationJava[] getParameterAnnotations(int parameter) {
        return this.parameterAnnotations.get(parameter);
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        String name = this._isVisible ? "RuntimeVisibleParameterAnnotations_attribute|" + this.numberOfParameters + "|" : "RuntimeInvisibleParameterAnnotations_attribute|" + this.numberOfParameters + "|";
        StructureDataType structure = this.getBaseStructure(name);
        structure.add(BYTE, "num_parameters", null);
        for (int i = 0; i < this.numberOfParameters; ++i) {
            structure.add(WORD, "num_annotations_" + i, null);
            AnnotationJava[] annotations = this.parameterAnnotations.get(i);
            for (int a = 0; a < annotations.length; ++a) {
                structure.add(annotations[a].toDataType(), "annotations_" + i + "_" + a, null);
            }
        }
        return structure;
    }
}

