/*
 * Decompiled with CFR 0.152.
 */
package ghidra.javaclass.format.attributes;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class InnerClass
implements StructConverter {
    private short innerClassInfoIndex;
    private short outerClassInfoIndex;
    private short innerNameIndex;
    private short innerClassAccessFlags;

    public InnerClass(BinaryReader reader) throws IOException {
        this.innerClassInfoIndex = reader.readNextShort();
        this.outerClassInfoIndex = reader.readNextShort();
        this.innerNameIndex = reader.readNextShort();
        this.innerClassAccessFlags = reader.readNextShort();
    }

    public short getInnerClassInfoIndex() {
        return this.innerClassInfoIndex;
    }

    public short getOuterClassInfoIndex() {
        return this.outerClassInfoIndex;
    }

    public short getInnerNameIndex() {
        return this.innerNameIndex;
    }

    public short getInnerClassAccessFlags() {
        return this.innerClassAccessFlags;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType("inner_class", 0);
        structure.add(WORD, "inner_class_info_index", null);
        structure.add(WORD, "outer_class_info_index", null);
        structure.add(WORD, "inner_name_index", null);
        structure.add(WORD, "inner_class_access_flags", null);
        return structure;
    }
}

