/*
 * Decompiled with CFR 0.152.
 */
package ghidra.javaclass.analyzers;

import ghidra.app.cmd.comments.SetCommentCmd;
import ghidra.app.cmd.disassemble.DisassembleCommand;
import ghidra.app.plugin.core.analysis.AnalysisWorker;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.model.DomainObject;
import ghidra.framework.options.Options;
import ghidra.javaclass.analyzers.AbstractJavaAnalyzer;
import ghidra.javaclass.format.ClassFileJava;
import ghidra.javaclass.format.DescriptorDecoder;
import ghidra.javaclass.format.FieldInfoJava;
import ghidra.javaclass.format.JavaClassUtil;
import ghidra.javaclass.format.MethodInfoJava;
import ghidra.javaclass.format.attributes.AbstractAttributeInfo;
import ghidra.javaclass.format.attributes.BootstrapMethods;
import ghidra.javaclass.format.attributes.BootstrapMethodsAttribute;
import ghidra.javaclass.format.attributes.CodeAttribute;
import ghidra.javaclass.format.attributes.LocalVariableJava;
import ghidra.javaclass.format.attributes.LocalVariableTableAttribute;
import ghidra.javaclass.format.constantpool.AbstractConstantPoolInfoJava;
import ghidra.javaclass.format.constantpool.ConstantPoolClassInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolDoubleInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolFieldReferenceInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolFloatInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolIntegerInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolInterfaceMethodReferenceInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolInvokeDynamicInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolLongInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolMethodHandleInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolMethodReferenceInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolMethodTypeInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolNameAndTypeInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolStringInfo;
import ghidra.javaclass.format.constantpool.ConstantPoolUtf8Info;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.lang.BasicCompilerSpec;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.ParameterImpl;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JavaAnalyzer
extends AbstractJavaAnalyzer
implements AnalysisWorker {
    private MessageLog log;

    public String getName() {
        return "Java Class Analyzer";
    }

    public AnalyzerType getAnalysisType() {
        return AnalyzerType.BYTE_ANALYZER;
    }

    public boolean getDefaultEnablement(Program program) {
        try {
            return JavaClassUtil.isClassFile(program);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getDescription() {
        return "Analyzes Java .class files.";
    }

    public AnalysisPriority getPriority() {
        return AnalysisPriority.FORMAT_ANALYSIS;
    }

    public boolean canAnalyze(Program program) {
        try {
            return JavaClassUtil.isClassFile(program);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isPrototype() {
        return false;
    }

    @Override
    public boolean analyze(Program program, AddressSetView set, TaskMonitor monitor, MessageLog messageLog) throws Exception {
        this.log = messageLog;
        AutoAnalysisManager manager = AutoAnalysisManager.getAnalysisManager((Program)program);
        return manager.scheduleWorker((AnalysisWorker)this, null, true, monitor);
    }

    public boolean analysisWorkerCallback(Program program, Object workerContext, TaskMonitor monitor) throws Exception {
        MemoryByteProvider provider;
        BinaryReader reader;
        ClassFileJava classFile;
        DataType classFileDataType;
        Address address = program.getAddressFactory().getAddressSpace("constantPool").getMinAddress();
        Data cpClassFileData = this.createData(program, address, classFileDataType = (classFile = new ClassFileJava(reader = new BinaryReader((ByteProvider)(provider = new MemoryByteProvider(program.getMemory(), address)), !program.getLanguage().isBigEndian()))).toDataType());
        if (cpClassFileData == null) {
            this.log.appendMsg("Unable to create header data.");
        }
        Data constantPoolData = cpClassFileData.getComponent(4);
        this.markupConstantPoolAndReferences(program, classFile, constantPoolData, monitor);
        this.createProgramDataTypes(program, classFile, monitor, this.log);
        this.markupFields(program, classFile, monitor);
        this.markupMethods(program, classFile, monitor);
        this.disassembleMethods(program, classFile, monitor);
        this.labelOperands(program, classFile);
        this.recordJavaVersionInfo(program, classFile);
        BasicCompilerSpec.enableJavaLanguageDecompilation((Program)program);
        return true;
    }

    private void disassembleMethods(Program program, ClassFileJava classFile, TaskMonitor monitor) throws MemoryAccessException, DuplicateNameException, InvalidInputException {
        MethodInfoJava[] methods = classFile.getMethods();
        int max = methods.length;
        for (int i = 0; i < max; ++i) {
            Address index = JavaClassUtil.toLookupAddress(program, i);
            int offset = program.getMemory().getInt(index);
            Address blockStart = program.getAddressFactory().getDefaultAddressSpace().getAddress((long)offset);
            DisassembleCommand cmd = new DisassembleCommand(blockStart, null, true);
            cmd.applyTo((DomainObject)program, monitor);
            Function function = this.createFunction(program, blockStart);
            if (function == null) continue;
            this.setFunctionInfo(function, methods[i], classFile, program.getDataTypeManager());
        }
    }

    private void createProgramDataTypes(Program program, ClassFileJava classFile, TaskMonitor monitor, MessageLog messageLog) {
        monitor.setMessage("JVM: processing class definitions");
        AbstractConstantPoolInfoJava[] constantPool = classFile.getConstantPool();
        DataTypeManager dtm = program.getDataTypeManager();
        int length = constantPool.length;
        for (int i = 0; i < length; ++i) {
            if (constantPool[i] instanceof ConstantPoolClassInfo) {
                this.addTypeForClassInfoElement(constantPool, i, dtm);
                continue;
            }
            if (!(constantPool[i] instanceof ConstantPoolNameAndTypeInfo)) continue;
            this.addTypesForNameAndTypeInfo(constantPool, i, dtm);
        }
    }

    private void addTypesForNameAndTypeInfo(AbstractConstantPoolInfoJava[] constantPool, int i, DataTypeManager dtm) {
        ConstantPoolNameAndTypeInfo nameAndType = (ConstantPoolNameAndTypeInfo)constantPool[i];
        ConstantPoolUtf8Info utf8 = (ConstantPoolUtf8Info)constantPool[nameAndType.getDescriptorIndex()];
        String descriptor = utf8.getString();
        if (descriptor.contains("(")) {
            List<String> classNames = DescriptorDecoder.getTypeNameList(descriptor, true, false);
            for (String className : classNames) {
                if (this.isPrimitiveType(className)) continue;
                DescriptorDecoder.resolveClassForString(className, dtm, (DataType)DWordDataType.dataType);
            }
        } else {
            String className = DescriptorDecoder.getTypeNameFromDescriptor(descriptor, true, false);
            if (this.isPrimitiveType(className)) {
                return;
            }
            DescriptorDecoder.resolveClassForString(className, dtm, (DataType)DWordDataType.dataType);
        }
    }

    private boolean isPrimitiveType(String type) {
        switch (type) {
            case "boolean": 
            case "byte": 
            case "short": 
            case "char": 
            case "int": 
            case "float": 
            case "long": 
            case "double": 
            case "void": {
                return true;
            }
        }
        return false;
    }

    private void addTypeForClassInfoElement(AbstractConstantPoolInfoJava[] constantPool, int index, DataTypeManager dtm) {
        ConstantPoolClassInfo classInfo = (ConstantPoolClassInfo)constantPool[index];
        short nameIndex = classInfo.getNameIndex();
        ConstantPoolUtf8Info utf8Info = (ConstantPoolUtf8Info)constantPool[nameIndex];
        DescriptorDecoder.resolveClassForString(utf8Info.getString(), dtm, (DataType)DWordDataType.dataType);
    }

    private void recordJavaVersionInfo(Program program, ClassFileJava classFile) {
        String javaVersion;
        Options programInfo = program.getOptions("Program Information");
        programInfo.setInt("Major Version", (int)classFile.getMajorVersion());
        programInfo.setInt("Minor Version", (int)classFile.getMinorVersion());
        switch (classFile.getMajorVersion()) {
            case 45: {
                javaVersion = "1.1";
                break;
            }
            case 46: {
                javaVersion = "1.2";
                break;
            }
            case 47: {
                javaVersion = "1.3";
                break;
            }
            case 48: {
                javaVersion = "1.4";
                break;
            }
            case 49: {
                javaVersion = "1.5";
                break;
            }
            case 50: {
                javaVersion = "1.6";
                break;
            }
            case 51: {
                javaVersion = "1.7";
                break;
            }
            case 52: {
                javaVersion = "1.8";
                break;
            }
            case 53: {
                javaVersion = "1.9";
                break;
            }
            default: {
                javaVersion = "Unknown";
            }
        }
        programInfo.setString("Java Version", javaVersion);
    }

    private void markupConstantPoolAndReferences(Program program, ClassFileJava classFile, Data constantPoolData, TaskMonitor monitor) {
        AbstractConstantPoolInfoJava[] constantPool = classFile.getConstantPool();
        Map<Integer, Integer> indexMap = this.getIndexMap(constantPool);
        for (int i = 1; i < constantPool.length; ++i) {
            if (monitor.isCancelled()) {
                return;
            }
            AbstractConstantPoolInfoJava constantPoolInfo = constantPool[i];
            BootstrapMethods[] bootstrapMethods = this.getBootStrapMethodAttribute(classFile, constantPool, indexMap);
            this.createConstantPoolReference(constantPoolData, constantPoolInfo, bootstrapMethods, indexMap, i);
        }
    }

    private BootstrapMethods[] getBootStrapMethodAttribute(ClassFileJava classFile, AbstractConstantPoolInfoJava[] constantPool, Map<Integer, Integer> indexMap) {
        AbstractAttributeInfo[] attributes;
        for (AbstractAttributeInfo attribute : attributes = classFile.getAttributes()) {
            String name;
            short nameIndex = attribute.getAttributeNameIndex();
            AbstractConstantPoolInfoJava poolEntry = classFile.getConstantPool()[nameIndex];
            if (!(poolEntry instanceof ConstantPoolUtf8Info) || !(name = ((ConstantPoolUtf8Info)poolEntry).getString()).equals("BootstrapMethods")) continue;
            return ((BootstrapMethodsAttribute)attribute).getBootstrapMethods();
        }
        return null;
    }

    private void createConstantPoolReference(Data constantPoolData, AbstractConstantPoolInfoJava constantPoolInfo, BootstrapMethods[] bootstrapMethods, Map<Integer, Integer> indexMap, int i) {
        Data data;
        Data indexData;
        Object indexValue;
        if (constantPoolInfo instanceof ConstantPoolClassInfo || constantPoolInfo instanceof ConstantPoolStringInfo || constantPoolInfo instanceof ConstantPoolMethodTypeInfo) {
            Data data2 = constantPoolData.getComponent(indexMap.get(i).intValue());
            Data indexData2 = data2.getComponent(1);
            Object indexValue2 = indexData2.getValue();
            if (indexValue2 instanceof Scalar) {
                int index = (int)(((Scalar)indexValue2).getValue() & 0xFFFFL);
                Data referredData = constantPoolData.getComponent(indexMap.get(index).intValue());
                indexData2.addValueReference(referredData.getAddress(), RefType.DATA);
            }
        } else if (constantPoolInfo instanceof ConstantPoolFieldReferenceInfo || constantPoolInfo instanceof ConstantPoolMethodReferenceInfo || constantPoolInfo instanceof ConstantPoolInterfaceMethodReferenceInfo || constantPoolInfo instanceof ConstantPoolNameAndTypeInfo) {
            Data referredData;
            int index;
            Data data3 = constantPoolData.getComponent(indexMap.get(i).intValue());
            Data indexData3 = data3.getComponent(1);
            Object indexValue3 = indexData3.getValue();
            if (indexValue3 instanceof Scalar) {
                index = (int)(((Scalar)indexValue3).getValue() & 0xFFFFL);
                referredData = constantPoolData.getComponent(indexMap.get(index).intValue());
                indexData3.addValueReference(referredData.getAddress(), RefType.DATA);
            }
            if ((indexValue3 = (indexData3 = data3.getComponent(2)).getValue()) instanceof Scalar) {
                index = (int)(((Scalar)indexValue3).getValue() & 0xFFFFL);
                referredData = constantPoolData.getComponent(indexMap.get(index).intValue());
                indexData3.addValueReference(referredData.getAddress(), RefType.DATA);
            }
        } else if (constantPoolInfo instanceof ConstantPoolInvokeDynamicInfo) {
            int index;
            Data data4 = constantPoolData.getComponent(indexMap.get(i).intValue());
            Data indexData4 = data4.getComponent(1);
            Object indexValue4 = indexData4.getValue();
            if (indexValue4 instanceof Scalar) {
                index = (int)(((Scalar)indexValue4).getValue() & 0xFFFFL);
                BootstrapMethods bootstrapMethod = bootstrapMethods[index];
                index = bootstrapMethod.getBootstrapMethodsReference() & 0xFFFF;
                Data referredData = constantPoolData.getComponent(indexMap.get(index).intValue());
                indexData4.addValueReference(referredData.getAddress(), RefType.DATA);
            }
            if ((indexValue4 = (indexData4 = data4.getComponent(2)).getValue()) instanceof Scalar) {
                index = (int)(((Scalar)indexValue4).getValue() & 0xFFFFL);
                Data referredData = constantPoolData.getComponent(indexMap.get(index).intValue());
                indexData4.addValueReference(referredData.getAddress(), RefType.DATA);
            }
        } else if (constantPoolInfo instanceof ConstantPoolMethodHandleInfo && (indexValue = (indexData = (data = constantPoolData.getComponent(indexMap.get(i).intValue())).getComponent(2)).getValue()) instanceof Scalar) {
            int index = (int)(((Scalar)indexValue).getValue() & 0xFFFFL);
            Data referredData = constantPoolData.getComponent(indexMap.get(index).intValue());
            indexData.addValueReference(referredData.getAddress(), RefType.DATA);
        }
    }

    private Map<Integer, Integer> getIndexMap(AbstractConstantPoolInfoJava[] constantPool) {
        HashMap<Integer, Integer> indexMap = new HashMap<Integer, Integer>();
        int offset = 1;
        for (int i = 1; i < constantPool.length; ++i) {
            indexMap.put(i, i - offset);
            if (!(constantPool[i] instanceof ConstantPoolLongInfo) && !(constantPool[i] instanceof ConstantPoolDoubleInfo)) continue;
            ++offset;
        }
        return indexMap;
    }

    private void labelOperands(Program program, ClassFileJava classFile) {
        InstructionIterator instructionIt = program.getListing().getInstructions(this.toAddr(program, 65536L), true);
        while (instructionIt.hasNext()) {
            Instruction instruction = instructionIt.next();
            Scalar opValue = instruction.getScalar(0);
            if (opValue == null) continue;
            AbstractConstantPoolInfoJava[] constantPool = classFile.getConstantPool();
            int index = (int)(opValue.getValue() & 0xFFFFFFFFFFFFFFFFL);
            String opMarkup = this.getOperandMarkup(program, constantPool, index);
            instruction.setComment(0, opMarkup);
        }
    }

    private void markupFields(Program program, ClassFileJava classFile, TaskMonitor monitor) {
        FieldInfoJava[] fields;
        AbstractConstantPoolInfoJava[] constantPool = classFile.getConstantPool();
        for (FieldInfoJava fieldInfo : fields = classFile.getFields()) {
            if (monitor.isCancelled()) break;
            ConstantPoolUtf8Info fieldName = (ConstantPoolUtf8Info)constantPool[fieldInfo.getNameIndex()];
            ConstantPoolUtf8Info fieldDescriptor = (ConstantPoolUtf8Info)constantPool[fieldInfo.getDescriptorIndex()];
            Address fieldAddress = this.toCpAddr(program, fieldInfo.getOffset());
            String comment = "FieldName = " + fieldName.getString() + "\nFieldDescriptor = " + fieldDescriptor.getString() + "\n";
            this.setEolComment(program, fieldAddress, comment);
        }
    }

    private void markupMethods(Program program, ClassFileJava classFile, TaskMonitor monitor) {
        MethodInfoJava[] methods;
        AbstractConstantPoolInfoJava[] constantPool = classFile.getConstantPool();
        for (MethodInfoJava methodInfo : methods = classFile.getMethods()) {
            LocalVariableTableAttribute localVariableTableAttribute;
            if (monitor.isCancelled()) break;
            ConstantPoolUtf8Info methodName = (ConstantPoolUtf8Info)constantPool[methodInfo.getNameIndex()];
            ConstantPoolUtf8Info methodDescriptor = (ConstantPoolUtf8Info)constantPool[methodInfo.getDescriptorIndex()];
            Address methodAddress = this.toCpAddr(program, methodInfo.getOffset());
            StringBuffer buffer = new StringBuffer();
            buffer.append("MethodName = " + methodName.getString() + "\n");
            buffer.append("MethodDescriptor = " + methodDescriptor.getString() + "\n");
            CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
            if (codeAttribute != null && (localVariableTableAttribute = codeAttribute.getLocalVariableTableAttribute()) != null) {
                LocalVariableJava[] localVariables = localVariableTableAttribute.getLocalVariables();
                long localVariableTableOffset = localVariableTableAttribute.getOffset();
                int offsetInTable = 8;
                for (LocalVariableJava localVariable : localVariables) {
                    ConstantPoolUtf8Info descriptor = (ConstantPoolUtf8Info)constantPool[localVariable.getDescriptorIndex()];
                    ConstantPoolUtf8Info name = (ConstantPoolUtf8Info)constantPool[localVariable.getNameIndex()];
                    String comment = "local: name = " + name + " type = " + descriptor;
                    buffer.append("\t" + comment + "\n");
                    Address localVariableAddress = this.toCpAddr(program, localVariableTableOffset + (long)offsetInTable);
                    this.setEolComment(program, localVariableAddress, comment);
                    offsetInTable += 10;
                }
            }
            this.setEolComment(program, methodAddress, buffer.toString());
        }
    }

    private String getOperandMarkup(Program program, AbstractConstantPoolInfoJava[] constantPool, int index) {
        if (index >= constantPool.length || index < 0) {
            return "";
        }
        AbstractConstantPoolInfoJava constantPoolInfo = constantPool[index];
        Object opMarkup = "";
        if (constantPoolInfo != null) {
            switch (constantPoolInfo.getTag()) {
                case 7: {
                    ConstantPoolClassInfo info = (ConstantPoolClassInfo)constantPoolInfo;
                    ConstantPoolUtf8Info utf8 = (ConstantPoolUtf8Info)constantPool[info.getNameIndex()];
                    opMarkup = utf8.getString().replaceAll("/", ".");
                    break;
                }
                case 6: {
                    ConstantPoolDoubleInfo info = (ConstantPoolDoubleInfo)constantPoolInfo;
                    double value = info.getValue();
                    opMarkup = Double.toString(value);
                    break;
                }
                case 9: {
                    ConstantPoolFieldReferenceInfo info = (ConstantPoolFieldReferenceInfo)constantPoolInfo;
                    ConstantPoolClassInfo classInfo = (ConstantPoolClassInfo)constantPool[info.getClassIndex()];
                    ConstantPoolUtf8Info className = (ConstantPoolUtf8Info)constantPool[classInfo.getNameIndex()];
                    ConstantPoolNameAndTypeInfo nameAndTypeInfo = (ConstantPoolNameAndTypeInfo)constantPool[info.getNameAndTypeIndex()];
                    ConstantPoolUtf8Info fieldName = (ConstantPoolUtf8Info)constantPool[nameAndTypeInfo.getNameIndex()];
                    ConstantPoolUtf8Info fieldDescriptor = (ConstantPoolUtf8Info)constantPool[nameAndTypeInfo.getDescriptorIndex()];
                    opMarkup = className.getString().replaceAll("/", ".") + "." + fieldName.getString() + " : " + DescriptorDecoder.getTypeNameFromDescriptor(fieldDescriptor.getString(), true, true);
                    break;
                }
                case 4: {
                    ConstantPoolFloatInfo info = (ConstantPoolFloatInfo)constantPoolInfo;
                    float value = info.getValue();
                    opMarkup = Float.toString(value);
                    break;
                }
                case 3: {
                    ConstantPoolIntegerInfo info = (ConstantPoolIntegerInfo)constantPoolInfo;
                    int value = info.getValue();
                    opMarkup = Integer.toString(value);
                    break;
                }
                case 11: {
                    ConstantPoolInterfaceMethodReferenceInfo info = (ConstantPoolInterfaceMethodReferenceInfo)constantPoolInfo;
                    ConstantPoolClassInfo classInfo = (ConstantPoolClassInfo)constantPool[info.getClassIndex()];
                    ConstantPoolUtf8Info className = (ConstantPoolUtf8Info)constantPool[classInfo.getNameIndex()];
                    ConstantPoolNameAndTypeInfo nameAndTypeInfo = (ConstantPoolNameAndTypeInfo)constantPool[info.getNameAndTypeIndex()];
                    ConstantPoolUtf8Info interfaceName = (ConstantPoolUtf8Info)constantPool[nameAndTypeInfo.getNameIndex()];
                    ConstantPoolUtf8Info interfaceDescriptor = (ConstantPoolUtf8Info)constantPool[nameAndTypeInfo.getDescriptorIndex()];
                    String descriptor = interfaceDescriptor.getString();
                    String params = this.getParameters(descriptor);
                    String returnType = DescriptorDecoder.getReturnTypeOfMethodDescriptor(descriptor, program.getDataTypeManager()).getName();
                    opMarkup = className.getString().replaceAll("/", ".") + "." + interfaceName.getString() + params + " : " + returnType;
                    break;
                }
                case 18: {
                    ConstantPoolInvokeDynamicInfo info = (ConstantPoolInvokeDynamicInfo)constantPoolInfo;
                    ConstantPoolNameAndTypeInfo nameAndTypeInfo = (ConstantPoolNameAndTypeInfo)constantPool[info.getNameAndTypeIndex()];
                    ConstantPoolUtf8Info name = (ConstantPoolUtf8Info)constantPool[nameAndTypeInfo.getNameIndex()];
                    opMarkup = name.getString();
                    break;
                }
                case 5: {
                    ConstantPoolLongInfo info = (ConstantPoolLongInfo)constantPoolInfo;
                    long value = info.getValue();
                    opMarkup = Long.toString(value);
                    break;
                }
                case 15: {
                    ConstantPoolMethodHandleInfo info = (ConstantPoolMethodHandleInfo)constantPoolInfo;
                    if (info.getReferenceKind() == 1 || info.getReferenceKind() == 2 || info.getReferenceKind() == 3 || info.getReferenceKind() == 4) {
                        ConstantPoolFieldReferenceInfo field = (ConstantPoolFieldReferenceInfo)constantPool[info.getReferenceIndex()];
                        ConstantPoolClassInfo classInfo = (ConstantPoolClassInfo)constantPool[field.getClassIndex()];
                        ConstantPoolUtf8Info className = (ConstantPoolUtf8Info)constantPool[classInfo.getNameIndex()];
                        ConstantPoolNameAndTypeInfo nameAndTypeInfo = (ConstantPoolNameAndTypeInfo)constantPool[field.getNameAndTypeIndex()];
                        ConstantPoolUtf8Info fieldName = (ConstantPoolUtf8Info)constantPool[nameAndTypeInfo.getNameIndex()];
                        ConstantPoolUtf8Info fieldInfo = (ConstantPoolUtf8Info)constantPool[nameAndTypeInfo.getDescriptorIndex()];
                        String descriptor = fieldInfo.getString();
                        String params = this.getParameters(descriptor);
                        String returnType = DescriptorDecoder.getReturnTypeOfMethodDescriptor(descriptor, program.getDataTypeManager()).getName();
                        opMarkup = className.getString().replaceAll("/", ".") + "." + fieldName.getString() + params + " : " + returnType;
                        break;
                    }
                    if (info.getReferenceKind() == 5 || info.getReferenceKind() == 6 || info.getReferenceKind() == 7 || info.getReferenceKind() == 8) {
                        ConstantPoolMethodReferenceInfo method = (ConstantPoolMethodReferenceInfo)constantPool[info.getReferenceIndex()];
                        ConstantPoolClassInfo classInfo = (ConstantPoolClassInfo)constantPool[method.getClassIndex()];
                        ConstantPoolUtf8Info className = (ConstantPoolUtf8Info)constantPool[classInfo.getNameIndex()];
                        ConstantPoolNameAndTypeInfo nameAndTypeInfo = (ConstantPoolNameAndTypeInfo)constantPool[method.getNameAndTypeIndex()];
                        ConstantPoolUtf8Info methodName = (ConstantPoolUtf8Info)constantPool[nameAndTypeInfo.getNameIndex()];
                        ConstantPoolUtf8Info methodInfo = (ConstantPoolUtf8Info)constantPool[nameAndTypeInfo.getDescriptorIndex()];
                        String descriptor = methodInfo.getString();
                        String params = this.getParameters(descriptor);
                        String returnType = DescriptorDecoder.getReturnTypeOfMethodDescriptor(descriptor, program.getDataTypeManager()).getName();
                        opMarkup = className.getString().replaceAll("/", ".") + "." + methodName.getString() + params + " : " + returnType;
                        break;
                    }
                    if (info.getReferenceKind() != 9) break;
                    ConstantPoolInterfaceMethodReferenceInfo interfaceMethod = (ConstantPoolInterfaceMethodReferenceInfo)constantPool[info.getReferenceIndex()];
                    ConstantPoolClassInfo classInfo = (ConstantPoolClassInfo)constantPool[interfaceMethod.getClassIndex()];
                    ConstantPoolUtf8Info className = (ConstantPoolUtf8Info)constantPool[classInfo.getNameIndex()];
                    ConstantPoolNameAndTypeInfo nameAndTypeInfo = (ConstantPoolNameAndTypeInfo)constantPool[interfaceMethod.getNameAndTypeIndex()];
                    ConstantPoolUtf8Info interfaceMethodName = (ConstantPoolUtf8Info)constantPool[nameAndTypeInfo.getNameIndex()];
                    ConstantPoolUtf8Info interfaceMethodInfo = (ConstantPoolUtf8Info)constantPool[nameAndTypeInfo.getDescriptorIndex()];
                    String descriptor = interfaceMethodInfo.getString();
                    String params = this.getParameters(descriptor);
                    String returnType = DescriptorDecoder.getReturnTypeOfMethodDescriptor(descriptor, program.getDataTypeManager()).getName();
                    opMarkup = className.getString().replaceAll("/", ".") + "." + interfaceMethodName.getString() + params + " : " + returnType;
                    break;
                }
                case 10: {
                    ConstantPoolMethodReferenceInfo info = (ConstantPoolMethodReferenceInfo)constantPoolInfo;
                    ConstantPoolClassInfo classInfo = (ConstantPoolClassInfo)constantPool[info.getClassIndex()];
                    ConstantPoolUtf8Info className = (ConstantPoolUtf8Info)constantPool[classInfo.getNameIndex()];
                    ConstantPoolNameAndTypeInfo nameAndTypeInfo = (ConstantPoolNameAndTypeInfo)constantPool[info.getNameAndTypeIndex()];
                    ConstantPoolUtf8Info methodName = (ConstantPoolUtf8Info)constantPool[nameAndTypeInfo.getNameIndex()];
                    ConstantPoolUtf8Info methodDescriptor = (ConstantPoolUtf8Info)constantPool[nameAndTypeInfo.getDescriptorIndex()];
                    ConstantPoolUtf8Info methodInfo = (ConstantPoolUtf8Info)constantPool[nameAndTypeInfo.getDescriptorIndex()];
                    String descriptor = methodInfo.getString();
                    String params = this.getParameters(descriptor);
                    String returnType = DescriptorDecoder.getReturnTypeOfMethodDescriptor(descriptor, program.getDataTypeManager()).getName();
                    if (methodName.getString().equals("<init>")) {
                        opMarkup = className.getString() + params;
                        break;
                    }
                    opMarkup = className.getString().replaceAll("/", ".") + "." + methodName.getString() + params + " : " + returnType;
                    break;
                }
                case 16: {
                    ConstantPoolMethodTypeInfo info = (ConstantPoolMethodTypeInfo)constantPoolInfo;
                    ConstantPoolUtf8Info methodType = (ConstantPoolUtf8Info)constantPool[info.getDescriptorIndex()];
                    opMarkup = methodType.getString();
                    break;
                }
                case 12: {
                    ConstantPoolNameAndTypeInfo info = (ConstantPoolNameAndTypeInfo)constantPoolInfo;
                    ConstantPoolUtf8Info fieldName = (ConstantPoolUtf8Info)constantPool[info.getNameIndex()];
                    ConstantPoolUtf8Info fieldDescriptor = (ConstantPoolUtf8Info)constantPool[info.getDescriptorIndex()];
                    opMarkup = fieldName.getString();
                    break;
                }
                case 8: {
                    ConstantPoolStringInfo info = (ConstantPoolStringInfo)constantPoolInfo;
                    ConstantPoolUtf8Info utf8 = (ConstantPoolUtf8Info)constantPool[info.getStringIndex()];
                    opMarkup = utf8.toString();
                    break;
                }
                case 1: {
                    ConstantPoolUtf8Info utf8 = (ConstantPoolUtf8Info)constantPoolInfo;
                    opMarkup = utf8.getString();
                    break;
                }
            }
        }
        return opMarkup;
    }

    private String getParameters(String descriptor) {
        List<String> paramTypeNames = DescriptorDecoder.getTypeNameList(descriptor, true, true);
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        int max = paramTypeNames.size() - 1;
        for (int i = 0; i < max; ++i) {
            sb.append(paramTypeNames.get(i));
            if (i >= max - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    public String getWorkerName() {
        return this.getName();
    }

    private boolean setEolComment(Program program, Address address, String comment) {
        if (address.getAddressSpace() != program.getAddressFactory().getDefaultAddressSpace()) {
            return false;
        }
        SetCommentCmd cmd = new SetCommentCmd(address, 0, comment);
        return cmd.applyTo((DomainObject)program);
    }

    private void setFunctionInfo(Function function, MethodInfoJava methodInfo, ClassFileJava classFile, DataTypeManager dtManager) throws DuplicateNameException, InvalidInputException {
        AbstractConstantPoolInfoJava[] constantPool = classFile.getConstantPool();
        String functionName = ((ConstantPoolUtf8Info)constantPool[methodInfo.getNameIndex()]).getString();
        String descriptor = ((ConstantPoolUtf8Info)constantPool[methodInfo.getDescriptorIndex()]).getString();
        List<String> typeNames = DescriptorDecoder.getTypeNameList(descriptor, true, true);
        StringBuilder sb = new StringBuilder();
        sb.append(functionName);
        for (String name : typeNames) {
            sb.append("_");
            sb.append(name);
        }
        function.setName(sb.toString(), SourceType.ANALYSIS);
        function.setCallingConvention("default");
        DataType returnType = DescriptorDecoder.getReturnTypeOfMethodDescriptor(descriptor, dtManager);
        function.setReturnType(returnType, SourceType.ANALYSIS);
        ArrayList<ParameterImpl> params = new ArrayList<ParameterImpl>();
        if (!methodInfo.isStatic()) {
            short thisIndex = classFile.getThisClass();
            ConstantPoolClassInfo thisClass = (ConstantPoolClassInfo)constantPool[thisIndex];
            short nameIndex = thisClass.getNameIndex();
            ConstantPoolUtf8Info thisNameInfo = (ConstantPoolUtf8Info)constantPool[nameIndex];
            DataType thisType = DescriptorDecoder.resolveClassForString(thisNameInfo.getString(), dtManager, (DataType)DWordDataType.dataType);
            ParameterImpl thisParam = new ParameterImpl("this", thisType, function.getProgram());
            params.add(thisParam);
        }
        List<DataType> explicitParams = DescriptorDecoder.getDataTypeList(descriptor, dtManager);
        int max = explicitParams.size();
        for (int i = 0; i < max; ++i) {
            ParameterImpl currentParam = new ParameterImpl("param" + Integer.toString(i + 1), explicitParams.get(i), function.getProgram());
            params.add(currentParam);
        }
        function.replaceParameters(params, Function.FunctionUpdateType.DYNAMIC_STORAGE_ALL_PARAMS, true, SourceType.ANALYSIS);
    }
}

