/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pcodeInject;

import ghidra.app.util.pcodeInject.JavaComputationalCategory;
import ghidra.app.util.pcodeInject.JavaInvocationType;
import ghidra.app.util.pcodeInject.PcodeTextEmitter;
import ghidra.javaclass.format.DescriptorDecoder;
import ghidra.javaclass.format.constantpool.AbstractConstantPoolInfoJava;
import java.util.List;

public class InvokeMethods {
    static final String CALL_TARGET = "call_target";
    static final String CAT_1_RETURN = "return_value";
    static final String CAT_2_RETURN = "cat2_return_value";
    static final String PARAMETER = "param";
    static final String PARAMETER_PART2 = "parampart";
    static final String THIS = "this";
    static final String STATIC_OFFSET = "0";
    static final String PARAM_SPACE = "parameterSpace";

    private InvokeMethods() {
        throw new AssertionError();
    }

    public static String getPcodeForInvoke(int offset, AbstractConstantPoolInfoJava[] constantPool, JavaInvocationType type) {
        StringBuilder pCode = new StringBuilder();
        String descriptor = DescriptorDecoder.getDescriptorForInvoke(offset, constantPool, type);
        List<JavaComputationalCategory> categories = DescriptorDecoder.getParameterCategories(descriptor);
        boolean includeThisPointer = type.equals((Object)JavaInvocationType.INVOKE_VIRTUAL) || type.equals((Object)JavaInvocationType.INVOKE_SPECIAL) || type.equals((Object)JavaInvocationType.INVOKE_INTERFACE);
        int stackPurge = DescriptorDecoder.getStackPurge(descriptor);
        if (includeThisPointer) {
            stackPurge += 4;
        }
        InvokeMethods.emitPcodeToMoveParams(pCode, categories, includeThisPointer, stackPurge);
        InvokeMethods.emitPcodeToResolveMethodReference(pCode, offset, constantPool, type);
        PcodeTextEmitter.emitIndirectCall(pCode, CALL_TARGET);
        JavaComputationalCategory retType = DescriptorDecoder.getReturnCategoryOfMethodDescriptor(descriptor);
        switch (retType) {
            case CAT_1: {
                PcodeTextEmitter.emitPushCat1Value(pCode, CAT_1_RETURN);
                break;
            }
            case CAT_2: {
                PcodeTextEmitter.emitPushCat2Value(pCode, CAT_2_RETURN);
                break;
            }
        }
        return pCode.toString();
    }

    static void emitPcodeToMoveParams(StringBuilder pCode, List<JavaComputationalCategory> categories, boolean includeThisPointer, int totalSize) {
        block4: for (int i = categories.size() - 1; i >= 0; --i) {
            switch (categories.get(i)) {
                case CAT_1: {
                    PcodeTextEmitter.emitPopCat1Value(pCode, PARAMETER + Integer.toString(i));
                    PcodeTextEmitter.emitWriteToMemory(pCode, PARAM_SPACE, 4, Integer.toString(totalSize -= 4) + ":4", PARAMETER + Integer.toString(i));
                    continue block4;
                }
                case CAT_2: {
                    PcodeTextEmitter.emitPopCat1Value(pCode, PARAMETER + Integer.toString(i));
                    PcodeTextEmitter.emitWriteToMemory(pCode, PARAM_SPACE, 4, Integer.toString(totalSize - 8) + ":4", PARAMETER + Integer.toString(i));
                    PcodeTextEmitter.emitPopCat1Value(pCode, PARAMETER_PART2 + Integer.toString(i));
                    PcodeTextEmitter.emitWriteToMemory(pCode, PARAM_SPACE, 4, Integer.toString(totalSize - 4) + ":4", PARAMETER_PART2 + Integer.toString(i));
                    totalSize -= 8;
                    continue block4;
                }
                default: {
                    throw new IllegalArgumentException("Invalid category!");
                }
            }
        }
        if (includeThisPointer) {
            PcodeTextEmitter.emitPopCat1Value(pCode, THIS);
            PcodeTextEmitter.emitWriteToMemory(pCode, PARAM_SPACE, 4, Integer.toString(totalSize -= 4) + ":4", THIS);
        }
    }

    static void emitPcodeToResolveMethodReference(StringBuilder pCode, int offset, AbstractConstantPoolInfoJava[] constantPool, JavaInvocationType type) {
        switch (type) {
            case INVOKE_DYNAMIC: {
                PcodeTextEmitter.emitAssignRegisterFromPcodeOpCall(pCode, CALL_TARGET, "cpool", STATIC_OFFSET, Integer.toString(offset), "7");
                break;
            }
            case INVOKE_INTERFACE: {
                PcodeTextEmitter.emitAssignRegisterFromPcodeOpCall(pCode, CALL_TARGET, "cpool", THIS, Integer.toString(offset), "8");
                break;
            }
            case INVOKE_SPECIAL: {
                PcodeTextEmitter.emitAssignRegisterFromPcodeOpCall(pCode, CALL_TARGET, "cpool", THIS, Integer.toString(offset), "9");
                break;
            }
            case INVOKE_STATIC: {
                PcodeTextEmitter.emitAssignRegisterFromPcodeOpCall(pCode, CALL_TARGET, "cpool", STATIC_OFFSET, Integer.toString(offset), "10");
                break;
            }
            case INVOKE_VIRTUAL: {
                PcodeTextEmitter.emitAssignRegisterFromPcodeOpCall(pCode, CALL_TARGET, "cpool", THIS, Integer.toString(offset), "11");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unimplemented JavaMethodType: " + type.toString());
            }
        }
    }
}

