/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.diff;

import docking.DialogComponentProvider;
import docking.DockingUtils;
import docking.ToolTipManager;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramDiffFilter;
import ghidra.program.util.ProgramMemoryComparator;
import ghidra.util.HelpLocation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class ExecuteDiffDialog
extends DialogComponentProvider {
    public static final String DIFF_ACTION = "Diff";
    private static final String TITLE = "Determine Program Differences";
    private static final String ADDRESS_AREA_TITLE = "Address Ranges To Diff";
    private JCheckBox diffBytesCB;
    private JCheckBox diffLabelsCB;
    private JCheckBox diffCodeUnitsCB;
    private JCheckBox diffReferencesCB;
    private JCheckBox diffProgramContextCB;
    private JCheckBox diffCommentsCB;
    private JCheckBox diffBookmarksCB;
    private JCheckBox diffPropertiesCB;
    private JCheckBox diffFunctionsCB;
    private JButton selectAllButton = new JButton("Select All");
    private JButton deselectAllButton = new JButton("Deselect All");
    private JCheckBox limitToSelectionCB;
    private JTextArea addressText;
    private boolean diffBytes;
    private boolean diffLabels;
    private boolean diffCodeUnits;
    private boolean diffReferences;
    private boolean diffProgramContext;
    private boolean diffComments;
    private boolean diffBookmarks;
    private boolean diffProperties;
    private boolean diffFunctions;
    private ProgramDiffFilter diffFilter;
    private JPanel diffPanel;
    private ArrayList<ActionListener> listenerList = new ArrayList();
    private boolean limitToSelection;
    private AddressSetView pgm1MemorySet;
    private AddressSetView pgm1SelectionSet;
    private AddressSetView pgm1CompatibleSet;
    private boolean pgmContextEnabled = true;

    public ExecuteDiffDialog() {
        super(TITLE, true, true, true, false);
        this.diffPanel = this.createDiffSettingsPanel();
        this.init();
        this.setHelpLocation(new HelpLocation(DIFF_ACTION, "ExecuteDiffDialog"));
    }

    public void configure(Program program1, Program program2, AddressSetView currentProgram1SelectionSet, ProgramDiffFilter diff) {
        this.pgm1MemorySet = program1.getMemory();
        this.pgm1SelectionSet = currentProgram1SelectionSet;
        this.pgm1CompatibleSet = ProgramMemoryComparator.getCombinedAddresses((Program)program1, (Program)program2);
        this.setDiffFilter(diff);
        boolean hasSelection = currentProgram1SelectionSet != null && !currentProgram1SelectionSet.isEmpty();
        this.setLimitToSelectionEnabled(hasSelection);
        this.limitToSelection(hasSelection);
        this.addressText.setText(this.getAddressText());
    }

    private void init() {
        this.addWorkPanel(this.diffPanel);
        this.addOKButton();
        this.setOkToolTip("Get the differences and highlight them in the second program.");
        this.addCancelButton();
    }

    protected void okCallback() {
        if (!this.hasDiffSelection()) {
            this.setStatusText("At least one difference type must be checked.");
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        for (int i = 0; i < this.listenerList.size(); ++i) {
            ActionListener listener = this.listenerList.get(i);
            listener.actionPerformed(new ActionEvent((Object)this, 0, DIFF_ACTION));
        }
        this.close();
    }

    protected void cancelCallback() {
        this.close();
    }

    JPanel createDiffSettingsPanel() {
        ProgramDiffFilter diff = new ProgramDiffFilter();
        JPanel panel = new JPanel(new BorderLayout());
        JPanel settingsPanel = new JPanel();
        settingsPanel.add(this.createDiffPanel());
        panel.add((Component)settingsPanel, "North");
        panel.add((Component)this.createAddressPanel(), "Center");
        this.setDiffFilter(diff);
        return panel;
    }

    private JPanel createDiffPanel() {
        JPanel panel = new JPanel();
        TitledBorder border = new TitledBorder("Do Differences On");
        panel.setBorder(border);
        panel.add(this.createDiffFilterPanel());
        return panel;
    }

    private JPanel createAddressPanel() {
        JPanel addressPanel = new JPanel(new BorderLayout());
        Border border = BorderFactory.createEtchedBorder();
        addressPanel.setBorder(new TitledBorder(border, ADDRESS_AREA_TITLE));
        addressPanel.add((Component)this.createLimitPanel(), "North");
        this.addressText = new JTextArea(5, 30);
        this.addressText.setName("AddressTextArea");
        this.addressText.setEditable(false);
        DockingUtils.setTransparent((JComponent)this.addressText);
        this.addressText.setText(this.getAddressText());
        JScrollPane scrolledAddresses = new JScrollPane(this.addressText);
        addressPanel.add((Component)scrolledAddresses, "Center");
        return addressPanel;
    }

    private JPanel createLimitPanel() {
        JPanel panel = new JPanel();
        this.limitToSelectionCB = new JCheckBox("Limit To Selection");
        this.limitToSelectionCB.setName("LimitToSelectionDiffCB");
        ToolTipManager.setToolTipText((JComponent)this.limitToSelectionCB, (String)"Limits the Diff to the selection.");
        this.limitToSelectionCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ExecuteDiffDialog.this.limitToSelection = ExecuteDiffDialog.this.limitToSelectionCB.isSelected();
                ExecuteDiffDialog.this.updateDiffSetText();
                ExecuteDiffDialog.this.clearStatusText();
            }
        });
        panel.add(this.limitToSelectionCB);
        return panel;
    }

    private JPanel createDiffFilterPanel() {
        JPanel checkBoxPanel = new JPanel();
        ToolTipManager.setToolTipText((JComponent)checkBoxPanel, (String)"Check the types of differences between the two programs that you want detected and highlighted.");
        this.createBytesCheckBox();
        this.createLabelsCheckBox();
        this.createCodeUnitsCheckBox();
        this.createReferencesCheckBox();
        this.createProgramContextCheckBox();
        this.createCommentsCheckBox();
        this.createBookmarksCheckBox();
        this.createPropertiesCheckBox();
        this.createFunctionsCheckBox();
        checkBoxPanel.setLayout(new GridLayout(3, 3, 5, 0));
        checkBoxPanel.add(this.diffBytesCB);
        checkBoxPanel.add(this.diffLabelsCB);
        checkBoxPanel.add(this.diffCodeUnitsCB);
        checkBoxPanel.add(this.diffReferencesCB);
        checkBoxPanel.add(this.diffProgramContextCB);
        checkBoxPanel.add(this.diffCommentsCB);
        checkBoxPanel.add(this.diffBookmarksCB);
        checkBoxPanel.add(this.diffPropertiesCB);
        checkBoxPanel.add(this.diffFunctionsCB);
        JPanel buttonPanel = new JPanel();
        this.createSelectAllButton();
        buttonPanel.add(this.selectAllButton);
        this.createDeselectAllButton();
        buttonPanel.add(this.deselectAllButton);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)checkBoxPanel, "Center");
        panel.add((Component)buttonPanel, "South");
        return panel;
    }

    private void createBytesCheckBox() {
        this.diffBytesCB = new JCheckBox("Bytes", this.diffBytes);
        this.diffBytesCB.setName("BytesDiffCB");
        ToolTipManager.setToolTipText((JComponent)this.diffBytesCB, (String)"Highlight byte differences.");
        this.diffBytesCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                ExecuteDiffDialog.this.diffBytes = event.getStateChange() == 1;
                ExecuteDiffDialog.this.diffFilter.setFilter(2, ExecuteDiffDialog.this.diffBytes);
                ExecuteDiffDialog.this.clearStatusText();
            }
        });
    }

    private void createLabelsCheckBox() {
        this.diffLabelsCB = new JCheckBox("Labels", this.diffLabels);
        this.diffLabelsCB.setName("LabelsDiffCB");
        ToolTipManager.setToolTipText((JComponent)this.diffLabelsCB, (String)"Highlight label differences.");
        this.diffLabelsCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                ExecuteDiffDialog.this.diffLabels = event.getStateChange() == 1;
                ExecuteDiffDialog.this.diffFilter.setFilter(1024, ExecuteDiffDialog.this.diffLabels);
                ExecuteDiffDialog.this.clearStatusText();
            }
        });
    }

    private void createCodeUnitsCheckBox() {
        this.diffCodeUnitsCB = new JCheckBox("Code Units", this.diffCodeUnits);
        this.diffCodeUnitsCB.setName("CodeUnitsDiffCB");
        ToolTipManager.setToolTipText((JComponent)this.diffCodeUnitsCB, (String)"Highlight the instruction, data, and equate differences.");
        this.diffCodeUnitsCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                ExecuteDiffDialog.this.diffCodeUnits = event.getStateChange() == 1;
                ExecuteDiffDialog.this.diffFilter.setFilter(4, ExecuteDiffDialog.this.diffCodeUnits);
                ExecuteDiffDialog.this.diffFilter.setFilter(512, ExecuteDiffDialog.this.diffCodeUnits);
                ExecuteDiffDialog.this.clearStatusText();
            }
        });
    }

    private void createReferencesCheckBox() {
        this.diffReferencesCB = new JCheckBox("References", this.diffReferences);
        this.diffReferencesCB.setName("ReferencesDiffCB");
        ToolTipManager.setToolTipText((JComponent)this.diffReferencesCB, (String)"Highlight the reference differences.");
        this.diffReferencesCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                ExecuteDiffDialog.this.diffReferences = event.getStateChange() == 1;
                ExecuteDiffDialog.this.diffFilter.setFilter(256, ExecuteDiffDialog.this.diffReferences);
                ExecuteDiffDialog.this.clearStatusText();
            }
        });
    }

    private void createProgramContextCheckBox() {
        this.diffProgramContextCB = new JCheckBox("Program Context", this.diffProgramContext);
        this.diffProgramContextCB.setName("ProgramContextDiffCB");
        ToolTipManager.setToolTipText((JComponent)this.diffProgramContextCB, (String)"Highlight the program context register differences.");
        this.diffProgramContextCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                ExecuteDiffDialog.this.diffProgramContext = event.getStateChange() == 1;
                ExecuteDiffDialog.this.diffFilter.setFilter(1, ExecuteDiffDialog.this.diffProgramContext);
                ExecuteDiffDialog.this.clearStatusText();
            }
        });
    }

    private void createCommentsCheckBox() {
        this.diffCommentsCB = new JCheckBox("Comments", this.diffComments);
        this.diffCommentsCB.setName("CommentsDiffCB");
        ToolTipManager.setToolTipText((JComponent)this.diffCommentsCB, (String)"Highlight comment differences.");
        this.diffCommentsCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                ExecuteDiffDialog.this.diffComments = event.getStateChange() == 1;
                ExecuteDiffDialog.this.diffFilter.setFilter(248, ExecuteDiffDialog.this.diffComments);
                ExecuteDiffDialog.this.clearStatusText();
            }
        });
    }

    private void createBookmarksCheckBox() {
        this.diffBookmarksCB = new JCheckBox("Bookmarks", this.diffBookmarks);
        this.diffBookmarksCB.setName("BookmarksDiffCB");
        ToolTipManager.setToolTipText((JComponent)this.diffBookmarksCB, (String)"Highlight bookmark differences. (for example, bookmark differences)");
        this.diffBookmarksCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                ExecuteDiffDialog.this.diffBookmarks = event.getStateChange() == 1;
                ExecuteDiffDialog.this.diffFilter.setFilter(4096, ExecuteDiffDialog.this.diffBookmarks);
                ExecuteDiffDialog.this.clearStatusText();
            }
        });
    }

    private void createPropertiesCheckBox() {
        this.diffPropertiesCB = new JCheckBox("Properties", this.diffProperties);
        this.diffPropertiesCB.setName("PropertiesDiffCB");
        ToolTipManager.setToolTipText((JComponent)this.diffPropertiesCB, (String)"Highlight user defined property differences. (for example, Format (space) differences)");
        this.diffPropertiesCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                ExecuteDiffDialog.this.diffProperties = event.getStateChange() == 1;
                ExecuteDiffDialog.this.diffFilter.setFilter(8192, ExecuteDiffDialog.this.diffProperties);
                ExecuteDiffDialog.this.clearStatusText();
            }
        });
    }

    private void createFunctionsCheckBox() {
        this.diffFunctionsCB = new JCheckBox("Functions", this.diffFunctions);
        this.diffFunctionsCB.setName("FunctionsDiffCB");
        ToolTipManager.setToolTipText((JComponent)this.diffFunctionsCB, (String)"Highlight function differences.");
        this.diffFunctionsCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                ExecuteDiffDialog.this.diffFunctions = event.getStateChange() == 1;
                ExecuteDiffDialog.this.diffFilter.setFilter(2048, ExecuteDiffDialog.this.diffFunctions);
                ExecuteDiffDialog.this.diffFilter.setFilter(16384, ExecuteDiffDialog.this.diffFunctions);
                ExecuteDiffDialog.this.clearStatusText();
            }
        });
    }

    private void createSelectAllButton() {
        this.selectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExecuteDiffDialog.this.setSelectAll(true);
            }
        });
        this.selectAllButton.setMnemonic('S');
    }

    private void createDeselectAllButton() {
        this.deselectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExecuteDiffDialog.this.setSelectAll(false);
            }
        });
        this.deselectAllButton.setMnemonic('D');
    }

    protected void setSelectAll(boolean selected) {
        this.diffBytesCB.setSelected(selected);
        this.diffLabelsCB.setSelected(selected);
        this.diffCodeUnitsCB.setSelected(selected);
        this.diffReferencesCB.setSelected(selected);
        this.diffProgramContextCB.setSelected(this.pgmContextEnabled && selected);
        this.diffCommentsCB.setSelected(selected);
        this.diffBookmarksCB.setSelected(selected);
        this.diffPropertiesCB.setSelected(selected);
        this.diffFunctionsCB.setSelected(selected);
    }

    private void adjustDiffFilter() {
        this.diffBytesCB.setSelected(this.diffBytes);
        this.diffLabelsCB.setSelected(this.diffLabels);
        this.diffCodeUnitsCB.setSelected(this.diffCodeUnits);
        this.diffReferencesCB.setSelected(this.diffReferences);
        this.diffProgramContextCB.setSelected(this.pgmContextEnabled && this.diffProgramContext);
        this.diffCommentsCB.setSelected(this.diffComments);
        this.diffBookmarksCB.setSelected(this.diffBookmarks);
        this.diffPropertiesCB.setSelected(this.diffProperties);
        this.diffFunctionsCB.setSelected(this.diffFunctions);
    }

    void setPgmContextEnabled(boolean enable) {
        this.pgmContextEnabled = enable;
        this.diffProgramContextCB.setEnabled(enable);
        if (!enable) {
            this.diffProgramContext = false;
        }
        this.diffProgramContextCB.setSelected(this.diffProgramContext);
    }

    ProgramDiffFilter getDiffFilter() {
        return new ProgramDiffFilter(this.diffFilter);
    }

    void setDiffFilter(ProgramDiffFilter filter) {
        this.diffFilter = new ProgramDiffFilter(filter);
        this.diffBytes = this.diffFilter.getFilter(2);
        this.diffLabels = this.diffFilter.getFilter(1024);
        this.diffCodeUnits = this.diffFilter.getFilter(4);
        this.diffReferences = this.diffFilter.getFilter(256);
        this.diffProgramContext = this.pgmContextEnabled && this.diffFilter.getFilter(1);
        this.diffComments = this.diffFilter.getFilter(248);
        this.diffBookmarks = this.diffFilter.getFilter(4096);
        this.diffProperties = this.diffFilter.getFilter(8192);
        this.diffFunctions = this.diffFilter.getFilter(2048);
        this.adjustDiffFilter();
    }

    boolean isLimitedToSelection() {
        return this.limitToSelectionCB.isSelected();
    }

    void limitToSelection(boolean limit) {
        this.limitToSelection = limit;
        this.limitToSelectionCB.setSelected(this.limitToSelection);
        this.updateDiffSetText();
    }

    void setLimitToSelectionEnabled(boolean enable) {
        this.limitToSelectionCB.setEnabled(enable);
    }

    private void updateDiffSetText() {
        AddressSetView pgm1AddressSet = this.getAddressSet();
        this.addressText.setText(this.getAddressText());
        this.setOkEnabled(pgm1AddressSet != null && !pgm1AddressSet.isEmpty());
    }

    AddressSetView getAddressSet() {
        if (this.isLimitedToSelection()) {
            return new AddressSet(this.pgm1SelectionSet);
        }
        return new AddressSet(this.pgm1CompatibleSet);
    }

    private String getAddressText() {
        AddressSetView addrs = this.getAddressSet();
        StringBuffer addrStr = new StringBuffer();
        if (addrs == null || addrs.equals(this.pgm1MemorySet)) {
            return "Entire Program";
        }
        for (AddressRange range : addrs) {
            addrStr.append(range.toString() + "\n");
        }
        return addrStr.toString();
    }

    public void addActionListener(ActionListener listener) {
        this.listenerList.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listenerList.remove(listener);
    }

    boolean hasDiffSelection() {
        return this.diffBytes || this.diffLabels || this.diffCodeUnits || this.diffProgramContext || this.diffReferences || this.diffComments || this.diffBookmarks || this.diffProperties || this.diffFunctions;
    }

    boolean isMarkingAllDiffs() {
        return this.diffBytes && this.diffLabels && this.diffCodeUnits && (!this.pgmContextEnabled || this.diffProgramContext) && this.diffReferences && this.diffComments && this.diffBookmarks && this.diffProperties && this.diffFunctions;
    }
}

