/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.data;

import db.DBChangeSet;
import db.DBHandle;
import db.buffers.BufferFile;
import db.buffers.LocalManagedBufferFile;
import db.buffers.ManagedBufferFile;
import ghidra.framework.client.ClientUtil;
import ghidra.framework.client.NotConnectedException;
import ghidra.framework.data.CheckinHandler;
import ghidra.framework.data.ContentHandler;
import ghidra.framework.data.DomainFileProxy;
import ghidra.framework.data.DomainObjectAdapter;
import ghidra.framework.data.DomainObjectAdapterDB;
import ghidra.framework.data.DomainObjectMergeManager;
import ghidra.framework.data.GhidraFile;
import ghidra.framework.data.GhidraFolderData;
import ghidra.framework.data.LockingTaskMonitor;
import ghidra.framework.data.ProjectFileManager;
import ghidra.framework.data.VersionIcon;
import ghidra.framework.model.ChangeSet;
import ghidra.framework.model.DomainFolderChangeListener;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.store.CheckoutType;
import ghidra.framework.store.DataFileItem;
import ghidra.framework.store.DatabaseItem;
import ghidra.framework.store.FileIDFactory;
import ghidra.framework.store.FileSystem;
import ghidra.framework.store.FolderItem;
import ghidra.framework.store.ItemCheckoutStatus;
import ghidra.framework.store.Version;
import ghidra.framework.store.local.LocalDatabaseItem;
import ghidra.framework.store.local.LocalFileSystem;
import ghidra.framework.store.local.LocalFolderItem;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.ReadOnlyException;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateFileException;
import ghidra.util.exception.FileInUseException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.TaskMonitorAdapter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import resources.MultiIcon;
import resources.ResourceManager;
import resources.icons.TranslateIcon;

public class GhidraFileData {
    private static boolean alwaysMerge = System.getProperty("ForceMerge") != null;
    public static final Icon UNSUPPORTED_FILE_ICON = ResourceManager.loadImage((String)"images/unknownFile.gif");
    public static final Icon CHECKED_OUT_ICON = ResourceManager.loadImage((String)"images/check.png");
    public static final Icon CHECKED_OUT_EXCLUSIVE_ICON = ResourceManager.loadImage((String)"images/checkex.png");
    public static final Icon HIJACKED_ICON = ResourceManager.loadImage((String)"images/small_hijack.gif");
    public static final Icon VERSION_ICON = new VersionIcon();
    public static final Icon READ_ONLY_ICON = ResourceManager.loadImage((String)"images/user-busy.png", (int)10, (int)10);
    public static final Icon NOT_LATEST_CHECKED_OUT_ICON = ResourceManager.loadImage((String)"images/checkNotLatest.gif");
    private ProjectFileManager fileManager;
    private LocalFileSystem fileSystem;
    private FileSystem versionedFileSystem;
    private DomainFolderChangeListener listener;
    private GhidraFolderData parent;
    private String name;
    private String fileID;
    private LocalFolderItem folderItem;
    private FolderItem versionedFolderItem;
    private Icon icon;
    private Icon disabledIcon;
    private volatile boolean busy = false;

    GhidraFileData(GhidraFolderData parent, String name) throws IOException {
        this.parent = parent;
        this.name = name;
        this.fileManager = parent.getProjectFileManager();
        this.fileSystem = parent.getLocalFileSystem();
        this.versionedFileSystem = parent.getVersionedFileSystem();
        this.listener = parent.getChangeListener();
        this.refresh();
    }

    private boolean refresh() throws IOException {
        String parentPath = this.parent.getPathname();
        this.folderItem = this.folderItem == null ? this.fileSystem.getItem(parentPath, this.name) : this.folderItem.refresh();
        if (this.versionedFileSystem.isOnline()) {
            try {
                this.versionedFolderItem = this.versionedFolderItem == null ? this.versionedFileSystem.getItem(parentPath, this.name) : this.versionedFolderItem.refresh();
                this.validateCheckout();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.folderItem == null && this.versionedFolderItem == null) {
            throw new FileNotFoundException(this.name + " not found");
        }
        boolean fileIdWasNull = this.fileID == null;
        this.fileID = this.folderItem != null ? this.folderItem.getFileID() : this.versionedFolderItem.getFileID();
        return fileIdWasNull && this.fileID != null;
    }

    void statusChanged() throws IOException {
        this.statusChanged(false);
    }

    private void statusChanged(boolean fileIDset) throws IOException {
        this.icon = null;
        this.disabledIcon = null;
        fileIDset |= this.refresh();
        if (this.parent.visited()) {
            this.listener.domainFileStatusChanged(this.getDomainFile(), fileIDset);
        }
    }

    private void validateCheckout() throws IOException {
        if (this.fileSystem.isReadOnly() || !this.versionedFileSystem.isOnline()) {
            return;
        }
        if (this.folderItem != null && this.folderItem.isCheckedOut()) {
            if (this.versionedFolderItem != null) {
                ItemCheckoutStatus coStatus = this.versionedFolderItem.getCheckout(this.folderItem.getCheckoutId());
                if (coStatus == null) {
                    this.folderItem.clearCheckout();
                }
            } else {
                this.folderItem.clearCheckout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkInUse() throws FileInUseException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (this.busy || this.getOpenedDomainObject() != null) {
                throw new FileInUseException(this.name + " is in use");
            }
        }
    }

    boolean isBusy() {
        if (this.busy) {
            return true;
        }
        DomainObjectAdapter dobj = this.getOpenedDomainObject();
        return dobj != null && !dobj.canLock();
    }

    void dispose() {
        this.fileManager.removeFromIndex(this.fileID);
    }

    String getFileID() {
        return this.fileID;
    }

    String getPathname() {
        Object path = this.parent.getPathname();
        if (((String)path).length() != FileSystem.SEPARATOR.length()) {
            path = (String)path + FileSystem.SEPARATOR;
        }
        path = (String)path + this.name;
        return path;
    }

    String getName() {
        return this.name;
    }

    GhidraFolderData getParent() {
        return this.parent;
    }

    GhidraFile getDomainFile() {
        return new GhidraFile(this.parent.getDomainFolder(), this.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetFileID() throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (this.versionedFolderItem != null || this.isCheckedOut()) {
                throw new IOException("File ID reset not permitted on versioned file");
            }
            if (this.folderItem != null) {
                this.fileID = this.folderItem.resetFileID();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    GhidraFile setName(String newName) throws InvalidNameException, IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (this.fileSystem.isReadOnly()) {
                throw new ReadOnlyException("setName permitted within writeable project only");
            }
            this.checkInUse();
            if (this.parent.containsFile(newName)) {
                throw new DuplicateFileException("File named " + newName + " already exists.");
            }
            String oldName = this.name;
            String folderPath = this.parent.getPathname();
            if (this.isHijacked()) {
                this.fileSystem.moveItem(folderPath, this.name, folderPath, newName);
                this.folderItem = null;
                this.parent.fileChanged(this.name);
                this.parent.fileChanged(newName);
                return this.parent.getDomainFile(newName);
            }
            if (this.versionedFolderItem == null) {
                if (this.isCheckedOut()) throw new FileInUseException(this.name + " is checked-out");
                this.fileSystem.moveItem(folderPath, this.name, folderPath, newName);
                this.folderItem = this.fileSystem.getItem(folderPath, newName);
            } else {
                this.versionedFileSystem.moveItem(folderPath, this.name, folderPath, newName);
                this.versionedFolderItem = this.versionedFileSystem.getItem(folderPath, newName);
            }
            this.name = newName;
            this.parent.fileRenamed(oldName, newName);
            return this.parent.getDomainFile(newName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getContentType() {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            LocalFolderItem item;
            Object object = item = this.folderItem != null ? this.folderItem : this.versionedFolderItem;
            if (item == null) {
                return "Missing-File";
            }
            String contentType = item.getContentType();
            String string = contentType != null ? contentType : "Unknown-File";
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Class<? extends DomainObject> getDomainObjectClass() {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            LocalFolderItem item = this.folderItem != null ? this.folderItem : this.versionedFolderItem;
            try {
                ContentHandler ch = DomainObjectAdapter.getContentHandler(item.getContentType());
                if (ch != null) {
                    return ch.getDomainObjectClass();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return DomainObject.class;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ChangeSet getChangesByOthersSinceCheckout() throws VersionException, IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (this.versionedFolderItem != null && this.folderItem != null && this.folderItem.isCheckedOut()) {
                ContentHandler ch = DomainObjectAdapter.getContentHandler(this.folderItem.getContentType());
                return ch.getChangeSet(this.versionedFolderItem, this.folderItem.getCheckoutVersion(), this.versionedFolderItem.getCurrentVersion());
            }
            return null;
        }
    }

    private DomainObjectAdapter getOpenedDomainObject() {
        return this.fileManager.getOpenedDomainObject(this.getPathname());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DomainObject getDomainObject(Object consumer, boolean okToUpgrade, boolean okToRecover, TaskMonitor monitor) throws VersionException, IOException, CancelledException {
        DomainObjectAdapter domainObj = null;
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (this.fileSystem.isReadOnly()) {
                return this.getReadOnlyDomainObject(consumer, -1, monitor);
            }
            domainObj = this.getOpenedDomainObject();
            if (domainObj != null) {
                if (!domainObj.addConsumer(consumer)) {
                    domainObj = null;
                    this.fileManager.clearDomainObject(this.getPathname());
                } else {
                    return domainObj;
                }
            }
            if (this.folderItem == null) {
                ContentHandler ch = DomainObjectAdapter.getContentHandler(this.versionedFolderItem.getContentType());
                DomainObjectAdapter doa = ch.getReadOnlyObject(this.versionedFolderItem, -1, true, consumer, monitor);
                doa.setChanged(false);
                DomainFileProxy proxy = new DomainFileProxy(this.name, this.parent.getPathname(), doa, -1, this.fileID, this.parent.getProjectLocator());
                proxy.setLastModified(this.getLastModifiedTime());
                return doa;
            }
            ContentHandler ch = DomainObjectAdapter.getContentHandler(this.folderItem.getContentType());
            LocalFolderItem myFolderItem = this.folderItem;
            domainObj = ch.getDomainObject((FolderItem)myFolderItem, (FileSystem)this.parent.getUserFileSystem(), -1L, okToUpgrade, okToRecover, consumer, monitor);
            this.fileManager.setDomainObject(this.getPathname(), domainObj);
        }
        try {
            domainObj.setDomainFile(this.getDomainFile());
        }
        catch (Exception e) {
            domainObj.release(consumer);
            this.fileManager.clearDomainObject(this.getPathname());
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof VersionException) {
                throw (VersionException)((Object)cause);
            }
            throw new IOException(e.getMessage(), e);
        }
        this.listener.domainFileObjectOpenedForUpdate(domainObj.getDomainFile(), domainObj);
        return domainObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DomainObject getReadOnlyDomainObject(Object consumer, int version, TaskMonitor monitor) throws VersionException, IOException, CancelledException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            FolderItem item;
            Object object = item = this.folderItem != null && version == -1 ? this.folderItem : this.versionedFolderItem;
            if (item == null) {
                return null;
            }
            ContentHandler ch = DomainObjectAdapter.getContentHandler(item.getContentType());
            DomainObjectAdapter doa = ch.getReadOnlyObject(item, version, true, consumer, monitor);
            doa.setChanged(false);
            DomainFileProxy proxy = new DomainFileProxy(this.name, this.getParent().getPathname(), doa, version, this.fileID, this.parent.getProjectLocator());
            proxy.setLastModified(this.getLastModifiedTime());
            return doa;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DomainObject getImmutableDomainObject(Object consumer, int version, TaskMonitor monitor) throws VersionException, IOException, CancelledException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            ContentHandler ch;
            DomainObjectAdapter obj = null;
            if (this.versionedFolderItem == null || version == -1 && this.folderItem != null || this.isHijacked()) {
                ch = DomainObjectAdapter.getContentHandler(this.folderItem.getContentType());
                obj = ch.getImmutableObject((FolderItem)this.folderItem, consumer, version, -1, monitor);
            } else {
                ch = DomainObjectAdapter.getContentHandler(this.versionedFolderItem.getContentType());
                obj = ch.getImmutableObject(this.versionedFolderItem, consumer, version, -1, monitor);
            }
            DomainFileProxy proxy = new DomainFileProxy(this.name, this.getParent().getPathname(), obj, version, this.fileID, this.parent.getProjectLocator());
            proxy.setLastModified(this.getLastModifiedTime());
            return obj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean canRecover() {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            DomainObjectAdapter dobj = this.getOpenedDomainObject();
            if (!this.fileSystem.isReadOnly() && this.folderItem != null && dobj == null) {
                return this.folderItem.canRecover();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean takeRecoverySnapshot() throws IOException {
        DomainObjectAdapter dobj = this.fileManager.getOpenedDomainObject(this.getPathname());
        if (this.fileSystem.isReadOnly() || !(dobj instanceof DomainObjectAdapterDB) || !dobj.isChanged()) {
            return true;
        }
        LockingTaskMonitor monitor = null;
        DomainObjectAdapterDB dbObjDB = (DomainObjectAdapterDB)dobj;
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (this.busy) {
                return true;
            }
            this.busy = true;
        }
        try {
            monitor = dbObjDB.lockForSnapshot(true, "Recovery Snapshot Task");
            if (monitor == null) {
                boolean bl = true;
                return bl;
            }
            monitor.setMessage(this.getName());
            boolean bl = dbObjDB.getDBHandle().takeRecoverySnapshot((DBChangeSet)dbObjDB.getChangeSet(), (TaskMonitor)monitor);
            return bl;
        }
        catch (CancelledException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            LocalFileSystem localFileSystem2 = this.fileSystem;
            synchronized (localFileSystem2) {
                this.busy = false;
            }
            if (monitor != null) {
                monitor.releaseLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getLastModifiedTime() {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (this.folderItem != null) {
                return this.folderItem.lastModified();
            }
            if (this.versionedFolderItem != null) {
                return this.versionedFolderItem.lastModified();
            }
            return 0L;
        }
    }

    Icon getIcon(boolean disabled) {
        if (disabled) {
            if (this.disabledIcon == null) {
                this.disabledIcon = this.generateIcon(true);
            }
            return this.disabledIcon;
        }
        if (this.icon == null) {
            this.icon = this.generateIcon(false);
        }
        return this.icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Icon generateIcon(boolean disabled) {
        if (this.parent == null) {
            return UNSUPPORTED_FILE_ICON;
        }
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            LocalFolderItem item;
            Object object = item = this.folderItem != null ? this.folderItem : this.versionedFolderItem;
            if (this.versionedFolderItem != null) {
                MultiIcon multiIcon = new MultiIcon(VERSION_ICON, disabled);
                multiIcon.addIcon(this.getBaseIcon((FolderItem)item));
                if (this.isHijacked()) {
                    multiIcon.addIcon(HIJACKED_ICON);
                } else if (this.isCheckedOut()) {
                    if (this.isCheckedOutExclusive()) {
                        multiIcon.addIcon(CHECKED_OUT_EXCLUSIVE_ICON);
                    } else if (this.getVersion() == this.getLatestVersion()) {
                        multiIcon.addIcon(CHECKED_OUT_ICON);
                    } else {
                        multiIcon.addIcon(NOT_LATEST_CHECKED_OUT_ICON);
                    }
                }
                return multiIcon;
            }
            if (this.folderItem != null) {
                MultiIcon multiIcon = new MultiIcon(this.getBaseIcon((FolderItem)item), disabled);
                if (this.isReadOnly() && !this.fileSystem.isReadOnly()) {
                    multiIcon.addIcon((Icon)new TranslateIcon(READ_ONLY_ICON, 6, 6));
                }
                if (this.isCheckedOut()) {
                    if (this.isCheckedOutExclusive()) {
                        multiIcon.addIcon(CHECKED_OUT_EXCLUSIVE_ICON);
                    } else {
                        multiIcon.addIcon(CHECKED_OUT_ICON);
                    }
                }
                return multiIcon;
            }
        }
        return UNSUPPORTED_FILE_ICON;
    }

    private Icon getBaseIcon(FolderItem item) {
        try {
            ContentHandler ch = DomainObjectAdapter.getContentHandler(item.getContentType());
            if (ch != null) {
                return ch.getIcon();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return UNSUPPORTED_FILE_ICON;
    }

    boolean isChanged() {
        DomainObjectAdapter dobj = this.getOpenedDomainObject();
        return dobj != null && dobj.isChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isCheckedOut() {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            return this.folderItem != null && this.folderItem.isCheckedOut();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isCheckedOutExclusive() {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (this.folderItem == null) {
                return false;
            }
            if (this.folderItem.isCheckedOutExclusive()) {
                return true;
            }
            return !this.versionedFileSystem.isShared() && this.folderItem.isCheckedOut();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean modifiedSinceCheckout() {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            return this.isCheckedOut() && this.folderItem.getCurrentVersion() != this.folderItem.getLocalCheckoutVersion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isReadOnly() {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            return this.folderItem != null && this.folderItem.isReadOnly();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isVersioned() {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (this.versionedFolderItem == null) {
                return false;
            }
            return !this.isHijacked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isHijacked() {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            return this.folderItem != null && this.versionedFolderItem != null && !this.folderItem.isCheckedOut();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean canAddToRepository() {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            try {
                return !this.fileSystem.isReadOnly() && !this.versionedFileSystem.isReadOnly() && this.folderItem != null && this.versionedFolderItem == null && !this.folderItem.isCheckedOut() && this.isVersionControlSupported();
            }
            catch (IOException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean canCheckout() {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            try {
                return this.folderItem == null && !this.fileSystem.isReadOnly() && !this.versionedFileSystem.isReadOnly();
            }
            catch (IOException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean canCheckin() {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            try {
                return !this.fileSystem.isReadOnly() && !this.versionedFileSystem.isReadOnly() && this.modifiedSinceCheckout();
            }
            catch (IOException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isVersionControlSupported() {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (this.versionedFolderItem != null) {
                return true;
            }
            if (!(this.folderItem instanceof DatabaseItem)) {
                return false;
            }
            try {
                ContentHandler ch = DomainObjectAdapter.getContentHandler(this.folderItem.getContentType());
                return !ch.isPrivateContentType();
            }
            catch (IOException iOException) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getVersion() {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            try {
                if (this.folderItem != null) {
                    if (this.folderItem.isCheckedOut()) {
                        return this.folderItem.getCheckoutVersion();
                    }
                    return this.folderItem.getCurrentVersion();
                }
                return this.versionedFolderItem.getCurrentVersion();
            }
            catch (IOException e) {
                Msg.error((Object)this, (Object)"IO error", (Throwable)e);
                return -1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getLatestVersion() {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (!this.isHijacked() && this.versionedFolderItem != null) {
                return this.versionedFolderItem.getCurrentVersion();
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean canMerge() {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            try {
                return !this.fileSystem.isReadOnly() && this.versionedFolderItem != null && this.folderItem != null && this.folderItem.isCheckedOut() && this.versionedFolderItem.getCurrentVersion() > this.folderItem.getCheckoutVersion();
            }
            catch (IOException e) {
                Msg.error((Object)this, (Object)"IO Error", (Throwable)e);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setReadOnly(boolean state) throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (this.fileSystem.isReadOnly()) {
                throw new ReadOnlyException("setReadOnly permitted in writeable project only");
            }
            if (this.isVersioned()) {
                throw new AssertException("Versioned files do not support read-only setting");
            }
            this.folderItem.setReadOnly(state);
            this.statusChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Version[] getVersionHistory() throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (this.versionedFolderItem != null) {
                return this.versionedFolderItem.getVersions();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToVersionControl(String comment, boolean keepCheckedOut, TaskMonitor monitor) throws IOException, CancelledException {
        DomainObjectAdapter oldDomainObj = null;
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            String user;
            block27: {
                if (!this.isVersionControlSupported()) {
                    throw new AssertException("file type does supported version control");
                }
                if (this.versionedFolderItem != null) {
                    throw new AssertException("file already versioned");
                }
                if (!this.versionedFileSystem.isOnline()) {
                    throw new NotConnectedException("Not connected to repository server");
                }
                if (this.fileSystem.isReadOnly() || this.versionedFileSystem.isReadOnly()) {
                    throw new ReadOnlyException("addToVersionControl permitted within writeable project and repository only");
                }
                String parentPath = this.parent.getPathname();
                user = ClientUtil.getUserName();
                try {
                    if (this.folderItem instanceof DatabaseItem) {
                        DatabaseItem databaseItem = (DatabaseItem)this.folderItem;
                        ManagedBufferFile bufferFile = databaseItem.open();
                        try {
                            this.versionedFolderItem = this.versionedFileSystem.createDatabase(parentPath, this.name, this.folderItem.getFileID(), (BufferFile)bufferFile, comment, this.folderItem.getContentType(), false, monitor, user);
                            break block27;
                        }
                        finally {
                            bufferFile.dispose();
                        }
                    }
                    if (this.folderItem instanceof DataFileItem) {
                        DataFileItem dataFileItem = (DataFileItem)this.folderItem;
                        try (InputStream istream = dataFileItem.getInputStream();){
                            this.versionedFolderItem = this.versionedFileSystem.createDataFile(parentPath, this.name, istream, comment, this.folderItem.getContentType(), monitor);
                            break block27;
                        }
                    }
                    throw new AssertException("Unknown folder item type");
                }
                catch (InvalidNameException e) {
                    throw new AssertException("Unexpected error", (Throwable)e);
                }
            }
            oldDomainObj = this.getOpenedDomainObject();
            if (keepCheckedOut) {
                CheckoutType checkoutType;
                boolean exclusive = !this.versionedFileSystem.isShared();
                ProjectLocator projectLocator = this.parent.getProjectLocator();
                if (projectLocator.isTransient()) {
                    checkoutType = CheckoutType.TRANSIENT;
                    exclusive = true;
                } else {
                    checkoutType = exclusive || !this.versionedFileSystem.isShared() ? CheckoutType.EXCLUSIVE : CheckoutType.NORMAL;
                }
                ItemCheckoutStatus checkout = this.versionedFolderItem.checkout(checkoutType, user, ItemCheckoutStatus.getProjectPath((String)projectLocator.toString(), (boolean)projectLocator.isTransient()));
                this.folderItem.setCheckout(checkout.getCheckoutId(), exclusive, checkout.getCheckoutVersion(), this.folderItem.getCurrentVersion());
            } else if (oldDomainObj == null) {
                try {
                    this.folderItem.delete(-1, ClientUtil.getUserName());
                    this.folderItem = null;
                }
                catch (FileInUseException fileInUseException) {
                    // empty catch block
                }
            }
            if (oldDomainObj != null) {
                this.fileManager.clearDomainObject(this.getPathname());
                oldDomainObj.setDomainFile(new DomainFileProxy("~" + this.name, oldDomainObj));
                oldDomainObj.setTemporary(true);
            }
        }
        if (oldDomainObj != null) {
            GhidraFile df = this.getDomainFile();
            this.listener.domainFileObjectClosed(df, oldDomainObj);
            this.listener.domainFileObjectReplaced(df, oldDomainObj);
        }
        if (!keepCheckedOut) {
            this.parent.deleteLocalFolderIfEmpty();
        }
        this.statusChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkout(boolean exclusive, TaskMonitor monitor) throws IOException, CancelledException {
        if (this.fileSystem.isReadOnly()) {
            throw new ReadOnlyException("checkout permitted in writeable project only");
        }
        if (this.versionedFileSystem.isReadOnly()) {
            throw new ReadOnlyException("Versioned repository is read-only and does not permit checkout");
        }
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            int checkoutVersion;
            boolean fileIDset;
            ItemCheckoutStatus checkout;
            block21: {
                CheckoutType checkoutType;
                if (this.folderItem != null) {
                    throw new AssertException("Cannot checkout, private file exists");
                }
                if (!this.versionedFileSystem.isOnline()) {
                    throw new NotConnectedException("Not connected to repository server");
                }
                String user = ClientUtil.getUserName();
                ProjectLocator projectLocator = this.parent.getProjectLocator();
                if (projectLocator.isTransient()) {
                    checkoutType = CheckoutType.TRANSIENT;
                    exclusive = true;
                } else {
                    checkoutType = exclusive || !this.versionedFileSystem.isShared() ? CheckoutType.EXCLUSIVE : CheckoutType.NORMAL;
                }
                checkout = this.versionedFolderItem.checkout(checkoutType, user, ItemCheckoutStatus.getProjectPath((String)projectLocator.toString(), (boolean)projectLocator.isTransient()));
                if (checkout == null) {
                    return false;
                }
                fileIDset = false;
                if (this.fileID == null) {
                    this.fileID = this.versionedFolderItem.getFileID();
                    fileIDset = this.fileID != null;
                }
                checkoutVersion = checkout.getCheckoutVersion();
                String parentPath = this.parent.getPathname();
                try {
                    if (this.versionedFolderItem instanceof DatabaseItem) {
                        DatabaseItem databaseItem = (DatabaseItem)this.versionedFolderItem;
                        ManagedBufferFile bufferFile = databaseItem.open(checkoutVersion);
                        try {
                            this.folderItem = this.fileSystem.createDatabase(parentPath, this.name, this.fileID, (BufferFile)bufferFile, null, databaseItem.getContentType(), false, monitor, user);
                            break block21;
                        }
                        finally {
                            bufferFile.dispose();
                        }
                    }
                    if (this.versionedFolderItem instanceof DataFileItem) {
                        DataFileItem dataFileItem = (DataFileItem)this.versionedFolderItem;
                        try (InputStream istream = dataFileItem.getInputStream(checkoutVersion);){
                            this.folderItem = this.fileSystem.createDataFile(parentPath, this.name, istream, null, dataFileItem.getContentType(), monitor);
                            break block21;
                        }
                    }
                    throw new AssertException("Can't checkout - unknown file type");
                }
                catch (InvalidNameException e) {
                    throw new AssertException("Unexpected error", (Throwable)e);
                }
            }
            this.folderItem.setCheckout(checkout.getCheckoutId(), exclusive, checkoutVersion, this.folderItem.getCurrentVersion());
            this.statusChanged(fileIDset);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean quickCheckin(CheckinHandler checkinHandler, TaskMonitor monitor) throws IOException, CancelledException {
        if (!(this.versionedFolderItem instanceof DatabaseItem)) {
            return false;
        }
        monitor.checkCanceled();
        monitor.setMessage("Initiating Check In for " + this.name);
        boolean success = false;
        LocalManagedBufferFile srcFile = null;
        ManagedBufferFile checkinFile = null;
        try {
            LocalFileSystem localFileSystem = this.fileSystem;
            synchronized (localFileSystem) {
                block21: {
                    checkinFile = ((DatabaseItem)this.versionedFolderItem).openForUpdate(this.folderItem.getCheckoutId());
                    if (this.versionedFolderItem.getCurrentVersion() == this.folderItem.getCheckoutVersion()) break block21;
                    boolean bl = false;
                    return bl;
                }
                srcFile = (LocalManagedBufferFile)((DatabaseItem)this.folderItem).open();
            }
            String comment = checkinHandler.getComment();
            if (checkinHandler.createKeepFile()) {
                DomainObject sourceObj = null;
                try {
                    ContentHandler ch = DomainObjectAdapter.getContentHandler(this.folderItem.getContentType());
                    sourceObj = ch.getImmutableObject((FolderItem)this.folderItem, this, -1, -1, monitor);
                    this.createKeepFile(sourceObj, monitor);
                }
                catch (VersionException versionException) {
                }
                finally {
                    if (sourceObj != null) {
                        sourceObj.release(this);
                    }
                }
            }
            monitor.checkCanceled();
            LocalFileSystem localFileSystem2 = this.fileSystem;
            synchronized (localFileSystem2) {
                srcFile.createNewVersion(checkinFile, comment, monitor);
                success = true;
            }
        }
        finally {
            if (checkinFile != null) {
                checkinFile.close();
            }
            if (srcFile != null) {
                srcFile.close();
            }
        }
        return success;
    }

    private void verifyRepoUser(String caseName) throws IOException {
        if (this.versionedFileSystem instanceof LocalFileSystem) {
            return;
        }
        String repoUserName = this.versionedFileSystem.getUserName();
        if (repoUserName == null) {
            throw new IOException("File " + caseName + " not permitted (not connected)");
        }
        ItemCheckoutStatus checkoutStatus = this.getCheckoutStatus();
        if (checkoutStatus == null) {
            throw new IOException("File not checked out");
        }
        String checkoutUserName = checkoutStatus.getUser();
        if (!repoUserName.equals(checkoutUserName)) {
            throw new IOException("File " + caseName + " not permitted - checkout user '" + checkoutUserName + "' differs from repository user '" + repoUserName + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkin(CheckinHandler checkinHandler, boolean okToUpgrade, TaskMonitor monitor) throws IOException, VersionException, CancelledException {
        block52: {
            if (!this.versionedFileSystem.isOnline()) {
                throw new NotConnectedException("Not connected to repository server");
            }
            if (this.fileSystem.isReadOnly() || this.versionedFileSystem.isReadOnly()) {
                throw new ReadOnlyException("checkin permitted within writeable project and repository only");
            }
            if (!this.isCheckedOut()) {
                throw new IOException("File not checked out");
            }
            if (this.isChanged()) {
                throw new IOException("File has unsaved changes");
            }
            if (this.canRecover()) {
                throw new IOException("File recovery data exists");
            }
            if (!this.modifiedSinceCheckout()) {
                throw new IOException("File has not been modified since checkout");
            }
            this.verifyRepoUser("checkin");
            if (monitor == null) {
                monitor = TaskMonitorAdapter.DUMMY_MONITOR;
            }
            LocalFileSystem localFileSystem = this.fileSystem;
            synchronized (localFileSystem) {
                if (this.busy) {
                    throw new FileInUseException(this.name + " is busy");
                }
                this.busy = true;
            }
            try {
                Object originalObj;
                boolean quickCheckin;
                boolean bl = quickCheckin = alwaysMerge ? false : this.quickCheckin(checkinHandler, monitor);
                if (!quickCheckin) {
                    if (SystemUtilities.isInHeadlessMode()) {
                        throw new IOException("Checkin failed, file requires merge which is not supported in headless mode");
                    }
                    Msg.info((Object)this, (Object)("Checkin with merge for " + this.name));
                    ContentHandler ch = DomainObjectAdapter.getContentHandler(this.folderItem.getContentType());
                    DomainObjectAdapter checkinObj = ch.getDomainObject(this.versionedFolderItem, null, this.folderItem.getCheckoutId(), okToUpgrade, false, this, monitor);
                    checkinObj.setDomainFile(new DomainFileProxy(this.name, this.getParent().getPathname(), checkinObj, this.versionedFolderItem.getCurrentVersion() + 1, this.fileID, this.parent.getProjectLocator()));
                    DomainObject sourceObj = null;
                    originalObj = null;
                    DomainObject latestObj = null;
                    try {
                        LocalFileSystem localFileSystem2 = this.fileSystem;
                        synchronized (localFileSystem2) {
                            int coVer = this.folderItem.getCheckoutVersion();
                            sourceObj = ch.getImmutableObject((FolderItem)this.folderItem, this, -1, -1, monitor);
                            originalObj = ch.getImmutableObject(this.versionedFolderItem, this, coVer, -1, monitor);
                            latestObj = ch.getImmutableObject(this.versionedFolderItem, this, -1, coVer, monitor);
                        }
                        DomainObjectMergeManager mergeMgr = ch.getMergeManager(checkinObj, sourceObj, (DomainObject)originalObj, latestObj);
                        if (!mergeMgr.merge(monitor)) {
                            Msg.info((Object)this, (Object)("Checkin with merge terminated for " + this.name));
                            return;
                        }
                        checkinObj.save(checkinHandler.getComment(), monitor);
                        if (checkinHandler.createKeepFile()) {
                            if (monitor != null) {
                                monitor.setMessage("Generating local keep file...");
                            }
                            this.createKeepFile(sourceObj, monitor);
                        }
                    }
                    finally {
                        checkinObj.release(this);
                        if (sourceObj != null) {
                            sourceObj.release(this);
                        }
                        if (originalObj != null) {
                            originalObj.release(this);
                        }
                        if (latestObj != null) {
                            latestObj.release(this);
                        }
                    }
                }
                DomainObjectAdapter oldDomainObj = null;
                LocalFolderItem oldLocalItem = null;
                boolean keepCheckedOut = checkinHandler.keepCheckedOut();
                originalObj = this.fileSystem;
                synchronized (originalObj) {
                    oldDomainObj = this.getOpenedDomainObject();
                    this.versionedFolderItem = this.versionedFileSystem.getItem(this.parent.getPathname(), this.name);
                    if (this.versionedFolderItem == null) {
                        throw new IOException("Checkin failed, versioned item not found");
                    }
                    Msg.info((Object)this, (Object)("Checkin completed for " + this.name));
                    if (keepCheckedOut) {
                        boolean success = false;
                        try {
                            if (monitor != null) {
                                monitor.setMessage("Updating local checkout file...");
                            }
                            this.folderItem.updateCheckout(this.versionedFolderItem, !quickCheckin, monitor);
                            success = true;
                        }
                        finally {
                            if (!success) {
                                try {
                                    this.undoCheckout(false, true);
                                }
                                catch (IOException e) {
                                    Msg.error((Object)this, (Object)"Undo checkout error", (Throwable)e);
                                }
                            }
                        }
                    }
                    if (oldDomainObj != null) {
                        oldLocalItem = this.folderItem;
                        this.folderItem = null;
                    } else {
                        this.undoCheckout(false, true);
                    }
                    if (oldDomainObj != null) {
                        this.fileManager.clearDomainObject(this.getPathname());
                        oldDomainObj.setDomainFile(new DomainFileProxy(this.name, this.parent.getPathname(), oldDomainObj, -2, this.fileID, this.parent.getProjectLocator()));
                        oldDomainObj.setTemporary(true);
                    }
                }
                if (oldDomainObj != null) {
                    GhidraFile df = this.getDomainFile();
                    this.listener.domainFileObjectClosed(df, oldDomainObj);
                    this.listener.domainFileObjectReplaced(df, oldDomainObj);
                }
                if (oldLocalItem == null) break block52;
                LocalFileSystem localFileSystem3 = this.fileSystem;
                synchronized (localFileSystem3) {
                    long checkoutId = oldLocalItem.getCheckoutId();
                    oldLocalItem.delete(-1, ClientUtil.getUserName());
                    this.versionedFolderItem.terminateCheckout(checkoutId, true);
                }
            }
            finally {
                this.busy = false;
                this.parent.deleteLocalFolderIfEmpty();
                this.parent.fileChanged(this.name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ItemCheckoutStatus getCheckoutStatus() throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            long checkoutId;
            if (!this.versionedFileSystem.isOnline()) {
                throw new NotConnectedException("Not connected to repository server");
            }
            if (this.versionedFolderItem == null) {
                throw new IOException("File is not versioned");
            }
            ItemCheckoutStatus status = null;
            if (this.folderItem != null && (checkoutId = this.folderItem.getCheckoutId()) >= 0L) {
                status = this.versionedFolderItem.getCheckout(checkoutId);
            }
            return status;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ItemCheckoutStatus[] getCheckouts() throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (!this.versionedFileSystem.isOnline()) {
                throw new NotConnectedException("Not connected to repository server");
            }
            if (this.versionedFolderItem == null) {
                throw new IOException("File is not versioned");
            }
            return this.versionedFolderItem.getCheckouts();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminateCheckout(long checkoutId) throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (!this.versionedFileSystem.isOnline()) {
                throw new NotConnectedException("Not connected to repository server");
            }
            if (this.versionedFolderItem == null) {
                throw new IOException("File is not versioned");
            }
            this.versionedFolderItem.terminateCheckout(checkoutId, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void undoCheckout(boolean keep, boolean inUseOK) throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (this.fileSystem.isReadOnly()) {
                throw new ReadOnlyException("undoCheckout permitted within writeable project only");
            }
            if (!inUseOK) {
                this.checkInUse();
            }
            if (!this.versionedFileSystem.isOnline()) {
                throw new NotConnectedException("Not connected to repository server");
            }
            if (!this.isCheckedOut()) {
                throw new IOException("File not checked out");
            }
            this.verifyRepoUser("undo-checkout");
            long checkoutId = this.folderItem.getCheckoutId();
            String keepName = this.getKeepName();
            this.versionedFolderItem.terminateCheckout(checkoutId, true);
            if (keep) {
                this.folderItem.clearCheckout();
                try {
                    String folderPath = this.parent.getPathname();
                    this.fileSystem.moveItem(folderPath, this.name, folderPath, keepName);
                    this.parent.fileChanged(keepName);
                }
                catch (InvalidNameException e) {
                    throw new AssertException("Unexpected error", (Throwable)e);
                }
            } else {
                this.folderItem.delete(-1, ClientUtil.getUserName());
                this.parent.deleteLocalFolderIfEmpty();
            }
            this.folderItem = null;
            this.parent.fileChanged(this.name);
        }
    }

    private String getKeepName() {
        String tempName;
        String keep = tempName = this.name + ".keep";
        int cnt = 0;
        while (this.fileSystem.fileExists(this.parent.getPathname(), keep) || this.versionedFileExists(keep)) {
            keep = tempName + "." + ++cnt;
        }
        return keep;
    }

    private boolean versionedFileExists(String fileName) {
        try {
            return this.versionedFileSystem.isOnline() && this.versionedFileSystem.getItem(this.parent.getPathname(), fileName) != null;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private void createKeepFile(DomainObject oldDomainObj, TaskMonitor monitor) {
        Object keepName = this.name + ".keep";
        try {
            GhidraFileData keepFileData = this.parent.getFileData((String)keepName, false);
            if (keepFileData != null) {
                try {
                    keepFileData.delete();
                }
                catch (IOException e) {
                    Msg.error((Object)this, (Object)("Failed to create keep file: failed to remove old keep file: " + (String)keepName), (Throwable)e);
                    return;
                }
            }
            keepName = this.getKeepName();
            Msg.info((Object)this, (Object)("Creating old version keep file: " + (String)keepName));
            this.parent.createFile((String)keepName, oldDomainObj, monitor);
        }
        catch (InvalidNameException e) {
            throw new AssertException("Unexpected error", (Throwable)e);
        }
        catch (CancelledException e) {
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)("Failed to create keep file: " + (String)keepName), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete() throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (this.fileSystem.isReadOnly()) {
                throw new ReadOnlyException("delete permitted within writeable project only");
            }
            this.checkInUse();
            if (this.folderItem != null && this.folderItem.isCheckedOut()) {
                throw new FileInUseException("Can not delete file while it is checked-out");
            }
            if (this.isHijacked()) {
                this.folderItem.delete(-1, ClientUtil.getUserName());
                this.parent.deleteLocalFolderIfEmpty();
                Msg.info((Object)this, (Object)("Deleted local file, revealing hijacked file " + this.name));
            } else if (this.versionedFolderItem == null) {
                this.folderItem.delete(-1, ClientUtil.getUserName());
                Msg.info((Object)this, (Object)("Deleted local file " + this.name));
            } else {
                this.versionedFolderItem.delete(-1, ClientUtil.getUserName());
                Msg.info((Object)this, (Object)("Deleted versioned file " + this.name));
            }
            if (!(this.fileID == null || this.folderItem != null && this.versionedFolderItem != null && this.fileID.equals(this.versionedFolderItem.getFileID()))) {
                this.removeAssociatedUserDataFile();
            }
            this.parent.fileChanged(this.name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete(int version) throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (this.fileSystem.isReadOnly()) {
                throw new ReadOnlyException("delete(version) permitted within writeable project only");
            }
            if (this.versionedFolderItem == null) {
                throw new IOException(this.name + " is not versioned");
            }
            if (this.folderItem != null && this.folderItem.getCheckoutVersion() == version) {
                throw new FileInUseException(this.name + " version " + version + " is checked-out");
            }
            this.versionedFolderItem.delete(version, ClientUtil.getUserName());
        }
    }

    private void removeAssociatedUserDataFile() {
        try {
            LocalFolderItem item = this.folderItem != null ? this.folderItem : this.versionedFolderItem;
            ContentHandler ch = DomainObjectAdapter.getContentHandler(item.getContentType());
            ch.removeUserDataFile((FolderItem)item, (FileSystem)this.parent.getUserFileSystem());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void merge(boolean okToUpgrade, TaskMonitor monitor) throws IOException, VersionException, CancelledException {
        if (this.fileSystem.isReadOnly()) {
            throw new ReadOnlyException("merge permitted within writeable project only");
        }
        if (this.parent.getProjectLocator().isTransient()) {
            throw new IOException("Merge not permitted for transient project");
        }
        if (!this.versionedFileSystem.isOnline()) {
            throw new NotConnectedException("Not connected to repository server");
        }
        if (!this.isCheckedOut()) {
            throw new IOException("File not checked out");
        }
        if (!(this.versionedFolderItem instanceof DatabaseItem)) {
            throw new IOException("unsupported operation");
        }
        if (this.folderItem.getCheckoutVersion() == this.versionedFolderItem.getCurrentVersion()) {
            throw new IOException("Versioned file has not been updated since checkout");
        }
        if (this.isChanged()) {
            throw new IOException("File has unsaved changes");
        }
        if (this.canRecover()) {
            throw new IOException("File recovery data exists");
        }
        this.verifyRepoUser("merge");
        if (monitor == null) {
            monitor = TaskMonitorAdapter.DUMMY_MONITOR;
        }
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (this.busy) {
                throw new FileInUseException(this.name + " is busy");
            }
            this.busy = true;
        }
        LocalDatabaseItem tmpItem = null;
        try {
            if (!this.modifiedSinceCheckout()) {
                this.folderItem.updateCheckout(this.versionedFolderItem, true, monitor);
            } else {
                if (SystemUtilities.isInHeadlessMode()) {
                    throw new IOException("Merge failed, file merge is not supported in headless mode");
                }
                ContentHandler ch = DomainObjectAdapter.getContentHandler(this.folderItem.getContentType());
                int mergeVer = this.versionedFolderItem.getCurrentVersion();
                if (!okToUpgrade) {
                    DomainObjectAdapter testObj = ch.getReadOnlyObject(this.versionedFolderItem, mergeVer, false, this, monitor);
                    testObj.release(this);
                }
                Msg.info((Object)this, (Object)("Merging version " + mergeVer + " for " + this.name));
                DatabaseItem databaseItem = (DatabaseItem)this.versionedFolderItem;
                ManagedBufferFile bufferFile = databaseItem.open(mergeVer);
                try {
                    String tmpName = this.name + ".merge";
                    tmpItem = this.fileSystem.createTemporaryDatabase(this.parent.getPathname(), tmpName, databaseItem.getFileID(), (BufferFile)bufferFile, databaseItem.getContentType(), false, monitor);
                }
                catch (InvalidNameException e) {
                    throw new AssertException("Unexpected error", (Throwable)e);
                }
                finally {
                    bufferFile.dispose();
                }
                int coVer = this.folderItem.getCheckoutVersion();
                long checkoutId = this.folderItem.getCheckoutId();
                tmpItem.setCheckout(checkoutId, this.folderItem.isCheckedOutExclusive(), mergeVer, 0);
                DomainObjectAdapter mergeObj = ch.getDomainObject((FolderItem)tmpItem, null, -1L, okToUpgrade, false, this, monitor);
                DomainObjectAdapter sourceObj = null;
                DomainObject originalObj = null;
                DomainObject latestObj = null;
                try {
                    sourceObj = ch.getImmutableObject((FolderItem)this.folderItem, this, -1, -1, monitor);
                    originalObj = ch.getImmutableObject(this.versionedFolderItem, this, coVer, -1, monitor);
                    latestObj = ch.getImmutableObject(this.versionedFolderItem, this, mergeVer, coVer, monitor);
                    DomainObjectMergeManager mergeMgr = ch.getMergeManager(mergeObj, sourceObj, originalObj, latestObj);
                    if (!mergeMgr.merge(monitor)) {
                        Msg.info((Object)this, (Object)("Merge terminated for " + this.name));
                        return;
                    }
                    mergeObj.save("Merge with version " + mergeVer, monitor);
                    this.createKeepFile(sourceObj, monitor);
                }
                finally {
                    mergeObj.release(this);
                    if (sourceObj != null) {
                        sourceObj.release(this);
                    }
                    if (originalObj != null) {
                        originalObj.release(this);
                    }
                    if (latestObj != null) {
                        latestObj.release(this);
                    }
                }
                this.folderItem.updateCheckout((FolderItem)tmpItem, mergeVer);
                this.versionedFolderItem.updateCheckoutVersion(checkoutId, mergeVer, ClientUtil.getUserName());
                tmpItem = null;
                Msg.info((Object)this, (Object)("Merge completed for " + this.name));
            }
            DomainObjectAdapter oldDomainObj = null;
            LocalFileSystem mergeVer = this.fileSystem;
            synchronized (mergeVer) {
                oldDomainObj = this.getOpenedDomainObject();
                if (oldDomainObj != null) {
                    this.fileManager.clearDomainObject(this.getPathname());
                    oldDomainObj.setDomainFile(new DomainFileProxy("~" + this.name, oldDomainObj));
                    oldDomainObj.setTemporary(true);
                }
            }
            if (oldDomainObj != null) {
                GhidraFile df = this.getDomainFile();
                this.listener.domainFileObjectClosed(df, oldDomainObj);
                this.listener.domainFileObjectReplaced(df, oldDomainObj);
            }
        }
        finally {
            this.busy = false;
            if (tmpItem != null) {
                try {
                    tmpItem.delete(-1, ClientUtil.getUserName());
                }
                catch (IOException e) {
                    Msg.error((Object)this, (Object)"IO error", (Throwable)e);
                }
            }
            this.parent.fileChanged(this.name);
            if (this.parent.visited()) {
                this.parent.refresh(false, true, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    GhidraFile moveTo(GhidraFolderData newParent) throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (newParent.getLocalFileSystem() != this.fileSystem) {
                throw new IllegalArgumentException("moveTo permitted within same project only");
            }
            if (this.fileSystem.isReadOnly()) {
                throw new ReadOnlyException("moveTo permitted within writeable project only");
            }
            if (this.getParent().getPathname().equals(newParent.getPathname())) {
                throw new IllegalArgumentException("newParent must differ from current parent");
            }
            this.checkInUse();
            GhidraFolderData oldParent = this.parent;
            String oldName = this.name;
            String newName = this.getTargetName(this.name, newParent);
            try {
                if (this.isHijacked()) {
                    this.fileSystem.moveItem(this.parent.getPathname(), this.name, newParent.getPathname(), newName);
                    this.parent.fileChanged(this.name);
                    newParent.fileChanged(newName);
                    return newParent.getDomainFile(newName);
                }
                if (this.versionedFolderItem == null) {
                    if (this.isCheckedOut()) throw new FileInUseException(this.name + " is checked-out");
                    this.fileSystem.moveItem(this.parent.getPathname(), this.name, newParent.getPathname(), newName);
                    this.folderItem = this.fileSystem.getItem(newParent.getPathname(), newName);
                } else {
                    this.versionedFileSystem.moveItem(this.parent.getPathname(), this.name, newParent.getPathname(), newName);
                    this.versionedFolderItem = this.versionedFileSystem.getItem(newParent.getPathname(), newName);
                }
            }
            catch (InvalidNameException e) {
                throw new AssertException("Unexpected error", (Throwable)e);
            }
            this.parent = newParent;
            this.name = newName;
            oldParent.fileMoved(newParent, oldName, newName);
            return newParent.getDomainFile(newName);
        }
    }

    private String getTargetName(String preferredName, GhidraFolderData newParent) throws IOException {
        Object newName = preferredName;
        int i = 1;
        while (newParent.getFileData((String)newName, false) != null) {
            newName = preferredName + "." + i;
            ++i;
        }
        return newName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GhidraFile copyTo(GhidraFolderData newParentData, TaskMonitor monitor) throws IOException, CancelledException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            String targetName;
            block14: {
                if (newParentData.getLocalFileSystem().isReadOnly()) {
                    throw new ReadOnlyException("copyVersionTo permitted to writeable project only");
                }
                LocalFolderItem item = this.folderItem != null ? this.folderItem : this.versionedFolderItem;
                String pathname = newParentData.getPathname();
                String contentType = item.getContentType();
                targetName = this.getTargetName(this.name, newParentData);
                String user = ClientUtil.getUserName();
                try {
                    if (item instanceof DatabaseItem) {
                        ManagedBufferFile bufferFile = ((DatabaseItem)item).open();
                        try {
                            newParentData.getLocalFileSystem().createDatabase(pathname, targetName, FileIDFactory.createFileID(), (BufferFile)bufferFile, null, contentType, true, monitor, user);
                            break block14;
                        }
                        finally {
                            bufferFile.dispose();
                        }
                    }
                    if (item instanceof DataFileItem) {
                        try (InputStream istream = ((DataFileItem)item).getInputStream();){
                            newParentData.getLocalFileSystem().createDataFile(pathname, targetName, istream, null, contentType, monitor);
                            break block14;
                        }
                    }
                    throw new AssertException("Unknown Item in copyTo");
                }
                catch (InvalidNameException e) {
                    throw new AssertException("Unexpected error", (Throwable)e);
                }
            }
            newParentData.fileChanged(targetName);
            return newParentData.getDomainFile(targetName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GhidraFile copyVersionTo(int version, GhidraFolderData destFolderData, TaskMonitor monitor) throws IOException, CancelledException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (destFolderData.getLocalFileSystem().isReadOnly()) {
                throw new ReadOnlyException("copyVersionTo permitted to writeable project");
            }
            if (this.versionedFolderItem == null) {
                return null;
            }
            if (!(this.versionedFolderItem instanceof DatabaseItem)) {
                throw new IOException("unsupported operation");
            }
            String pathname = destFolderData.getPathname();
            String contentType = this.versionedFolderItem.getContentType();
            String targetName = this.getTargetName(this.name + "_v" + version, destFolderData);
            String user = ClientUtil.getUserName();
            try {
                ManagedBufferFile bufferFile = ((DatabaseItem)this.versionedFolderItem).open(version);
                if (bufferFile == null) {
                    return null;
                }
                try {
                    destFolderData.getLocalFileSystem().createDatabase(pathname, targetName, FileIDFactory.createFileID(), (BufferFile)bufferFile, null, contentType, true, monitor, user);
                }
                finally {
                    bufferFile.dispose();
                }
            }
            catch (InvalidNameException e) {
                throw new AssertException("Unexpected error", (Throwable)e);
            }
            destFolderData.fileChanged(targetName);
            return destFolderData.getDomainFile(targetName);
        }
    }

    void convertToPrivateFile(TaskMonitor monitor) throws IOException, CancelledException {
        if (!this.isVersioned()) {
            return;
        }
        GhidraFolderData oldParent = this.getParent();
        GhidraFile df = this.copyTo(oldParent, monitor);
        this.versionedFolderItem.delete(-1, ClientUtil.getUserName());
        oldParent.fileChanged(this.name);
        try {
            df.setName(this.name);
        }
        catch (InvalidNameException e) {
            throw new AssertException("Unexpected error", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void packFile(File file, TaskMonitor monitor) throws IOException, CancelledException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            LocalFolderItem item = this.folderItem != null ? this.folderItem : this.versionedFolderItem;
            item.output(file, -1, monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long length() throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (this.folderItem != null) {
                return this.folderItem.length();
            }
            if (this.versionedFolderItem != null) {
                return this.versionedFolderItem.length();
            }
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, String> getMetadata() {
        LocalFolderItem item = this.folderItem != null ? this.folderItem : this.versionedFolderItem;
        GenericDomainObjectDB genericDomainObj = null;
        try {
            if (item instanceof DatabaseItem) {
                DatabaseItem databaseItem = (DatabaseItem)item;
                ManagedBufferFile bf = databaseItem.open();
                DBHandle dbh = new DBHandle((BufferFile)bf);
                genericDomainObj = new GenericDomainObjectDB(dbh);
                Map<String, String> map = genericDomainObj.getMetadata();
                return map;
            }
        }
        catch (FileNotFoundException databaseItem) {
        }
        catch (IOException e) {
            Msg.error((Object)this, (Object)"Read meta-data error", (Throwable)e);
        }
        finally {
            if (genericDomainObj != null) {
                genericDomainObj.release();
            }
        }
        return new HashMap<String, String>();
    }

    public String toString() {
        if (this.fileManager == null) {
            return this.name + "(disposed)";
        }
        return this.fileManager.getProjectLocator().getName() + ":" + this.getPathname();
    }

    private class GenericDomainObjectDB
    extends DomainObjectAdapterDB {
        protected GenericDomainObjectDB(DBHandle dbh) throws IOException {
            super(dbh, "Generic", 500, 1000, GhidraFileData.this);
            this.loadMetadata();
        }

        @Override
        public String getDescription() {
            return "Generic Database Domain Object";
        }

        @Override
        public boolean isChangeable() {
            return false;
        }

        public void release() {
            this.release(GhidraFileData.this);
        }
    }
}

