/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler.microsoft;

import ghidra.app.util.demangler.DemangledException;
import ghidra.app.util.demangler.DemangledObject;
import ghidra.app.util.demangler.Demangler;
import ghidra.program.model.listing.Program;
import java.util.regex.Pattern;
import mdemangler.MDException;
import mdemangler.MDMangGhidra;
import util.demangler.GenericDemangledException;

public class MicrosoftDemangler
implements Demangler {
    private static Pattern INVALID_TRAILING_CHARS_PATTERN = Pattern.compile(".*@@[?*`%~+/-][A-Z]");

    public boolean canDemangle(Program program) {
        String executableFormat = program.getExecutableFormat();
        return executableFormat != null && (executableFormat.indexOf("Portable Executable (PE)") != -1 || executableFormat.indexOf("MS Common Object File Format (COFF)") != -1);
    }

    public DemangledObject demangle(String mangled, boolean demangleOnlyKnownPatterns) throws DemangledException {
        try {
            DemangledObject demangled = this.demangleMS(mangled, demangleOnlyKnownPatterns);
            return demangled;
        }
        catch (GenericDemangledException e) {
            throw new DemangledException(true);
        }
    }

    private DemangledObject demangleMS(String mangled, boolean demangleOnlyKnownPatterns) throws GenericDemangledException {
        if (mangled == null || mangled.length() == 0) {
            throw new GenericDemangledException(true);
        }
        MDMangGhidra demangler = new MDMangGhidra();
        try {
            demangler.demangle(mangled, demangleOnlyKnownPatterns);
            DemangledObject object = demangler.getObject();
            return object;
        }
        catch (MDException e) {
            GenericDemangledException gde = new GenericDemangledException("Unable to demangle symbol: " + mangled);
            gde.initCause((Throwable)e);
            throw gde;
        }
    }
}

